/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_BP_Relation;
import org.adempiere.core.domains.models.I_HR_Employee;
import org.adempiere.core.domains.models.I_HR_Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRProcess;
import org.eevolution.hr.process.HRGenerateInvoiceFromProcessAbstract;

public class HRGenerateInvoiceFromProcess
extends HRGenerateInvoiceFromProcessAbstract {
    private int count = 0;
    private HashMap<Integer, MInvoice> invoices = new HashMap();

    protected String doIt() throws Exception {
        MBPartner partner = null;
        if (this.getBPartnerId() > 0) {
            partner = new MBPartner(this.getCtx(), this.getBPartnerId(), this.get_TrxName());
        }
        List payrollMovements = this.getInstancesForSelection(this.get_TrxName());
        for (MHRMovement payrollMovement : payrollMovements) {
            if (this.getBPartnerId() <= 0) {
                partner = MBPartner.get((Properties)this.getCtx(), (int)payrollMovement.getC_BPartner_ID());
            }
            if (payrollMovement.getC_BP_Relation_ID() > 0) {
                I_C_BP_Relation partnerRelation = payrollMovement.getC_BP_Relation();
                partner = MBPartner.get((Properties)this.getCtx(), (int)partnerRelation.getC_BPartnerRelation_ID());
            }
            MHREmployee employee = MHREmployee.getById(this.getCtx(), payrollMovement.getHR_Employee_ID());
            if (!this.invoices.containsKey(partner.get_ID())) {
                MHRProcess process = new MHRProcess(this.getCtx(), payrollMovement.getHR_Process_ID(), this.get_TrxName());
                MInvoice invoice = this.createInvoice((I_HR_Process)process, partner, (I_HR_Employee)employee, this.getDocTypeId(), this.getDateInvoiced());
                this.invoices.put(invoice.getC_BPartner_ID(), invoice);
            }
            this.createInvoiceLine(this.invoices.get(partner.get_ID()), (I_HR_Employee)employee, payrollMovement, this.getChargeId());
        }
        if ("CO".equals(this.getDocAction())) {
            this.invoices.entrySet().forEach(entry -> {
                MInvoice invoice = (MInvoice)entry.getValue();
                invoice.processIt(this.getDocAction());
                invoice.saveEx();
                this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), invoice.getGrandTotal(), "@C_Invoice_ID@ " + invoice.getDocumentNo() + " @C_BPartner_ID@  @TaxId@ " + invoice.getC_BPartner().getValue() + " @Name@ " + invoice.getC_BPartner().getName());
            });
        }
        this.openResult("C_Invoice");
        return "@OK@";
    }

    private MInvoice createInvoice(I_HR_Process process, MBPartner partner, I_HR_Employee employee, int docTypeId, Timestamp dateInvoice) {
        String paymentRule;
        int partnerLocationId = 0;
        if (this.getBPartnerLocationId() > 0) {
            partnerLocationId = this.getBPartnerLocationId();
        } else {
            MBPartnerLocation partnerLocation = this.getLocationBill(partner);
            if (partnerLocation == null) {
                this.log.log(Level.SEVERE, " @C_BPartner_Location_ID@ @NotFound@ : " + partner.getName());
                this.addLog(0, process.getDateAcct(), null, "@Bill_Location_ID@ @NotFound@ " + process.getDocumentNo() + " " + partner.getName());
                return null;
            }
            partnerLocationId = partnerLocation.get_ID();
        }
        String string = paymentRule = employee != null ? employee.getPaymentRule() : null;
        if (paymentRule == null || paymentRule.isEmpty()) {
            paymentRule = partner.getPaymentRulePO();
        }
        if (paymentRule == null) {
            this.log.log(Level.SEVERE, " @PaymentRule@ @NotFound@ : " + partner.getName());
            this.addLog(0, process.getDateAcct(), null, "@PaymentRule@ @NotFound@ " + process.getDocumentNo() + " " + process.getName() + " " + partner.getValue() + " " + partner.getName());
            return null;
        }
        this.log.info("New Invoice for ");
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)docTypeId);
        StringBuilder invoiceDescription = new StringBuilder();
        invoiceDescription.append(Msg.parseTranslation((Properties)this.getCtx(), (String)("@HR_Process_ID@ " + process.getName() + " @DocumentNo@ " + process.getDocumentNo() + " @HR_Employee_ID@ " + employee.getName())));
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setAD_Org_ID(process.getAD_Org_ID());
        invoice.setIsSOTrx(docType.isSOTrx());
        invoice.setPaymentRule(paymentRule);
        invoice.setC_DocTypeTarget_ID(docTypeId);
        invoice.setC_DocType_ID(docTypeId);
        invoice.setDescription(invoiceDescription.toString());
        invoice.setDateOrdered(dateInvoice);
        invoice.setDateInvoiced(dateInvoice);
        invoice.setDateAcct(dateInvoice);
        invoice.setBPartner(partner);
        invoice.setC_BPartner_Location_ID(partnerLocationId);
        MPaymentTerm paymentTerm = MPaymentTerm.getPaymentTermByDefault((Properties)this.getCtx(), (String)partner.get_TrxName());
        if (paymentTerm != null) {
            invoice.setC_PaymentTerm_ID(paymentTerm.getC_PaymentTerm_ID());
        }
        if (employee != null && employee.getC_Activity_ID() != 0) {
            invoice.setC_Activity_ID(employee.getC_Activity_ID());
        }
        invoice.setDocStatus("DR");
        invoice.setDocAction("--");
        invoice.setSalesRep_ID(this.getAD_User_ID());
        invoice.saveEx();
        this.count = this.count++;
        return invoice;
    }

    private MInvoiceLine createInvoiceLine(MInvoice invoice, I_HR_Employee employee, MHRMovement movement, int chargeId) {
        StringBuilder invoiceLineDescription = new StringBuilder();
        invoiceLineDescription.append(Msg.parseTranslation((Properties)invoice.getCtx(), (String)("@HR_Employee_ID@ " + employee.getName() + " @HR_Concept_ID@ " + MHRConcept.getById(this.getCtx(), movement.getHR_Concept_ID(), movement.get_TrxName()).getName())));
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setC_Charge_ID(chargeId);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.setDescription(invoiceLineDescription.toString());
        invoiceLine.setC_Activity_ID(movement.getC_Activity_ID());
        invoiceLine.setC_Campaign_ID(movement.getC_Campaign_ID());
        invoiceLine.setAD_OrgTrx_ID(movement.getAD_OrgTrx_ID());
        invoiceLine.setC_Project_ID(movement.getC_Project_ID());
        invoiceLine.setC_ProjectPhase_ID(movement.getC_ProjectPhase_ID());
        invoiceLine.setC_ProjectTask_ID(movement.getC_ProjectTask_ID());
        invoiceLine.setUser1_ID(movement.getUser1_ID());
        invoiceLine.setUser2_ID(movement.getUser2_ID());
        invoiceLine.setUser3_ID(movement.getUser3_ID());
        invoiceLine.setUser4_ID(movement.getUser4_ID());
        invoiceLine.setPrice(movement.getAmount());
        invoiceLine.setTax();
        invoiceLine.saveEx();
        this.addLog(invoiceLine.getLine(), invoice.getDateInvoiced(), invoiceLine.getLineNetAmt(), invoiceLineDescription.toString());
        movement.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        movement.saveEx();
        return invoiceLine;
    }

    private MBPartnerLocation getLocationBill(MBPartner partner) {
        String whereClause = "C_BPartner_ID=? AND IsBillTo=? AND IsActive=?";
        return (MBPartnerLocation)new Query(partner.getCtx(), "C_BPartner_Location", whereClause, partner.get_TrxName()).setClient_ID().setParameters(new Object[]{partner.getC_BPartner_ID(), true, true}).first();
    }
}

