/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPaySelection;
import org.eevolution.hr.model.MHRPaySelectionCheck;
import org.eevolution.hr.model.MHRPaySelectionLine;
import org.eevolution.hr.process.HRPaySelectionCreateFromAbstract;

public class HRPaySelectionCreateCheck
extends HRPaySelectionCreateFromAbstract {
    private List<MHRPaySelectionCheck> paySelectionChecks = new ArrayList<MHRPaySelectionCheck>();

    @Override
    protected void prepare() {
        super.prepare();
        this.getProcessInfo().setTable_ID(MHRPaySelection.Table_ID);
    }

    protected String doIt() {
        this.log.info("HR_PaySelection_ID=" + this.getRecord_ID() + ", PaymentRule=" + this.getPaymentRule());
        MHRPaySelection paySelection = (MHRPaySelection)this.getInstance(this.get_TrxName());
        if (paySelection.get_ID() == 0) {
            throw new IllegalArgumentException("Not found HR_PaySelection_ID=" + this.getRecord_ID());
        }
        if (paySelection.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        Arrays.stream(paySelection.getLines(true)).filter(paySelectionLine -> paySelectionLine != null && paySelectionLine.isActive() && !paySelectionLine.isProcessed()).forEach(paySelectionLine -> this.createCheck((MHRPaySelectionLine)((Object)paySelectionLine)));
        paySelection.setProcessed(true);
        paySelection.save();
        return "@C_PaySelectionCheck_ID@ - #" + this.paySelectionChecks.size();
    }

    private void createCheck(MHRPaySelectionLine paySelectionLine) {
        this.paySelectionChecks.stream().filter(paySelectionCheck -> paySelectionCheck.getC_BPartner_ID() == new MHRMovement(paySelectionLine.getCtx(), paySelectionLine.getHR_Movement_ID(), paySelectionLine.get_TrxName()).getC_BPartner_ID()).forEach(paySelectionCheck -> {
            paySelectionCheck.addLine(paySelectionLine);
            paySelectionCheck.saveEx();
            paySelectionLine.setHR_PaySelectionCheck_ID(paySelectionCheck.getHR_PaySelectionCheck_ID());
            paySelectionLine.setProcessed(true);
            paySelectionCheck.saveEx();
        });
        Optional<String> paymentRuleOptional = Optional.of(paySelectionLine.getPaymentRule());
        MHRPaySelectionCheck paySelectionCheck2 = new MHRPaySelectionCheck(paySelectionLine, paymentRuleOptional.orElseGet(() -> "T"));
        paySelectionCheck2.setAD_Org_ID(paySelectionLine.getAD_Org_ID());
        paySelectionCheck2.saveEx();
        paySelectionLine.setHR_PaySelectionCheck_ID(paySelectionCheck2.getHR_PaySelectionCheck_ID());
        paySelectionLine.setProcessed(true);
        paySelectionLine.saveEx();
        this.paySelectionChecks.add(paySelectionCheck2);
    }
}

