/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.I_C_BPartner;
import org.compiere.model.Query;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRPaySelection;
import org.eevolution.hr.model.MHRPaySelectionLine;
import org.eevolution.hr.process.HRPaySelectionCreateFromAbstract;

public class HRPaySelectionCreateFrom
extends HRPaySelectionCreateFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        this.getProcessInfo().setTable_ID(MHRPaySelection.Table_ID);
    }

    protected String doIt() throws Exception {
        this.log.info("Pay Selection Id=" + this.getRecord_ID() + ", Process=" + this.getHRProcessId() + ", Payroll=" + this.getPayrollId() + ", BP Group=" + this.getBPGroupId() + ", PaymentRule=" + this.getPaymentRule() + ", Concept=" + this.getConceptId() + ", Depatment=" + this.getDepartmentId() + ", Job=" + this.getJobId());
        MHRPaySelection paySelection = (MHRPaySelection)this.getInstance(this.get_TrxName());
        paySelection.setHR_Process_ID(this.getHRProcessId());
        paySelection.saveEx();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("@HR_PaySelection_ID@ @Notfound@");
        }
        if (paySelection.isProcessed()) {
            throw new IllegalArgumentException("@HR_PaySelection_ID@ @Processed@");
        }
        parameters.add(this.getHRProcessId());
        parameters.add(true);
        parameters.add(this.getRecord_ID());
        StringBuilder where = new StringBuilder();
        where.append("HR_Process_ID").append("=?");
        where.append(" AND EXISTS(SELECT 1 FROM HR_Concept WHERE HR_Concept_ID = HR_Movement.HR_Concept_ID AND IsPaid=?)");
        where.append(" AND NOT EXISTS(SELECT 1  FROM HR_PaySelectionLine  WHERE HR_Movement_ID = HR_Movement.HR_Movement_ID AND HR_PaySelectionCheck_ID > 0 OR HR_PaySelection_ID=?)");
        if (this.getBPGroupId() > 0) {
            where.append(" AND ").append("C_BP_Group_ID").append("=?");
            parameters.add(this.getBPGroupId());
        }
        if (this.getEmployeeTypeId() > 0) {
            where.append(" AND ").append("HR_EmployeeType_ID").append("=?");
            parameters.add(this.getEmployeeTypeId());
        }
        if (this.getBPartnerId() > 0) {
            where.append(" AND ").append("C_BPartner_ID").append("=?");
            parameters.add(this.getBPartnerId());
        }
        if (this.getPaymentRule() != null) {
            where.append(" AND EXISTS(SELECT 1 FROM HR_Employee WHERE HR_Employee_ID = HR_Movement.HR_Employee_ID AND PaymentRule=?)");
            parameters.add(this.getPaymentRule());
        }
        if (this.getConceptId() > 0) {
            where.append(" AND ").append("HR_Concept_ID").append("=?");
            parameters.add(this.getConceptId());
        }
        if (this.getDepartmentId() > 0) {
            where.append(" AND ").append("HR_Department_ID").append("=?");
            parameters.add(this.getDepartmentId());
        }
        if (this.getJobId() > 0) {
            where.append(" AND ").append("HR_Job_ID").append("=?");
            parameters.add(this.getJobId());
        }
        List movements = new Query(this.getCtx(), "HR_Movement", where.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).list();
        AtomicInteger lineNo = new AtomicInteger();
        movements.stream().filter(movement -> movement != null).forEach(movement -> {
            I_C_BPartner partner = movement.getC_BPartner();
            Optional<MHREmployee> employeeOption = Optional.ofNullable(MHREmployee.getActiveEmployee(this.getCtx(), partner.getC_BPartner_ID(), movement.get_TrxName()));
            String paymentRule = employeeOption.flatMap(employee -> Optional.ofNullable(employee.getPaymentRule())).orElseGet(() -> Optional.ofNullable(partner.getPaymentRule()).orElseGet(() -> "T"));
            lineNo.updateAndGet(count -> count + 10);
            MHRPaySelectionLine paySelectionLine = new MHRPaySelectionLine(this.getCtx(), 0, this.get_TrxName());
            paySelectionLine.setHR_PaySelection_ID(this.getRecord_ID());
            paySelectionLine.setHR_Movement_ID(movement.getHR_Movement_ID());
            paySelectionLine.setPaymentRule(paymentRule);
            paySelectionLine.setAD_Org_ID(paySelection.getAD_Org_ID());
            paySelectionLine.setLine(lineNo.get());
            paySelectionLine.setOpenAmt(movement.getAmount().setScale(2, RoundingMode.HALF_DOWN));
            paySelectionLine.setPayAmt(movement.getAmount().setScale(2, RoundingMode.HALF_DOWN));
            paySelectionLine.setDescription(partner.getName() + " " + partner.getName2());
            paySelectionLine.setDifferenceAmt(BigDecimal.ZERO);
            paySelectionLine.setDiscountAmt(BigDecimal.ZERO);
            paySelectionLine.setIsManual(false);
            paySelectionLine.setIsSOTrx(false);
            paySelectionLine.setIsActive(true);
            paySelectionLine.saveEx();
        });
        return "@HR_PaySelection_ID@  - #" + lineNo.get();
    }
}

