/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_I_HR_Movement;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.process.ImportPayrollMovementsAbstract;

public class ImportPayrollMovements
extends ImportPayrollMovementsAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getPayrollImportMovementIds(true, true, null)).forEach(recordId -> {
                X_I_HR_Movement importPayrollMovement = new X_I_HR_Movement(this.getCtx(), recordId, null);
                importPayrollMovement.deleteEx(true);
            });
        }
        AtomicInteger importedRecord = new AtomicInteger(0);
        AtomicInteger withErrors = new AtomicInteger(0);
        Arrays.stream(this.getPayrollImportMovementIds(false, false, null)).forEach(recordId -> Trx.run(trxName -> {
            X_I_HR_Movement importPayrollMovement = new X_I_HR_Movement(this.getCtx(), recordId, trxName);
            this.fillIdValues(importPayrollMovement);
            if (this.importRecord(importPayrollMovement)) {
                importedRecord.updateAndGet(record -> record + 1);
            } else {
                withErrors.updateAndGet(error -> error + 1);
            }
        }));
        return "@HR_Movement_ID@ @Import@ @Records@ " + importedRecord.get() + " @Errors@ " + withErrors.get();
    }

    private void fillIdValues(X_I_HR_Movement importPayrollMovement) {
        StringBuilder messageError = new StringBuilder();
        importPayrollMovement.setI_ErrorMsg("");
        if (importPayrollMovement.getHR_Process_ID() <= 0) {
            Optional maybeProcessId = Optional.ofNullable(importPayrollMovement.getProcessName()).flatMap(processName -> {
                int processId = this.getId("HR_Process", "Name=?", processName);
                if (processId > 0) {
                    return Optional.of(processId);
                }
                return Optional.empty();
            });
            if (maybeProcessId.isPresent()) {
                maybeProcessId.ifPresent(arg_0 -> ((X_I_HR_Movement)importPayrollMovement).setHR_Process_ID(arg_0));
            } else {
                messageError.append("@HR_Process_ID@  @NotFound@ ");
            }
        }
        if (importPayrollMovement.getC_BPartner_ID() <= 0) {
            Optional maybePartnerId = Optional.ofNullable(importPayrollMovement.getBPartner_Value()).flatMap(partnerValue -> {
                int partnerId = this.getId("C_BPartner", "Value=?", partnerValue);
                if (partnerId > 0) {
                    MBPartner partner = new MBPartner(this.getCtx(), partnerId, importPayrollMovement.get_TrxName());
                    if (!partner.isEmployee()) {
                        messageError.append(", ").append("@IsEmployee@ @NotValid@ @C_BPartner_ID@ ").append(partner.getName());
                        return Optional.empty();
                    }
                    return Optional.of(partnerId);
                }
                return Optional.empty();
            });
            if (maybePartnerId.isPresent()) {
                maybePartnerId.ifPresent(arg_0 -> ((X_I_HR_Movement)importPayrollMovement).setC_BPartner_ID(arg_0));
            } else {
                messageError.append(", ").append("@C_BPartner_ID@ @NotFound@ ");
            }
        }
        if (importPayrollMovement.getHR_Concept_ID() <= 0) {
            Optional maybeConceptId = Optional.ofNullable(importPayrollMovement.getConceptValue()).flatMap(conceptValue -> {
                StringBuilder whereClause = new StringBuilder();
                whereClause.append("Value").append("=? AND ").append("IsManual").append("=? AND ").append("IsActive").append("=? ");
                int conceptId = this.getId("HR_Concept", whereClause.toString(), conceptValue.trim(), true, true);
                if (conceptId > 0) {
                    MHRConcept concept = new MHRConcept(this.getCtx(), conceptId, importPayrollMovement.get_TrxName());
                    if ("E".equals(concept.getType())) {
                        messageError.append(", ").append("@HR_Concept_ID@ ").append(concept.getName()).append(" @NotValid@ ");
                        return Optional.empty();
                    }
                    return Optional.of(conceptId);
                }
                return Optional.empty();
            });
            if (maybeConceptId.isPresent()) {
                maybeConceptId.ifPresent(arg_0 -> ((X_I_HR_Movement)importPayrollMovement).setHR_Concept_ID(arg_0));
            } else {
                messageError.append("@HR_Concept_ID@ ").append(" @NotFound@ ");
            }
        }
        if (importPayrollMovement.getValidFrom() == null) {
            messageError.append(", @ValidFrom@ @FillMandatory@ ");
        }
        if (importPayrollMovement.getValidTo() == null) {
            importPayrollMovement.setValidTo(importPayrollMovement.getValidFrom());
        }
        if (messageError.length() > 0) {
            this.setImportError(importPayrollMovement, messageError.toString()).saveEx(importPayrollMovement.get_TrxName());
        }
        importPayrollMovement.saveEx();
    }

    private boolean importRecord(X_I_HR_Movement importPayrollMovement) {
        if (importPayrollMovement.getI_ErrorMsg() != null && importPayrollMovement.getI_ErrorMsg().length() > 0) {
            importPayrollMovement.setProcessed(false);
            importPayrollMovement.setI_IsImported(false);
            importPayrollMovement.saveEx();
            return false;
        }
        MHRMovement payrollMovement = new MHRMovement(importPayrollMovement);
        payrollMovement.saveEx(importPayrollMovement.get_TrxName());
        importPayrollMovement.setHR_Movement_ID(payrollMovement.getHR_Movement_ID());
        importPayrollMovement.setI_IsImported(true);
        importPayrollMovement.setProcessed(true);
        importPayrollMovement.setI_ErrorMsg("");
        importPayrollMovement.saveEx(importPayrollMovement.get_TrxName());
        return true;
    }

    private int getId(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(parameters).firstId();
    }

    private X_I_HR_Movement setImportError(X_I_HR_Movement importPayrollMovement, String error) {
        importPayrollMovement.setI_ErrorMsg(Msg.parseTranslation((Properties)this.getCtx(), (String)error));
        this.addLog(importPayrollMovement.getI_HR_Movement_ID(), importPayrollMovement.getValidFrom(), importPayrollMovement.getAmount(), importPayrollMovement.getI_ErrorMsg());
        return importPayrollMovement;
    }

    private int[] getPayrollImportMovementIds(boolean isImported, boolean isProcessed, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Movement", whereClause.toString(), trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{isImported, isProcessed}).getIDs();
    }
}

