/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRLeave;
import org.eevolution.hr.model.MHRLeaveAssign;
import org.eevolution.hr.model.MHRLeaveType;
import org.eevolution.hr.process.LeaveCreditManualAbstract;
import org.spin.hr.util.TNAUtil;

public class LeaveCreditManual
extends LeaveCreditManualAbstract {
    protected String doIt() throws Exception {
        BigDecimal leaveDuration;
        if (this.getNoOfLeavesAllocated() <= 0) {
            return "";
        }
        MHRLeaveAssign assignedLeave = new MHRLeaveAssign(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MHRLeaveType leaveType = MHRLeaveType.getById(this.getCtx(), assignedLeave.getHR_LeaveType_ID(), this.get_TrxName());
        Timestamp validFrom = assignedLeave.getValidFrom();
        boolean isFromPreviousLeave = false;
        if (this.getValidFrom() != null) {
            if (!TimeUtil.isValid((Timestamp)validFrom, (Timestamp)assignedLeave.getValidTo(), (Timestamp)this.getValidFrom())) {
                throw new AdempiereException("@Invalid@ @ValidFrom@");
            }
            validFrom = this.getValidFrom();
        } else {
            validFrom = assignedLeave.getDateLastRun();
            isFromPreviousLeave = true;
        }
        if (validFrom == null) {
            validFrom = assignedLeave.getValidFrom();
        }
        int leaveToUse = assignedLeave.getBalance();
        if (this.getNoOfLeavesAllocated() < leaveToUse) {
            leaveToUse = this.getNoOfLeavesAllocated();
        }
        if (leaveToUse == 0) {
            throw new AdempiereException("@HR_LeaveAssign_ID@ @Used@");
        }
        String durationType = TNAUtil.getDurationUnitFromTimeUnit(leaveType.getTimeUnit());
        if (Util.isEmpty((String)durationType)) {
            throw new AdempiereException("@Invalid@ @TimeUnit@");
        }
        if (durationType.equals("h")) {
            durationType = "D";
        }
        if ((leaveDuration = leaveType.getLeaveDurationTime()) == null || leaveDuration.compareTo(Env.ZERO) <= 0) {
            leaveDuration = Env.ONE;
        }
        if (isFromPreviousLeave) {
            validFrom = TimeUtil.addDuration((Timestamp)validFrom, (String)durationType, (BigDecimal)leaveDuration);
        }
        for (int i = 0; i < leaveToUse; ++i) {
            MHRLeave leave = new MHRLeave(this.getCtx(), 0, this.get_TrxName());
            leave.setHR_LeaveType_ID(leaveType.getHR_LeaveType_ID());
            leave.setHR_LeaveAssign_ID(assignedLeave.getHR_LeaveAssign_ID());
            leave.setHR_LeaveReason_ID(this.getLeaveReasonId());
            leave.setDateDoc(validFrom);
            leave.setC_BPartner_ID(assignedLeave.getC_BPartner_ID());
            leave.saveEx();
            if (!leave.processIt(this.getDocAction())) {
                throw new AdempiereException(leave.getProcessMsg());
            }
            leave.saveEx();
            this.addLog("@HR_Leave_ID@ " + leave.getDocumentNo() + " @DateDoc@: " + DisplayType.getDateFormat((int)15).format(leave.getDateDoc()));
            validFrom = TimeUtil.addDuration((Timestamp)validFrom, (String)durationType, (BigDecimal)leaveDuration);
        }
        assignedLeave.setDateLastRun(validFrom);
        assignedLeave.saveEx();
        return "@Created@: " + leaveToUse;
    }
}

