/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.hr.model.MHRProcess;

public class PayrollProcessing
extends SvrProcess {
    public static final String PARAM_HR_Process_ID = "HR_Process_ID";
    private int m_HR_Process_ID;

    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) {
                this.log.fine("Null Parameter: " + name);
                continue;
            }
            if (name.equals(PARAM_HR_Process_ID)) {
                this.m_HR_Process_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        if (this.m_HR_Process_ID <= 0) {
            throw new FillMandatoryException(new String[]{PARAM_HR_Process_ID});
        }
        MHRProcess process = new MHRProcess(this.getCtx(), this.m_HR_Process_ID, this.get_TrxName());
        long start = System.currentTimeMillis();
        boolean ok = process.processIt("CO");
        process.saveEx();
        if (!ok) {
            throw new AdempiereException(process.getProcessMsg());
        }
        return "@Processed@ " + process.getName() + " - " + (System.currentTimeMillis() - start) + "ms";
    }
}

