/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.io.File;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.hr.process.SendPayrollReceiptByEmailAbstract;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class SendPayrollReceiptByEmail
extends SendPayrollReceiptByEmailAbstract {
    private int counter = 0;
    private int errors = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.getMailTextId());
        MMailText mailText = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        if (mailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.getMailTextId() + " @NotFound@ ");
        }
        MClient client = MClient.get((Properties)this.getCtx());
        if (client.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (client.getSMTPHost() == null || client.getSMTPHost().length() == 0) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long start = System.currentTimeMillis();
        this.sendEMail(mailText);
        return "@Created@=" + this.counter + ", @Errors@=" + this.errors + " - " + (System.currentTimeMillis() - start) + "ms";
    }

    private void sendEMail(MMailText mailText) {
        int[] nArray = this.getPaymentIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer paymentId = nArray[i];
            Boolean ok = this.sendIndividualMail(mailText, paymentId, null);
            if (ok == null) continue;
            if (ok.booleanValue()) {
                ++this.counter;
                continue;
            }
            ++this.errors;
        }
    }

    private Boolean sendIndividualMail(MMailText mailText, int paymentId, String unSubscribe) {
        try {
            MBPBankAccount bankAccount;
            MPayment payment = new MPayment(this.getCtx(), paymentId, this.get_TrxName());
            MBPartner employee = (MBPartner)payment.getC_BPartner();
            Object message = mailText.getMailText(true);
            if (unSubscribe != null) {
                message = (String)message + unSubscribe;
            }
            StringBuffer whereClause = new StringBuffer();
            whereClause.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation location = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{employee.getC_BPartner_ID(), "Primary"}).first();
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(Env.getCtx()).withTransactionName(this.get_TrxName());
            notifier.clearMessage().withApplicationType("UDP").withText((String)message).withUserId(Env.getAD_User_ID((Properties)this.getCtx())).withDescription(mailText.getMailHeader()).withEntity(MPayment.Table_ID, paymentId);
            String eMail = null;
            if (location != null) {
                eMail = location.getEMail();
            }
            if (Util.isEmpty(eMail) && (bankAccount = this.getBPAccountInfo(payment, true)) != null && Util.isEmpty((String)(eMail = bankAccount.getA_EMail())) && bankAccount.getAD_User_ID() != 0) {
                MUser user2 = MUser.get((Properties)this.getCtx(), (int)bankAccount.getAD_User_ID());
                eMail = user2.getEMail();
            }
            notifier.addAttachment(this.getPDF(paymentId));
            notifier.addRecipient(eMail);
            Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)employee.getC_BPartner_ID(), (String)this.get_TrxName())).forEach(user -> notifier.addRecipient(user.getAD_User_ID()));
            this.addLog(0, null, null, employee.getName() + " @MessageAddedToQueue@");
            notifier.addToQueue();
            return true;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public MBPBankAccount getBPAccountInfo(MPayment payment, boolean defaultWhenNull) {
        if (payment.getC_BP_BankAccount_ID() != 0) {
            return (MBPBankAccount)payment.getC_BP_BankAccount();
        }
        if (defaultWhenNull) {
            List bpAccountList = MBPBankAccount.getByPartner((Properties)Env.getCtx(), (int)payment.getC_BPartner_ID());
            if (bpAccountList == null || bpAccountList.size() == 0) {
                return null;
            }
            Optional<MBPBankAccount> first = bpAccountList.stream().filter(account -> account.isACH()).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            bpAccountList.get(0);
        }
        return null;
    }

    private int[] getPaymentIds() {
        ArrayList<Constable> parameters = new ArrayList<Constable>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("EXISTS (SELECT 1 FROM C_PaySelectionCheck psc ").append("INNER JOIN C_PaySelectionLine psl ON(psc.C_PaySelection_ID = psl.C_PaySelection_ID AND psl.C_BPartner_ID = psc.C_BPartner_ID) ").append("INNER JOIN HR_Movement m ON (psl.HR_Movement_ID = m.HR_Movement_ID) ").append("WHERE C_Payment.C_Payment_ID = psc.C_Payment_ID ").append("AND m.HR_Process_ID = ? ");
        parameters.add(Integer.valueOf(this.getHRProcessId()));
        if (this.getBPartnerId() > 0) {
            whereClause.append("AND psc.C_BPartner_ID=? ");
            parameters.add(Integer.valueOf(this.getBPartnerId()));
        }
        if (this.getDepartmentId() > 0) {
            whereClause.append("AND m.HR_Department_ID=? ");
            parameters.add(Integer.valueOf(this.getDepartmentId()));
        }
        if (this.getJobId() > 0) {
            whereClause.append("AND m.HR_Job_ID=? ");
            parameters.add(Integer.valueOf(this.getJobId()));
        }
        if (this.getActivityId() > 0) {
            whereClause.append("AND m.C_Activity_ID=? ");
            parameters.add(Integer.valueOf(this.getActivityId()));
        }
        if (this.getBPGroupId() > 0) {
            whereClause.append("AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = psc.C_BPartner_ID AND bp.IsEmployee=? AND bp.C_BP_Group_ID = ?)");
            parameters.add(Boolean.valueOf(true));
            parameters.add(Integer.valueOf(this.getBPGroupId()));
        }
        whereClause.append(")");
        return new Query(this.getCtx(), "C_Payment", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).getIDs();
    }

    private File getPDF(Integer recordId) {
        if (recordId <= 0) {
            return null;
        }
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(this.getADProcessId())).withTitle(SendPayrollReceiptByEmail.getProcessName()).withRecordId(Integer.valueOf(MPayment.Table_ID), recordId).execute();
        return processInfo.getPDFReport();
    }
}

