/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pr.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_HR_ProcessReport;
import org.adempiere.core.domains.models.X_RV_HR_ProcessDetail;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Util;
import org.spin.hr.util.AbstractPayrollReportExport;
import org.spin.hr.util.GenericPayrollExport;
import org.spin.pr.model.MHRProcessReportLine;

public class MHRProcessReport
extends X_HR_ProcessReport {
    private static final long serialVersionUID = 7984464436153212633L;
    private static CCache<Integer, MHRProcessReport> s_cache = new CCache("HR_ProcessReport", 100);
    private List<MHRProcessReportLine> lines = null;
    private AbstractPayrollReportExport reportExport = null;

    public MHRProcessReport(Properties ctx, int HR_ProcessReport_ID, String trxName) {
        super(ctx, HR_ProcessReport_ID, trxName);
    }

    public MHRProcessReport(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRProcessReport get(Properties ctx, int p_LVE_HR_ProcessReport_ID) {
        if (p_LVE_HR_ProcessReport_ID == 0) {
            return null;
        }
        MHRProcessReport report = (MHRProcessReport)((Object)s_cache.get((Object)p_LVE_HR_ProcessReport_ID));
        if (report != null) {
            return report;
        }
        report = new MHRProcessReport(ctx, p_LVE_HR_ProcessReport_ID, null);
        s_cache.put((Object)report.get_ID(), (Object)report);
        return report;
    }

    public List<MHRProcessReportLine> getLines(boolean requery, String sqlWhere) {
        if (this.lines != null && !requery) {
            return this.lines;
        }
        this.lines = new Query(this.getCtx(), "HR_ProcessReportLine", "HR_ProcessReport_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getHR_ProcessReport_ID()}).list();
        return this.lines;
    }

    public int copyFrom(MHRProcessReport from, MHRProcessReport to) {
        int count = 0;
        List<MHRProcessReportLine> concepts = from.getLines(false, null);
        for (MHRProcessReportLine line : concepts) {
            MHRProcessReportLine processReportLine = new MHRProcessReportLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)line, (PO)processReportLine, (int)line.getAD_Client_ID(), (int)line.getAD_Org_ID());
            processReportLine.setHR_ProcessReport_ID(this.getHR_ProcessReport_ID());
            processReportLine.saveEx();
            ++count;
        }
        return count;
    }

    private Class<?> getHandlerClass() {
        String className = this.getFileExportClass();
        if (Util.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != AbstractPayrollReportExport.class) continue;
                this.log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        this.log.finest("Not found: " + className);
        return null;
    }

    private void loadExportClass() throws Exception {
        if (this.reportExport != null) {
            return;
        }
        Class<?> clazz = this.getHandlerClass();
        if (clazz == null) {
            this.log.log(Level.INFO, "Using Standard Report Export");
            this.reportExport = new GenericPayrollExport(this.getCtx());
            return;
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class);
        this.reportExport = (AbstractPayrollReportExport)constructor.newInstance(this.getCtx());
    }

    public AbstractPayrollReportExport getPayrollReportExport() throws Exception {
        this.loadExportClass();
        return this.reportExport;
    }

    public boolean exportToFile(File file, List<X_RV_HR_ProcessDetail> detail) throws Exception {
        this.loadExportClass();
        if (this.reportExport != null) {
            this.reportExport.setDetail(detail);
            return this.reportExport.exportToFile(file);
        }
        return false;
    }

    public String toString() {
        return this.getHR_ProcessReport_ID() + " - " + this.getName();
    }
}

