/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.engine.forecast;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.eevolution.manufacturing.engine.forecast.DataElement;
import org.eevolution.manufacturing.engine.forecast.DataSet;
import org.eevolution.manufacturing.engine.forecast.DoubleExponentialSmoothing;
import org.eevolution.manufacturing.engine.forecast.ForecastRule;
import org.eevolution.manufacturing.model.MPPForecastRule;

public final class ForecastEngine {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static ForecastEngine s_instance = null;
    private static TreeSet<String> s_RuleNoImplement = new TreeSet();
    private HashMap<String, ForecastRule> m_ForecastRules = new HashMap();
    private String m_packageName = "org.eevolution.engine.forecast";

    public static ForecastEngine get() {
        if (s_instance == null) {
            s_instance = new ForecastEngine();
        }
        return s_instance;
    }

    public static List<MPPForecastRule> getForecastRules(Properties ctx, int AD_Client_ID, String trxName) {
        String whereClause = "";
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (AD_Client_ID > 0) {
            whereClause = "AD_Client_ID=?";
            parameters.add(AD_Client_ID);
        } else {
            whereClause = null;
        }
        return new Query(ctx, "PP_ForecastRule", whereClause, trxName).setOnlyActiveRecords(true).setParameters(parameters).list();
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        Ini.setProperty((String)"ApplicationUserID", (String)"SuperUser");
        Ini.setProperty((String)"ApplicationPassword", (String)"System");
        Ini.setProperty((String)"Role", (String)"GardenWorld Admin");
        Ini.setProperty((String)"Client", (String)"GardenWorld");
        Ini.setProperty((String)"Organization", (String)"HQ");
        Ini.setProperty((String)"Warehouse", (String)"HQ Warehouse");
        Ini.setProperty((String)"Language", (String)"English");
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        ForecastEngine engine = ForecastEngine.get();
    }

    public ForecastEngine() {
        this.registerRules(true);
    }

    protected <T extends ForecastRule> Class<T> getClass(String className) throws ClassNotFoundException {
        return Class.forName(this.getPackageName() + "." + className);
    }

    protected String getClassName(MPPForecastRule rule) {
        return "";
    }

    public ForecastRule getForecastRuleFactory(String className) {
        if (this.m_ForecastRules.containsKey(className)) {
            return this.m_ForecastRules.get(className);
        }
        try {
            Class cl = this.getClass(className);
            Constructor constructor = null;
            try {
                constructor = cl.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                this.log.fine("Not found <ForecastRule>()");
            }
            if (constructor != null) {
                ForecastRule rule = (ForecastRule)constructor.newInstance(new Object[0]);
                this.m_ForecastRules.put(className, rule);
                return rule;
            }
            constructor = cl.getDeclaredConstructor(new Class[0]);
            ForecastRule rule = (ForecastRule)constructor.newInstance(new Object[0]);
            this.m_ForecastRules.put(className, rule);
            return rule;
        }
        catch (ClassNotFoundException e) {
            s_RuleNoImplement.add(className);
        }
        catch (Throwable e) {
            throw new AdempiereException(e);
        }
        return null;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    protected void registerRules(boolean reset) {
        if (reset) {
            this.m_ForecastRules.clear();
        }
        ForecastRule rule = this.getForecastRuleFactory(DoubleExponentialSmoothing.class.getSimpleName());
    }

    public DataSet getForecast(String implementationClass, Integer M_Product_ID, DataSet series, double factorAlpha, double factorGamma, double factorBeta, double factorMultiplier, double factorScale, double factor) {
        ForecastRule implementation = this.getForecastRuleFactory(implementationClass);
        if (implementation == null) {
            throw new AdempiereException("@PP_ForecastRule_ID@ " + implementationClass + " @NotFound@ ");
        }
        implementation.setDataSet(series, factorAlpha, factorGamma, factorBeta, factorMultiplier, factorScale, factor);
        implementation.setKey(M_Product_ID.toString());
        return this.applyfactorScale(this.applyfactorMultiplier(implementation.getForecast(), factorMultiplier), factorScale);
    }

    private DataSet applyfactorMultiplier(DataSet dataSet, double factorMultiplier) {
        Enumeration<DataElement> elements = dataSet.getDataElements();
        while (elements.hasMoreElements()) {
            DataElement element = elements.nextElement();
            BigDecimal qty = (BigDecimal)element.getValue();
            if (factorMultiplier == 0.0) continue;
            BigDecimal value = qty.multiply(new BigDecimal(factorMultiplier)).divide(new BigDecimal(100));
            String desc = element.getDescription() + " Multiplier :" + value.toString();
            element.setValue(qty.add(value));
            element.setDescription(desc);
        }
        return dataSet;
    }

    private DataSet applyfactorScale(DataSet dataSet, double factorScale) {
        Enumeration<DataElement> elements = dataSet.getDataElements();
        while (elements.hasMoreElements()) {
            DataElement element = elements.nextElement();
            if (factorScale == 0.0) continue;
            BigDecimal qty = (BigDecimal)element.getValue();
            BigDecimal value = qty.multiply(new BigDecimal(factorScale)).divide(new BigDecimal(100));
            String desc = element.getDescription() + " Scale :" + value.toString();
            element.setValue(value);
            element.setDescription(desc);
        }
        return dataSet;
    }
}

