/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_UOM;
import org.adempiere.core.domains.models.I_PP_Cost_Collector;
import org.adempiere.core.domains.models.X_PP_Cost_Collector;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.engine.StorageEngine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.NoVendorForProductException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.manufacturing.exceptions.ActivityProcessedException;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;
import org.eevolution.manufacturing.model.MPPOrderNode;
import org.eevolution.manufacturing.model.MPPOrderNodeProduct;
import org.eevolution.manufacturing.model.MPPOrderWorkflow;
import org.eevolution.manufacturing.services.StandardCostCollector;

public class MPPCostCollector
extends X_PP_Cost_Collector
implements DocAction,
IDocumentLine {
    private static final long serialVersionUID = 2329378809441860241L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPOrder m_order = null;
    private MPPOrderNode m_orderNode = null;
    private MPPOrderBOMLine m_bomLine = null;
    private BigDecimal priceActual = Env.ZERO;

    public static MPPCostCollector createVarianceCostCollector(MPPCostCollector cc, String CostCollectorType) {
        MPPCostCollector costCollectorVariance = new MPPCostCollector(cc.getCtx(), 0, cc.get_TrxName());
        MPPCostCollector.copyValues((PO)cc, (PO)costCollectorVariance);
        costCollectorVariance.setProcessing(false);
        costCollectorVariance.setProcessed(false);
        costCollectorVariance.setDocStatus("DR");
        costCollectorVariance.setDocAction("CO");
        costCollectorVariance.setCostCollectorType(CostCollectorType);
        costCollectorVariance.setDocumentNo(null);
        costCollectorVariance.saveEx();
        return costCollectorVariance;
    }

    public static MPPCostCollector createCollector(MPPOrder order, int productId, int locatorId, int attributeSetInstanceId, int resourceId, int orderBOMLineId, int orderNodeId, int docTypeId, String costCollectorType, Timestamp movementDate, BigDecimal qty, BigDecimal scrap, BigDecimal reject, BigDecimal durationSetup, BigDecimal duration) {
        MPPCostCollector cc = new MPPCostCollector(order);
        cc.setPP_Order_BOMLine_ID(orderBOMLineId);
        cc.setPP_Order_Node_ID(orderNodeId);
        cc.setC_DocType_ID(docTypeId);
        cc.setC_DocTypeTarget_ID(docTypeId);
        cc.setCostCollectorType(costCollectorType);
        cc.setDocAction("CO");
        cc.setDocStatus("DR");
        cc.setIsActive(true);
        cc.setM_Locator_ID(locatorId);
        cc.setM_AttributeSetInstance_ID(attributeSetInstanceId);
        cc.setS_Resource_ID(resourceId);
        cc.setMovementDate(movementDate);
        cc.setDateAcct(movementDate);
        cc.setMovementQty(qty);
        cc.setScrappedQty(scrap);
        cc.setQtyReject(reject);
        cc.setSetupTimeReal(durationSetup);
        cc.setDurationReal(duration);
        cc.setPosted(false);
        cc.setProcessed(false);
        cc.setProcessing(false);
        cc.setUser1_ID(order.getUser1_ID());
        cc.setUser2_ID(order.getUser2_ID());
        cc.setUser3_ID(order.getUser3_ID());
        cc.setUser4_ID(order.getUser4_ID());
        cc.setM_Product_ID(productId);
        if (orderNodeId > 0) {
            cc.setIsSubcontracting(orderNodeId);
        }
        if (orderBOMLineId > 0) {
            cc.setC_UOM_ID(0);
        }
        cc.saveEx();
        if (!cc.processIt("CO")) {
            throw new AdempiereException(cc.getProcessMsg());
        }
        cc.saveEx();
        return cc;
    }

    public static void setPP_Order(I_PP_Cost_Collector cc, MPPOrder order) {
        cc.setPP_Order_ID(order.getPP_Order_ID());
        cc.setPP_Order_Workflow_ID(order.getMPPOrderWorkflow().get_ID());
        cc.setAD_Org_ID(order.getAD_Org_ID());
        cc.setM_Warehouse_ID(order.getM_Warehouse_ID());
        cc.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        cc.setC_Activity_ID(order.getC_Activity_ID());
        cc.setC_Campaign_ID(order.getC_Campaign_ID());
        cc.setC_Project_ID(order.getC_Project_ID());
        cc.setDescription(order.getDescription());
        cc.setS_Resource_ID(order.getS_Resource_ID());
        cc.setM_Product_ID(order.getM_Product_ID());
        cc.setC_UOM_ID(order.getC_UOM_ID());
        cc.setM_AttributeSetInstance_ID(order.getM_AttributeSetInstance_ID());
        cc.setMovementQty(order.getQtyOrdered());
    }

    public MPPCostCollector(Properties ctx, int costCollectorId, String trxName) {
        super(ctx, costCollectorId, trxName);
        if (costCollectorId == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setIsActive(true);
            this.setPosted(false);
            this.setProcessing(false);
            this.setProcessed(false);
        }
    }

    public MPPCostCollector(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPCostCollector(MPPOrder order) {
        this(order.getCtx(), 0, order.get_TrxName());
        MPPCostCollector.setPP_Order((I_PP_Cost_Collector)this, order);
        this.m_order = order;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setC_DocTypeTarget_ID(String docBaseType) {
        MDocType[] doc = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)docBaseType);
        if (doc == null) {
            throw new DocTypeNotFoundException(docBaseType, "");
        }
        this.setC_DocTypeTarget_ID(doc[0].get_ID());
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE PP_Cost_Collector SET Processed=? WHERE PP_Cost_Collector_ID=?";
        int noLine = DB.executeUpdateEx((String)"UPDATE PP_Cost_Collector SET Processed=? WHERE PP_Cost_Collector_ID=?", (Object[])new Object[]{processed, this.get_ID()}, (String)this.get_TrxName());
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        if (this.isActivityControl()) {
            MPPOrderNode activity = this.getPP_Order_Node();
            if ("CO".equals(activity.getDocStatus())) {
                throw new ActivityProcessedException(activity);
            }
            if (activity.isSubcontracting()) {
                if ("IP".equals(activity.getDocStatus()) && "IP".equals(this.getDocStatus())) {
                    return "IP";
                }
                if ("IP".equals(activity.getDocStatus()) && "DR".equals(this.getDocStatus())) {
                    throw new ActivityProcessedException(activity);
                }
                this.m_processMsg = this.createPO(activity);
                this.m_justPrepared = false;
                activity.setInProgress(this);
                activity.saveEx();
                return "IP";
            }
            activity.setInProgress(this);
            activity.setQtyDelivered(activity.getQtyDelivered().add(this.getMovementQty()));
            activity.setQtyScrap(activity.getQtyScrap().add(this.getScrappedQty()));
            activity.setQtyReject(activity.getQtyReject().add(this.getQtyReject()));
            activity.setDurationReal(activity.getDurationReal().add(this.getDurationReal()));
            activity.setSetupTimeReal(activity.getSetupTimeReal().add(this.getSetupTimeReal()));
            activity.saveEx();
            if (activity.isMilestone()) {
                MPPOrderWorkflow order_workflow = activity.getMPPOrderWorkflow();
                order_workflow.closeActivities(activity, this.getMovementDate(), true);
            }
        } else if (this.isIssue()) {
            MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
            MProduct product = this.getM_Product();
            MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)Table_ID, (boolean)false, (int)this.getM_AttributeSetInstance_ID());
        } else if (this.isReceipt()) {
            MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
            MProduct product = this.getM_Product();
            MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)Table_ID, (boolean)false, (int)this.getM_AttributeSetInstance_ID());
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    public String completeIt() {
        MPPOrderNode activity;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.isIssue() || this.isReceipt()) {
            MProduct product = this.getM_Product();
            if (product != null && product.isStocked() && !this.isVariance()) {
                int reservationAttributeSetInstanceId = 0;
                int reservationWarehouseId = 0;
                if (this.getPP_Order_BOMLine_ID() > 0) {
                    MPPOrderBOMLine orderBOMLine = this.getPP_Order_BOMLine();
                    reservationAttributeSetInstanceId = orderBOMLine.getM_AttributeSetInstance_ID();
                    reservationWarehouseId = orderBOMLine.getM_Warehouse_ID();
                } else {
                    MPPOrder order = this.getPP_Order();
                    reservationAttributeSetInstanceId = order.getM_AttributeSetInstance_ID();
                    reservationWarehouseId = order.getM_Warehouse_ID();
                }
                StorageEngine.createTransaction((IDocumentLine)this, (String)this.getMovementType(), (Timestamp)this.getMovementDate(), (BigDecimal)this.getMovementQty(), (boolean)false, (int)this.getM_Warehouse_ID(), (int)reservationAttributeSetInstanceId, (int)reservationWarehouseId, (boolean)false);
            }
            if (this.isIssue() && !this.isVariance()) {
                MPPOrderBOMLine orderBomLine = this.getPP_Order_BOMLine();
                orderBomLine.setQtyDelivered(orderBomLine.getQtyDelivered().add(this.getMovementQty()));
                orderBomLine.setQtyScrap(orderBomLine.getQtyScrap().add(this.getScrappedQty()));
                orderBomLine.setQtyReject(orderBomLine.getQtyReject().add(this.getQtyReject()));
                orderBomLine.setDateDelivered(this.getMovementDate());
                this.log.fine("OrderLine - Reserved=" + orderBomLine.getQtyReserved() + ", Delivered=" + orderBomLine.getQtyDelivered());
                orderBomLine.saveEx();
                this.log.fine("OrderLine -> Reserved=" + orderBomLine.getQtyReserved() + ", Delivered=" + orderBomLine.getQtyDelivered());
            } else if (this.isIssue() && this.isCostCollectorType("130") && this.isVariance()) {
                StandardCostCollector.createMethodVariances(this);
            }
            if (this.isReceipt()) {
                MPPOrder order = this.getPP_Order();
                order.setQtyDelivered(order.getQtyDelivered().add(this.getMovementQty()));
                order.setQtyScrap(order.getQtyScrap().add(this.getScrappedQty()));
                order.setQtyReject(order.getQtyReject().add(this.getQtyReject()));
                order.setQtyReserved(order.getQtyReserved().subtract(this.getMovementQty()));
                order.setDateDelivered(this.getMovementDate());
                if (order.getDateStart() == null) {
                    order.setDateStart(this.getDateStart());
                }
                if (order.getQtyOpen().signum() <= 0) {
                    order.setDateFinish(this.getDateFinish());
                }
                order.saveEx();
            }
        } else if (this.isActivityControl()) {
            activity = this.getPP_Order_Node();
            if (activity.isProcessed()) {
                throw new ActivityProcessedException(activity);
            }
            if (this.isSubcontracting()) {
                String whereClause = "PP_Cost_Collector_ID=?";
                List olines = new Query(this.getCtx(), "C_OrderLine", whereClause, this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
                String DocStatus = "CO";
                StringBuffer msg = new StringBuffer("The quantity do not is complete for next Purchase Order : ");
                for (MOrderLine oline : olines) {
                    if (oline.getQtyDelivered().compareTo(oline.getQtyOrdered()) < 0) {
                        DocStatus = "IP";
                    }
                    msg.append(oline.getParent().getDocumentNo()).append(",");
                }
                if ("IP".equals(DocStatus)) {
                    this.m_processMsg = msg.toString();
                    return DocStatus;
                }
                this.setProcessed(true);
                this.setDocAction("CL");
                this.setDocStatus("CO");
                activity.completeIt();
                activity.saveEx();
                this.m_processMsg = Msg.translate((Properties)this.getCtx(), (String)"PP_Order_ID") + ": " + this.getPP_Order().getDocumentNo() + " " + Msg.translate((Properties)this.getCtx(), (String)"PP_Order_Node_ID") + ": " + this.getPP_Order_Node().getValue();
                return DocStatus;
            }
            StandardCostCollector.createActivityControl(this);
            if (activity.getQtyDelivered().compareTo(activity.getQtyRequired()) >= 0) {
                activity.closeIt();
                activity.saveEx();
            }
        } else if (this.isCostCollectorType("120") && this.getPP_Order_BOMLine_ID() > 0) {
            MPPOrderBOMLine orderBOMLine = this.getPP_Order_BOMLine();
            orderBOMLine.setQtyScrap(orderBOMLine.getQtyScrap().add(this.getScrappedQty()));
            orderBOMLine.setQtyReject(orderBOMLine.getQtyReject().add(this.getQtyReject()));
            this.log.fine("OrderLine - Reserved=" + orderBOMLine.getQtyReserved() + ", Delivered=" + orderBOMLine.getQtyDelivered());
            orderBOMLine.saveEx();
            this.log.fine("OrderLine -> Reserved=" + orderBOMLine.getQtyReserved() + ", Delivered=" + orderBOMLine.getQtyDelivered());
            StandardCostCollector.createUsageVariances(this);
        } else if (this.isCostCollectorType("120") && this.getPP_Order_Node_ID() > 0) {
            activity = this.getPP_Order_Node();
            activity.setDurationReal(activity.getDurationReal().add(this.getDurationReal()));
            activity.setSetupTimeReal(activity.getSetupTimeReal().add(this.getSetupTimeReal()));
            activity.saveEx();
            StandardCostCollector.createActivityControl(this);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        this.setDocStatus("CO");
        return "CO";
    }

    public boolean voidIt() {
        return false;
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        return false;
    }

    public boolean reverseAccrualIt() {
        return false;
    }

    public boolean reActivateIt() {
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDescription());
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)0, (int)this.getPP_Order_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    protected boolean beforeSave(boolean newRecord) {
        MWarehouse wh;
        MLocator loc;
        if (this.getM_Locator_ID() <= 0 && this.getM_Warehouse_ID() > 0 && (loc = (wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID())).getDefaultLocator()) != null) {
            this.setM_Locator_ID(loc.get_ID());
        }
        if (this.isIssue()) {
            if (this.getPP_Order_BOMLine_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"PP_Order_BOMLine_ID"});
            }
            if (this.getC_UOM_ID() <= 0) {
                this.setC_UOM_ID(this.getPP_Order_BOMLine().getC_UOM_ID());
            }
            if (this.getC_UOM_ID() != this.getPP_Order_BOMLine().getC_UOM_ID()) {
                throw new AdempiereException("@PP_Cost_Collector_ID@ @C_UOM_ID@ <> @PP_Order_BOMLine_ID@ @C_UOM_ID@");
            }
        }
        if (this.isActivityControl() && this.getPP_Order_Node_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"PP_Order_Node_ID"});
        }
        return true;
    }

    public MPPOrderNode getPP_Order_Node() {
        int node_id = this.getPP_Order_Node_ID();
        if (node_id <= 0) {
            this.m_orderNode = null;
            return null;
        }
        if (this.m_orderNode == null || this.m_orderNode.get_ID() != node_id) {
            this.m_orderNode = new MPPOrderNode(this.getCtx(), node_id, this.get_TrxName());
        }
        return this.m_orderNode;
    }

    public MPPOrderBOMLine getPP_Order_BOMLine() {
        int id = this.getPP_Order_BOMLine_ID();
        if (id <= 0) {
            this.m_bomLine = null;
            return null;
        }
        if (this.m_bomLine == null || this.m_bomLine.get_ID() != id) {
            this.m_bomLine = new MPPOrderBOMLine(this.getCtx(), id, this.get_TrxName());
        }
        this.m_bomLine.set_TrxName(this.get_TrxName());
        return this.m_bomLine;
    }

    public MPPOrder getPP_Order() {
        int id = this.getPP_Order_ID();
        if (id <= 0) {
            this.m_order = null;
            return null;
        }
        if (this.m_order == null || this.m_order.get_ID() != id) {
            this.m_order = new MPPOrder(this.getCtx(), id, this.get_TrxName());
        }
        return this.m_order;
    }

    public long getDurationBaseSec() {
        return this.getPP_Order().getMPPOrderWorkflow().getDurationBaseSec();
    }

    public Timestamp getDateStart() {
        double duration = this.getDurationReal().doubleValue();
        if (duration != 0.0) {
            long durationMillis = (long)(this.getDurationReal().doubleValue() * (double)this.getDurationBaseSec() * 1000.0);
            return new Timestamp(this.getMovementDate().getTime() - durationMillis);
        }
        return this.getMovementDate();
    }

    public Timestamp getDateFinish() {
        return this.getMovementDate();
    }

    private String createPO(MPPOrderNode activity) {
        Object msg = "";
        HashMap<Integer, MOrder> orders = new HashMap<Integer, MOrder>();
        String whereClause = "PP_Order_Node_ID=? AND IsSubcontracting=?";
        List subcontracts = new Query(this.getCtx(), "PP_Order_Node_Product", whereClause, this.get_TrxName()).setParameters(new Object[]{activity.get_ID(), true}).setOnlyActiveRecords(true).list();
        for (MPPOrderNodeProduct subcontract : subcontracts) {
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)subcontract.getM_Product_ID());
            if (!product.isPurchased() || !"S".equals(product.getProductType())) {
                throw new AdempiereException("The Product: " + product.getName() + " Do not is Purchase or Service Type");
            }
            int C_BPartner_ID = activity.getC_BPartner_ID();
            MProductPO product_po = null;
            for (MProductPO ppo : MProductPO.getOfProduct((Properties)this.getCtx(), (int)product.get_ID(), null)) {
                if (C_BPartner_ID == ppo.getC_BPartner_ID()) {
                    C_BPartner_ID = ppo.getC_BPartner_ID();
                    product_po = ppo;
                    break;
                }
                if (!ppo.isCurrentVendor() || ppo.getC_BPartner_ID() == 0) continue;
                C_BPartner_ID = ppo.getC_BPartner_ID();
                product_po = ppo;
                break;
            }
            if (C_BPartner_ID <= 0 || product_po == null) {
                throw new NoVendorForProductException(product.getName());
            }
            Timestamp today = new Timestamp(System.currentTimeMillis());
            Timestamp datePromised = TimeUtil.addDays((Timestamp)today, (int)product_po.getDeliveryTime_Promised());
            MOrder order = (MOrder)orders.get(C_BPartner_ID);
            if (order == null) {
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                MBPartner vendor = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
                order.setAD_Org_ID(this.getAD_Org_ID());
                order.setBPartner(vendor);
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID();
                order.setDatePromised(datePromised);
                order.setDescription(Msg.translate((Properties)this.getCtx(), (String)"PP_Order_ID") + ":" + this.getPP_Order().getDocumentNo());
                order.setDocStatus("DR");
                order.setDocAction("CO");
                order.setAD_User_ID(this.getAD_User_ID());
                order.setM_Warehouse_ID(this.getM_Warehouse_ID());
                order.saveEx();
                this.addDescription(Msg.translate((Properties)this.getCtx(), (String)"C_Order_ID") + ": " + order.getDocumentNo());
                orders.put(C_BPartner_ID, order);
                msg = (String)msg + Msg.translate((Properties)this.getCtx(), (String)"C_Order_ID") + " : " + order.getDocumentNo() + " - " + Msg.translate((Properties)this.getCtx(), (String)"C_BPartner_ID") + " : " + vendor.getName() + " , ";
            }
            BigDecimal QtyOrdered = this.getMovementQty().multiply(subcontract.getQty());
            if (product_po.getOrder_Min().signum() > 0) {
                QtyOrdered = QtyOrdered.max(product_po.getOrder_Min());
            }
            if (product_po.getOrder_Pack().signum() > 0 && QtyOrdered.signum() > 0) {
                QtyOrdered = product_po.getOrder_Pack().multiply(QtyOrdered.divide(product_po.getOrder_Pack(), 0, RoundingMode.UP));
            }
            MOrderLine oline = new MOrderLine(order);
            oline.setM_Product_ID(product.getM_Product_ID());
            oline.setDescription(activity.getDescription());
            oline.setM_Warehouse_ID(this.getM_Warehouse_ID());
            oline.setQty(QtyOrdered);
            oline.setPP_Cost_Collector_ID(this.get_ID());
            oline.setDatePromised(datePromised);
            oline.saveEx();
            this.setProcessed(true);
        }
        return msg;
    }

    public MProduct getM_Product() {
        return MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
    }

    public I_C_UOM getC_UOM() {
        return MUOM.get((Properties)this.getCtx(), (int)this.getC_UOM_ID());
    }

    public boolean isIssue() {
        return this.isCostCollectorType("110") || this.isCostCollectorType("130") && this.getPP_Order_BOMLine_ID() > 0 || this.isCostCollectorType("150") && this.getPP_Order_BOMLine_ID() > 0;
    }

    public boolean isReceipt() {
        return this.isCostCollectorType("100");
    }

    public boolean isActivityControl() {
        return this.isCostCollectorType("160");
    }

    public boolean isVariance() {
        return this.isCostCollectorType("130", "120", "140", "150");
    }

    public String getMovementType() {
        if (this.isReceipt()) {
            return "W+";
        }
        if (this.isIssue()) {
            return "W-";
        }
        return null;
    }

    public boolean isCostCollectorType(String ... types) {
        String type = this.getCostCollectorType();
        for (String t : types) {
            if (!type.equals(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isFloorStock() {
        String whereClause = "PP_Order_BOMLine_ID=? AND IssueMethod=?";
        boolean isFloorStock = new Query(this.getCtx(), "PP_Order_BOMLine", "PP_Order_BOMLine_ID=? AND IssueMethod=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{this.getPP_Order_BOMLine_ID(), "2"}).match();
        return isFloorStock;
    }

    public void setIsSubcontracting(int PP_Order_Node_ID) {
        this.setIsSubcontracting(MPPOrderNode.get(this.getCtx(), PP_Order_Node_ID, this.get_TrxName()).isSubcontracting());
    }

    public int getM_LocatorTo_ID() {
        return 0;
    }

    public int getM_AttributeSetInstanceTo_ID() {
        return 0;
    }

    public boolean isSOTrx() {
        return false;
    }

    public int getReversalLine_ID() {
        return 0;
    }

    public BigDecimal getPriceActual() {
        return this.priceActual;
    }

    public void setPriceActual(BigDecimal cost) {
        this.priceActual = cost;
    }

    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    public BigDecimal getPriceActualCurrency() {
        return BigDecimal.ZERO;
    }

    public int getC_Currency_ID() {
        MClient client = MClient.get((Properties)this.getCtx());
        return client.getC_Currency_ID();
    }

    public int getC_ConversionType_ID() {
        return MConversionType.getDefault((int)this.getAD_Client_ID());
    }

    public boolean isReversalParent() {
        return false;
    }
}

