/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_PP_PeriodDefinition;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.eevolution.manufacturing.model.MPPPeriod;

public class MPPPeriodDefinition
extends X_PP_PeriodDefinition {
    private static final long serialVersionUID = 1849382103051033180L;

    public List<MPPPeriod> getPeriodsOfHistory(int periodHistory) {
        ArrayList<MPPPeriod> periods = new ArrayList<MPPPeriod>();
        int countPeriod = 1;
        for (MPPPeriod period : this.getPeriodsOrderBy("PeriodNo DESC")) {
            periods.add(period);
            if (countPeriod >= periodHistory) break;
            ++countPeriod;
        }
        return periods;
    }

    public MPPPeriodDefinition(Properties ctx, int M_PeriodDefinition_ID, String trxName) {
        super(ctx, M_PeriodDefinition_ID, trxName);
    }

    public MPPPeriodDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MPPPeriod> getPeriodsOrderBy(String orderBy) {
        String whereClause = "PP_PeriodDefinition_ID=?";
        return new Query(this.getCtx(), "PP_Period", "PP_PeriodDefinition_ID=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.get_ID()}).setOrderBy(orderBy).list();
    }

    public boolean createPeriods(Locale locale, Timestamp startDate, String dateFormat, int noPeriods) {
        if (locale == null) {
            MClient client = MClient.get((Properties)this.getCtx());
            locale = client.getLocale();
        }
        if (locale == null && Language.getLoginLanguage() != null) {
            locale = Language.getLoginLanguage().getLocale();
        }
        if (locale == null) {
            locale = Env.getLanguage((Properties)this.getCtx()).getLocale();
        }
        if (dateFormat == null || dateFormat.equals("")) {
            if (noPeriods == 52) {
                dateFormat = "ww-yy";
            }
            if (noPeriods == 12) {
                dateFormat = "MMM-yy";
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, locale);
        int year = this.getYearAsInt();
        GregorianCalendar cal = new GregorianCalendar(locale);
        if (startDate != null) {
            cal.setTime(startDate);
            if (cal.get(1) != year) {
                year = cal.get(1);
            }
        } else {
            cal.set(1, year);
            if (noPeriods == 12) {
                cal.set(2, 0);
            }
            if (noPeriods == 52) {
                cal.set(3, 1);
            }
            cal.set(5, 1);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        for (int p = 0; p < noPeriods; ++p) {
            Timestamp start = new Timestamp(cal.getTimeInMillis());
            String name = formatter.format(start);
            if (noPeriods == 52) {
                cal.add(3, 1);
            }
            if (noPeriods == 12) {
                cal.add(2, 1);
            }
            cal.add(6, -1);
            Timestamp end = new Timestamp(cal.getTimeInMillis());
            MPPPeriod period = MPPPeriod.findByCalendar(this.getCtx(), start, this.getPP_Calendar_ID(), this.get_TrxName());
            if (period == null) {
                period = new MPPPeriod(this, p + 1, name, start, end);
                period.setPP_PeriodDefinition_ID(this.getPP_PeriodDefinition_ID());
            }
            period.setPeriodNo(p + 1);
            period.setName(name);
            period.setStartDate(start);
            period.setEndDate(end);
            period.saveEx(this.get_TrxName());
            if (noPeriods == 52) {
                cal.add(7, 1);
            }
            if (noPeriods != 12) continue;
            cal.add(6, 1);
        }
        return true;
    }

    public int getYearAsInt() {
        String year = this.getCalendarYear();
        if (Util.isEmpty((String)year)) {
            throw new AdempiereException("@CalendarYear@ @NotFound@");
        }
        try {
            return Integer.parseInt(year);
        }
        catch (Exception e) {
            StringTokenizer st = new StringTokenizer(year, "/-, \t\n\r\f");
            if (st.hasMoreTokens()) {
                String year2 = st.nextToken();
                try {
                    return Integer.parseInt(year2);
                }
                catch (Exception e2) {
                    this.log.log(Level.WARNING, year + "->" + year2 + " - " + e2.toString());
                }
            } else {
                this.log.log(Level.WARNING, year + " - " + e.toString());
            }
            return 0;
        }
    }
}

