/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.eevolution.manufacturing.model.MPPProductBOMLine;
import org.eevolution.manufacturing.process.CalculateLowLevelAbstract;

public class CalculateLowLevel
extends CalculateLowLevelAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        AtomicInteger countOk = new AtomicInteger(0);
        int[] productIds = new Query(this.getCtx(), "M_Product", "AD_Client_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getAD_Client_ID()}).setOrderBy("M_Product_ID").getIDs();
        Arrays.stream(productIds).filter(productId -> productId > 0).forEach(productId -> Trx.run(trxName -> {
            int lowLevel = MPPProductBOMLine.getLowLevel(this.getCtx(), productId, trxName);
            StringBuilder sql = new StringBuilder("UPDATE M_Product SET LowLevel=? WHERE M_Product_ID=?");
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            parameters.add(lowLevel);
            parameters.add(productId);
            DB.executeUpdateEx((String)sql.toString(), (Object[])parameters.toArray(), (String)trxName);
            countOk.updateAndGet(count -> count + 1);
        }));
        return "@Ok@ @Records@ " + countOk + " @Processed@";
    }
}

