/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.engine.CostDimension;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.eevolution.manufacturing.process.CopyCostTypeToCostTypeAbstract;

public class CopyCostTypeToCostType
extends CopyCostTypeToCostTypeAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getCostTypeId() == this.getCostTypeIdTo()) {
            throw new AdempiereException("@M_CostType_ID@ @NotValid@");
        }
        MAcctSchema accountSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId());
        MCostType costTypeFrom = MCostType.get((Properties)this.getCtx(), (int)this.getCostTypeId());
        MCostType costTypeTo = MCostType.get((Properties)this.getCtx(), (int)this.getCostTypeIdTo());
        MCostElement costElementFrom = MCostElement.get((Properties)this.getCtx(), (int)this.getCostElementId());
        MCostElement costElementTo = MCostElement.get((Properties)this.getCtx(), (int)this.getCostElementIdTo());
        Arrays.stream(this.getProductIds()).filter(productId -> productId > 0).forEach(productId -> Trx.run(trxName -> this.copyCostTypeToCostType(productId, accountSchema, costTypeFrom, costTypeTo, costElementFrom, costElementTo, trxName)));
        return "@Ok@";
    }

    private void copyCostTypeToCostType(int productId, MAcctSchema accountSchema, MCostType costTypeFrom, MCostType costTypeTo, MCostElement costElementFrom, MCostElement costElementTo, String trxName) {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)productId);
        CostDimension costDimensionFrom = new CostDimension(product, accountSchema, costTypeFrom.get_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElementFrom.get_ID());
        Optional<MCost> costDimensionFromOptional = Optional.ofNullable((MCost)costDimensionFrom.toQuery(MCost.class, trxName).first());
        CostDimension costDimensionTo = new CostDimension(product, accountSchema, costTypeTo.get_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElementTo.get_ID());
        Optional<MCost> costDimensionToOptional = Optional.ofNullable((MCost)costDimensionTo.toQuery(MCost.class, trxName).first());
        if (this.isUpdateCosting()) {
            if (costDimensionToOptional.isPresent() && costDimensionFromOptional.isPresent()) {
                MCost costTo = costDimensionToOptional.get();
                if (!"S".equals(costTypeFrom.getCostingMethod()) || !costTo.isCostFrozen()) {
                    costTo.setCurrentCostPrice(costDimensionFromOptional.get().getCurrentCostPrice());
                    costTo.saveEx();
                }
            } else if (!costDimensionToOptional.isPresent() && costDimensionFromOptional.isPresent()) {
                MCost costTo = MCost.getOrCreate((MProduct)product, (int)0, (MAcctSchema)accountSchema, (int)this.getOrgId(), (int)this.getWarehouseId(), (int)costTypeTo.get_ID(), (int)costElementTo.get_ID());
                if (!"S".equals(costTypeFrom.getCostingMethod()) || !costTo.isCostFrozen()) {
                    costDimensionFromOptional.ifPresent(costFrom -> costTo.setCurrentCostPrice(costFrom.getCurrentCostPrice()));
                    costTo.saveEx();
                }
            } else if (costDimensionToOptional.isPresent() && !costDimensionFromOptional.isPresent()) {
                MCost costTo = costDimensionToOptional.get();
                costTo.setCurrentCostPrice(BigDecimal.ZERO);
                costTo.saveEx();
            } else if (!costDimensionToOptional.isPresent() && !costDimensionFromOptional.isPresent()) {
                MCost costTo = MCost.getOrCreate((MProduct)product, (int)0, (MAcctSchema)accountSchema, (int)this.getOrgId(), (int)this.getWarehouseId(), (int)costTypeTo.get_ID(), (int)costElementTo.get_ID());
                costTo.setCurrentCostPrice(BigDecimal.ZERO);
                costTo.saveEx();
            }
        } else if (!costDimensionToOptional.isPresent()) {
            MCost costTo = MCost.getOrCreate((MProduct)product, (int)0, (MAcctSchema)accountSchema, (int)this.getOrgId(), (int)this.getWarehouseId(), (int)costTypeTo.get_ID(), (int)costElementTo.get_ID());
            costDimensionFromOptional.ifPresent(costFrom -> costTo.setCurrentCostPrice(costFrom.getCurrentCostPrice()));
            costTo.saveEx();
        }
    }

    private int[] getProductIds() {
        StringBuilder whereClause = new StringBuilder("1=1 ");
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (this.getProductId() > 0) {
            whereClause.append(" AND ").append("M_Product_ID").append("=? ");
            parameters.add(this.getProductId());
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=? ");
            parameters.add(this.getProductCategoryId());
        }
        if (this.getProductGroupId() > 0) {
            whereClause.append(" AND ").append("M_Product_Group_ID").append("=? ");
            parameters.add(this.getProductGroupId());
        }
        if (this.getProductClassId() > 0) {
            whereClause.append(" AND ").append("M_Product_Class_ID").append("=? ");
            parameters.add(this.getProductClassId());
        }
        if (this.getProductClassificationId() > 0) {
            whereClause.append(" AND ").append("M_Product_Classification_ID").append("=? ");
            parameters.add(this.getProductClassificationId());
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).getIDs();
    }
}

