/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderCost;
import org.eevolution.manufacturing.process.GenerateOrderCostAbstract;

public class GenerateOrderCost
extends GenerateOrderCostAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        for (MPPOrder order : this.getOrders()) {
            for (MPPOrderCost cost : this.getOrderCost(order)) {
                cost.deleteEx(true);
            }
            order.createStandardCosts();
        }
        return "@Ok@";
    }

    private List<MPPOrder> getOrders() {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        whereClause.append("DocStatus").append("=? AND ");
        parameters.add("CO");
        if (this.getOrderId() > 0) {
            whereClause.append("PP_Order_ID").append("=? AND ");
            parameters.add(this.getOrderId());
        }
        whereClause.append("TRUNC(DateOrdered, 'DD') BETWEEN ").append(DB.TO_DATE((Timestamp)this.getDateOrdered(), (boolean)true)).append(" AND ").append(DB.TO_DATE((Timestamp)this.getDateOrderedTo(), (boolean)true));
        return new Query(this.getCtx(), "PP_Order", whereClause.toString(), this.getTableName()).setClient_ID().setParameters(parameters).list();
    }

    private List<MPPOrderCost> getOrderCost(MPPOrder order) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        whereClause.append("PP_Order_ID").append("=? ");
        parameters.add(order.getPP_Order_ID());
        return new Query(this.getCtx(), "PP_Order_Cost", whereClause.toString(), this.getTableName()).setClient_ID().setParameters(parameters).list();
    }
}

