/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_I_Product_BOM;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductBOMLine;

public class ImportProductBOM
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean isImported = false;
    private int imported = 0;

    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Product_BOM bom : this.getRecords(true, false)) {
                bom.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported;
    }

    private void fillIDValues() {
        for (X_I_Product_BOM importBOM : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            int AD_Org_ID = 0;
            if (importBOM.getAD_Org_ID() > 0) {
                AD_Org_ID = this.getID("AD_Org", "AD_Org_ID = ?", new Object[]{importBOM.getAD_Org_ID()});
            }
            if (AD_Org_ID < 0 && importBOM.getOrgValue() != null) {
                AD_Org_ID = this.getID("AD_Org", "Value = ?", new Object[]{importBOM.getOrgValue()});
                importBOM.setAD_Org_ID(AD_Org_ID);
            } else {
                importBOM.setAD_Org_ID(AD_Org_ID);
            }
            int M_Product_ID = 0;
            if (importBOM.getM_Product_ID() > 0) {
                M_Product_ID = this.getID("M_Product", "M_Product_ID=?", new Object[]{importBOM.getM_Product_ID()});
            }
            if (M_Product_ID <= 0 && importBOM.getProductValue() != null) {
                M_Product_ID = this.getID("M_Product", "Value=?", new Object[]{importBOM.getProductValue()});
            }
            importBOM.setM_Product_ID(M_Product_ID);
            int M_Component_ID = 0;
            if (importBOM.getM_BOMProduct_ID() > 0) {
                M_Component_ID = this.getID("M_Product", "M_Product_ID=?", new Object[]{importBOM.getM_BOMProduct_ID()});
            }
            if (M_Component_ID <= 0 && importBOM.getProduct_BOM_Value() != null) {
                M_Component_ID = this.getID("M_Product", "Value=?", new Object[]{importBOM.getProduct_BOM_Value()});
            }
            importBOM.setM_BOMProduct_ID(M_Component_ID);
            int C_UOM_ID = 0;
            if (importBOM.getC_UOM_ID() > 0) {
                C_UOM_ID = this.getID("C_UOM", "C_UOM_ID=?", new Object[]{importBOM.getC_UOM_ID()});
            }
            if (C_UOM_ID <= 0 && importBOM.getX12DE355() != null) {
                C_UOM_ID = this.getID("C_UOM", "X12DE355=?", new Object[]{importBOM.getX12DE355()});
            }
            importBOM.setC_UOM_ID(C_UOM_ID);
            StringBuffer err = new StringBuffer("");
            if (importBOM.getAD_Org_ID() < 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (importBOM.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (importBOM.getM_BOMProduct_ID() <= 0) {
                err.append(" @M_ProductBOM_ID@ @NotFound@");
            }
            if (importBOM.getDocumentNo() == null) {
                err.append(" @FillMandatory@ @DocumentNo@");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                importBOM.setI_ErrorMsg(Msg.parseTranslation((Properties)this.getCtx(), (String)err.toString()));
            }
            importBOM.saveEx();
        }
    }

    private void importRecords() {
        for (X_I_Product_BOM importBOM : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MPPProductBOM bom = this.getMPPProductBOM(importBOM);
            MPPProductBOMLine bomLine = null;
            if (bom != null) {
                bomLine = this.importBOMLine(bom, importBOM);
            }
            if (bomLine != null) {
                importBOM.setPP_Product_BOMLine_ID(bomLine.getPP_Product_BOMLine_ID());
                importBOM.setPP_Product_BOM_ID(bom.get_ID());
                ++this.imported;
                this.isImported = true;
            }
            importBOM.setI_IsImported(this.isImported);
            importBOM.setProcessed(this.isImported);
            importBOM.saveEx();
        }
    }

    private MPPProductBOM getMPPProductBOM(X_I_Product_BOM importBOM) {
        String whereClause = "M_Product_ID=? AND Value=?";
        MPPProductBOM bom = (MPPProductBOM)new Query(Env.getCtx(), "PP_Product_BOM", "M_Product_ID=? AND Value=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{importBOM.getM_Product_ID(), importBOM.getValue()}).firstOnly();
        if (bom == null) {
            bom = new MPPProductBOM(Env.getCtx(), 0, this.get_TrxName());
            bom.setAD_Org_ID(importBOM.getAD_Org_ID());
            bom.setM_Product_ID(importBOM.getM_Product_ID());
            bom.setValue(importBOM.getValue() == null || importBOM.getValue().isEmpty() ? importBOM.getM_Product().getValue() : importBOM.getValue());
        }
        bom.setName(importBOM.getName() == null || importBOM.getName().isEmpty() ? importBOM.getM_Product().getName() : importBOM.getName());
        bom.setValidFrom(importBOM.getValidFrom());
        bom.setValidTo(importBOM.getValidTo());
        bom.setBOMType(importBOM.getBOMType());
        bom.setBOMUse(importBOM.getBOMUse());
        bom.setDescription(importBOM.getDescription());
        bom.setDocumentNo(importBOM.getDocumentNo());
        bom.setHelp(importBOM.getHelp());
        bom.setC_UOM_ID(importBOM.getM_Product().getC_UOM_ID());
        bom.saveEx();
        return bom;
    }

    private MPPProductBOMLine importBOMLine(MPPProductBOM bom, X_I_Product_BOM importBOM) {
        MPPProductBOMLine bomLine = this.getProductBOMLine(bom, importBOM);
        MProduct component = new MProduct(Env.getCtx(), importBOM.getM_BOMProduct_ID(), this.get_TrxName());
        if (bomLine == null) {
            bomLine = new MPPProductBOMLine(Env.getCtx(), 0, this.get_TrxName());
            bomLine.setAD_Org_ID(importBOM.getAD_Org_ID());
            bomLine.setPP_Product_BOM_ID(bom.get_ID());
            bomLine.setM_Product_ID(importBOM.getM_BOMProduct_ID());
        }
        bomLine.setComponentType(importBOM.getComponentType());
        bomLine.setQtyBOM(importBOM.getQtyBOM());
        bomLine.setQtyBatch(importBOM.getQtyBatch());
        bomLine.setIssueMethod(importBOM.getIssueMethod());
        bomLine.setIsQtyPercentage(importBOM.isQtyPercentage());
        bomLine.setValidFrom(importBOM.getValidFrom());
        bomLine.setM_ChangeNotice_ID(importBOM.getM_ChangeNotice_ID());
        bomLine.setIsCritical(importBOM.isCritical());
        bomLine.setCostAllocationPerc(importBOM.getCostAllocationPerc());
        bomLine.setScrap(importBOM.getScrap());
        bomLine.setAssay(importBOM.getAssay());
        bomLine.setBackflushGroup(importBOM.getBackflushGroup());
        bomLine.setLeadTimeOffset(importBOM.getLeadTimeOffset());
        if (importBOM.getC_UOM_ID() > 0) {
            bomLine.setC_UOM_ID(importBOM.getC_UOM_ID());
        } else {
            bomLine.setC_UOM_ID(component.getC_UOM_ID());
        }
        bomLine.saveEx();
        return bomLine;
    }

    private MPPProductBOMLine getProductBOMLine(MPPProductBOM bom, X_I_Product_BOM importBOM) {
        String whereClause = "PP_Product_BOM_ID=? AND M_Product_ID=? AND BackflushGroup=?";
        return (MPPProductBOMLine)new Query(Env.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=? AND M_Product_ID=? AND BackflushGroup=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{bom.getPP_Product_BOM_ID(), importBOM.getM_BOMProduct_ID(), importBOM.getBackflushGroup()}).first();
    }

    private int getID(String tableName, String whereClause, Object[] values) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(values).firstIdOnly();
    }

    private List<X_I_Product_BOM> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Product_BOM", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{imported}).list();
    }
}

