/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_PP_Product_Planning;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MMessage;
import org.compiere.model.MNote;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResource;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.distribution.model.MDDNetworkDistribution;
import org.eevolution.distribution.model.MDDNetworkDistributionLine;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.manufacturing.model.MPPMRP;
import org.eevolution.manufacturing.model.MPPMRPDetail;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductPlanning;

public class MRP
extends SvrProcess {
    protected Integer p_AD_Org_ID = 0;
    protected Integer p_M_Warehouse_ID = 0;
    protected Integer p_S_Resource_ID = 0;
    protected Boolean p_IsSynchronize = false;
    protected Boolean p_IsMPS = null;
    protected Boolean p_IsMRP = null;
    protected Boolean p_IsDRP = null;
    protected Boolean p_IsMfg = null;
    protected Boolean p_IsPur = null;
    protected Boolean p_IsLowLevel = null;
    protected Integer p_Planner_ID = null;
    protected Integer p_C_BPartner_ID = null;
    protected Integer p_M_Product_ID = null;
    protected Integer p_M_Product_Category_ID = null;
    protected String p_Version = "1";
    protected static int MRP_Regenerative = 1;
    protected static int MRP_Net_Change = 2;
    protected static int MRP_Selective = 3;
    protected static int MPR_DRP = 4;
    protected int EXECUTION_MODE = MRP_Regenerative;
    protected ArrayList<Object> parameters = new ArrayList();
    protected LinkedHashMap<Integer, BigDecimal> demands = new LinkedHashMap();
    protected LinkedHashMap<Integer, BigDecimal> supplies = new LinkedHashMap();
    private MPPProductPlanning m_product_planning = null;
    private BigDecimal QtyProjectOnHand = Env.ZERO;
    private BigDecimal QtyGrossReqs = Env.ZERO;
    private BigDecimal QtyScheduledReceipts = Env.ZERO;
    private Timestamp DatePromisedFrom = null;
    private Timestamp DatePromisedTo = null;
    private Timestamp Today = new Timestamp(System.currentTimeMillis());
    private Timestamp TimeFence = null;
    private Timestamp Planning_Horizon = null;
    private int docTypeReq_ID = 0;
    private int docTypeMO_ID = 0;
    private int docTypeMF_ID = 0;
    private int docTypeDO_ID = 0;
    private int count_MO = 0;
    private int count_MR = 0;
    private int count_DO = 0;
    private int count_Msg = 0;
    private static CCache<String, Integer> dd_order_id_cache = new CCache("DD_Order_ID", 50);
    private static CCache<Integer, MBPartner> partner_cache = new CCache("C_BPartner", 50);

    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("Synchronize")) {
                this.p_IsSynchronize = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsMPS")) {
                this.p_IsMPS = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsRequiredMRP")) {
                this.p_IsMRP = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsRequiredDRP")) {
                this.p_IsDRP = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsBOM")) {
                this.p_IsMfg = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsPurchased")) {
                this.p_IsPur = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("LowLevel")) {
                this.p_IsLowLevel = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("Planner_ID")) {
                this.p_Planner_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Produc_Category_ID")) {
                this.p_M_Product_Category_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("Version")) {
                this.p_Version = (String)para.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        int AD_Process_ID = this.getProcessInfo().getAD_Process_ID();
        if (AD_Process_ID == 53016) {
            this.EXECUTION_MODE = MRP_Regenerative;
            this.p_IsMRP = false;
            if (this.isSynchronize().booleanValue()) {
                this.p_IsDRP = false;
            }
        }
        if (AD_Process_ID == 53320) {
            this.EXECUTION_MODE = MRP_Net_Change;
            this.p_IsMRP = true;
            if (this.isSynchronize().booleanValue()) {
                this.p_IsDRP = true;
            }
        }
        if (AD_Process_ID == 53313) {
            this.EXECUTION_MODE = MRP_Selective;
        }
        if (AD_Process_ID == 53022) {
            this.EXECUTION_MODE = MPR_DRP;
            this.p_IsSynchronize = true;
            this.p_IsDRP = true;
        }
    }

    public int getAD_Org_ID() {
        return this.p_AD_Org_ID;
    }

    public int getPlant_ID() {
        return this.p_S_Resource_ID;
    }

    public Integer getM_Warehouse_ID() {
        return this.p_M_Warehouse_ID;
    }

    public Integer getM_Product_ID() {
        return this.p_M_Product_ID;
    }

    public Integer getM_Product_Category_ID() {
        return this.p_M_Product_Category_ID;
    }

    public Integer getC_BPartner_ID() {
        return this.p_C_BPartner_ID;
    }

    public Boolean isMPS() {
        return this.p_IsMPS;
    }

    public Boolean isSynchronize() {
        return this.p_IsSynchronize;
    }

    public Boolean isDRP() {
        return this.p_IsDRP;
    }

    public Boolean isMRP() {
        return this.p_IsMRP;
    }

    public Boolean isMfg() {
        return this.p_IsMfg;
    }

    public Boolean isPur() {
        return this.p_IsPur;
    }

    public Boolean isLowLevel() {
        return this.p_IsLowLevel;
    }

    public Integer getPlanner_ID() {
        return this.p_Planner_ID;
    }

    protected String doIt() throws Exception {
        List plants;
        this.parameters = new ArrayList();
        dd_order_id_cache.clear();
        partner_cache.clear();
        StringBuffer whereClause = new StringBuffer("ManufacturingResourceType=? AND AD_Client_ID=?");
        this.parameters.add("PT");
        this.parameters.add(this.getAD_Client_ID());
        if (this.getPlant_ID() > 0) {
            whereClause.append(" AND S_Resource_ID=?");
            this.parameters.add(this.getPlant_ID());
        }
        if ((plants = new Query(this.getCtx(), "S_Resource", whereClause.toString(), this.get_TrxName()).setParameters(this.parameters).list()) == null || plants.size() <= 0) {
            return MRefList.getListName((Properties)this.getCtx(), (int)53223, (String)"PT") + " @S_Resource_ID@ @NotFound@";
        }
        for (MResource plant : plants) {
            this.log.info("Run MRP to Plant: " + plant.getName());
            this.Planning_Horizon = TimeUtil.addDays((Timestamp)this.getToday(), (int)plant.getPlanningHorizon());
            this.parameters = new ArrayList();
            whereClause = new StringBuffer("AD_Client_ID=?");
            this.parameters.add(this.getAD_Client_ID());
            if (this.getAD_Org_ID() > 0) {
                whereClause.append(" AND AD_Org_ID=?");
                this.parameters.add(this.getAD_Org_ID());
            }
            List orgList = new Query(this.getCtx(), "AD_Org", whereClause.toString(), this.get_TrxName()).setParameters(this.parameters).list();
            for (MOrg org : orgList) {
                int AD_User_ID = Env.getAD_User_ID((Properties)this.getCtx());
                this.docTypeReq_ID = MPPMRP.getDocType(this.getCtx(), "POR", org.getAD_Org_ID(), AD_User_ID, this.get_TrxName());
                this.docTypeMO_ID = MPPMRP.getDocType(this.getCtx(), "MOP", org.getAD_Org_ID(), AD_User_ID, this.get_TrxName());
                this.docTypeMF_ID = MPPMRP.getDocType(this.getCtx(), "MOF", org.getAD_Org_ID(), AD_User_ID, this.get_TrxName());
                this.docTypeDO_ID = MPPMRP.getDocType(this.getCtx(), "DOO", org.getAD_Org_ID(), AD_User_ID, this.get_TrxName());
                this.log.info("Run MRP to Organization: " + org.getName());
                MWarehouse[] ws = this.getM_Warehouse_ID() <= 0 ? MWarehouse.getForOrg((Properties)this.getCtx(), (int)org.getAD_Org_ID()) : new MWarehouse[]{MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID())};
                for (MWarehouse w : ws) {
                    this.log.info("Run MRP to Wharehouse: " + w.getName());
                    this.runMRP(this.getAD_Client_ID(), org.getAD_Org_ID(), plant.getS_Resource_ID(), w.getM_Warehouse_ID());
                    StringBuffer resultMsg = new StringBuffer();
                    resultMsg.append("<br> <b> @AD_Org_ID@: </b>" + org.getName());
                    resultMsg.append("<b>, @M_Warehouse_ID@: </b>" + w.getName());
                    resultMsg.append("<b>, @S_Resource_ID@: </b>" + plant.getName());
                    resultMsg.append("<hr>");
                    resultMsg.append("<br><b>@PP_Order_ID@:</b> " + this.count_MO);
                    resultMsg.append("<br><b>@DD_Order_ID@:</b> " + this.count_DO);
                    resultMsg.append("<br><b>@M_Requisition_ID@:</b> " + this.count_MR);
                    resultMsg.append("<br><b>@AD_Note_ID@:</b> " + this.count_Msg);
                    this.count_MO = 0;
                    this.count_MR = 0;
                    this.count_DO = 0;
                    this.count_Msg = 0;
                    this.addLog("");
                    this.addLog(resultMsg.toString());
                }
            }
        }
        return "";
    }

    protected String getDeleteSQLWhere(String tableName, String where, Integer AD_Client_ID, Integer AD_Org_ID, Integer M_Warehouse_ID, Integer S_Resource_ID, Integer M_Product_ID, String typeMRP) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM PP_MRP mrp ").append(" INNER JOIN M_Product p ON (p.M_Product_ID=mrp.M_Product_ID) ").append(" LEFT JOIN PP_Product_Planning pp ON (pp.M_Product_ID = mrp.M_Product_ID AND mrp.M_Warehouse_ID = pp.M_Warehouse_ID) ").append(" WHERE ").append(where).append(" AND ");
        whereClause.append(this.getSQLWhere(tableName, AD_Client_ID, AD_Org_ID, M_Warehouse_ID, S_Resource_ID, M_Product_ID, null, typeMRP, this.Planning_Horizon));
        whereClause.append(")");
        return whereClause.toString();
    }

    protected void deleteMRP(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID, int M_Product_ID, String trxName) throws SQLException {
        StringBuilder sql = new StringBuilder("DELETE FROM AD_Note WHERE ");
        sql.append(this.getDeleteSQLWhere("mrp", "mrp.PP_MRP_ID = Record_ID AND AD_Table_ID=" + MPPMRP.Table_ID, AD_Client_ID, AD_Org_ID, null, null, M_Product_ID, null)).append(" AND (Reference LIKE '%M_Warehouse_ID->" + M_Warehouse_ID + "%') OR  (Reference LIKE '%M_Product_ID->" + M_Product_ID + "%' )");
        ArrayList<Object> myParameters = new ArrayList<Object>(this.parameters);
        DB.executeUpdateEx((String)sql.toString(), (Object[])myParameters.toArray(), (String)trxName);
        StringBuilder whereClause = new StringBuilder(this.getDeleteSQLWhere("PP_MRP", "mrp.PP_MRP_ID = PP_MRP_ID", AD_Client_ID, AD_Org_ID, M_Warehouse_ID, S_Resource_ID, M_Product_ID, null));
        myParameters = new ArrayList<Object>(this.parameters);
        sql = new StringBuilder();
        sql.append("DELETE FROM PP_MRP WHERE ").append(whereClause.toString()).append(" AND ").append("OrderType").append("=? ").append("AND ").append("DocStatus").append("=? ");
        myParameters.add("MOP");
        myParameters.add("CL");
        DB.executeUpdateEx((String)sql.toString(), (Object[])myParameters.toArray(), (String)trxName);
        String where = this.getDeleteSQLWhere("PP_Order", "mrp.PP_Order_ID = PP_Order_ID AND mrp.PP_Order_BOMLine_ID IS NULL ", AD_Client_ID, AD_Org_ID, M_Warehouse_ID, S_Resource_ID, M_Product_ID, null) + " AND DocStatus=?";
        myParameters = new ArrayList<Object>(this.parameters);
        myParameters.add("DR");
        this.deletePO("PP_Order", where, trxName, myParameters.toArray());
        whereClause = new StringBuilder(this.getDeleteSQLWhere("PP_MRP", "mrp.PP_MRP_ID = PP_MRP_ID", AD_Client_ID, AD_Org_ID, M_Warehouse_ID, null, M_Product_ID, null));
        myParameters = new ArrayList<Object>(this.parameters);
        sql = new StringBuilder();
        sql.append("DELETE FROM PP_MRP WHERE ").append(whereClause.toString()).append(" AND ").append("OrderType").append("=? ").append("AND ").append("DocStatus").append("=? ");
        myParameters.add("POO");
        myParameters.add("CL");
        DB.executeUpdateEx((String)sql.toString(), (Object[])myParameters.toArray(), (String)trxName);
        where = this.getDeleteSQLWhere("M_RequisitionLine", "mrp.M_RequisitionLine_ID = M_RequisitionLine_ID", AD_Client_ID, AD_Org_ID, M_Warehouse_ID, null, M_Product_ID, null) + " AND EXISTS (SELECT 1 FROM M_Requisition r WHERE r.M_Requisition_ID = M_Requisition_ID AND DocStatus = ?)";
        myParameters = new ArrayList<Object>(this.parameters);
        myParameters.add("DR");
        this.deletePO("M_RequisitionLine", where, trxName, myParameters.toArray());
        if (this.isSynchronize().booleanValue()) {
            where = this.getDeleteSQLWhere("DD_OrderLine", "mrp.DD_OrderLine_ID = DD_OrderLine_ID", AD_Client_ID, AD_Org_ID, null, null, M_Product_ID, "S") + " AND EXISTS (SELECT 1 FROM  M_Locator l WHERE l.M_Locator_ID=M_LocatorTo_ID AND l.M_Warehouse_ID=? )  AND EXISTS (SELECT 1 FROM  DD_Order o WHERE o.DD_Order_ID=DD_OrderLine.DD_Order_ID AND DocStatus = ?)";
            myParameters = new ArrayList<Object>(this.parameters);
            myParameters.add(M_Warehouse_ID);
            myParameters.add("DR");
            this.deletePO("DD_OrderLine", where, trxName, myParameters.toArray());
        }
        whereClause = new StringBuilder(this.getDeleteSQLWhere("PP_MRP", "mrp.PP_MRP_ID = PP_MRP_ID", AD_Client_ID, AD_Org_ID, M_Warehouse_ID, null, M_Product_ID, "S"));
        sql = new StringBuilder();
        sql.append("UPDATE PP_MRP SET IsAvailable ='Y' WHERE ").append(whereClause.toString());
        DB.executeUpdateEx((String)sql.toString(), (Object[])this.parameters.toArray(), (String)trxName);
        sql = new StringBuilder("DELETE FROM PP_MRP_Detail WHERE NOT EXISTS (SELECT 1 FROM PP_MRP WHERE PP_MRP_ID=PP_MRP_Detail.MRP_Supply_ID)");
        DB.executeUpdateEx((String)sql.toString(), (String)trxName);
    }

    protected String runMRP(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID) throws SQLException {
        Trx.run((TrxRunnable)new TrxRunnable(){
            private int AD_Client_ID;
            private int AD_Org_ID;
            private int S_Resource_ID;
            private int M_Warehouse_ID;

            public TrxRunnable setParameters(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID) {
                this.AD_Client_ID = AD_Client_ID;
                this.AD_Org_ID = AD_Org_ID;
                this.S_Resource_ID = S_Resource_ID;
                this.M_Warehouse_ID = M_Warehouse_ID;
                return this;
            }

            public void run(String trxName) {
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    MProduct product = null;
                    int BeforePP_MRP_ID = 0;
                    Timestamp BeforeDateStartSchedule = null;
                    Timestamp POQDateStartSchedule = null;
                    int lowlevel = MPPMRP.getMaxLowLevel(MRP.this.getCtx(), trxName);
                    MRP.this.log.info("Low Level Is :" + lowlevel);
                    for (int level = 0; level <= lowlevel; ++level) {
                        MRP.this.log.info("Current Level Is :" + level);
                        StringBuilder sql = new StringBuilder();
                        sql.append("SELECT mrp.M_Product_ID, mrp.LowLevel, mrp.Qty, mrp.DatePromised").append(",mrp.TypeMRP, mrp.OrderType, mrp.DateOrdered, mrp.M_Warehouse_ID").append(",mrp.PP_MRP_ID, mrp.DateStartSchedule, mrp.DateFinishSchedule").append(" FROM RV_PP_MRP mrp WHERE 1=1 ").append(MRP.this.getSQLWhere("mrp", this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, null, null, level, "D", MRP.this.Planning_Horizon)).append(" ORDER BY  mrp.M_Product_ID , mrp.DatePromised");
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                        DB.setParameters((PreparedStatement)pstmt, MRP.this.parameters);
                        rs = pstmt.executeQuery();
                        MRP.this.log.info("Records " + rs.getFetchSize() + " to process for Low Code:" + level);
                        while (rs.next()) {
                            int PP_MRP_ID = rs.getInt("PP_MRP_ID");
                            String TypeMRP = rs.getString("TypeMRP");
                            String OrderType = rs.getString("OrderType");
                            Timestamp DatePromised = rs.getTimestamp("DateStartSchedule");
                            BigDecimal Qty = rs.getBigDecimal("Qty");
                            int M_Product_ID = rs.getInt("M_Product_ID");
                            if ("D".equals(TypeMRP) && "FCT".equals(OrderType) && DatePromised.compareTo(MRP.this.getToday()) <= 0) continue;
                            if (product == null || product.get_ID() != M_Product_ID) {
                                if (MRP.this.QtyGrossReqs.signum() != 0) {
                                    if (product == null) {
                                        throw new IllegalStateException("MRP Internal Error: QtyGrossReqs=" + MRP.this.QtyGrossReqs + " and we do not have previous demand defined");
                                    }
                                    if ("POQ".equals(MRP.this.m_product_planning.getOrder_Policy()) && POQDateStartSchedule.compareTo(MRP.this.Planning_Horizon) < 0) {
                                        BeforeDateStartSchedule = POQDateStartSchedule;
                                        MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, BeforePP_MRP_ID, product, BeforeDateStartSchedule, trxName);
                                    } else if ("LFL".equals(MRP.this.m_product_planning.getOrder_Policy()) && BeforeDateStartSchedule.compareTo(MRP.this.Planning_Horizon) <= 0) {
                                        MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, BeforePP_MRP_ID, product, BeforeDateStartSchedule, trxName);
                                    }
                                    MRP.this.QtyGrossReqs = Env.ZERO;
                                }
                                if (MRP.this.m_product_planning != null) {
                                    MPPMRP.setIsRequired((PO)MRP.this.m_product_planning, "IsRequiredMRP", false, trxName);
                                }
                                product = MProduct.get((Properties)MRP.this.getCtx(), (int)M_Product_ID);
                                MRP.this.log.info("Calculte Plan to this Product:" + product);
                                MRP.this.setProduct(this.AD_Client_ID, this.AD_Org_ID, this.S_Resource_ID, this.M_Warehouse_ID, product, PP_MRP_ID, trxName);
                                if (MRP.this.m_product_planning == null) continue;
                                if ("POQ".equals(MRP.this.m_product_planning.getOrder_Policy())) {
                                    POQDateStartSchedule = null;
                                }
                            }
                            MRP.this.demands.put(PP_MRP_ID, Qty);
                            if (MRP.this.m_product_planning == null) continue;
                            int daysPOQ = MRP.this.m_product_planning.getOrder_Period().intValueExact() - 1;
                            if ("POQ".equals(MRP.this.m_product_planning.getOrder_Policy()) && MRP.this.DatePromisedTo != null && DatePromised.compareTo(MRP.this.DatePromisedTo) > 0) {
                                MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, PP_MRP_ID, product, MRP.this.DatePromisedFrom, trxName);
                                MRP.this.DatePromisedFrom = DatePromised;
                                MRP.this.DatePromisedTo = TimeUtil.addDays((Timestamp)DatePromised, (int)(daysPOQ < 0 ? 0 : daysPOQ));
                                POQDateStartSchedule = DatePromised;
                            } else if (POQDateStartSchedule == null) {
                                MRP.this.DatePromisedFrom = DatePromised;
                                MRP.this.DatePromisedTo = TimeUtil.addDays((Timestamp)DatePromised, (int)(daysPOQ < 0 ? 0 : daysPOQ));
                                POQDateStartSchedule = DatePromised;
                            }
                            if (DatePromised.compareTo(MRP.this.getToday()) < 0) {
                                String comment = Msg.translate((Properties)MRP.this.getCtx(), (String)"DatePromised") + " : " + DatePromised;
                                MRP.this.createMRPNote("MRP-150", this.AD_Org_ID, PP_MRP_ID, product, MPPMRP.getDocumentNo(PP_MRP_ID), Qty, comment, trxName);
                            }
                            BeforePP_MRP_ID = PP_MRP_ID;
                            if ("POQ".equals(MRP.this.m_product_planning.getOrder_Policy())) {
                                if (MRP.this.DatePromisedTo == null || DatePromised.compareTo(MRP.this.DatePromisedTo) > 0) continue;
                                MRP.this.QtyGrossReqs = MRP.this.QtyGrossReqs.add(Qty);
                                MRP.this.log.info("Accumulation   QtyGrossReqs:" + MRP.this.QtyGrossReqs);
                                MRP.this.log.info("DatePromised:" + DatePromised);
                                MRP.this.log.info("DatePromisedTo:" + MRP.this.DatePromisedTo);
                                Trx.get((String)trxName, (boolean)true).commit(true);
                                continue;
                            }
                            if (!"LFL".equals(MRP.this.m_product_planning.getOrder_Policy())) continue;
                            MRP.this.QtyGrossReqs = MRP.this.QtyGrossReqs.add(Qty);
                            BeforeDateStartSchedule = DatePromised;
                            MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, PP_MRP_ID, product, BeforeDateStartSchedule, trxName);
                            Trx.get((String)trxName, (boolean)true).commit(true);
                        }
                        if (MRP.this.QtyGrossReqs.signum() != 0 && product != null) {
                            if ("POQ".equals(MRP.this.m_product_planning.getOrder_Policy()) && POQDateStartSchedule.compareTo(MRP.this.Planning_Horizon) < 0) {
                                BeforeDateStartSchedule = POQDateStartSchedule;
                                MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, BeforePP_MRP_ID, product, BeforeDateStartSchedule, trxName);
                            } else if ("LFL".equals(MRP.this.m_product_planning.getOrder_Policy()) && BeforeDateStartSchedule.compareTo(MRP.this.Planning_Horizon) <= 0) {
                                MRP.this.calculatePlan(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, BeforePP_MRP_ID, product, BeforeDateStartSchedule, trxName);
                            }
                        } else if (product != null) {
                            MRP.this.getNetRequirements(this.AD_Client_ID, this.AD_Org_ID, this.M_Warehouse_ID, product, null, trxName);
                        }
                        MRP.this.createMRPPegging(trxName);
                        Trx.get((String)trxName, (boolean)true).commit(true);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Exception)ex);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
        }.setParameters(AD_Client_ID, AD_Org_ID, S_Resource_ID, M_Warehouse_ID));
        return "ok";
    }

    private void setProduct(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID, MProduct product, int PP_MRP_ID, String trxName) throws SQLException {
        String comment;
        this.createMRPPegging(trxName);
        this.deleteMRP(AD_Client_ID, AD_Org_ID, S_Resource_ID, M_Warehouse_ID, product.getM_Product_ID(), trxName);
        this.DatePromisedTo = null;
        this.DatePromisedFrom = null;
        this.m_product_planning = this.getProductPlanning(AD_Client_ID, AD_Org_ID, S_Resource_ID, M_Warehouse_ID, product, trxName);
        if (this.m_product_planning == null) {
            this.createMRPNote("MRP-120", AD_Org_ID, 0, product, (String)null, null, null, trxName);
            return;
        }
        if (this.m_product_planning.getTimeFence().signum() > 0) {
            this.TimeFence = TimeUtil.addDays((Timestamp)this.getToday(), (int)this.m_product_planning.getTimeFence().intValueExact());
        }
        this.QtyProjectOnHand = this.getQtyOnHand((I_PP_Product_Planning)this.m_product_planning, trxName);
        if (this.QtyProjectOnHand.signum() < 0) {
            comment = Msg.translate((Properties)this.getCtx(), (String)"QtyOnHand") + ": " + this.QtyProjectOnHand;
            this.createMRPNote("MRP-140", AD_Org_ID, 0, product, null, this.QtyProjectOnHand, comment, trxName);
        } else if (this.QtyProjectOnHand.signum() > 0) {
            this.supplies.put(0, this.QtyProjectOnHand);
        }
        if (this.m_product_planning.getSafetyStock().signum() > 0 && this.m_product_planning.getSafetyStock().compareTo(this.QtyProjectOnHand) > 0) {
            comment = Msg.translate((Properties)this.getCtx(), (String)"QtyOnHand") + " : " + this.QtyProjectOnHand + "\n" + Msg.translate((Properties)this.getCtx(), (String)"SafetyStock") + " : " + this.m_product_planning.getSafetyStock();
            this.createMRPNote("MRP-001", AD_Org_ID, 0, product, null, this.QtyProjectOnHand, comment, trxName);
        }
        this.log.info("QtyOnHand :" + this.QtyProjectOnHand);
    }

    protected MPPProductPlanning getProductPlanning(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID, MProduct product, String trxName) throws SQLException {
        MPPProductPlanning pp = MPPProductPlanning.find(this.getCtx(), AD_Org_ID, M_Warehouse_ID, S_Resource_ID, product.getM_Product_ID(), trxName);
        if (pp == null) {
            return null;
        }
        MPPProductPlanning pp2 = new MPPProductPlanning(this.getCtx(), 0, null);
        MPPProductPlanning.copyValues((PO)pp, (PO)pp2);
        pp2.setAD_Org_ID(pp.getAD_Org_ID());
        pp2.setIsRequiredDRP(this.isSynchronize());
        if (pp2.getPP_Product_BOM_ID() <= 0 && product.isBOM()) {
            pp2.setPP_Product_BOM_ID(MPPProductBOM.getBOMSearchKey(product));
        }
        if (pp2.getAD_Workflow_ID() <= 0 && product.isBOM()) {
            pp2.setAD_Workflow_ID(MWorkflow.getWorkflowSearchKey((MProduct)product));
        }
        if (pp2.getPlanner_ID() <= 0) {
            pp2.setPlanner_ID(this.getPlanner_ID() == null || this.getPlanner_ID() == 0 ? Env.getAD_User_ID((Properties)this.getCtx()) : this.getPlanner_ID());
        }
        if (pp2.getM_Warehouse_ID() <= 0) {
            pp2.setM_Warehouse_ID(M_Warehouse_ID);
        }
        if (pp2.getS_Resource_ID() <= 0) {
            pp2.setS_Resource_ID(S_Resource_ID);
        }
        if (pp2.getOrder_Policy() == null) {
            pp2.setOrder_Policy("LFL");
        }
        if (!this.isSynchronize().booleanValue()) {
            if (product.isPurchased()) {
                int C_BPartner_ID = 0;
                MProductPO[] ppos = MProductPO.getOfProduct((Properties)this.getCtx(), (int)product.getM_Product_ID(), (String)trxName);
                for (int i = 0; i < ppos.length; ++i) {
                    if (!ppos[i].isCurrentVendor() || ppos[i].getC_BPartner_ID() == 0) continue;
                    C_BPartner_ID = ppos[i].getC_BPartner_ID();
                    pp2.setDeliveryTime_Promised(BigDecimal.valueOf(ppos[i].getDeliveryTime_Promised()));
                    pp2.setOrder_Min(ppos[i].getOrder_Min());
                    pp2.setOrder_Max(Env.ZERO);
                    pp2.setOrder_Pack(ppos[i].getOrder_Pack());
                    pp2.setC_BPartner_ID(C_BPartner_ID);
                    break;
                }
                if (C_BPartner_ID <= 0) {
                    this.createMRPNote("MRP-130", AD_Org_ID, 0, product, (String)null, null, null, trxName);
                    pp2.setIsCreatePlan(false);
                }
            }
            if (product.isBOM() && pp2.getAD_Workflow_ID() <= 0) {
                this.log.info("Error: Do not exist workflow (" + product.getValue() + ")");
            }
        }
        return pp2;
    }

    protected BigDecimal getQtyOnHand(I_PP_Product_Planning pp, String trxName) {
        return MPPMRP.getQtyOnHand(this.getCtx(), pp.getM_Warehouse_ID(), pp.getM_Product_ID(), trxName);
    }

    protected Timestamp getToday() {
        return this.Today;
    }

    private void calculatePlan(int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID, int PP_MRP_ID, MProduct product, Timestamp DemandDateStartSchedule, String trxName) throws SQLException {
        String comment;
        this.log.info("Create Plan ...");
        if (this.m_product_planning.getM_Product_ID() != product.get_ID()) {
            throw new IllegalStateException("MRP Internal Error: DataPlanningProduct(" + this.m_product_planning.getM_Product_ID() + ") <> Product(" + product + ")");
        }
        BigDecimal yield = BigDecimal.valueOf(this.m_product_planning.getYield());
        if (yield.signum() != 0) {
            this.QtyGrossReqs = this.QtyGrossReqs.multiply(Env.ONEHUNDRED).divide(yield, 4, RoundingMode.HALF_UP);
        }
        BigDecimal QtyNetReqs = this.getNetRequirements(AD_Client_ID, AD_Org_ID, M_Warehouse_ID, product, DemandDateStartSchedule, trxName);
        BigDecimal QtyPlanned = Env.ZERO;
        this.m_product_planning.dump();
        this.log.info("                    Product:" + product);
        this.log.info(" Demand Date Start Schedule:" + DemandDateStartSchedule);
        this.log.info("           DatePromisedFrom:" + this.DatePromisedFrom + " DatePromisedTo:" + this.DatePromisedTo);
        this.log.info("                Qty Planned:" + QtyPlanned);
        this.log.info("     Qty Scheduled Receipts:" + this.QtyScheduledReceipts);
        this.log.info("           QtyProjectOnHand:" + this.QtyProjectOnHand);
        this.log.info("               QtyGrossReqs:" + this.QtyGrossReqs);
        this.log.info("                     Supply:" + this.QtyScheduledReceipts.add(this.QtyProjectOnHand));
        this.log.info("                 QtyNetReqs:" + QtyNetReqs);
        if (QtyNetReqs.signum() > 0) {
            this.QtyProjectOnHand = QtyNetReqs;
            QtyNetReqs = Env.ZERO;
            this.QtyScheduledReceipts = Env.ZERO;
            QtyPlanned = Env.ZERO;
            this.QtyGrossReqs = Env.ZERO;
            return;
        }
        QtyPlanned = QtyNetReqs.negate();
        this.QtyGrossReqs = Env.ZERO;
        this.QtyScheduledReceipts = Env.ZERO;
        if (QtyPlanned.signum() > 0 && this.m_product_planning.getOrder_Min().signum() > 0) {
            if (this.m_product_planning.getOrder_Min().compareTo(QtyPlanned) > 0) {
                comment = Msg.translate((Properties)this.getCtx(), (String)"Order_Min") + " : " + this.m_product_planning.getOrder_Min();
                this.createMRPNote("MRP-080", AD_Org_ID, PP_MRP_ID, product, null, QtyPlanned, comment, trxName);
            }
            QtyPlanned = QtyPlanned.max(this.m_product_planning.getOrder_Min());
        }
        if (this.m_product_planning.getOrder_Pack().signum() > 0 && QtyPlanned.signum() > 0) {
            QtyPlanned = this.m_product_planning.getOrder_Pack().multiply(QtyPlanned.divide(this.m_product_planning.getOrder_Pack(), 0, RoundingMode.UP));
        }
        if (QtyPlanned.compareTo(this.m_product_planning.getOrder_Max()) > 0 && this.m_product_planning.getOrder_Max().signum() > 0) {
            comment = Msg.translate((Properties)this.getCtx(), (String)"Order_Max") + " : " + this.m_product_planning.getOrder_Max();
            this.createMRPNote("MRP-090", AD_Org_ID, PP_MRP_ID, product, null, QtyPlanned, comment, trxName);
        }
        this.QtyProjectOnHand = QtyPlanned.add(QtyNetReqs);
        this.log.info("QtyNetReqs:" + QtyNetReqs);
        this.log.info("QtyPlanned:" + QtyPlanned);
        this.log.info("QtyProjectOnHand:" + this.QtyProjectOnHand);
        if (this.TimeFence != null && DemandDateStartSchedule.compareTo(this.TimeFence) < 0) {
            comment = Msg.translate((Properties)this.getCtx(), (String)"TimeFence") + " : " + this.m_product_planning.getTimeFence() + "-" + Msg.getMsg((Properties)this.getCtx(), (String)"Date") + " : " + this.TimeFence + " " + Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + DemandDateStartSchedule;
            this.createMRPNote("MRP-100", AD_Org_ID, PP_MRP_ID, product, null, QtyPlanned, comment, trxName);
        }
        if (!this.m_product_planning.isCreatePlan() && QtyPlanned.signum() > 0) {
            this.createMRPNote("MRP-020", AD_Org_ID, PP_MRP_ID, product, null, QtyPlanned, null, trxName);
            return;
        }
        if (QtyPlanned.signum() > 0) {
            int loops = 1;
            if (this.m_product_planning.getOrder_Policy().equals("FOQ")) {
                if (this.m_product_planning.getOrder_Qty().signum() != 0) {
                    loops = QtyPlanned.divide(this.m_product_planning.getOrder_Qty(), 0, RoundingMode.UP).intValueExact();
                }
                QtyPlanned = this.m_product_planning.getOrder_Qty();
            }
            for (int ofq = 1; ofq <= loops; ++ofq) {
                this.log.info("Is Purchased: " + product.isPurchased() + " Is BOM: " + product.isBOM());
                try {
                    this.createSupply(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule, trxName);
                    continue;
                }
                catch (Exception e) {
                    this.createMRPNote("MRP-160", AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule, e, trxName);
                }
            }
        } else {
            this.log.info("No Create Plan");
        }
    }

    protected void createSupply(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule, String trxName) throws AdempiereException, SQLException {
        if (this.isSynchronize().booleanValue() && this.m_product_planning.getDD_NetworkDistribution_ID() > 0) {
            this.createDDOrder(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule, trxName);
        } else if (product.isPurchased()) {
            this.createRequisition(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule, trxName);
        } else if (product.isBOM()) {
            this.createPPOrder(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule, trxName);
        } else {
            throw new IllegalStateException("MRP Internal Error: Don't know what document to create for " + product + "(" + this.m_product_planning + ")");
        }
    }

    private void createMRPPegging(String trxName) {
        if (this.demands == null || this.demands.size() == 0 || this.supplies == null || this.supplies.size() == 0) {
            return;
        }
        Iterator<Map.Entry<Integer, BigDecimal>> iteratorDemands = this.demands.entrySet().iterator();
        Iterator<Map.Entry<Integer, BigDecimal>> iteratorSupplies = this.supplies.entrySet().iterator();
        block0: while (iteratorSupplies.hasNext()) {
            Map.Entry<Integer, BigDecimal> supply = iteratorSupplies.next();
            while (iteratorDemands.hasNext()) {
                Map.Entry<Integer, BigDecimal> demand = iteratorDemands.next();
                if (demand.getValue().signum() <= 0) {
                    iteratorDemands.remove();
                    continue;
                }
                if (supply.getValue().signum() <= 0) continue;
                MPPMRPDetail detail = new MPPMRPDetail(this.getCtx(), 0, trxName);
                detail.setMRP_Demand_ID(demand.getKey());
                detail.setMRP_Supply_ID(supply.getKey());
                if (supply.getValue().compareTo(demand.getValue()) >= 0) {
                    detail.setQty(demand.getValue());
                    detail.saveEx();
                    supply.setValue(supply.getValue().subtract(demand.getValue()));
                    iteratorDemands.remove();
                    if (supply.getValue().signum() != 0) continue;
                    iteratorSupplies.remove();
                    continue block0;
                }
                detail.setQty(supply.getValue());
                detail.saveEx();
                demand.setValue(demand.getValue().subtract(supply.getValue()));
                iteratorSupplies.remove();
                continue block0;
            }
        }
        this.demands = new LinkedHashMap();
        this.supplies = new LinkedHashMap();
    }

    private MPPMRP getSupply(String columnMaster, Integer master_id, String columnDetail, Integer detail_id, String trxName) {
        StringBuilder whereClause = new StringBuilder("TypeMRP").append("=? AND ").append(columnMaster).append("=? ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add("S");
        parameters.add(master_id);
        if (columnDetail != null && detail_id != null) {
            whereClause.append(" AND ").append(columnDetail).append("=?");
            parameters.add(detail_id);
        }
        return (MPPMRP)new Query(this.getCtx(), "PP_MRP", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).first();
    }

    protected void createDDOrder(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule, String trxName) throws AdempiereException, SQLException {
        MPPMRP.setIsRequired((PO)this.m_product_planning, "IsRequiredDRP", false, trxName);
        if (this.m_product_planning.getDD_NetworkDistribution_ID() == 0) {
            this.createMRPNote("DRP-060", AD_Org_ID, PP_MRP_ID, product, (String)null, null, null, trxName);
        }
        MDDNetworkDistribution network = MDDNetworkDistribution.get((Properties)this.getCtx(), (int)this.m_product_planning.getDD_NetworkDistribution_ID());
        MDDNetworkDistributionLine[] network_lines = network.getLines(this.m_product_planning.getM_Warehouse_ID());
        int M_Shipper_ID = 0;
        MDDOrder order = null;
        Integer DD_Order_ID = 0;
        for (MDDNetworkDistributionLine network_line : network_lines) {
            if (network_line.getM_Shipper_ID() == 0) {
                String comment = Msg.translate((Properties)this.getCtx(), (String)"Name") + " : " + network.getName();
                this.createMRPNote("DRP-030", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                continue;
            }
            MWarehouse source = new MWarehouse(this.getCtx(), network_line.getM_WarehouseSource_ID(), trxName);
            MLocator locator = MLocator.getDefault((MWarehouse)source);
            if (locator == null || locator.getM_Locator_ID() <= 0) {
                String comment = Msg.translate((Properties)this.getCtx(), (String)" @M_Locator_ID@ @Default@ @NotFound@ @To@ ") + source.getName();
                this.createMRPNote("DRP-001", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                continue;
            }
            MWarehouse target = new MWarehouse(this.getCtx(), network_line.getM_Warehouse_ID(), trxName);
            MLocator locator_to = MLocator.getDefault((MWarehouse)target);
            if (locator_to == null || locator_to.getM_Locator_ID() <= 0) {
                String comment = Msg.translate((Properties)this.getCtx(), (String)" @M_Locator_ID@ @Default@ @NotFound@ @To@ ") + source.getName();
                this.createMRPNote("DRP-001", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                continue;
            }
            BigDecimal transferTime = network_line.getTransferTime();
            if (transferTime.compareTo(Env.ZERO) <= 0) {
                transferTime = this.m_product_planning.getTransferTime();
            }
            if (locator == null || locator_to == null) {
                String comment = Msg.translate((Properties)this.getCtx(), (String)"M_WarehouseSource_ID") + " : " + source.getName();
                this.createMRPNote("DRP-001", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                continue;
            }
            MWarehouse[] wsts = MWarehouse.getInTransitForOrg((Properties)this.getCtx(), (int)source.getAD_Org_ID());
            if (wsts == null || wsts.length == 0) {
                String comment = Msg.translate((Properties)this.getCtx(), (String)"Name") + " : " + MOrg.get((Properties)this.getCtx(), (int)AD_Org_ID).getName();
                this.createMRPNote("DRP-010", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                continue;
            }
            if (M_Shipper_ID != network_line.getM_Shipper_ID()) {
                MOrg org = MOrg.get((Properties)this.getCtx(), (int)locator_to.getAD_Org_ID());
                int C_BPartner_ID = org.getLinkedC_BPartner_ID(trxName);
                if (C_BPartner_ID == 0) {
                    String comment = Msg.translate((Properties)this.getCtx(), (String)"Name") + " : " + MOrg.get((Properties)this.getCtx(), (int)AD_Org_ID).getName();
                    this.createMRPNote("DRP-020", AD_Org_ID, PP_MRP_ID, product, null, null, comment, trxName);
                    continue;
                }
                MBPartner bp = this.getBPartner(C_BPartner_ID);
                DD_Order_ID = this.getDDOrder_ID(AD_Org_ID, wsts[0].get_ID(), network_line.getM_Shipper_ID(), bp.getC_BPartner_ID(), TimeUtil.getDay((long)DemandDateStartSchedule.getTime()), trxName);
                if (DD_Order_ID <= 0) {
                    order = new MDDOrder(this.getCtx(), 0, trxName);
                    order.setAD_Org_ID(target.getAD_Org_ID());
                    order.setC_BPartner_ID(C_BPartner_ID);
                    order.setAD_User_ID(bp.getPrimaryAD_User_ID());
                    order.setC_DocType_ID(this.docTypeDO_ID);
                    order.setM_Warehouse_ID(wsts[0].get_ID());
                    order.setDocAction("CO");
                    order.setDateOrdered(TimeUtil.addDays((Timestamp)DemandDateStartSchedule, (int)this.m_product_planning.getDeliveryTime_Promised().add(transferTime).negate().intValueExact()));
                    order.setDatePromised(DemandDateStartSchedule);
                    order.setM_Shipper_ID(network_line.getM_Shipper_ID());
                    order.setIsInDispute(false);
                    order.setIsInTransit(false);
                    order.setSalesRep_ID(this.m_product_planning.getPlanner_ID());
                    order.setProcessed(false);
                    order.setProcessing(false);
                    order.saveEx();
                    order.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@DD_Order_ID@ @DocumentNo@ " + order.getDocumentNo() + " @Generate@ @from@ " + this.getName())));
                    order.saveEx();
                    DD_Order_ID = order.get_ID();
                    String key = order.getAD_Org_ID() + "#" + order.getM_Warehouse_ID() + "#" + network_line.getM_Shipper_ID() + "#" + C_BPartner_ID + "#" + TimeUtil.getDay((long)DemandDateStartSchedule.getTime()) + "DR";
                    dd_order_id_cache.put((Object)key, (Object)DD_Order_ID);
                } else {
                    order = new MDDOrder(this.getCtx(), DD_Order_ID.intValue(), trxName);
                }
                M_Shipper_ID = network_line.getM_Shipper_ID();
            }
            BigDecimal QtyOrdered = QtyPlanned.multiply(network_line.getPercent()).divide(Env.ONEHUNDRED);
            MDDOrderLine oline = new MDDOrderLine(this.getCtx(), 0, trxName);
            oline.setDD_Order_ID(order.getDD_Order_ID());
            oline.setAD_Org_ID(target.getAD_Org_ID());
            oline.setM_Locator_ID(locator.getM_Locator_ID());
            oline.setM_LocatorTo_ID(locator_to.getM_Locator_ID());
            oline.setM_Product_ID(this.m_product_planning.getM_Product_ID());
            oline.setDateOrdered(order.getDateOrdered());
            oline.setDatePromised(DemandDateStartSchedule);
            oline.setQtyEntered(QtyOrdered);
            oline.setQtyOrdered(QtyOrdered);
            oline.setTargetQty(MPPMRP.getQtyReserved(this.getCtx(), target.getM_Warehouse_ID(), this.m_product_planning.getM_Product_ID(), DemandDateStartSchedule, trxName));
            oline.setIsInvoiced(false);
            oline.saveEx();
            String whereClause = "DD_OrderLine_ID=?";
            List mrpList = new Query(this.getCtx(), "PP_MRP", "DD_OrderLine_ID=?", trxName).setParameters(new Object[]{oline.getDD_OrderLine_ID()}).list();
            for (MPPMRP mrp : mrpList) {
                MDDOrder distributionOrder = new MDDOrder(mrp.getCtx(), mrp.getDD_OrderLine_ID(), mrp.get_TrxName());
                mrp.setDateOrdered(this.getToday());
                mrp.setDateOrdered(distributionOrder.getDateOrdered());
                mrp.setDateStartSchedule(mrp.getDateOrdered());
                mrp.setDatePromised(DemandDateStartSchedule);
                mrp.setDateFinishSchedule(DemandDateStartSchedule);
                mrp.saveEx();
                if (!"S".equals(mrp.getTypeMRP())) continue;
                this.supplies.put(mrp.get_ID(), mrp.getQty());
            }
            ++this.count_DO;
        }
    }

    protected void createRequisition(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule, String trxName) throws AdempiereException, SQLException {
        this.log.info("Create Requisition");
        int duration = MPPMRP.getDurationDays(QtyPlanned, (I_PP_Product_Planning)this.m_product_planning);
        int M_PriceList_ID = -1;
        if (this.m_product_planning.getC_BPartner_ID() > 0) {
            String sql = "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?";
            M_PriceList_ID = DB.getSQLValueEx((String)trxName, (String)"SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", (Object[])new Object[]{this.m_product_planning.getC_BPartner_ID()});
        }
        MRequisition req = new MRequisition(this.getCtx(), 0, trxName);
        req.setAD_Org_ID(AD_Org_ID);
        req.setAD_User_ID(this.m_product_planning.getPlanner_ID());
        req.setDateDoc(TimeUtil.addDays((Timestamp)DemandDateStartSchedule, (int)(0 - duration)));
        req.setDateRequired(DemandDateStartSchedule);
        req.setM_Warehouse_ID(this.m_product_planning.getM_Warehouse_ID());
        req.setC_DocType_ID(this.docTypeReq_ID);
        if (M_PriceList_ID > 0) {
            req.setM_PriceList_ID(M_PriceList_ID);
        }
        req.saveEx();
        req.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@M_Requisition_ID@ @DocumentNo@ " + req.getDocumentNo() + " @Generate@ @from@ " + this.getName())));
        req.saveEx();
        MRequisitionLine reqline = new MRequisitionLine(req);
        reqline.setLine(10);
        reqline.setAD_Org_ID(AD_Org_ID);
        reqline.setC_BPartner_ID(this.m_product_planning.getC_BPartner_ID());
        reqline.setM_Product_ID(this.m_product_planning.getM_Product_ID());
        reqline.setPrice();
        reqline.setPriceActual(Env.ZERO);
        reqline.setQty(QtyPlanned);
        reqline.saveEx();
        String whereClause = "M_Requisition_ID=?";
        List mrpList = new Query(this.getCtx(), "PP_MRP", "M_Requisition_ID=?", trxName).setParameters(new Object[]{req.getM_Requisition_ID()}).list();
        for (MPPMRP mrp : mrpList) {
            mrp.setDateOrdered(this.getToday());
            mrp.setS_Resource_ID(this.m_product_planning.getS_Resource_ID());
            mrp.setDatePromised(req.getDateRequired());
            mrp.setDateStartSchedule(req.getDateDoc());
            mrp.setDateFinishSchedule(DemandDateStartSchedule);
            mrp.saveEx();
            if (!"S".equals(mrp.getTypeMRP())) continue;
            this.supplies.put(mrp.get_ID(), mrp.getQty());
        }
        ++this.count_MR;
    }

    protected void createPPOrder(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule, String trxName) throws AdempiereException, SQLException {
        this.log.info("PP_Product_BOM_ID:" + this.m_product_planning.getPP_Product_BOM_ID() + ", AD_Workflow_ID:" + this.m_product_planning.getAD_Workflow_ID());
        if (this.m_product_planning.getPP_Product_BOM_ID() == 0 || this.m_product_planning.getAD_Workflow_ID() == 0) {
            throw new AdempiereException("@FillMandatory@ @PP_Product_BOM_ID@, @AD_Workflow_ID@ ( @M_Product_ID@=" + product.getValue() + ")");
        }
        int duration = MPPMRP.getDurationDays(QtyPlanned, (I_PP_Product_Planning)this.m_product_planning);
        MPPOrder order = new MPPOrder(this.getCtx(), 0, trxName);
        order.setAD_Org_ID(AD_Org_ID);
        order.setLine(10);
        if ("M".equals(this.getBOMType(trxName))) {
            this.log.info("Maintenance Order Created");
            order.setC_DocTypeTarget_ID(this.docTypeMF_ID);
            order.setC_DocType_ID(this.docTypeMF_ID);
        } else {
            this.log.info("Manufacturing Order Created");
            order.setC_DocTypeTarget_ID(this.docTypeMO_ID);
            order.setC_DocType_ID(this.docTypeMO_ID);
        }
        order.setS_Resource_ID(this.m_product_planning.getS_Resource_ID());
        order.setM_Warehouse_ID(this.m_product_planning.getM_Warehouse_ID());
        order.setM_Product_ID(this.m_product_planning.getM_Product_ID());
        order.setM_AttributeSetInstance_ID(0);
        order.setPP_Product_BOM_ID(this.m_product_planning.getPP_Product_BOM_ID());
        order.setAD_Workflow_ID(this.m_product_planning.getAD_Workflow_ID());
        order.setPlanner_ID(this.m_product_planning.getPlanner_ID());
        order.setDateOrdered(this.getToday());
        order.setDatePromised(DemandDateStartSchedule);
        order.setDateStartSchedule(TimeUtil.addDays((Timestamp)DemandDateStartSchedule, (int)(0 - duration)));
        order.setDateFinishSchedule(DemandDateStartSchedule);
        order.setQty(QtyPlanned);
        order.setC_UOM_ID(product.getC_UOM_ID());
        order.setYield(Env.ZERO);
        order.setScheduleType("D");
        order.setPriorityRule("5");
        order.setDocAction("CO");
        order.saveEx();
        order.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@PP_Order_ID@ @DocumentNo@ " + order.getDocumentNo() + " @Generate@ @from@ " + this.getName())));
        order.saveEx();
        MPPMRP mrp = this.getSupply("PP_Order_ID", order.get_ID(), null, null, trxName);
        this.supplies.put(mrp.get_ID(), mrp.getQty());
        ++this.count_MO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePO(String tableName, String whereClause, String trxName, Object ... params) throws SQLException {
        try (POResultSet rs = new Query(this.getCtx(), tableName, whereClause, trxName).setParameters(params).scroll();){
            while (rs.hasNext()) {
                rs.next().deleteEx(true);
            }
        }
    }

    protected void createMRPNote(String code, int AD_Org_ID, int PP_MRP_ID, MProduct product, String documentNo, BigDecimal qty, String comment, String trxName) throws SQLException {
        int M_Warehouse_ID = MPPMRP.getM_Warehouse_ID(PP_MRP_ID, trxName);
        documentNo = documentNo != null ? documentNo : "";
        comment = comment != null ? comment : "";
        qty = qty != null ? qty : Env.ZERO;
        MMessage msg = MMessage.get((Properties)this.getCtx(), (String)code);
        if (msg == null) {
            msg = MMessage.get((Properties)this.getCtx(), (String)"MRP-999");
        }
        String message = msg.getValue() + " " + Msg.getMsg((Properties)this.getCtx(), (String)msg.getValue());
        int user_id = 0;
        if (this.m_product_planning != null) {
            user_id = this.m_product_planning.getPlanner_ID();
        }
        if (M_Warehouse_ID > 0) {
            String warehouseName = DB.getSQLValueString((String)trxName, (String)"SELECT Name FROM M_Warehouse  WHERE M_Warehouse_ID=? ", (int)MPPMRP.getM_Warehouse_ID(PP_MRP_ID, trxName));
            message = message + "\n" + Msg.translate((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " : " + warehouseName;
        }
        if (product != null) {
            message = message + "\n" + Msg.translate((Properties)this.getCtx(), (String)"M_Product_ID") + " : " + product.getValue() + " " + product.getName();
        }
        if (!Util.isEmpty((String)documentNo, (boolean)true)) {
            message = message + "\n" + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo") + " : " + documentNo;
        }
        if (qty != null) {
            message = message + "\n" + Msg.translate((Properties)this.getCtx(), (String)"QtyPlan") + " : " + qty;
        }
        if (!Util.isEmpty((String)comment, (boolean)true)) {
            message = message + "\n" + comment;
        }
        Object reference = "";
        if (PP_MRP_ID > 0) {
            reference = "M_Warehouse_ID->" + M_Warehouse_ID + " | ";
        }
        reference = (String)(reference != "" ? reference : reference) + "M_Product_ID->" + product.get_ID();
        MNote note = new MNote(this.getCtx(), msg.getAD_Message_ID(), user_id, MPPMRP.Table_ID, PP_MRP_ID, (String)reference, message, trxName);
        note.setAD_Org_ID(AD_Org_ID);
        note.saveEx();
        String noteMessage = documentNo != null && documentNo.length() > 0 ? "@DocumentNo@ : " + documentNo + " -> " + message : message;
        this.addLog(noteMessage);
        this.log.info(code + ": " + note.getTextMsg());
        ++this.count_Msg;
    }

    private void createMRPNote(String code, MPPMRP mrp, MProduct product, String comment, String trxName) throws SQLException {
        this.createMRPNote(code, mrp.getAD_Org_ID(), mrp.get_ID(), product, MPPMRP.getDocumentNo(mrp.get_ID()), mrp.getQty(), comment, trxName);
    }

    protected void createMRPNote(String code, int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal qty, Timestamp DemandDateStartSchedule, Exception e, String trxName) throws SQLException {
        String documentNo = null;
        String comment = e.getLocalizedMessage();
        this.createMRPNote(code, AD_Org_ID, PP_MRP_ID, product, documentNo, qty, comment, trxName);
    }

    private int getDDOrder_ID(int AD_Org_ID, int M_Warehouse_ID, int M_Shipper_ID, int C_BPartner_ID, Timestamp DatePromised, String trxName) {
        String key = AD_Org_ID + "#" + M_Warehouse_ID + "#" + M_Shipper_ID + "#" + C_BPartner_ID + "#" + DatePromised + "DR";
        Integer order_id = (Integer)dd_order_id_cache.get((Object)key.toString());
        if (order_id == null) {
            String sql = "SELECT DD_Order_ID FROM DD_Order WHERE AD_Org_ID=? AND M_Warehouse_ID=? AND M_Shipper_ID = ? AND C_BPartner_ID=? AND TRUNC(DatePromised)=? AND DocStatus=?";
            order_id = DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{AD_Org_ID, M_Warehouse_ID, M_Shipper_ID, C_BPartner_ID, DatePromised, "DR"});
            if (order_id > 0) {
                dd_order_id_cache.put((Object)key, (Object)order_id);
            }
        }
        return order_id;
    }

    private MBPartner getBPartner(int C_BPartner_ID) {
        MBPartner partner = (MBPartner)partner_cache.get((Object)C_BPartner_ID);
        if (partner == null) {
            partner = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
            partner_cache.put((Object)C_BPartner_ID, (Object)partner);
        }
        return partner;
    }

    private BigDecimal getNetRequirements(int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID, MProduct product, Timestamp DemandDateStartSchedule, String trxName) throws SQLException {
        BigDecimal QtyNetReqs = this.QtyProjectOnHand.subtract(this.QtyGrossReqs);
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_Warehouse_ID=? AND TypeMRP=? AND DocStatus IN (?,?,?) AND Qty<>0 AND IsAvailable=?";
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(AD_Client_ID);
        parameters.add(AD_Org_ID);
        parameters.add(product.get_ID());
        parameters.add(M_Warehouse_ID);
        parameters.add("S");
        parameters.add("CO");
        parameters.add("IP");
        parameters.add("DR");
        parameters.add(true);
        List mrps = new Query(this.getCtx(), "PP_MRP", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_Warehouse_ID=? AND TypeMRP=? AND DocStatus IN (?,?,?) AND Qty<>0 AND IsAvailable=?", trxName).setParameters(parameters).setOrderBy("DateStartSchedule").list();
        for (MPPMRP mrp : mrps) {
            String comment;
            if (mrp.isReleased()) {
                this.QtyScheduledReceipts = this.QtyScheduledReceipts.add(mrp.getQty());
                this.supplies.put(mrp.get_ID(), mrp.getQty());
            }
            if (DemandDateStartSchedule != null) {
                if (mrp.isReleased() && QtyNetReqs.negate().signum() > 0 && mrp.getDateStartSchedule() != null && mrp.getDateStartSchedule().compareTo(DemandDateStartSchedule) < 0) {
                    comment = Msg.translate((Properties)this.getCtx(), (String)"DateStartSchedule") + " : " + mrp.getDateStartSchedule() + "\n" + Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + DemandDateStartSchedule;
                    this.createMRPNote("MRP-030", mrp, product, comment, trxName);
                }
                if (mrp.isReleased() && QtyNetReqs.negate().signum() > 0 && mrp.getDateStartSchedule() != null && mrp.getDateStartSchedule().compareTo(DemandDateStartSchedule) > 0) {
                    comment = Msg.translate((Properties)this.getCtx(), (String)"DateStartSchedule") + " : " + mrp.getDateStartSchedule() + "\n " + Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + DemandDateStartSchedule;
                    this.createMRPNote("MRP-040", mrp, product, comment, trxName);
                }
                if (!mrp.isReleased() && QtyNetReqs.negate().signum() > 0 && mrp.getDateStartSchedule() != null && mrp.getDatePromised().compareTo(this.getToday()) >= 0) {
                    comment = Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + mrp.getDatePromised();
                    this.createMRPNote("MRP-060", mrp, product, comment, trxName);
                }
                if (!mrp.isReleased() && QtyNetReqs.negate().signum() > 0 && mrp.getDateStartSchedule() != null && mrp.getDatePromised().compareTo(this.getToday()) < 0) {
                    comment = Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + mrp.getDatePromised();
                    this.createMRPNote("MRP-070", mrp, product, comment, trxName);
                }
                if (mrp.isReleased() && mrp.getDateStartSchedule() != null && mrp.getDatePromised().compareTo(this.getToday()) < 0) {
                    comment = Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + mrp.getDatePromised();
                    this.createMRPNote("MRP-110", mrp, product, comment, trxName);
                }
                mrp.setIsAvailable(false);
                mrp.saveEx();
                if ((QtyNetReqs = QtyNetReqs.add(mrp.getQty())).signum() < 0) continue;
                return QtyNetReqs;
            }
            if (mrp.isReleased() && this.QtyScheduledReceipts.signum() > 0) {
                comment = Msg.translate((Properties)this.getCtx(), (String)"DatePromised") + " : " + mrp.getDatePromised();
                this.createMRPNote("MRP-050", mrp, product, comment, trxName);
            }
            mrp.setIsAvailable(false);
            mrp.saveEx();
            QtyNetReqs = QtyNetReqs.add(mrp.getQty());
        }
        return QtyNetReqs;
    }

    private String getBOMType(String trxName) {
        if (this.m_product_planning == null || this.m_product_planning.getPP_Product_BOM_ID() == 0) {
            return null;
        }
        String BOMType = DB.getSQLValueString((String)trxName, (String)"SELECT BOMType FROM PP_Product_BOM WHERE PP_Product_BOM_ID = ?", (int)this.m_product_planning.getPP_Product_BOM_ID());
        return BOMType;
    }

    private String getSQLWhere(String tableName, Integer AD_Client_ID, Integer AD_Org_ID, Integer M_Warehouse_ID, Integer S_Resource_ID, Integer M_Product_ID, Integer LowLevel, String typeMRP, Timestamp DatePromised) {
        StringBuilder whereClause = new StringBuilder();
        this.parameters = new ArrayList();
        if (M_Product_ID != null) {
            whereClause.append(tableName).append(".").append("M_Product_ID").append("=? ");
            this.parameters.add(M_Product_ID);
        }
        if (typeMRP != null) {
            whereClause.append(" AND ").append("mrp.").append("TypeMRP").append("=?");
            this.parameters.add(typeMRP);
        }
        if (AD_Client_ID != null && AD_Client_ID > 0) {
            whereClause.append(" AND ").append("mrp.").append("AD_Client_ID").append("=? ");
            this.parameters.add(AD_Client_ID);
        }
        if (AD_Org_ID != null && AD_Org_ID > 0) {
            whereClause.append(" AND ").append("mrp.").append("AD_Org_ID").append("=? ");
            this.parameters.add(AD_Org_ID);
        }
        if (M_Warehouse_ID != null && M_Warehouse_ID > 0) {
            whereClause.append(" AND ").append("mrp.").append("M_Warehouse_ID").append("=? ");
            this.parameters.add(M_Warehouse_ID);
        }
        if (S_Resource_ID != null && S_Resource_ID > 0) {
            whereClause.append(" AND ").append("mrp.").append("S_Resource_ID").append("=? ");
            this.parameters.add(S_Resource_ID);
        }
        if (DatePromised != null) {
            whereClause.append(" AND ").append("mrp.").append("DatePromised").append("<=? ");
            this.parameters.add(DatePromised);
        }
        if (LowLevel != null) {
            whereClause.append(" AND ").append("COALESCE(LowLevel,0)=? ");
            this.parameters.add(LowLevel);
        }
        if (this.EXECUTION_MODE == MRP_Selective) {
            if (this.isMPS() != null) {
                whereClause.append(" AND ").append("IsMPS").append("=?");
                this.parameters.add(this.isMPS());
            }
            if (this.isMRP() != null) {
                whereClause.append(" AND ").append("IsRequiredMRP").append("=?");
                this.parameters.add(this.isMRP());
            }
            if (this.isDRP() != null) {
                whereClause.append(" AND ").append("IsRequiredDRP").append("=?");
                this.parameters.add(this.isDRP());
            }
            if (this.isMfg() != null) {
                whereClause.append(" AND ").append("IsBOM").append("=?");
                this.parameters.add(this.isMfg());
            }
            if (this.isPur() != null) {
                whereClause.append(" AND ").append("IsPurchased").append("=?");
                this.parameters.add(this.isPur());
            }
            if (this.isLowLevel() != null) {
                // empty if block
            }
            if (this.getPlanner_ID() != null && this.getPlanner_ID() > 0) {
                whereClause.append(" AND ").append("mrp.").append("Planner_ID").append("=?");
                this.parameters.add(this.getPlanner_ID());
            }
            if (this.getC_BPartner_ID() != null && this.getC_BPartner_ID() > 0) {
                whereClause.append(" AND ").append("mrp.").append("C_BPartner_ID").append("=?");
                this.parameters.add(this.getC_BPartner_ID());
            }
            if (this.getM_Product_ID() != null && this.getM_Product_ID() > 0) {
                whereClause.append(" AND ").append(tableName).append(".").append("M_Product_ID").append("=?");
                this.parameters.add(this.getM_Product_ID());
            }
            if (this.getM_Product_Category_ID() != null && this.getM_Product_Category_ID() > 0) {
                whereClause.append(" AND ").append("M_Product_Category_ID").append("=?");
                this.parameters.add(this.getM_Product_Category_ID());
            }
        }
        if (this.EXECUTION_MODE == MRP_Net_Change) {
            if (this.isMRP() != null) {
                whereClause.append(" AND ").append("IsRequiredMRP").append("=?");
                this.parameters.add(this.isMRP());
            }
            if (this.isDRP() != null && this.isSynchronize().booleanValue()) {
                whereClause.append(" AND ").append("IsRequiredDRP").append("=?");
                this.parameters.add(this.isDRP());
            }
        }
        return whereClause.toString();
    }

    public boolean isRequiredDRP() {
        return false;
    }
}

