/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.wf.MWorkflow;
import org.eevolution.manufacturing.model.MPPMRP;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductPlanning;
import org.eevolution.manufacturing.process.RollupBillOfMaterialAbstract;

public class RollupBillOfMaterial
extends RollupBillOfMaterialAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        int maxLowLevel;
        MAcctSchema acctSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId());
        MCostType costType = MCostType.get((Properties)this.getCtx(), (int)this.getCostTypeId());
        final List<MCostElement> costElements = this.getCostElementId() > 0 ? Arrays.asList(MCostElement.get((Properties)this.getCtx(), (int)this.getCostElementId())) : MCostElement.getCostElement((Properties)this.getCtx(), (String)this.get_TrxName());
        for (int lowLevel = maxLowLevel = MPPMRP.getMaxLowLevel(this.getCtx(), this.get_TrxName()); lowLevel >= 0; --lowLevel) {
            Arrays.stream(this.getProductIds(lowLevel)).filter(productId -> productId > 0).forEach(productId -> {
                MPPProductBOM bom;
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)productId);
                MPPProductPlanning productPlanning = MPPProductPlanning.find(this.getCtx(), this.getOrgId(), this.getWarehouseId(), this.getResourceId(), productId, this.get_TrxName());
                int bomId = 0;
                if (productPlanning != null) {
                    bomId = productPlanning.getPP_Product_BOM_ID();
                } else {
                    this.createNotice(product, Msg.parseTranslation((Properties)this.getCtx(), (String)"@NotFound@ @PP_Product_Planning_ID@"));
                }
                if (bomId <= 0) {
                    bomId = MPPProductBOM.getBOMSearchKey(product);
                }
                if ((bom = MPPProductBOM.get(this.getCtx(), bomId)) == null) {
                    this.createNotice(product, Msg.parseTranslation((Properties)this.getCtx(), (String)"@NotFound@ @PP_Product_BOM_ID@"));
                }
                Trx.run((TrxRunnable)new TrxRunnable(){
                    MAcctSchema acctSchema;
                    MCostType costType;
                    MProduct product;
                    MPPProductBOM bom;

                    public TrxRunnable setParameters(MAcctSchema acctSchema, MCostType costType, MProduct product, MPPProductBOM bom) {
                        this.acctSchema = acctSchema;
                        this.costType = costType;
                        this.product = product;
                        this.bom = bom;
                        return this;
                    }

                    public void run(String trxName) {
                        costElements.stream().filter(costElement -> costElement != null).forEach(costElement -> RollupBillOfMaterial.this.rollup(this.acctSchema, this.costType, (MCostElement)costElement, this.product, this.bom, trxName));
                    }
                }.setParameters(acctSchema, costType, product, bom));
            });
        }
        return "@OK@";
    }

    protected void rollup(MAcctSchema acctSchema, MCostType costType, MCostElement costElement, MProduct product, MPPProductBOM bom, String trxName) {
        MCost cost = MCost.getOrCreate((MProduct)product, (int)0, (MAcctSchema)acctSchema, (int)this.getOrgId(), (int)this.getWarehouseId(), (int)costType.getM_CostType_ID(), (int)costElement.getM_CostElement_ID());
        cost.setFutureCostPriceLL(BigDecimal.ZERO);
        if (!cost.isCostFrozen()) {
            cost.setCurrentCostPriceLL(BigDecimal.ZERO);
        }
        this.log.info("Calculate Lower Cost for : " + bom);
        BigDecimal price = this.getFutureCostPriceLowLevel(acctSchema, bom, costElement, trxName);
        this.log.info(" Product :" + product.getName() + " Element Cost : " + costElement.getName() + " Cost Low Level : " + price);
        cost.setFutureCostPriceLL(price);
        if (!cost.isCostFrozen()) {
            cost.setCurrentCostPriceLL(price);
        }
        this.updateCoProductCosts(bom, cost, trxName);
        cost.saveEx();
    }

    private void updateCoProductCosts(MPPProductBOM bom, MCost baseDimension, String trxName) {
        if (bom == null) {
            return;
        }
        AtomicReference<BigDecimal> costPriceTotal = new AtomicReference<BigDecimal>(Env.ZERO);
        Arrays.stream(bom.getLines()).filter(bomLine -> bomLine != null && bomLine.isCoProduct()).forEach(bomLine -> {
            BigDecimal costPrice = baseDimension.getFutureCostPriceLL().multiply(bomLine.getCostAllocationPerc(true));
            MCost dimension = MCost.getDimension((MProduct)((MProduct)bomLine.getM_Product()), (int)baseDimension.getC_AcctSchema_ID(), (int)baseDimension.getAD_Org_ID(), (int)baseDimension.getM_Warehouse_ID(), (int)0, (int)baseDimension.getM_CostType_ID(), (int)baseDimension.getM_CostElement_ID());
            if (dimension == null) {
                dimension = new MCost(baseDimension.getCtx(), 0, trxName);
                dimension.setAD_Org_ID(baseDimension.getAD_Org_ID());
                dimension.setM_Product_ID(bomLine.getM_Product_ID());
                dimension.setM_Warehouse_ID(baseDimension.getM_Warehouse_ID());
                dimension.setM_CostType_ID(baseDimension.getM_CostType_ID());
                dimension.setC_AcctSchema_ID(baseDimension.getC_AcctSchema_ID());
                dimension.setM_CostElement_ID(baseDimension.getM_CostElement_ID());
                dimension.setM_AttributeSetInstance_ID(0);
            }
            dimension.setFutureCostPriceLL(costPrice);
            if (!dimension.isCostFrozen()) {
                dimension.setCurrentCostPriceLL(costPrice);
            }
            dimension.saveEx();
            costPriceTotal.updateAndGet(costAmt -> costAmt.add(costPrice));
        });
        if (costPriceTotal.get().signum() != 0) {
            baseDimension.setFutureCostPriceLL(costPriceTotal.get());
        }
    }

    private BigDecimal getFutureCostPriceLowLevel(MAcctSchema acctSchema, MPPProductBOM bom, MCostElement costElement, String trxName) {
        this.log.info("Element: " + costElement);
        AtomicReference<BigDecimal> costPriceLowLevel = new AtomicReference<BigDecimal>(Env.ZERO);
        if (bom == null) {
            return costPriceLowLevel.get();
        }
        Arrays.stream(bom.getLines()).filter(bomLine -> bomLine != null && !bomLine.isCoProduct()).forEach(bomLine -> {
            BigDecimal costPrice;
            MProduct component = MProduct.get((Properties)this.getCtx(), (int)bomLine.getM_Product_ID());
            MCost cost = MCost.getOrCreate((MProduct)component, (int)0, (MAcctSchema)acctSchema, (int)this.getOrgId(), (int)this.getWarehouseId(), (int)this.getCostTypeId(), (int)costElement.getM_CostElement_ID());
            Boolean includingScrapQty = true;
            BigDecimal qty = bomLine.getQty(includingScrapQty);
            if (bomLine.isByProduct()) {
                cost.setFutureCostPriceLL(Env.ZERO);
            }
            if ((costPrice = cost.getFutureCostPrice().add(cost.getFutureCostPriceLL())).equals(BigDecimal.ZERO)) {
                costPrice = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
            }
            if (bomLine.getM_Product().getC_UOM_ID() != bomLine.getC_UOM_ID()) {
                BigDecimal rate = MUOMConversion.getProductRateFrom((Properties)this.getCtx(), (int)component.getM_Product_ID(), (int)bomLine.getC_UOM_ID());
                costPrice = rate == null ? costPrice.multiply(BigDecimal.ONE) : costPrice.multiply(rate);
            }
            if (bomLine.isPacking()) {
                BigDecimal qtyBatchSize;
                int workflowId = 0;
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)bom.getM_Product_ID());
                MPPProductPlanning productPlanning = null;
                if (workflowId <= 0) {
                    workflowId = MWorkflow.getWorkflowSearchKey((MProduct)product);
                }
                if (workflowId <= 0) {
                    productPlanning = MPPProductPlanning.find(this.getCtx(), this.getOrgId(), this.getWarehouseId(), this.getResourceId(), product.get_ID(), this.get_TrxName());
                    if (productPlanning != null) {
                        workflowId = productPlanning.getAD_Workflow_ID();
                    } else {
                        this.createNotice(product, "@NotFound@ @PP_Product_Planning_ID@");
                    }
                }
                if (workflowId <= 0) {
                    this.createNotice(product, "@NotFound@ @AD_Workflow_ID@");
                }
                if ((qtyBatchSize = DB.getSQLValueBD((String)trxName, (String)"SELECT QtyBatchSize FROM AD_Workflow WHERE AD_Workflow_ID=?", (int)workflowId)) != null && qtyBatchSize.signum() != 0) {
                    qty = qty.divide(qtyBatchSize, acctSchema.getCostingPrecision(), RoundingMode.HALF_UP);
                }
            }
            BigDecimal componentCost = costPrice.multiply(qty);
            costPriceLowLevel.updateAndGet(costAmt -> costAmt.add(componentCost));
            this.log.info("CostElement: " + costElement.getName() + ", Component: " + component.getValue() + ", CostPrice: " + costPrice + ", Qty: " + qty + ", Cost: " + componentCost + " => Total Cost Element: " + costPriceLowLevel.get());
        });
        return costPriceLowLevel.get();
    }

    private int[] getProductIds(int lowLevel) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=?").append(" AND ").append("LowLevel").append("=?");
        params.add(this.getAD_Client_ID());
        params.add(lowLevel);
        whereClause.append(" AND ").append("IsBOM").append("=?");
        params.add(true);
        if (this.getProductId() > 0) {
            whereClause.append(" AND ").append("M_Product_ID").append("=?");
            params.add(this.getProductId());
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=?");
            params.add(this.getProductCategoryId());
        }
        if (this.getProductClassId() > 0) {
            whereClause.append(" AND ").append("M_Product_Class_ID").append("=?");
            params.add(this.getProductClassId());
        }
        if (this.getProductGroupId() > 0) {
            whereClause.append(" AND ").append("M_Product_Group_ID").append("=?");
            params.add(this.getProductGroupId());
        }
        if (this.getProductClassificationId() > 0) {
            whereClause.append(" AND ").append("M_Product_Classification_ID").append("=?");
            params.add(this.getProductClassificationId());
        }
        if (this.getProductId() <= 0 && this.getProductType() != null) {
            whereClause.append(" AND ").append("ProductType").append("=?");
            params.add(this.getProductType());
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setParameters(params).getIDs();
    }

    private void createNotice(MProduct product, String msg) {
        String productValue = product != null ? product.getValue() : "-";
        this.addLog("WARNING: Product " + productValue + ": " + msg);
    }
}

