/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_T_BOMLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductBOMLine;
import org.eevolution.manufacturing.process.SimulatedPickListAbstract;

public class SimulatedPickList
extends SimulatedPickListAbstract {
    private int SeqNo = 0;
    private String levels = new String("....................");
    private int levelNo = 1;

    protected String doIt() throws Exception {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        if (!product.isVerified()) {
            throw new AdempiereException("Product BOM Configuration not verified. Please verify the product first - " + product.getValue());
        }
        try {
            this.loadBOM();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "PrintBOM", (Object)e.toString());
            throw new Exception(e.getLocalizedMessage());
        }
        return "@OK@";
    }

    private void loadBOM() throws Exception {
        int count = 0;
        if (this.getProductId() == 0) {
            this.raiseError("Error: ", "Product ID not found");
        }
        MProduct product = new MProduct(this.getCtx(), this.getProductId(), this.get_TrxName());
        X_T_BOMLine tboml = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
        tboml.setAD_Org_ID(product.getAD_Org_ID());
        tboml.setPP_Product_BOM_ID(0);
        tboml.setPP_Product_BOMLine_ID(0);
        tboml.setSel_Product_ID(this.getProductId());
        tboml.setM_Product_ID(this.getProductId());
        tboml.setSel_Product_ID(this.getProductId());
        tboml.setDateTrx(this.getDateTrx());
        tboml.setImplosion(false);
        tboml.setLevelNo(0);
        tboml.setLevels("0");
        tboml.setQtyBOM(Env.ONE);
        tboml.setQtyRequired(this.getQtyRequired());
        tboml.setM_Warehouse_ID(this.getWarehouseId());
        tboml.setSeqNo(0);
        tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
        tboml.saveEx();
        String whereClause = "M_Product_ID=?";
        List boms = new Query(this.getCtx(), "PP_Product_BOM", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{this.getProductId()}).list();
        for (MPPProductBOM bom : boms) {
            if (!bom.isValidFromTo(this.getDateTrx())) continue;
            this.parentExplotion(bom.get_ID(), this.getQtyRequired());
            ++count;
        }
        if (count == 0) {
            this.raiseError("Error: ", "Product is not a BOM");
        }
    }

    public void parentExplotion(int PP_Product_BOM_ID, BigDecimal qtyRequiered) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(PP_Product_BOM_ID);
        StringBuilder whereClause = new StringBuilder("PP_Product_BOM_ID").append("=?");
        if (this.getBackflushGroup() != null) {
            whereClause.append(" AND ").append("BackflushGroup").append("LIKE ?");
            parameters.add(this.getBackflushGroup());
        }
        List bomLines = new Query(this.getCtx(), "PP_Product_BOMLine", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("Line").list();
        for (MPPProductBOMLine line : bomLines) {
            if (!line.isValidFromTo(this.getDateTrx())) continue;
            ++this.SeqNo;
            MProduct product = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
            X_T_BOMLine tboml = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
            tboml.setAD_Org_ID(product.getAD_Org_ID());
            tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
            tboml.setPP_Product_BOMLine_ID(line.get_ID());
            tboml.setM_Product_ID(line.getM_Product_ID());
            tboml.setLevelNo(this.levelNo);
            tboml.setDateTrx(this.getDateTrx());
            tboml.setLevels(this.levels.substring(0, this.levelNo) + this.levelNo);
            tboml.setSeqNo(this.SeqNo);
            tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
            tboml.setSel_Product_ID(this.getProductId());
            tboml.setQtyBOM(line.getQty(true));
            tboml.setQtyRequired(qtyRequiered.multiply(line.getQty(true)));
            tboml.setM_Warehouse_ID(this.getWarehouseId());
            tboml.setImplosion(false);
            tboml.saveEx();
            this.component(line.getM_Product_ID(), tboml.getQtyBOM());
        }
    }

    public void component(int M_Product_ID, BigDecimal qtyRequiered) throws Exception {
        if (this.levelNo == this.getSimulateLevelNo()) {
            return;
        }
        String value = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT Value FROM M_Product WHERE M_Product_ID=?", (int)M_Product_ID);
        StringBuilder whereClause = new StringBuilder("Value").append("=? AND ").append("M_Product_ID").append("=?");
        List boms = new Query(this.getCtx(), "PP_Product_BOM", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{value, M_Product_ID}).list();
        boolean level = false;
        for (MPPProductBOM bom : boms) {
            if (!bom.isValidFromTo(this.getDateTrx())) continue;
            if (!level) {
                ++this.levelNo;
            }
            level = true;
            this.parentExplotion(bom.get_ID(), qtyRequiered);
            --this.levelNo;
        }
    }

    private void raiseError(String string, String hint) throws Exception {
        Object msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = (String)msg + hint;
        throw new Exception((String)msg);
    }
}

