/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.services;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_AD_WF_Node;
import org.adempiere.core.domains.models.I_M_CostElement;
import org.adempiere.core.domains.models.I_PP_Cost_Collector;
import org.adempiere.engine.CostDimension;
import org.adempiere.engine.CostEngine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;
import org.eevolution.manufacturing.model.MPPOrderCost;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class StandardCostCollector {
    public static BigDecimal getResourceStandardCostRate(MPPCostCollector cc, int S_Resource_ID, CostDimension d, String trxName) {
        MProduct resourceProduct = MProduct.forS_Resource_ID((Properties)Env.getCtx(), (int)S_Resource_ID, null);
        return StandardCostCollector.getProductStandardCostPrice(cc, resourceProduct, MAcctSchema.get((Properties)Env.getCtx(), (int)d.getC_AcctSchema_ID()), MCostElement.get((Properties)Env.getCtx(), (int)d.getM_CostElement_ID()));
    }

    public static BigDecimal getProductStandardCostPrice(MPPCostCollector cc, MProduct product, MAcctSchema as, MCostElement element) {
        CostDimension d = new CostDimension(product, as, as.getM_CostType_ID(), 0, 0, 0, element.getM_CostElement_ID());
        MPPOrderCost oc = (MPPOrderCost)d.toQuery(MPPOrderCost.class, "PP_Order_ID=?", new Object[]{cc.getPP_Order_ID()}, cc.get_TrxName()).firstOnly();
        if (oc == null) {
            return Env.ZERO;
        }
        BigDecimal costs = oc.getCurrentCostPrice().add(oc.getCurrentCostPriceLL());
        return CostEngine.roundCost((BigDecimal)costs, (int)as.getC_AcctSchema_ID());
    }

    public static void createRateVariances(MPPCostCollector costCollector) {
        MProduct product = null;
        if (costCollector.isCostCollectorType("160")) {
            I_AD_WF_Node node = costCollector.getPP_Order_Node().getAD_WF_Node();
            product = MProduct.forS_Resource_ID((Properties)costCollector.getCtx(), (int)node.getS_Resource_ID(), null);
        } else if (costCollector.isCostCollectorType("110")) {
            MPPOrderBOMLine bomLine = costCollector.getPP_Order_BOMLine();
            product = MProduct.get((Properties)costCollector.getCtx(), (int)bomLine.getM_Product_ID());
        } else if ("140".equals(costCollector.getCostCollectorType())) {
            product = MProduct.get((Properties)costCollector.getCtx(), (int)costCollector.getM_Product_ID());
        }
        MPPCostCollector costCollectorRateVariance = null;
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema((PO)costCollector)) {
            for (MCostElement costElement : MCostElement.getCostElement((Properties)costCollector.getCtx(), (String)costCollector.get_TrxName())) {
                BigDecimal amtActual;
                MCostDetail cost = StandardCostCollector.getCostDetail(costCollector, costElement.getM_CostElement_ID());
                if (cost == null) continue;
                BigDecimal quantity = cost.getQty();
                BigDecimal priceStandard = StandardCostCollector.getProductStandardCostPrice(costCollector, product, accountSchema, costElement);
                BigDecimal priceActual = StandardCostCollector.getProductActualCostPrice(costCollector, product, accountSchema, costElement, costCollector.get_TrxName());
                BigDecimal amountStandard = CostEngine.roundCost((BigDecimal)priceStandard.multiply(quantity), (int)accountSchema.getC_AcctSchema_ID());
                if (amountStandard.compareTo(amtActual = CostEngine.roundCost((BigDecimal)priceActual.multiply(quantity), (int)accountSchema.getC_AcctSchema_ID())) == 0) continue;
                if (costCollectorRateVariance == null) {
                    costCollectorRateVariance = MPPCostCollector.createVarianceCostCollector(costCollector, "140");
                }
                List costTypes = MCostType.get((Properties)accountSchema.getCtx(), (String)accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    StandardCostCollector.createVarianceCostDetail(costCollectorRateVariance, amtActual.abs(), quantity, cost, null, accountSchema, costType, costElement);
                    StandardCostCollector.createVarianceCostDetail(costCollectorRateVariance, amountStandard.abs(), quantity, cost, null, accountSchema, costType, costElement);
                }
            }
        }
        if (costCollectorRateVariance != null) {
            boolean ok = costCollectorRateVariance.processIt("CO");
            costCollectorRateVariance.saveEx();
            if (!ok) {
                throw new AdempiereException(costCollectorRateVariance.getProcessMsg());
            }
        }
    }

    public static List<MCostDetail> getByCollectorCost(MPPCostCollector costCollector) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("PP_Cost_Collector_ID").append("=? ");
        return new Query(costCollector.getCtx(), "M_CostDetail", whereClause.toString(), costCollector.get_TrxName()).setClient_ID().setParameters(new Object[]{costCollector.getPP_Cost_Collector_ID()}).list();
    }

    public static MCostDetail getCostDetail(MPPCostCollector cc, int M_CostElement_ID) {
        String whereClause = "PP_Cost_Collector_ID=? AND M_CostElement_ID=?";
        MCostDetail cd = (MCostDetail)new Query(cc.getCtx(), "M_CostDetail", "PP_Cost_Collector_ID=? AND M_CostElement_ID=?", cc.get_TrxName()).setClient_ID().setParameters(new Object[]{cc.getPP_Cost_Collector_ID(), M_CostElement_ID}).firstOnly();
        return cd;
    }

    public static void createMethodVariances(MPPCostCollector costCollector) {
        if (!costCollector.getCostCollectorType().equals("130")) {
            return;
        }
        for (MAcctSchema as : CostEngine.getAcctSchema((PO)costCollector)) {
            for (MCostElement element : MCostElement.getCostElement((Properties)costCollector.getCtx(), (String)costCollector.get_TrxName())) {
                List costtypes = MCostType.get((Properties)as.getCtx(), (String)as.get_TrxName());
                for (MCostType costType : costtypes) {
                    if (!"S".equals(costType.getCostingMethod())) continue;
                    MProduct product = MProduct.get((Properties)costCollector.getCtx(), (int)costCollector.getM_Product_ID());
                    BigDecimal priceActual = StandardCostCollector.getProductActualCostPrice(costCollector, product, as, element, costCollector.get_TrxName());
                    StandardCostCollector.createVarianceCostDetail(costCollector, priceActual, costCollector.getMovementQty(), null, product, as, costType, element);
                }
            }
        }
    }

    public static void createMethodVariancesFromActivityControl(MPPCostCollector costCollector) {
        int actual_resource_id;
        if (!costCollector.isCostCollectorType("160")) {
            return;
        }
        int std_resource_id = costCollector.getPP_Order_Node().getAD_WF_Node().getS_Resource_ID();
        if (std_resource_id == (actual_resource_id = costCollector.getS_Resource_ID())) {
            return;
        }
        MPPCostCollector methodChangeVariance = null;
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(costCollector.getAD_Client_ID());
        for (MAcctSchema as : CostEngine.getAcctSchema((PO)costCollector)) {
            for (MCostElement element : MCostElement.getCostElement((Properties)costCollector.getCtx(), (String)costCollector.get_TrxName())) {
                BigDecimal priceActual;
                MProduct resourcePStd = MProduct.forS_Resource_ID((Properties)costCollector.getCtx(), (int)std_resource_id, null);
                MProduct resourcePActual = MProduct.forS_Resource_ID((Properties)costCollector.getCtx(), (int)actual_resource_id, null);
                BigDecimal priceStd = StandardCostCollector.getProductActualCostPrice(costCollector, resourcePStd, as, element, costCollector.get_TrxName());
                if (priceStd.compareTo(priceActual = StandardCostCollector.getProductActualCostPrice(costCollector, resourcePActual, as, element, costCollector.get_TrxName())) == 0) continue;
                if (methodChangeVariance == null) {
                    methodChangeVariance = MPPCostCollector.createVarianceCostCollector(costCollector, "130");
                }
                BigDecimal qty = routingService.getResourceBaseValue(costCollector.getS_Resource_ID(), (I_PP_Cost_Collector)costCollector);
                BigDecimal amtStd = priceStd.multiply(qty);
                BigDecimal amtActual = priceActual.multiply(qty);
                List costtypes = MCostType.get((Properties)as.getCtx(), (String)as.get_TrxName());
                for (MCostType costType : costtypes) {
                    if (!"S".equals(costType.getCostingMethod())) continue;
                    StandardCostCollector.createVarianceCostDetail(methodChangeVariance, amtActual.abs(), qty, null, resourcePActual, as, costType, element);
                    StandardCostCollector.createVarianceCostDetail(methodChangeVariance, amtStd.negate(), qty.negate(), null, resourcePStd, as, costType, element);
                }
            }
        }
        if (methodChangeVariance != null) {
            boolean ok = methodChangeVariance.processIt("CO");
            methodChangeVariance.saveEx();
            if (!ok) {
                throw new AdempiereException(methodChangeVariance.getProcessMsg());
            }
        }
    }

    public static MCostDetail createVarianceCostDetail(MPPCostCollector costCollector, BigDecimal amount, BigDecimal quantity, MCostDetail cost, MProduct product, MAcctSchema accountSchema, MCostType costType, MCostElement costElement) {
        MCostDetail costDetailVariance = new MCostDetail(costCollector.getCtx(), 0, costCollector.get_TrxName());
        if (cost != null) {
            MCostDetail.copyValues((PO)cost, (PO)costDetailVariance);
            costDetailVariance.setProcessed(false);
        }
        if (product != null) {
            costDetailVariance.setM_Product_ID(product.getM_Product_ID());
            costDetailVariance.setM_AttributeSetInstance_ID(costCollector.getM_AttributeSetInstance_ID());
        }
        if (accountSchema != null) {
            costDetailVariance.setC_AcctSchema_ID(accountSchema.getC_AcctSchema_ID());
        }
        if (costElement != null) {
            costDetailVariance.setM_CostElement_ID(costElement.getM_CostElement_ID());
        }
        costDetailVariance.setPP_Cost_Collector_ID(costCollector.getPP_Cost_Collector_ID());
        costDetailVariance.setM_CostType_ID(costType.getM_CostType_ID());
        costDetailVariance.setM_CostElement_ID(costElement.getM_CostElement_ID());
        costDetailVariance.setAmt(amount);
        costDetailVariance.setCostAmt(amount);
        costDetailVariance.setAmtLL(BigDecimal.ZERO);
        costDetailVariance.setQty(quantity);
        costDetailVariance.setDateAcct(costCollector.getDateAcct());
        costDetailVariance.saveEx();
        return costDetailVariance;
    }

    public static void createActivityControl(MPPCostCollector costCollector) {
        if (!costCollector.isCostCollectorType("160")) {
            return;
        }
        MProduct product = MProduct.forS_Resource_ID((Properties)costCollector.getCtx(), (int)costCollector.getS_Resource_ID(), null);
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(costCollector.getAD_Client_ID());
        BigDecimal quantity = routingService.getResourceBaseValue(costCollector.getS_Resource_ID(), (I_PP_Cost_Collector)costCollector);
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema((PO)costCollector)) {
            for (MCostElement costElement : MCostElement.getCostElement((Properties)costCollector.getCtx(), (String)costCollector.get_TrxName())) {
                if (!CostEngine.isActivityControlElement((I_M_CostElement)costElement)) continue;
                CostDimension dimension = new CostDimension(product, accountSchema, accountSchema.getM_CostType_ID(), costCollector.getAD_Org_ID(), costCollector.getM_Warehouse_ID(), costCollector.getM_AttributeSetInstanceTo_ID(), costElement.getM_CostElement_ID());
                BigDecimal price = StandardCostCollector.getResourceActualCostRate(costCollector.getS_Resource_ID(), dimension, costCollector.get_TrxName());
                BigDecimal costs = price.multiply(quantity);
                if (costs.scale() > accountSchema.getCostingPrecision()) {
                    costs = costs.setScale(accountSchema.getCostingPrecision(), RoundingMode.HALF_UP);
                }
                List costTypes = MCostType.get((Properties)accountSchema.getCtx(), (String)accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    if (!"S".equals(costType.getCostingMethod())) continue;
                    MCostDetail cost = new MCostDetail(accountSchema, costCollector.getAD_Org_ID(), dimension.getM_Product_ID(), 0, costElement.getM_CostElement_ID(), costs.negate(), quantity.negate(), costElement.getName(), costCollector.get_TrxName(), costType.getM_CostType_ID());
                    cost.setPP_Cost_Collector_ID(costCollector.getPP_Cost_Collector_ID());
                    cost.setDateAcct(costCollector.getDateAcct());
                    cost.setCostAmt(costs.negate());
                    cost.saveEx();
                }
            }
        }
    }

    public static void createUsageVariances(MPPCostCollector usageVariance) {
        BigDecimal quantity;
        MProduct product;
        if (!usageVariance.isCostCollectorType("120")) {
            throw new IllegalArgumentException("Cost Collector is not Material Usage Variance");
        }
        if (usageVariance.getPP_Order_BOMLine_ID() > 0) {
            product = MProduct.get((Properties)usageVariance.getCtx(), (int)usageVariance.getM_Product_ID());
            quantity = usageVariance.getMovementQty();
        } else {
            product = MProduct.forS_Resource_ID((Properties)usageVariance.getCtx(), (int)usageVariance.getS_Resource_ID(), null);
            RoutingService routingService = RoutingServiceFactory.get().getRoutingService(usageVariance.getAD_Client_ID());
            quantity = routingService.getResourceBaseValue(usageVariance.getS_Resource_ID(), (I_PP_Cost_Collector)usageVariance);
        }
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema((PO)usageVariance)) {
            for (MCostElement element : MCostElement.getCostElement((Properties)usageVariance.getCtx(), (String)usageVariance.get_TrxName())) {
                BigDecimal price = StandardCostCollector.getProductActualCostPrice(usageVariance, product, accountSchema, element, usageVariance.get_TrxName());
                BigDecimal amt = CostEngine.roundCost((BigDecimal)price.multiply(quantity), (int)accountSchema.getC_AcctSchema_ID());
                if (amt.compareTo(Env.ZERO) == 0) continue;
                List costTypes = MCostType.get((Properties)accountSchema.getCtx(), (String)accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    StandardCostCollector.createVarianceCostDetail(usageVariance, amt.abs(), quantity, null, product, accountSchema, costType, element);
                }
            }
        }
    }

    public static BigDecimal getResourceActualCostRate(int resourceId, CostDimension costDimension, String trxName) {
        if (resourceId <= 0) {
            return Env.ZERO;
        }
        MProduct resourceProduct = MProduct.forS_Resource_ID((Properties)Env.getCtx(), (int)resourceId, (String)trxName);
        CostDimension resourcecCostDimension = new CostDimension(costDimension.setM_Product(resourceProduct));
        MCost cost = (MCost)resourcecCostDimension.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
        return CostEngine.roundCost((BigDecimal)price, (int)resourcecCostDimension.getC_AcctSchema_ID());
    }

    public static BigDecimal getProductActualCostPrice(MPPCostCollector costCollector, MProduct product, MAcctSchema acctSchema, MCostElement element, String trxName) {
        String costingLevel = product.getCostingLevel(acctSchema);
        int orgId = 0;
        int warehouseId = 0;
        int attributeSetInstanceId = 0;
        if (costCollector != null) {
            orgId = costCollector.getAD_Org_ID();
            warehouseId = costCollector.getM_Warehouse_ID();
            attributeSetInstanceId = costCollector.getM_AttributeSetInstance_ID();
        }
        if ("C".equals(costingLevel)) {
            orgId = 0;
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("O".equals(costingLevel)) {
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("W".equals(costingLevel)) {
            attributeSetInstanceId = 0;
        } else if ("B".equals(costingLevel)) {
            orgId = 0;
            warehouseId = 0;
        }
        CostDimension costDimension = new CostDimension(product, acctSchema, acctSchema.getM_CostType_ID(), orgId, warehouseId, attributeSetInstanceId, element.getM_CostElement_ID());
        MCost cost = (MCost)costDimension.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
        return CostEngine.roundCost((BigDecimal)price, (int)acctSchema.getC_AcctSchema_ID());
    }

    public static List<MPPCostCollector> getCostCollectorNotTransaction(Properties ctx, int productId, Timestamp dateAccount, Timestamp dateAccountTo, String trxName) {
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("CostCollectorType NOT IN ('100','110') AND ");
        if (productId > 0) {
            whereClause.append("M_Product_ID=? AND ");
            params.add(Integer.valueOf(productId));
        }
        if (dateAccount == null || dateAccountTo == null) {
            throw new AdempiereException("@DateAcct@ @NotFound@");
        }
        whereClause.append("DateAcct>=? AND ");
        params.add(dateAccount);
        whereClause.append("DateAcct<=?");
        params.add(dateAccountTo);
        return new Query(ctx, "PP_Cost_Collector", whereClause.toString(), trxName).setClient_ID().setParameters(params).list();
    }
}

