/*
 * Decompiled with CFR 0.152.
 */
package oracle;

import java.sql.ResultSet;
import java.sql.SQLException;

public class Column {
    private static final int NOT_SET = -1;
    private String tableName;
    private String columnName;
    private String dataType;
    private boolean isNullable = false;
    private int dataPrecision = -1;
    private int dataScale = -1;
    private String charUsed;
    private int charColDeclLength = -1;
    private String defaultValue;
    private String tmpDefaultValue;
    private boolean isStringType;
    private boolean isNumberType;
    private boolean nullHasChanged = false;
    private boolean defaultHasChanged = false;

    public int getDataPrecision() {
        return this.dataPrecision;
    }

    public int getDataScale() {
        return this.dataScale;
    }

    public Column(String columnName) {
        this.columnName = columnName;
    }

    public Column(ResultSet rs) {
        try {
            if (rs != null) {
                this.defaultValue = rs.getString("DATA_DEFAULT");
                if (this.defaultValue != null) {
                    this.defaultValue = this.defaultValue.trim();
                    if (this.defaultValue.toUpperCase().equals("NULL")) {
                        this.defaultValue = null;
                    }
                }
                this.tableName = rs.getString("TABLE_NAME");
                this.columnName = rs.getString("COLUMN_NAME");
                this.dataType = rs.getString("DATA_TYPE");
                this.isNumberType = "NUMBER".equals(this.dataType);
                this.isStringType = this.dataType != null && this.dataType.indexOf("CHAR") != -1;
                this.isNullable = "Y".equals(rs.getString("NULLABLE"));
                this.dataPrecision = rs.getInt("DATA_PRECISION");
                this.dataScale = rs.getInt("DATA_SCALE");
                this.charUsed = rs.getString("CHAR_USED");
                this.charColDeclLength = rs.getInt("CHAR_COL_DECL_LENGTH");
            }
        }
        catch (SQLException e) {
            System.out.println("Column constructor - sql exception");
            System.out.println("Don't use getString at last position...");
            e.printStackTrace();
        }
    }

    public String getDefinitionString() {
        StringBuffer buffer = this.getTypeDefinitionString();
        buffer = this.defaultValue != null && !this.defaultValue.equals("") ? buffer.append(" DEFAULT ").append(this.defaultValue) : buffer.append(" DEFAULT NULL ");
        buffer = !this.isNullable ? buffer.append(" NOT NULL ") : buffer.append(" NULL ");
        return buffer.toString();
    }

    public String getDefinitionStringForCreateTable() {
        StringBuffer buffer = this.getTypeDefinitionString();
        if (this.defaultValue != null && !this.defaultValue.equals("")) {
            buffer = buffer.append(" DEFAULT ").append(this.defaultValue);
        }
        buffer = !this.isNullable ? buffer.append(" NOT NULL ") : buffer.append(" NULL ");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Column) || obj == null) {
            return false;
        }
        Column col = (Column)obj;
        return col.isNullable == this.isNullable && col.charColDeclLength == this.charColDeclLength && col.dataPrecision == this.dataPrecision && col.dataScale == this.dataScale && (col.charUsed != null && col.charUsed.equals(this.charUsed) || col.charUsed == null && this.charUsed == null) && (col.columnName != null && col.columnName.equals(this.columnName) || col.columnName == null && this.columnName == null) && (col.dataType != null && col.dataType.equals(this.dataType) || col.dataType == null && this.dataType == null) && (col.defaultValue != null && col.defaultValue.equals(this.defaultValue) || col.defaultValue == null && this.defaultValue == null) && (col.tableName != null && col.tableName.equals(this.tableName) || col.tableName == null && this.tableName == null);
    }

    public String toString() {
        return this.tableName + " - " + this.columnName + " - " + this.charUsed + " - " + this.charColDeclLength + " - " + this.dataPrecision + " - " + this.dataScale + " - " + this.dataType + " - " + this.defaultValue + " - " + this.isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isStringType() {
        return this.isStringType;
    }

    public boolean isNumberType() {
        return this.isNumberType;
    }

    public String getTmpDefaultValue() {
        return this.tmpDefaultValue;
    }

    public void setTmpDefaultValue(String tmpDefaultValue) {
        this.tmpDefaultValue = tmpDefaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefinitionStringWithTempDefault() {
        StringBuffer buffer = this.getTypeDefinitionString();
        buffer = buffer.append(" DEFAULT ").append(this.tmpDefaultValue);
        if (!this.isNullable) {
            buffer = buffer.append(" NOT NULL ");
        }
        return buffer.toString();
    }

    public String getSetDefaultString() {
        StringBuffer buffer = this.getTypeDefinitionString();
        buffer = this.defaultValue == null ? buffer.append(" DEFAULT NULL ") : buffer.append(" DEFAULT ").append(this.defaultValue);
        return buffer.toString();
    }

    public StringBuffer getTypeDefinitionString() {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append("   ").append(this.columnName + " " + this.dataType);
        if (this.charUsed != null && !this.charUsed.equals("")) {
            buffer = buffer.append("(").append(this.charColDeclLength);
            if ("CHAR".equals(this.dataType)) {
                buffer = buffer.append(" ").append("C".equals(this.charUsed) ? "CHAR" : "BYTE");
            }
            buffer = buffer.append(") ");
        }
        if (this.dataPrecision != -1 && this.dataPrecision != 0) {
            buffer = buffer.append("(").append(this.dataPrecision);
            if (this.dataScale != -1) {
                buffer = buffer.append(",").append(this.dataScale);
            }
            buffer = buffer.append(")");
        }
        return buffer;
    }

    public String getNullDefinitionString() {
        StringBuffer buffer = this.getTypeDefinitionString();
        buffer = buffer.append(" NULL ");
        return buffer.toString();
    }

    public boolean isDefaultHasChanged() {
        return this.defaultHasChanged;
    }

    public void setDefaultHasChanged(boolean defaultHasChanged) {
        this.defaultHasChanged = defaultHasChanged;
    }

    public boolean isNullHasChanged() {
        return this.nullHasChanged;
    }

    public void setNullHasChanged(boolean nullHasChanged) {
        this.nullHasChanged = nullHasChanged;
    }
}

