/*
 * Decompiled with CFR 0.152.
 */
package oracle;

import java.util.Vector;

public class Constraint {
    public static final String PRIMARY_KEY = "P";
    public static final String FOREIGN_KEY = "R";
    public static final String CHECK = "C";
    public static final String UNIQEINDEX = "U";
    private String name;
    private String type;
    private String tableName;
    private String checkCondition;
    private String indexName;
    private Vector<String> columnNames = new Vector();
    private Constraint rConstraint;
    private String deleteRule;

    public Constraint(String name, String tableName) {
        this.name = name;
        this.tableName = tableName;
    }

    public String getAlterTableString() {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append("ALTER TABLE ").append(this.tableName);
        buffer = buffer.append(" ADD ");
        if (this.type.equals(PRIMARY_KEY)) {
            buffer = buffer.append("CONSTRAINT ");
            buffer = buffer.append(this.name).append(" PRIMARY KEY (");
            for (int i = 0; i < this.columnNames.size(); ++i) {
                buffer = buffer.append(this.columnNames.get(i));
                if (i == this.columnNames.size() - 1) continue;
                buffer = buffer.append(", ");
            }
            buffer = buffer.append(")");
        } else if (this.type.equals(FOREIGN_KEY)) {
            buffer = buffer.append("CONSTRAINT ");
            buffer = buffer.append(this.name).append(" FOREIGN KEY (");
            buffer = buffer.append(this.columnNames.get(0)).append(")");
            buffer = buffer.append(" REFERENCES ").append(this.rConstraint.getTableName());
            buffer = buffer.append(" (").append(this.rConstraint.getColumnName()).append(")");
            if (this.deleteRule != null) {
                buffer.append(" ON DELETE " + this.deleteRule + " ");
            }
        } else if (this.type.equals(CHECK)) {
            buffer = buffer.append("CHECK (").append(this.checkCondition).append(")");
        } else if (this.type.equals(UNIQEINDEX)) {
            // empty if block
        }
        buffer = buffer.append(";");
        return buffer.toString();
    }

    private String getColumnName() {
        if (this.columnNames.size() > 0) {
            return this.columnNames.get(0);
        }
        return null;
    }

    public String getDropString() {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append("ALTER TABLE ").append(this.tableName);
        buffer = buffer.append(" DROP CONSTRAINT ").append(this.name).append(";");
        return buffer.toString();
    }

    public String getCheckCondition() {
        return this.checkCondition;
    }

    public void setCheckCondition(String checkCondition) {
        this.checkCondition = checkCondition;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Constraint getRConstraint() {
        return this.rConstraint;
    }

    public void setRConstraint(Constraint constraint) {
        this.rConstraint = constraint;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDeleteRule(String deleteRule) {
        this.deleteRule = deleteRule;
        if (deleteRule != null && deleteRule.trim().toUpperCase().equals("NO ACTION")) {
            this.deleteRule = null;
        }
    }
}

