/*
 * Decompiled with CFR 0.152.
 */
package oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import oracle.ADDataElement;
import oracle.Column;
import oracle.Constraint;
import oracle.Table;
import oracle.View;

public class DBDifference {
    private static final String DB1_NAME = "c253a";
    private static final String DB1_URL = "jdbc:oracle:thin:@meitner:1521:";
    private static final String DB1_USER = "compiere";
    private static final String DB1_PASSWD = "compiere";
    private static final String DB2_NAME = "c253b";
    private static final String DB2_USER = "compiere";
    private static final String DB2_PASSWD = "compiere";
    private static final String DB2_URL = "jdbc:oracle:thin:@meitner:1521:";
    private static final String AD_ROLE_ID = "1000000";
    private static final String AD_CLIENT_ID = "1000000";
    private static final String TIME_FORMAT = "RRRR-MM-DD";
    private Vector<Table> m_newTables = new Vector();
    private Vector<Table> m_changedTables = new Vector();
    private Vector<Table> m_tablesToDrop = new Vector();
    private Vector<View> m_newViews = new Vector();
    private Vector<View> m_changedViews = new Vector();
    private Vector<Constraint> m_newConstraints = new Vector();
    private Vector<Constraint> m_constraintsToDrop = new Vector();
    private Vector<String> m_newTableEntry = new Vector();
    private Vector<String> m_alterADEntry = new Vector();
    private Vector<String> m_deleteADEntry = new Vector();
    private Vector<String> m_newFunctionStatements = new Vector();
    private Vector<String> m_newIndexStatements = new Vector();
    private Vector<String> m_dropIndexStatements = new Vector();
    private Vector<String> m_dropFunctionStatements = new Vector();
    private Vector<String> m_dropTriggerStatements = new Vector();
    private Vector<String> m_unappliableStatements = new Vector();
    private Statement stmtdb1 = null;
    private Statement stmtdb2 = null;
    private Connection con1 = null;
    private Connection con2 = null;

    public static void main(String[] args) {
        new DBDifference().showDifference();
    }

    public void showDifference() {
        try {
            this.con1 = this.getConnection(DB1_NAME, "compiere", "compiere", "jdbc:oracle:thin:@meitner:1521:");
            this.con1.setAutoCommit(false);
            this.con2 = this.getConnection(DB2_NAME, "compiere", "compiere", "jdbc:oracle:thin:@meitner:1521:");
            this.con2.setAutoCommit(false);
            this.stmtdb1 = this.con1.createStatement();
            this.stmtdb2 = this.con2.createStatement();
            System.out.println("compare tables ...");
            this.compareTables();
            System.out.println("compare constraints ...");
            this.compareConstraints();
            System.out.println("compare views ...");
            this.compareViews();
            System.out.println("compare functions/procedures ...");
            this.compareFunctionsAndProcedures();
            System.out.println("drop triggers ...");
            this.dropTriggers();
            System.out.println("compare ad_elements ...");
            this.compareADElements();
            System.out.println("compare indexes ...");
            this.compareIndexes();
            this.sortAndPrintSQL();
            this.stmtdb1.close();
            this.stmtdb2.close();
            this.con1.close();
            this.con2.close();
            System.out.println("done.");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void dropTriggers() throws SQLException {
        String sql = "select trigger_name from user_triggers order by trigger_name";
        ResultSet rs = this.stmtdb1.executeQuery(sql);
        while (rs.next()) {
            this.m_dropTriggerStatements.add("DROP " + rs.getString("TRIGGER_NAME") + ";");
        }
        rs.close();
    }

    private void compareIndexes() throws SQLException {
        int i;
        Vector<String> indexNamesDB1 = new Vector<String>();
        Vector<String> indexNamesDB2 = new Vector<String>();
        Object sql = "select index_name, uniqueness, table_name from user_indexes  where index_type='NORMAL' and index_name not like 'SYS_%' and index_name not like 'BIN$%'";
        ResultSet rs = this.stmtdb1.executeQuery((String)sql);
        while (rs.next()) {
            indexNamesDB1.add(rs.getString("INDEX_NAME"));
        }
        rs.close();
        rs = this.stmtdb2.executeQuery((String)sql);
        while (rs.next()) {
            indexNamesDB2.add(rs.getString("INDEX_NAME"));
        }
        rs.close();
        Vector<String> newIndexes = this.getNewElements(indexNamesDB1, indexNamesDB2);
        for (int i2 = 0; i2 < newIndexes.size(); ++i2) {
            if (newIndexes.get(i2).endsWith("KEY")) continue;
            this.createNewIndexEntry(newIndexes.get(i2));
        }
        Vector<String> missingIndexes = this.getMissingElements(indexNamesDB1, indexNamesDB2);
        for (i = 0; i < missingIndexes.size(); ++i) {
            if (missingIndexes.get(i).endsWith("KEY")) continue;
            this.m_dropIndexStatements.add("DROP INDEX " + missingIndexes.get(i) + ";");
        }
        for (i = 0; i < indexNamesDB2.size(); ++i) {
            if (!indexNamesDB1.contains(indexNamesDB2.get(i))) continue;
            Vector<String> columnNames1 = new Vector<String>();
            Vector<String> columnNames2 = new Vector<String>();
            sql = "select column_name from user_ind_columns where index_name='" + indexNamesDB2.get(i) + "' order by column_position";
            rs = this.stmtdb1.executeQuery((String)sql);
            while (rs.next()) {
                columnNames1.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            rs = this.stmtdb2.executeQuery((String)sql);
            while (rs.next()) {
                columnNames2.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            if (columnNames1.size() == columnNames2.size() || indexNamesDB2.get(i).endsWith("KEY")) continue;
            this.m_dropIndexStatements.add("DROP INDEX " + indexNamesDB2.get(i) + ";");
            this.createNewIndexEntry(indexNamesDB2.get(i));
        }
    }

    private void createNewIndexEntry(String indexName) throws SQLException {
        String unique = "";
        String tableName = "";
        ResultSet rs = this.stmtdb2.executeQuery("select table_name, uniqueness from user_indexes where index_name='" + indexName + "'");
        if (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            unique = rs.getString("UNIQUENESS");
            if (unique.equals("NONUNIQUE")) {
                unique = "";
            }
        }
        rs.close();
        String createStatement = "CREATE " + unique + " INDEX " + indexName + " ON " + tableName + " (";
        rs = this.stmtdb2.executeQuery("select column_name from user_ind_columns where index_name='" + indexName + "' order by column_position");
        int k = 0;
        while (rs.next()) {
            if (k != 0) {
                createStatement = createStatement + " ,";
            }
            createStatement = createStatement + rs.getString("COLUMN_NAME");
            ++k;
        }
        rs.close();
        createStatement = createStatement + ");";
        this.m_newIndexStatements.add(createStatement);
    }

    private void compareFunctionsAndProcedures() throws SQLException {
        Vector<String> functionNamesDB1 = new Vector<String>();
        Vector<String> functionNamesDB2 = new Vector<String>();
        Object sql = "select object_name from user_procedures order by object_name";
        ResultSet rs = this.stmtdb1.executeQuery((String)sql);
        while (rs.next()) {
            functionNamesDB1.add(rs.getString("OBJECT_NAME"));
        }
        rs.close();
        rs = this.stmtdb2.executeQuery((String)sql);
        while (rs.next()) {
            functionNamesDB2.add(rs.getString("OBJECT_NAME"));
        }
        rs.close();
        for (int i = 0; i < functionNamesDB2.size(); ++i) {
            if (!functionNamesDB1.contains(functionNamesDB2.get(i))) continue;
            sql = "select text from user_source where name='" + functionNamesDB2.get(i) + "'";
            rs = this.stmtdb1.executeQuery((String)sql);
            String text1 = "";
            String text2 = "";
            if (rs.next()) {
                text1 = rs.getString("TEXT");
            }
            rs.close();
            rs = this.stmtdb2.executeQuery((String)sql);
            if (rs.next()) {
                text2 = rs.getString("TEXT");
            }
            rs.close();
            if (text2.equals(text1)) continue;
            System.out.println("FUNCTION OR PROCEDURE " + functionNamesDB2.get(i) + " HAS CHANGED - please check it for customizations");
            rs = this.stmtdb2.executeQuery("select text from user_source where name='" + functionNamesDB2.get(i) + "'");
            Object createStatement = "create or replace ";
            while (rs.next()) {
                createStatement = (String)createStatement + rs.getString("TEXT");
            }
            this.m_newFunctionStatements.add((String)createStatement);
        }
        System.out.println("searching new functions/procedures ...");
        Vector<String> newFunctions = this.getNewElements(functionNamesDB1, functionNamesDB2);
        for (int i = 0; i < newFunctions.size(); ++i) {
            rs = this.stmtdb2.executeQuery("select text from user_source where name='" + newFunctions.get(i) + "'");
            Object createStatement = " CREATE OR REPLACE ";
            while (rs.next()) {
                createStatement = (String)createStatement + rs.getString("TEXT");
            }
            this.m_newFunctionStatements.add((String)createStatement);
        }
        Vector<String> missingFunctions = this.getMissingElements(functionNamesDB1, functionNamesDB2);
        for (int i = 0; i < missingFunctions.size(); ++i) {
            this.m_dropFunctionStatements.add(" DROP FUNCTION " + missingFunctions.get(i) + ";");
        }
    }

    private void compareViews() throws SQLException {
        String name;
        int i;
        Vector<View> viewsDB1 = new Vector<View>();
        Vector<View> viewsDB2 = new Vector<View>();
        String sql = "select view_name, text from user_views where view_name not like 'BIN$%'";
        ResultSet rs = this.stmtdb1.executeQuery(sql);
        while (rs.next()) {
            viewsDB1.add(new View(rs.getString("VIEW_NAME"), rs.getString("TEXT")));
        }
        rs.close();
        rs = this.stmtdb2.executeQuery(sql);
        while (rs.next()) {
            viewsDB2.add(new View(rs.getString("VIEW_NAME"), rs.getString("TEXT")));
        }
        rs.close();
        for (i = 0; i < viewsDB2.size(); ++i) {
            name = ((View)viewsDB2.get(i)).getName();
            String text = ((View)viewsDB2.get(i)).getText();
            boolean found = false;
            boolean identical = false;
            for (int j = 0; j < viewsDB1.size(); ++j) {
                if (!name.equals(((View)viewsDB1.get(j)).getName())) continue;
                found = true;
                if (!text.equals(((View)viewsDB1.get(j)).getText())) break;
                identical = true;
                break;
            }
            if (!found) {
                this.m_newViews.add((View)viewsDB2.get(i));
                continue;
            }
            if (identical) continue;
            this.m_changedViews.add((View)viewsDB2.get(i));
        }
        for (i = 0; i < viewsDB1.size(); ++i) {
            name = ((View)viewsDB1.get(i)).getName();
            boolean found = false;
            for (int j = 0; j < viewsDB2.size(); ++j) {
                if (!name.equals(((View)viewsDB2.get(j)).getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println();
            System.out.println("THE VIEW " + name + " DOESN'T EXIST IN NEW DB - but no need to drop them...");
            System.out.println();
        }
    }

    private void compareTables() throws SQLException {
        Table table;
        Vector<String> tableNamesDB1 = new Vector<String>();
        Vector<String> tableNamesDB2 = new Vector<String>();
        Object sql = "select table_name from user_tables where table_name not like 'BIN$%'";
        ResultSet rs = this.stmtdb1.executeQuery((String)sql);
        while (rs.next()) {
            tableNamesDB1.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        rs = this.stmtdb2.executeQuery((String)sql);
        while (rs.next()) {
            tableNamesDB2.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        System.out.println("searching new tables ...");
        Vector<String> newTables = this.getNewElements(tableNamesDB1, tableNamesDB2);
        for (int i = 0; i < newTables.size(); ++i) {
            String tableName = newTables.get(i);
            table = new Table(tableName);
            sql = "select * from user_tab_columns where table_name='" + tableName + "'";
            rs = this.stmtdb2.executeQuery((String)sql);
            while (rs.next()) {
                Column column = new Column(rs);
                table.addColumn(column);
            }
            rs.close();
            this.m_newTables.add(table);
        }
        System.out.println("searching missing tables ...");
        Vector<String> missingTables = this.getMissingElements(tableNamesDB1, tableNamesDB2);
        for (int i = 0; i < missingTables.size(); ++i) {
            table = new Table(missingTables.get(i));
            this.m_tablesToDrop.add(table);
        }
        System.out.println("searching changed tables ...");
        this.addChangedTablesToGlobalVector(tableNamesDB1, tableNamesDB2);
    }

    private void addChangedTablesToGlobalVector(Vector<String> tableNamesDB1, Vector<String> tableNamesDB2) throws SQLException {
        PreparedStatement stmtGetColumNamesForTable1 = this.con1.prepareStatement("select column_name from user_tab_columns where table_name=?");
        PreparedStatement stmtGetColumNamesForTable2 = this.con2.prepareStatement("select column_name from user_tab_columns where table_name=?");
        PreparedStatement stmtGetColumDetailsDB1 = this.con1.prepareStatement("select * from user_tab_columns where column_name=? and table_name=?");
        PreparedStatement stmtGetColumDetailsDB2 = this.con2.prepareStatement("select * from user_tab_columns where column_name=? and table_name=?");
        for (String tableName : tableNamesDB2) {
            Vector<String> missingColumns;
            if (!tableNamesDB1.contains(tableName)) continue;
            Vector<String> columnNamesDB1 = new Vector<String>();
            Vector<String> columnNamesDB2 = new Vector<String>();
            stmtGetColumNamesForTable1.setString(1, tableName);
            stmtGetColumNamesForTable2.setString(1, tableName);
            ResultSet rs = stmtGetColumNamesForTable1.executeQuery();
            while (rs.next()) {
                columnNamesDB1.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            rs = stmtGetColumNamesForTable2.executeQuery();
            while (rs.next()) {
                columnNamesDB2.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            Vector<String> addedColumns = this.getNewElements(columnNamesDB1, columnNamesDB2);
            if (addedColumns.size() != 0) {
                Table table = new Table(tableName);
                for (int i = 0; i < addedColumns.size(); ++i) {
                    stmtGetColumDetailsDB2.setString(1, addedColumns.get(i));
                    stmtGetColumDetailsDB2.setString(2, tableName);
                    rs = stmtGetColumDetailsDB2.executeQuery();
                    while (rs.next()) {
                        Column column = new Column(rs);
                        if (!column.isNullable() && column.getDefaultValue() == null) {
                            column.setTmpDefaultValue(this.getTempDefaultValueForColumn(tableName, column));
                        }
                        table.addColumnToAdd(column);
                    }
                    rs.close();
                }
                this.m_changedTables.add(table);
            }
            if ((missingColumns = this.getMissingElements(columnNamesDB1, columnNamesDB2)).size() != 0) {
                Table table = new Table(tableName);
                for (int i = 0; i < missingColumns.size(); ++i) {
                    table.addColumnToDrop(new Column(missingColumns.get(i)));
                }
                this.m_changedTables.add(table);
            }
            Table changedTable = null;
            for (int i = 0; i < columnNamesDB1.size(); ++i) {
                String colName = columnNamesDB1.get(i);
                if (!columnNamesDB2.contains(colName)) continue;
                stmtGetColumDetailsDB1.setString(1, colName);
                stmtGetColumDetailsDB1.setString(2, tableName);
                stmtGetColumDetailsDB2.setString(1, colName);
                stmtGetColumDetailsDB2.setString(2, tableName);
                Column colDB1 = null;
                Column colDB2 = null;
                rs = stmtGetColumDetailsDB1.executeQuery();
                if (rs.next()) {
                    colDB1 = new Column(rs);
                }
                rs.close();
                rs = stmtGetColumDetailsDB2.executeQuery();
                if (rs.next()) {
                    colDB2 = new Column(rs);
                }
                rs.close();
                if (colDB1.equals(colDB2)) continue;
                if (changedTable == null) {
                    changedTable = new Table(tableName);
                }
                if (!colDB2.isNullable() && colDB2.getDefaultValue() == null) {
                    colDB2.setTmpDefaultValue(this.getTempDefaultValueForColumn(tableName, colDB2));
                }
                colDB2.setNullHasChanged(colDB2.isNullable() != colDB1.isNullable());
                String def1 = colDB1.getDefaultValue();
                String def2 = colDB2.getDefaultValue();
                if (def1 == null && def2 == null) {
                    colDB2.setDefaultHasChanged(false);
                } else if (def1 != null && def2 != null) {
                    colDB2.setDefaultHasChanged(!def1.equals(def2));
                } else {
                    colDB2.setDefaultHasChanged(true);
                }
                changedTable.addColumnToModify(colDB2);
            }
            if (changedTable == null) continue;
            this.m_changedTables.add(changedTable);
        }
        stmtGetColumNamesForTable1.close();
        stmtGetColumNamesForTable2.close();
        stmtGetColumDetailsDB1.close();
        stmtGetColumDetailsDB2.close();
    }

    private String getTempDefaultValueForColumn(String tableName, Column column) throws SQLException {
        String retValue = null;
        String sql = "select col2.Table_Name, col2.Column_Name from User_Cons_Columns col inner join user_constraints con on (col.Constraint_Name=con.Constraint_Name) inner join User_Cons_Columns col2 on (con.R_Constraint_Name=col2.Constraint_Name) where col.table_name='" + tableName + "' and con.constraint_type='R' and col.Column_Name='" + column.getColumnName() + "'";
        ResultSet rs = this.stmtdb2.executeQuery(sql);
        String fkTableName = "";
        String fkColumnName = "";
        if (rs.next()) {
            fkTableName = rs.getString("Table_Name");
            fkColumnName = rs.getString("Column_Name");
        }
        rs.close();
        if (!"".equals(fkColumnName) && !"".equals(fkTableName)) {
            try {
                sql = "select max(" + fkColumnName + ")  from " + fkTableName;
                rs = this.stmtdb1.executeQuery(sql);
                if (rs.next()) {
                    retValue = rs.getString(1);
                }
                rs.close();
            }
            catch (SQLException e) {
                System.out.println("foreign key column missing in db1: " + fkColumnName + " - table: " + fkTableName);
            }
        }
        if (retValue == null) {
            if (column.isNumberType()) {
                retValue = "-1";
            } else if (column.isStringType()) {
                retValue = "'N'";
            }
        }
        return retValue;
    }

    private Vector<String> getMissingElements(Vector<String> objNamesDB1, Vector<String> objNamesDB2) {
        Vector<String> missingElements = new Vector<String>();
        for (String name : objNamesDB1) {
            if (objNamesDB2.contains(name)) continue;
            missingElements.add(name);
        }
        return missingElements;
    }

    private Vector<String> getNewElements(Vector<String> objNamesDB1, Vector<String> objNamesDB2) {
        Vector<String> newElements = new Vector<String>();
        for (String name : objNamesDB2) {
            if (objNamesDB1.contains(name)) continue;
            newElements.add(name);
        }
        return newElements;
    }

    private void sortAndPrintSQL() throws SQLException {
        int i;
        int i2;
        Vector<String> statements = new Vector<String>(1000, 500);
        Vector<String> sortedStatements = new Vector<String>(1000, 500);
        for (i2 = 0; i2 < this.m_newTables.size(); ++i2) {
            statements.add(this.m_newTables.get(i2).getCreateStatement());
        }
        for (i2 = 0; i2 < this.m_changedTables.size(); ++i2) {
            if (this.m_changedTables.get(i2).isAlterAdd()) {
                statements.add(this.m_changedTables.get(i2).getAlterAddStatement());
                continue;
            }
            if (this.m_changedTables.get(i2).isAlterDrop()) {
                statements.add(this.m_changedTables.get(i2).getAlterDropStatement());
                continue;
            }
            if (!this.m_changedTables.get(i2).isAlterModify()) continue;
            statements.add(this.m_changedTables.get(i2).getAlterModifyStatement());
        }
        for (i2 = 0; i2 < this.m_constraintsToDrop.size(); ++i2) {
            statements.add(this.m_constraintsToDrop.get(i2).getDropString());
        }
        for (i2 = 0; i2 < this.m_newConstraints.size(); ++i2) {
            statements.add(this.m_newConstraints.get(i2).getAlterTableString());
        }
        Vector<String> tempVector = this.sortStatements(statements);
        for (i = 0; i < tempVector.size(); ++i) {
            sortedStatements.add(tempVector.get(i));
        }
        sortedStatements.add("COMMIT;");
        sortedStatements.add("SET DEFINE OFF;");
        statements.clear();
        for (i = 0; i < this.m_newTableEntry.size(); ++i) {
            statements.add(this.m_newTableEntry.get(i).replaceAll("\n", " "));
        }
        tempVector = this.sortStatements(statements);
        for (i = 0; i < tempVector.size(); ++i) {
            sortedStatements.add(tempVector.get(i));
        }
        sortedStatements.add("COMMIT;");
        sortedStatements.add("SET DEFINE OFF;");
        statements.clear();
        for (i = 0; i < this.m_alterADEntry.size(); ++i) {
            statements.add(this.m_alterADEntry.get(i).replaceAll("\n", " "));
        }
        tempVector = this.sortStatements(statements);
        for (i = 0; i < tempVector.size(); ++i) {
            sortedStatements.add(tempVector.get(i));
        }
        sortedStatements.add("COMMIT;");
        sortedStatements.add("SET DEFINE OFF;");
        statements.clear();
        for (i = 0; i < this.m_deleteADEntry.size(); ++i) {
            statements.add(this.m_deleteADEntry.get(i).replaceAll("\n", " "));
        }
        tempVector = this.sortStatements(statements);
        for (i = 0; i < tempVector.size(); ++i) {
            sortedStatements.add(tempVector.get(i));
        }
        System.out.println();
        System.out.println("---------------------------");
        System.out.println("--   SCRIPT STARTS HERE!");
        System.out.println("---------------------------");
        System.out.println("-- UNABLE TO APPLY THESE STATEMENTS - START");
        for (i = 0; i < this.m_unappliableStatements.size(); ++i) {
            System.out.println(this.m_unappliableStatements.get(i));
        }
        System.out.println("-- UNABLE TO APPLY THESE STATEMENTS - END");
        System.out.println();
        System.out.println("-- NEW/CHANGED TABLES - NEW/CHANGED AD_ENTRIES");
        for (i = 0; i < sortedStatements.size(); ++i) {
            System.out.println((String)sortedStatements.get(i));
        }
        System.out.println();
        System.out.println("-- NEW VIEWS");
        for (i = 0; i < this.m_newViews.size(); ++i) {
            System.out.println(this.m_newViews.get(i).getCreateStatement());
        }
        System.out.println();
        System.out.println("-- CHANGED VIEWS - but check them first - don't overwrite your customizations...");
        for (i = 0; i < this.m_changedViews.size(); ++i) {
            System.out.println(this.m_changedViews.get(i).getCreateStatement());
        }
        System.out.println();
        System.out.println("-- NEW OR CHANGED FUNCTIONS/PROCEDURES");
        for (i = 0; i < this.m_newFunctionStatements.size(); ++i) {
            System.out.println(this.m_newFunctionStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP FUNCTIONS/PROCEDURES");
        for (i = 0; i < this.m_dropFunctionStatements.size(); ++i) {
            System.out.println(this.m_dropFunctionStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP TRIGGERS");
        for (i = 0; i < this.m_dropTriggerStatements.size(); ++i) {
            System.out.println(this.m_dropTriggerStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP INDEXES");
        for (i = 0; i < this.m_dropIndexStatements.size(); ++i) {
            System.out.println(this.m_dropIndexStatements.get(i));
        }
        System.out.println();
        System.out.println("-- NEW OR CHANGED INDEXES");
        for (i = 0; i < this.m_newIndexStatements.size(); ++i) {
            System.out.println(this.m_newIndexStatements.get(i));
        }
        System.out.println();
        System.out.println("-- PLEASE CHECK THE SEQUENCES BY HAND - USE:");
        System.out.println("-- select * from user_sequences;");
        System.out.println();
        System.out.println(this.getUpdateVersionStatement());
        System.out.println("COMMIT;");
    }

    private Vector<String> sortStatements(Vector<String> statements) {
        Vector<String> sortedStatements = new Vector<String>(1000, 500);
        int maxTries = statements.size();
        for (int attempt = 0; statements.size() != 0 && attempt <= maxTries; ++attempt) {
            String statement = statements.firstElement();
            try {
                String[] stmts = statement.split("<STATEMENT_SEPARATOR>\n");
                for (int j = 0; j < stmts.length; ++j) {
                    if ("".equals(stmts[j])) continue;
                    this.stmtdb1.executeUpdate(stmts[j].substring(0, stmts[j].lastIndexOf(59)));
                }
                sortedStatements.add(statement.replaceAll("<STATEMENT_SEPARATOR>\n", ""));
                statements.remove(0);
                maxTries = statements.size();
                attempt = 0;
                continue;
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                statements.remove(0);
                statements.add(statement);
            }
        }
        if (statements.size() != 0) {
            for (int i = 0; i < statements.size(); ++i) {
                this.m_unappliableStatements.add(statements.get(i));
            }
        }
        return sortedStatements;
    }

    private void printSQL() {
        int i;
        System.out.println();
        System.out.println("-- please replace all PA_Measure/PA_MeasureCalc related entries with the following lines");
        System.out.println("and place them at the end of the alter tables section");
        System.out.println(this.getHardcodedStuff());
        System.out.println();
        System.out.println("-- end of the PA_Measure/PA_MeasureCalc replacement lines");
        System.out.println();
        System.out.println("-- USE THE FOLLOWING LINES FOR YOUR MIGRATION SCRIPT:");
        System.out.println("-- INSERT TABLES");
        for (i = 0; i < this.m_newTables.size(); ++i) {
            System.out.println(this.m_newTables.get(i).getCreateStatement());
        }
        System.out.println();
        System.out.println("-- ALTER TABLES");
        for (i = 0; i < this.m_changedTables.size(); ++i) {
            if (!this.m_changedTables.get(i).isAlterAdd()) continue;
            System.out.println(this.m_changedTables.get(i).getAlterAddStatement());
        }
        System.out.println("-- PLEASE CHECK THE ADD/MODIFY STATEMENTS:");
        System.out.println("-- If you find a 'BEWARE' first check if the table has some data");
        System.out.println("-- if not, you can ignort the 'BEWARE', if the table has data");
        System.out.println("-- you might have to set a temporary default value for the column");
        System.out.println("-- (if not all rows have a value for the modied column)");
        System.out.println("-- Sample: \t\tALTER TABLE TEST ADD ( columnname NOT NULL);");
        System.out.println("-- first set default value (for existing data), than remove it (for new data)");
        System.out.println("-- change to:\tALTER TABLE TEST ADD ( columnname DEFAULT 'tempDefault' NOT NULL);");
        System.out.println("-- \t\t\t\tALTER TABLE TEST MODIFY ( columnname NULL);");
        System.out.println("-- \t\t\t\tALTER TABLE TEST MODIFY ( columnname NOT NULL);");
        System.out.println();
        System.out.println("-- FOR MODIFY STATEMENTS");
        System.out.println("-- just set a value for all existing rows");
        System.out.println();
        System.out.println("-- Sample: \t\tALTER TABLE TEST MODIFY ( columnname not null);");
        System.out.println("-- insert an update statement before the alter statement");
        System.out.println("-- insert before:\tUPDATE TEST SET columnname 'myDefault';");
        for (i = 0; i < this.m_changedTables.size(); ++i) {
            if (!this.m_changedTables.get(i).isAlterModify()) continue;
            System.out.println(this.m_changedTables.get(i).getAlterModifyStatement());
        }
        System.out.println("-- PLEASE CHECK THE FOLLOWING COLUMNS - DON'T DROP CUSTOMIZATIONS");
        for (i = 0; i < this.m_changedTables.size(); ++i) {
            if (!this.m_changedTables.get(i).isAlterDrop()) continue;
            System.out.println(this.m_changedTables.get(i).getAlterDropStatement());
        }
        System.out.println();
        System.out.println("-- DROP TABLES - but check them first - don't drop customizations...");
        for (i = 0; i < this.m_tablesToDrop.size(); ++i) {
            System.out.println(this.m_tablesToDrop.get(i).getDropStatement());
        }
        System.out.println();
        System.out.println();
        System.out.println("-- PUT THE FOLLOWING LINES INTO A NEW FILE");
        System.out.println();
        System.out.println();
        System.out.println("-- DROP CONSTRAINTS");
        for (i = 0; i < this.m_constraintsToDrop.size(); ++i) {
            System.out.println(this.m_constraintsToDrop.get(i).getDropString());
        }
        System.out.println();
        System.out.println("-- ADD/RECREATE CONSTRAINTS");
        for (i = this.m_newConstraints.size() - 1; i >= 0; --i) {
            System.out.println(this.m_newConstraints.get(i).getAlterTableString());
        }
        System.out.println();
        System.out.println();
        System.out.println("-- PUT THE FOLLOWING LINES INTO A NEW FILE");
        System.out.println();
        System.out.println();
        System.out.println("-- NEW AD_* ENTRIES AND ROWS OF ADDED TABLES");
        System.out.println();
        System.out.println("SET DEFINE OFF;");
        System.out.println();
        Collections.sort(this.m_newTableEntry, new AD_Comparator());
        for (i = 0; i < this.m_newTableEntry.size(); ++i) {
            System.out.println(this.m_newTableEntry.get(i).replaceAll("\n", " "));
        }
        System.out.println();
        System.out.println("-- CHANGED AD_* ENTRIES");
        Collections.sort(this.m_alterADEntry);
        for (i = 0; i < this.m_alterADEntry.size(); ++i) {
            System.out.println(this.m_alterADEntry.get(i).replaceAll("\n", " "));
        }
        System.out.println();
        System.out.println();
        System.out.println("-- PUT THE FOLLOWING LINES INTO A NEW FILE");
        System.out.println();
        System.out.println();
        System.out.println("-- NEW VIEWS");
        for (i = 0; i < this.m_newViews.size(); ++i) {
            System.out.println(this.m_newViews.get(i).getCreateStatement());
        }
        System.out.println();
        System.out.println("-- CHANGED VIEWS - but check them first - don't overwrite your customizations...");
        for (i = 0; i < this.m_changedViews.size(); ++i) {
            System.out.println(this.m_changedViews.get(i).getCreateStatement());
        }
        System.out.println();
        System.out.println("-- NEW OR CHANGED FUNCTIONS/PROCEDURES");
        for (i = 0; i < this.m_newFunctionStatements.size(); ++i) {
            System.out.println(this.m_newFunctionStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP FUNCTIONS/PROCEDURES");
        for (i = 0; i < this.m_dropFunctionStatements.size(); ++i) {
            System.out.println(this.m_dropFunctionStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP TRIGGERS - BUT DON'T DELETE CUSTOMIZATIONS");
        for (i = 0; i < this.m_dropTriggerStatements.size(); ++i) {
            System.out.println(this.m_dropTriggerStatements.get(i));
        }
        System.out.println();
        System.out.println("-- DROP INDEXES - BUT DON'T DELETE CUSTOMIZATIONS");
        for (i = 0; i < this.m_dropIndexStatements.size(); ++i) {
            System.out.println(this.m_dropIndexStatements.get(i));
        }
        System.out.println();
        System.out.println("-- NEW OR CHANGED INDEXES");
        for (i = 0; i < this.m_newIndexStatements.size(); ++i) {
            System.out.println(this.m_newIndexStatements.get(i));
        }
        System.out.println();
        System.out.println("-- PLEASE CHECK THE SEQUENCES BY HAND - USE:");
        System.out.println("-- select * from user_sequences;");
        System.out.println();
        System.out.println(this.getUpdateVersionStatement());
        System.out.println("COMMIT;");
    }

    private void compareConstraints() throws SQLException {
        int j;
        boolean found;
        int i;
        Vector<Constraint> constraintsDB1 = new Vector<Constraint>();
        Vector<Constraint> constraintsDB2 = new Vector<Constraint>();
        Object sql = "select * from user_constraints where constraint_name not like 'SYS_%' and constraint_name not like 'BIN%' and constraint_type != 'U'";
        ResultSet rs = this.stmtdb1.executeQuery((String)sql);
        while (rs.next()) {
            constraintsDB1.add(new Constraint(rs.getString("CONSTRAINT_NAME"), rs.getString("TABLE_NAME")));
        }
        rs.close();
        rs = this.stmtdb2.executeQuery((String)sql);
        while (rs.next()) {
            constraintsDB2.add(new Constraint(rs.getString("CONSTRAINT_NAME"), rs.getString("TABLE_NAME")));
        }
        rs.close();
        System.out.println("searching constraints to drop...");
        Vector<Constraint> constraintsToDrop = new Vector<Constraint>();
        Vector<Constraint> duplicatedConstraints = new Vector<Constraint>();
        for (i = 0; i < constraintsDB1.size(); ++i) {
            String n1 = ((Constraint)constraintsDB1.get(i)).getName();
            found = false;
            for (j = 0; j < constraintsDB2.size(); ++j) {
                String n2 = ((Constraint)constraintsDB2.get(j)).getName();
                if (!n2.equals(n1)) continue;
                found = true;
                break;
            }
            if (!found) {
                constraintsToDrop.add((Constraint)constraintsDB1.get(i));
                continue;
            }
            duplicatedConstraints.add((Constraint)constraintsDB1.get(i));
        }
        for (i = 0; i < constraintsToDrop.size(); ++i) {
            this.m_constraintsToDrop.add((Constraint)constraintsToDrop.get(i));
        }
        System.out.println("searching new constraints...");
        for (i = 0; i < constraintsDB2.size(); ++i) {
            String n2 = ((Constraint)constraintsDB2.get(i)).getName();
            found = false;
            for (j = 0; j < constraintsDB1.size(); ++j) {
                String n1 = ((Constraint)constraintsDB1.get(j)).getName();
                if (!n2.equals(n1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.m_newConstraints.add(this.createNewConstraint(((Constraint)constraintsDB2.get(i)).getName()));
        }
        for (i = 0; i < duplicatedConstraints.size(); ++i) {
            String name = ((Constraint)duplicatedConstraints.get(i)).getName();
            sql = "select Constraint_Type, Table_Name,Search_Condition, R_Constraint_Name, Delete_Rule from User_Constraints where Constraint_Name='" + name + "'";
            String sqlColumn = "select * from User_Cons_Columns where Constraint_Name='" + name + "'";
            rs = this.stmtdb2.executeQuery((String)sql);
            String tableName2 = "";
            String constraintType2 = "";
            String condition2 = "";
            String rConstraintName2 = "";
            String deleteRule2 = "";
            String column2 = "";
            if (rs.next()) {
                constraintType2 = rs.getString("Constraint_Type");
                tableName2 = rs.getString("Table_Name");
                condition2 = rs.getString("Search_Condition");
                rConstraintName2 = rs.getString("R_Constraint_Name");
                deleteRule2 = rs.getString("Delete_Rule");
            }
            rs.close();
            rs = this.stmtdb2.executeQuery(sqlColumn);
            if (rs.next()) {
                column2 = rs.getString("Column_Name");
            }
            rs.close();
            rs = this.stmtdb1.executeQuery((String)sql);
            String tableName1 = "";
            String constraintType1 = "";
            String condition1 = "";
            String rConstraintName1 = "";
            String deleteRule1 = "";
            String column1 = "";
            if (rs.next()) {
                constraintType1 = rs.getString("Constraint_Type");
                tableName1 = rs.getString("Table_Name");
                condition1 = rs.getString("Search_Condition");
                rConstraintName1 = rs.getString("R_Constraint_Name");
                deleteRule1 = rs.getString("Delete_Rule");
            }
            rs.close();
            rs = this.stmtdb1.executeQuery(sqlColumn);
            if (rs.next()) {
                column1 = rs.getString("Column_Name");
            }
            rs.close();
            if (condition1 == null) {
                condition1 = "";
            }
            if (rConstraintName1 == null) {
                rConstraintName1 = "";
            }
            if (deleteRule1 == null) {
                deleteRule1 = "";
            }
            if (column1 == null) {
                column1 = "";
            }
            if (condition2 == null) {
                condition2 = "";
            }
            if (rConstraintName2 == null) {
                rConstraintName2 = "";
            }
            if (deleteRule2 == null) {
                deleteRule2 = "";
            }
            if (column2 == null) {
                column2 = "";
            }
            if (tableName1.equals(tableName2) && constraintType1.equals(constraintType2) && condition1.equals(condition2) && rConstraintName1.equals(rConstraintName2) && deleteRule1.equals(deleteRule2) && column1.equals(column2)) continue;
            this.m_constraintsToDrop.add((Constraint)duplicatedConstraints.get(i));
            this.m_newConstraints.add(this.createNewConstraint(name));
        }
        this.addMissingSysConstraints();
    }

    private void addMissingSysConstraints() {
        Object sql2 = "";
        Vector<String> newConstraintNames = new Vector<String>();
        try {
            String sql = "select * from user_constraints where constraint_name like 'SYS_%' and constraint_type='C'";
            ResultSet rs2 = this.stmtdb2.executeQuery(sql);
            while (rs2.next()) {
                String searchCondition = rs2.getString("SEARCH_CONDITION");
                if (searchCondition == null || searchCondition.toUpperCase().indexOf("IS NOT NULL") != -1) continue;
                String tableName = rs2.getString("TABLE_NAME");
                sql2 = "select * from user_constraints where table_name='" + tableName + "' and search_condition is not null";
                ResultSet rs1 = this.stmtdb1.executeQuery((String)sql2);
                boolean found = false;
                while (rs1.next()) {
                    if (!searchCondition.equals(rs1.getString("SEARCH_CONDITION"))) continue;
                    found = true;
                }
                rs1.close();
                if (found) continue;
                newConstraintNames.add(rs2.getString("CONSTRAINT_NAME"));
            }
            rs2.close();
            for (int i = 0; i < newConstraintNames.size(); ++i) {
                this.m_newConstraints.add(this.createNewConstraint((String)newConstraintNames.get(i)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println((String)sql2);
        }
    }

    private Constraint createNewConstraint(String name) throws SQLException {
        ResultSet rs = this.stmtdb2.executeQuery("select Constraint_Type, Table_Name,Search_Condition, R_Constraint_Name, Delete_Rule from User_Constraints where Constraint_Name='" + name + "'");
        String tableName = "";
        String constraintType = "";
        String condition = "";
        String rConstraintName = "";
        String deleteRule = "";
        String column = "";
        if (rs.next()) {
            constraintType = rs.getString("Constraint_Type");
            tableName = rs.getString("Table_Name");
            condition = rs.getString("Search_Condition");
            rConstraintName = rs.getString("R_Constraint_Name");
            deleteRule = rs.getString("Delete_Rule");
        }
        rs.close();
        if (constraintType.equals("R")) {
            Constraint refConstraint = null;
            rs = this.stmtdb2.executeQuery("select * from User_Cons_Columns where Constraint_Name='" + name + "'");
            if (rs.next()) {
                column = rs.getString("Column_Name");
            }
            rs.close();
            rs = this.stmtdb2.executeQuery("select * from User_Cons_Columns where Constraint_Name='" + rConstraintName + "'");
            if (rs.next()) {
                String refColumn = rs.getString("Column_Name");
                String refTableName = rs.getString("Table_Name");
                refConstraint = new Constraint(rConstraintName, refTableName);
                refConstraint.addColumnName(refColumn);
                refConstraint.setDeleteRule(deleteRule);
            }
            rs.close();
            Constraint c = new Constraint(name, tableName);
            c.setType("R");
            c.addColumnName(column);
            c.setRConstraint(refConstraint);
            c.addColumnName(column);
            c.setDeleteRule(deleteRule);
            return c;
        }
        if (constraintType.equals("P")) {
            rs = this.stmtdb2.executeQuery("select * from User_Cons_Columns where Constraint_Name='" + name + "'");
            Constraint c = new Constraint(name, tableName);
            c.setType("P");
            c.setDeleteRule(deleteRule);
            while (rs.next()) {
                c.addColumnName(rs.getString("Column_Name"));
            }
            rs.close();
            return c;
        }
        if (constraintType.equals("C")) {
            rs = this.stmtdb2.executeQuery("select * from User_Cons_Columns where Constraint_Name='" + name + "'");
            if (rs.next()) {
                column = rs.getString("Column_Name");
            }
            rs.close();
            Constraint c = new Constraint(name, tableName);
            c.setType("C");
            c.addColumnName(column);
            c.setCheckCondition(condition);
            c.setDeleteRule(deleteRule);
            return c;
        }
        return null;
    }

    private void compareADElements() throws SQLException {
        String TABLE_DOES_NOT_EXITST = "ORA-00942";
        Vector<String> adTableNames2 = new Vector<String>();
        Object sql = "select table_name from user_tables";
        ResultSet rs = this.stmtdb2.executeQuery((String)sql);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (tableName.endsWith("_TRL")) continue;
            adTableNames2.add(tableName);
        }
        rs.close();
        for (int i = 0; i < adTableNames2.size(); ++i) {
            int j;
            String tableName = (String)adTableNames2.get(i);
            boolean addClientAccess = false;
            if (tableName.equals("AD_WINDOW_ACCESS") || tableName.equals("AD_PROCESS_ACCESS") || tableName.equals("AD_FORM_ACCESS")) {
                addClientAccess = true;
            }
            Vector<Column> columns1 = new Vector<Column>();
            Vector<Column> columns2 = new Vector<Column>();
            sql = "select * from user_tab_columns where table_name='" + tableName + "' order by column_id";
            rs = this.stmtdb1.executeQuery((String)sql);
            while (rs.next()) {
                columns1.add(new Column(rs));
            }
            rs.close();
            rs = this.stmtdb2.executeQuery((String)sql);
            while (rs.next()) {
                columns2.add(new Column(rs));
            }
            rs.close();
            sql = "select col.column_name from user_constraints constr inner join User_Cons_Columns col ON (col.constraint_name = constr.constraint_name) where constr.constraint_type='P' and constr.table_name = '" + tableName + "'";
            Vector<String> keycolumns = new Vector<String>();
            rs = this.stmtdb2.executeQuery((String)sql);
            sql = "select * from " + tableName + " where ";
            if (rs.next()) {
                sql = (String)sql + rs.getString("COLUMN_NAME");
                sql = (String)sql + " <1000000 ";
                keycolumns.add(rs.getString("COLUMN_NAME"));
            } else {
                System.out.println("Please check table " + tableName + " for new data and add it by hand");
                continue;
            }
            while (rs.next()) {
                sql = (String)sql + " and " + rs.getString("COLUMN_NAME");
                sql = (String)sql + " <1000000 ";
                keycolumns.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            Vector<ADDataElement> dataElements1 = new Vector<ADDataElement>();
            Vector<ADDataElement> dataElements2 = new Vector<ADDataElement>();
            try {
                int m;
                boolean found;
                String colName;
                ADDataElement data;
                rs = this.stmtdb2.executeQuery((String)sql);
                while (rs.next()) {
                    data = new ADDataElement();
                    for (j = 0; j < columns2.size(); ++j) {
                        colName = ((Column)columns2.get(j)).getColumnName();
                        data.addColumnAndValue(colName, rs.getString(colName));
                    }
                    dataElements2.add(data);
                }
                rs.close();
                rs = this.stmtdb1.executeQuery((String)sql);
                while (rs.next()) {
                    data = new ADDataElement();
                    for (j = 0; j < columns1.size(); ++j) {
                        colName = ((Column)columns1.get(j)).getColumnName();
                        data.addColumnAndValue(colName, rs.getString(colName));
                    }
                    dataElements1.add(data);
                }
                rs.close();
                try {
                    for (int j2 = 0; j2 < dataElements1.size(); ++j2) {
                        found = false;
                        ADDataElement data1 = (ADDataElement)dataElements1.get(j2);
                        sql = "select * from " + tableName + " where ";
                        for (m = 0; m < keycolumns.size(); ++m) {
                            if (m != 0) {
                                sql = (String)sql + " and ";
                            }
                            sql = (String)sql + keycolumns.get(m) + "=" + data1.getValueForColumn(keycolumns.get(m));
                        }
                        rs = this.stmtdb2.executeQuery((String)sql);
                        if (rs.next()) {
                            found = true;
                        }
                        rs.close();
                        if (found) continue;
                        this.createDeleteTableEntry(tableName, data1, keycolumns, columns1);
                    }
                }
                catch (SQLException e1) {
                    System.out.println(e1.getMessage() + " - on searching data to drop for table: " + tableName);
                }
                for (int j3 = 0; j3 < dataElements2.size(); ++j3) {
                    found = false;
                    ADDataElement data2 = (ADDataElement)dataElements2.get(j3);
                    sql = "select * from " + tableName + " where ";
                    for (m = 0; m < keycolumns.size(); ++m) {
                        if (m != 0) {
                            sql = (String)sql + " and ";
                        }
                        sql = (String)sql + keycolumns.get(m) + "=" + data2.getValueForColumn(keycolumns.get(m));
                    }
                    rs = this.stmtdb1.executeQuery((String)sql);
                    if (rs.next()) {
                        found = true;
                    }
                    rs.close();
                    if (!found) {
                        this.createNewTableEntry(tableName, data2, keycolumns, columns2);
                        if (!addClientAccess || "1000000" == null || "1000000" == null) continue;
                        data2.setValueForColumn("AD_CLIENT_ID", "1000000");
                        data2.setValueForColumn("AD_ROLE_ID", "1000000");
                        this.createNewTableEntry(tableName, data2, keycolumns, columns2);
                        continue;
                    }
                    sql = "select * from " + tableName + " where ";
                    boolean and = false;
                    for (int m2 = 0; m2 < columns2.size(); ++m2) {
                        if (!columns1.contains(columns2.get(m2))) continue;
                        String value = data2.getValueForColumn(columns2.get(m2).getColumnName());
                        if (value != null && value.indexOf(39) != -1) {
                            value = value.replaceAll("'", "''");
                        }
                        if (and) {
                            sql = (String)sql + " and ";
                        }
                        if (value == null) {
                            sql = (String)sql + columns2.get(m2).getColumnName() + " is null ";
                            and = true;
                            continue;
                        }
                        if (columns2.get(m2).isStringType()) {
                            sql = (String)sql + columns2.get(m2).getColumnName() + "='" + value + "'";
                            and = true;
                            continue;
                        }
                        if (columns2.get(m2).isNumberType()) {
                            sql = (String)sql + columns2.get(m2).getColumnName() + "=" + data2.getValueForColumn(columns2.get(m2).getColumnName());
                            and = true;
                            continue;
                        }
                        and = false;
                    }
                    try {
                        found = false;
                        rs = this.stmtdb1.executeQuery((String)sql);
                        if (rs.next()) {
                            found = true;
                        }
                        rs.close();
                        if (found) continue;
                        this.updateADEntry(tableName, data2, keycolumns, columns2);
                        continue;
                    }
                    catch (SQLException e) {
                        if (e.getMessage().startsWith("ORA-00933") || e.getMessage().startsWith("ORA-01722")) continue;
                        System.out.println(e.getMessage() + ":");
                        System.out.println((String)sql);
                    }
                }
                continue;
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("ORA-00942")) {
                    for (j = 0; j < dataElements2.size(); ++j) {
                        this.createNewTableEntry(tableName, (ADDataElement)dataElements2.get(j), keycolumns, columns2);
                    }
                    continue;
                }
                System.out.println(e.getMessage() + " - for table " + tableName);
            }
        }
    }

    private void createDeleteTableEntry(String tableName, ADDataElement data1, Vector<String> keycolumns, Vector<Column> columns1) {
        String alterStatement = "DELETE FROM " + tableName + " WHERE ";
        boolean and = false;
        for (int i = 0; i < columns1.size(); ++i) {
            Column column = columns1.get(i);
            String columnName = column.getColumnName();
            if (!keycolumns.contains(columnName)) continue;
            if (and) {
                alterStatement = alterStatement + " AND ";
            }
            and = true;
            if (data1.getValueForColumn(columnName) == null) {
                alterStatement = alterStatement + column.getColumnName() + " is null ";
                continue;
            }
            alterStatement = alterStatement + column.getColumnName() + "=";
            alterStatement = column.isStringType() ? alterStatement + "'" + data1.getValueForColumn(columnName).replaceAll("'", "''") + "'" : alterStatement + data1.getValueForColumn(columnName);
        }
        alterStatement = alterStatement + ";";
        this.m_deleteADEntry.add(alterStatement);
    }

    private void updateADEntry(String tableName, ADDataElement data2, Vector<String> keycolumns, Vector<Column> columns2) {
        String alterStatement = "UPDATE " + tableName + " SET ";
        boolean comma = false;
        for (int i = 0; i < columns2.size(); ++i) {
            Column column = columns2.get(i);
            if (keycolumns.contains(column.getColumnName()) || "DATE".equals(column.getDataType())) continue;
            if (comma) {
                alterStatement = alterStatement + ",";
            }
            comma = true;
            String columnName = column.getColumnName();
            alterStatement = alterStatement + column.getColumnName() + "=";
            if (column.isStringType()) {
                if (data2.getValueForColumn(columnName) == null) {
                    alterStatement = alterStatement + "null";
                    continue;
                }
                alterStatement = alterStatement + "'" + data2.getValueForColumn(columnName).replaceAll("'", "''") + "'";
                continue;
            }
            alterStatement = alterStatement + data2.getValueForColumn(columnName);
        }
        alterStatement = alterStatement + " WHERE ";
        boolean and = false;
        for (int i = 0; i < columns2.size(); ++i) {
            Column column = columns2.get(i);
            String columnName = column.getColumnName();
            if (!keycolumns.contains(columnName)) continue;
            if (and) {
                alterStatement = alterStatement + " AND ";
            }
            and = true;
            if (data2.getValueForColumn(columnName) == null) {
                alterStatement = alterStatement + column.getColumnName() + " is null ";
                continue;
            }
            alterStatement = alterStatement + column.getColumnName() + "=";
            alterStatement = column.isStringType() ? alterStatement + "'" + data2.getValueForColumn(columnName).replaceAll("'", "''") + "'" : alterStatement + data2.getValueForColumn(columnName);
        }
        alterStatement = alterStatement + ";";
        this.m_alterADEntry.add(alterStatement);
    }

    private void createNewTableEntry(String tableName, ADDataElement data2, Vector<String> keyColumnNames2, Vector<Column> columns) throws SQLException {
        int i;
        String insertStatement = "INSERT INTO " + tableName + "(";
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                insertStatement = insertStatement + ",";
            }
            insertStatement = insertStatement + columns.get(i).getColumnName();
        }
        insertStatement = insertStatement + ")values(";
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                insertStatement = insertStatement + ",";
            }
            String type = columns.get(i).getDataType();
            String columnName = columns.get(i).getColumnName();
            int precision = columns.get(i).getDataPrecision();
            int scale = columns.get(i).getDataScale();
            if (data2.getValueForColumn(columnName) == null) {
                insertStatement = insertStatement + "null";
                continue;
            }
            if (type.equals("BLOB")) {
                insertStatement = insertStatement + "'" + data2.getValueForColumn(columnName).replaceAll("'", "''") + "'";
                continue;
            }
            if (type.equals("RAW")) continue;
            if (type.equals("CLOB")) {
                insertStatement = insertStatement + "'" + data2.getValueForColumn(columnName).replaceAll("'", "''") + "'";
                continue;
            }
            if (type.equals("CHAR") || type.equals("NCHAR") || type.equals("NVARCHAR2") || type.equals("VARCHAR2")) {
                insertStatement = insertStatement + "'" + data2.getValueForColumn(columnName).replaceAll("'", "''") + "'";
                continue;
            }
            if (type.equals("DATE")) {
                String date = data2.getValueForColumn(columnName);
                if (date.indexOf(32) != -1) {
                    date = date.substring(0, date.indexOf(32));
                }
                insertStatement = insertStatement + "to_date('" + date + "','RRRR-MM-DD')";
                continue;
            }
            if (!type.equals("NUMBER")) continue;
            insertStatement = scale == 0 ? insertStatement + data2.getValueForColumn(columnName) : insertStatement + data2.getValueForColumn(columnName);
        }
        insertStatement = insertStatement + ");";
        this.m_newTableEntry.add(insertStatement);
    }

    private void createEntriesForTable(String tableName) throws SQLException {
        Vector<Column> columns2 = new Vector<Column>();
        String sql = "select * from user_tab_columns where table_name='" + tableName + "' order by column_id";
        ResultSet rs = this.stmtdb2.executeQuery(sql);
        while (rs.next()) {
            columns2.add(new Column(rs));
        }
        rs.close();
        sql = "select col.column_name from user_constraints constr inner join User_Cons_Columns col ON (col.constraint_name = constr.constraint_name) where constr.constraint_type='P' and constr.table_name = '" + tableName + "'";
        Vector<String> keycolumns = new Vector<String>();
        rs = this.stmtdb2.executeQuery(sql);
        while (rs.next()) {
            keycolumns.add(rs.getString("COLUMN_NAME"));
        }
        rs.close();
        sql = "select * from " + tableName;
        Vector<ADDataElement> dataElements2 = new Vector<ADDataElement>();
        rs = this.stmtdb2.executeQuery(sql);
        while (rs.next()) {
            ADDataElement data = new ADDataElement();
            for (int i = 0; i < columns2.size(); ++i) {
                String colName = ((Column)columns2.get(i)).getColumnName();
                data.addColumnAndValue(colName, rs.getString(colName));
            }
            dataElements2.add(data);
        }
        rs.close();
        for (int i = 0; i < dataElements2.size(); ++i) {
            try {
                this.createNewTableEntry(tableName, (ADDataElement)dataElements2.get(i), keycolumns, columns2);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String getHardcodedStuff() {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append("--  BEWARE: ALL ENTRIES IN PA_MEASURE AND PA_MEASURECALC ARE DELETED \n").append("DELETE FROM PA_MEASURE;\n").append("DELETE FROM PA_MEASURECALC;\n").append("\n").append("  ALTER TABLE PA_MEASURECALC \n").append("  ADD (\tAD_TABLE_ID NUMBER(10,0) NOT NULL ENABLE, \n").append("\tKEYCOLUMN NVARCHAR2(60) NOT NULL ENABLE, \n").append("\tENTITYTYPE VARCHAR2(4 BYTE) NOT NULL ENABLE\n").append("   ) ;\n").append("\n").append("--  INSERTING into PA_MEASURECALC \n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (100,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Net Revenue','Invoiced net revenue, without tax and charges','SELECT SUM(il.LineNetAmt) \n").append("FROM RV_C_Invoice C_Invoice\n").append("  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y''','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');\n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (101,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Gross Revenue','Invoice gross amount including tax; Does not allow selection by product (Category)','SELECT SUM(GrandTotal) \n").append("FROM RV_C_Invoice C_Invoice','WHERE IsSOTrx=''Y'' AND Processed=''Y''','DateInvoiced','AD_Org_ID','C_BPartner_ID',null,318,'C_Invoice_ID','D');\n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (102,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Sales Margin','Difference between Limit and Actual price','SELECT SUM((il.PriceActual-il.PriceLimit)*QtyInvoiced) \n").append("FROM RV_C_Invoice C_Invoice\n").append("  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y''','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');\n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (103,0,0,'Y',to_date('26.04.01','DD.MM.RR'),0,to_date('25.12.05','DD.MM.RR'),100,'Number of Customers','Number of (new) customers','SELECT COUNT(*) \n").append("FROM C_BPartner','WHERE IsCustomer=''Y''','Created','AD_Org_ID','C_BPartner_ID',null,291,'C_BPartner_ID','D');\n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (104,0,0,'Y',to_date('25.12.05','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Invoiced Paid Quantities','Invoiced paid quantities','SELECT SUM(il.QtyInvoiced) \n").append("FROM RV_C_Invoice C_Invoice\n").append("  INNER JOIN RV_C_InvoiceLine il ON (C_Invoice.C_Invoice_ID=il.C_Invoice_ID)','WHERE C_Invoice.IsSOTrx=''Y'' AND C_Invoice.Processed=''Y'' AND C_Invoice.IsPaid=''Y''\n").append("','C_Invoice.DateInvoiced','C_Invoice.AD_Org_ID','C_Invoice.C_BPartner_ID','il.M_Product_ID',318,'C_Invoice.C_Invoice_ID','D');\n").append("INSERT INTO PA_MEASURECALC (PA_MEASURECALC_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,SELECTCLAUSE,WHERECLAUSE,DATECOLUMN,ORGCOLUMN,BPARTNERCOLUMN,PRODUCTCOLUMN,AD_TABLE_ID,KEYCOLUMN,ENTITYTYPE) values (105,0,0,'Y',to_date('01.01.06','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Open Invoice Amount','Open Invoice Amount  in Accounting Currency','SELECT COALESCE(SUM(currencyBase(invoiceOpen(C_Invoice_ID, C_InvoicePaySchedule_ID),C_Currency_ID, DateAcct, AD_Client_ID, AD_Org_ID)),0)\n").append("FROM C_Invoice_v C_Invoice','WHERE IsSOTrx=''Y'' AND Processed=''Y''','DateInvoiced','AD_Org_ID','C_BPartner_ID',null,318,'C_Invoice_ID','D');\n").append("\n").append("\n").append("  ALTER TABLE PA_MEASURE \n").append("  ADD (\tPA_BENCHMARK_ID NUMBER(10,0), \n").append("\tPA_RATIO_ID NUMBER(10,0), \n").append("\tPA_HIERARCHY_ID NUMBER(10,0), \n").append("\tMEASUREDATATYPE CHAR(1 BYTE) NOT NULL ENABLE, \n").append("\tR_REQUESTTYPE_ID NUMBER(10,0), \n").append("\tC_PROJECTTYPE_ID NUMBER(10,0)\n").append("   ) ;\n").append("   \n").append(" ALTER TABLE  PA_MEASURE\n").append(" ADD CONSTRAINT  PABENCHMARK_PAMEASURE FOREIGN KEY (PA_BENCHMARK_ID)\n").append("   \t  REFERENCES PA_BENCHMARK (PA_BENCHMARK_ID); \n").append(" ALTER TABLE  PA_MEASURE\n").append(" ADD CONSTRAINT PAHIERARCHY_PAMEASURE FOREIGN KEY (PA_HIERARCHY_ID)\n").append("   \t  REFERENCES PA_HIERARCHY (PA_HIERARCHY_ID);  \n").append(" ALTER TABLE  PA_MEASURE\n").append(" ADD CONSTRAINT PARATIO_PAMEASURE FOREIGN KEY (PA_RATIO_ID)\n").append("\t  REFERENCES PA_RATIO (PA_RATIO_ID);\n").append("   \n").append("--  INSERTING into PA_MEASURE \n").append("INSERT INTO PA_MEASURE (PA_MEASURE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,MEASURETYPE,MANUALACTUAL,MANUALNOTE,CALCULATIONCLASS,PA_MEASURECALC_ID,PA_BENCHMARK_ID,PA_RATIO_ID,PA_HIERARCHY_ID,MEASUREDATATYPE,R_REQUESTTYPE_ID,C_PROJECTTYPE_ID) values (102,11,0,'Y',to_date('01.01.06','DD.MM.RR'),100,to_date('01.01.06','DD.MM.RR'),100,'Open Invoice Amount',null,'C',0,null,null,105,null,null,null,'S',null,null);\n").append("INSERT INTO PA_MEASURE (PA_MEASURE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,MEASURETYPE,MANUALACTUAL,MANUALNOTE,CALCULATIONCLASS,PA_MEASURECALC_ID,PA_BENCHMARK_ID,PA_RATIO_ID,PA_HIERARCHY_ID,MEASUREDATATYPE,R_REQUESTTYPE_ID,C_PROJECTTYPE_ID) values (103,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('20.01.06','DD.MM.RR'),100,'Service Requests (Time)',null,'Q',0,null,null,null,null,null,null,'T',101,null);\n").append("INSERT INTO PA_MEASURE (PA_MEASURE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,MEASURETYPE,MANUALACTUAL,MANUALNOTE,CALCULATIONCLASS,PA_MEASURECALC_ID,PA_BENCHMARK_ID,PA_RATIO_ID,PA_HIERARCHY_ID,MEASUREDATATYPE,R_REQUESTTYPE_ID,C_PROJECTTYPE_ID) values (104,11,0,'Y',to_date('20.01.06','DD.MM.RR'),100,to_date('20.01.06','DD.MM.RR'),100,'Service Requests (Status)',null,'Q',0,null,null,null,null,null,null,'S',101,null);\n").append("INSERT INTO PA_MEASURE (PA_MEASURE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,MEASURETYPE,MANUALACTUAL,MANUALNOTE,CALCULATIONCLASS,PA_MEASURECALC_ID,PA_BENCHMARK_ID,PA_RATIO_ID,PA_HIERARCHY_ID,MEASUREDATATYPE,R_REQUESTTYPE_ID,C_PROJECTTYPE_ID) values (101,11,0,'Y',to_date('25.12.05','DD.MM.RR'),100,to_date('26.12.05','DD.MM.RR'),101,'Invoices Gross Revenue',null,'C',0,null,null,101,null,null,null,'T',null,null);\n").append("\n");
        return buffer.toString();
    }

    private String getUpdateVersionStatement() {
        return "UPDATE AD_SYSTEM SET VERSION='2006-01-20';";
    }

    private Connection getConnection(String dbName, String username, String password, String url) throws ClassNotFoundException, SQLException {
        String driverName = "oracle.jdbc.OracleDriver";
        Class.forName(driverName);
        url = (String)url + dbName;
        Connection connection = DriverManager.getConnection((String)url, username, password);
        return connection;
    }

    private class AD_Comparator
    implements Comparator {
        String[] reihenfolge = new String[]{"AD_ELEMENT(", "AD_WINDOW(", "AD_WINDOW_ACCESS(", "AD_TABLE(", "AD_REFERENCE(", "AD_VAL_RULE(", "AD_REPORTVIEW(", "AD_PROCESS(", "AD_PROCESS_ACCESS(", "AD_PROCESS_PARA(", "AD_PINSTANCE(", "AD_PINSTANCE_PARA(", "AD_COLUMN(", "AD_TAB(", "AD_FIELD(", "AD_FORM(", "AD_FORM_ACCESS(", "AD_MENU(", "AD_PRINTFORMAT(", "AD_PRINTFORMATITEM(", "AD_MESSAGE(", "AD_REF_LIST(", "AD_TREE(", "AD_TREENODE(", "AD_TREENODEMM("};

        private AD_Comparator() {
        }

        public int compare(Object arg1, Object arg2) {
            int i;
            if (!(arg1 instanceof String) || !(arg2 instanceof String)) {
                return 0;
            }
            String str1 = (String)arg1;
            String str2 = (String)arg2;
            int prio1 = 100;
            int prio2 = 100;
            for (i = 0; i < this.reihenfolge.length; ++i) {
                if (!str1.startsWith("INSERT INTO " + this.reihenfolge[i])) continue;
                prio1 = i;
                break;
            }
            for (i = 0; i < this.reihenfolge.length; ++i) {
                if (!str2.startsWith("INSERT INTO " + this.reihenfolge[i])) continue;
                prio2 = i;
                break;
            }
            if (prio1 != prio2) {
                if (prio1 < prio2) {
                    return -1;
                }
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

