/*
 * Decompiled with CFR 0.152.
 */
package oracle;

import java.util.Vector;
import oracle.Column;

public class Table {
    private Vector<Column> allTableColumns = new Vector();
    private Vector<Column> columnsToAdd = new Vector();
    private Vector<Column> columnsToModify = new Vector();
    private Vector<Column> columnsToDrop = new Vector();
    private String name;
    public static final String STATEMENT_SEPARATOR = "<STATEMENT_SEPARATOR>\n";

    public Table(String name) {
        this.name = name;
    }

    public String getCreateStatement() {
        StringBuffer insert = new StringBuffer();
        insert = insert.append("CREATE TABLE ").append(this.name).append("\n");
        insert = insert.append("(").append("\n");
        for (int i = 0; i < this.allTableColumns.size(); ++i) {
            insert = insert.append(this.allTableColumns.get(i).getDefinitionStringForCreateTable());
            if (i == this.allTableColumns.size() - 1) continue;
            insert = insert.append(",\n");
        }
        insert = insert.append("\n").append(");\n");
        return insert.toString();
    }

    public String getAlterModifyStatement() {
        StringBuffer alter = new StringBuffer();
        String prefix = "ALTER TABLE " + this.name + " MODIFY (\n";
        String postfix = "\n);\n";
        for (int i = 0; i < this.columnsToModify.size(); ++i) {
            Column column = this.columnsToModify.get(i);
            if (column.isNullHasChanged()) {
                if (column.isNullable()) {
                    alter = alter.append(prefix).append(column.getDefinitionString()).append(postfix).append(STATEMENT_SEPARATOR);
                    continue;
                }
                String defaultValue = null;
                boolean isTempDefault = false;
                if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
                    defaultValue = column.getDefaultValue();
                } else {
                    defaultValue = column.getTmpDefaultValue();
                    isTempDefault = true;
                }
                if (isTempDefault) {
                    alter = alter.append("-- TEMP VALUE - REPLACE_ME: " + defaultValue + "\n");
                }
                alter = alter.append("UPDATE ").append(this.name).append(" SET ").append(column.getColumnName()).append("=").append(defaultValue);
                alter = alter.append(" WHERE ").append(column.getColumnName()).append(" IS NULL;\n").append(STATEMENT_SEPARATOR);
                alter = alter.append(prefix).append(column.getDefinitionString()).append(postfix).append(STATEMENT_SEPARATOR);
                continue;
            }
            alter = column.isDefaultHasChanged() ? alter.append(prefix).append(column.getSetDefaultString()).append(postfix).append(STATEMENT_SEPARATOR) : alter.append(prefix).append(column.getTypeDefinitionString()).append(postfix).append(STATEMENT_SEPARATOR);
        }
        alter = alter.delete(alter.lastIndexOf(STATEMENT_SEPARATOR), alter.length());
        return alter.toString();
    }

    public String getAlterDropStatement() {
        StringBuffer alter = new StringBuffer();
        alter = alter.append("ALTER TABLE ").append(this.name).append("\n");
        alter = alter.append("DROP (").append("\n");
        for (int i = 0; i < this.columnsToDrop.size(); ++i) {
            alter = alter.append(this.columnsToDrop.get(i).getColumnName());
            if (i == this.columnsToDrop.size() - 1) continue;
            alter = alter.append(",\n");
        }
        alter = alter.append("\n").append(");\n");
        return alter.toString();
    }

    public String getAlterAddStatement() {
        StringBuffer alter = new StringBuffer();
        String prefixAdd = "ALTER TABLE " + this.name + " ADD (\n";
        String prefixModify = "ALTER TABLE " + this.name + " MODIFY (\n";
        String postfix = "\n);\n";
        for (int i = 0; i < this.columnsToAdd.size(); ++i) {
            Column column = this.columnsToAdd.get(i);
            if (column.isNullable()) {
                alter = alter.append(prefixAdd).append(column.getDefinitionString()).append(postfix).append(STATEMENT_SEPARATOR);
                continue;
            }
            if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
                alter = alter.append(prefixAdd).append(column.getDefinitionString()).append(postfix).append(STATEMENT_SEPARATOR);
                continue;
            }
            alter = alter.append(prefixAdd).append("-- TEMP VALUE - REPLACE_ME: ").append(column.getTmpDefaultValue()).append("\n").append(column.getDefinitionStringWithTempDefault()).append(postfix).append(STATEMENT_SEPARATOR);
            alter = alter.append(prefixModify).append(column.getSetDefaultString()).append(postfix).append(STATEMENT_SEPARATOR);
        }
        alter = alter.delete(alter.lastIndexOf(STATEMENT_SEPARATOR), alter.length());
        return alter.toString();
    }

    public String getDropStatement() {
        return "DROP TABLE " + this.name + ";";
    }

    public void addColumn(Column column) {
        if (!this.allTableColumns.contains(column)) {
            this.allTableColumns.add(column);
        }
    }

    public void addColumnToAdd(Column column) {
        if (!this.columnsToAdd.contains(column)) {
            this.columnsToAdd.add(column);
        }
    }

    public void addColumnToDrop(Column column) {
        if (!this.columnsToDrop.contains(column)) {
            this.columnsToDrop.add(column);
        }
    }

    public void addColumnToModify(Column column) {
        if (!this.columnsToModify.contains(column)) {
            this.columnsToModify.add(column);
        }
    }

    public boolean isAlterAdd() {
        return this.columnsToAdd.size() > 0;
    }

    public boolean isAlterDrop() {
        return this.columnsToDrop.size() > 0;
    }

    public boolean isAlterModify() {
        return this.columnsToModify.size() > 0;
    }
}

