/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.model.MUserAuthentication;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.authentication.services.IOpenIDConnect;
import org.spin.authentication.services.OpenIDUtil;
import org.spin.model.MADAppRegistration;

public abstract class OpenIDConnect
implements IOpenIDConnect {
    private static final CLogger log = CLogger.getCLogger(OpenIDConnect.class);
    private MADAppRegistration applicationRegistration = null;
    private int registrationId = 0;
    private Boolean isValid = null;
    private String accessToken = null;
    private String refreshToken = null;
    private URI authorizationEndPoint = null;
    private URI tokenEndpoint = null;
    private URI redirectURL = null;
    private URI userInfoEndpoint = null;
    private ClientID clientID = null;
    private Scope scope = null;
    private ResponseType responseType = null;
    private Secret clientSecret = null;
    HashMap<String, String> userInfoData = new HashMap();

    public String testConnection() {
        if (this.validateSetting()) {
            return "@OK@";
        }
        return "";
    }

    private boolean validateSetting() {
        AtomicReference<Boolean> valid = new AtomicReference<Boolean>(true);
        OpenIDUtil.PARAMETER_TAGS.forEach(tag -> Optional.ofNullable(this.getApplicationRegistration().getParameterValue(tag)).orElseGet(() -> {
            valid.set(false);
            return "";
        }));
        return valid.get();
    }

    public MADAppRegistration getApplicationRegistration() {
        this.applicationRegistration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        return this.applicationRegistration;
    }

    public boolean isValid() {
        return Optional.ofNullable(this.isValid).orElseGet(() -> {
            this.isValid = this.validateSetting();
            return this.isValid;
        });
    }

    public String getServiceURL() {
        String requestURI = null;
        if (this.isValid()) {
            State state = new State(OpenIDUtil.getState((MADAppRegistration)this.applicationRegistration));
            Optional<String> maybeScope = Optional.ofNullable(this.getApplicationRegistration().getParameterValue("SCOPES"));
            maybeScope.ifPresent(scope -> this.setScope(scope.split(",")));
            AuthorizationRequest request = new AuthorizationRequest.Builder(this.getResponseType(), this.getClientID()).scope(this.getScope()).state(state).redirectionURI(this.getRedirectURL()).endpointURI(this.getAuthorizationEndPoint()).build();
            requestURI = request.toURI().toString();
        }
        return requestURI;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.isValid = null;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    private void accessToken(String codeParameter) {
        Optional<String> maybeCode = Optional.ofNullable(codeParameter);
        maybeCode.ifPresent(code -> {
            try {
                AuthorizationCode authorizationCode = new AuthorizationCode(code);
                AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authorizationCode, this.getRedirectURL());
                ClientSecretBasic clientAuth = new ClientSecretBasic(this.getClientID(), this.getClientSecret());
                TokenRequest request = new TokenRequest(this.getTokenEndpoint(), (ClientAuthentication)clientAuth, (AuthorizationGrant)codeGrant);
                TokenResponse tokenResponse = this.parseTokenResponse(request.toHTTPRequest().send());
                if (!tokenResponse.indicatesSuccess()) {
                    log.severe(tokenResponse.toErrorResponse().getErrorObject().toString());
                    return;
                }
                OIDCTokenResponse successResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
                Optional<AccessToken> maybeAccessToken = Optional.ofNullable(successResponse.getOIDCTokens().getAccessToken());
                maybeAccessToken.ifPresent(token -> {
                    this.accessToken = token.getValue();
                });
                Optional<RefreshToken> maybeRefreshToken = Optional.ofNullable(successResponse.getOIDCTokens().getRefreshToken());
                maybeRefreshToken.ifPresent(token -> {
                    this.refreshToken = token.getValue();
                });
            }
            catch (ParseException e) {
                log.severe(e.getMessage());
            }
            catch (IOException e) {
                log.severe(e.getMessage());
            }
        });
    }

    public void validateAuthentication(String codeParameter, MUser user) {
        Optional<MUser> maybeUser = Optional.ofNullable(user);
        this.accessToken(codeParameter);
        maybeUser = Optional.ofNullable(maybeUser.orElse(this.getUser()));
        maybeUser.ifPresent(userLogin -> MUserAuthentication.createUserAuthentication().withUserId(userLogin.get_ID()).withAppRegistrationId(this.getAppRegistrationId()).withAccessToken(this.accessToken).withRefreshToken(this.refreshToken).saveEx());
    }

    public Map<String, String> getUserInfo() {
        if (this.userInfoData.isEmpty()) {
            try {
                BearerAccessToken token = new BearerAccessToken(this.accessToken);
                HTTPResponse httpResponse = new UserInfoRequest(this.getUserInfoEndpoint(), (AccessToken)token).toHTTPRequest().send();
                UserInfoResponse userInfoResponse = this.parseUserInfo(httpResponse);
                if (!userInfoResponse.indicatesSuccess()) {
                    log.severe(userInfoResponse.toErrorResponse().getErrorObject().toString());
                    return this.userInfoData;
                }
                UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
                this.userInfoData = userInfo.toJSONObject().entrySet().stream().collect(Collectors.toMap(map -> Optional.ofNullable((String)map.getKey()).orElse("").toString(), map -> Optional.ofNullable(map.getValue()).orElse("").toString(), (key, value) -> key, HashMap::new));
            }
            catch (IOException e) {
                log.severe(e.getMessage());
            }
            catch (ParseException e) {
                log.severe(e.getMessage());
            }
        }
        return this.userInfoData;
    }

    protected TokenResponse parseTokenResponse(HTTPResponse httpResponse) throws ParseException {
        return OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
    }

    protected UserInfoResponse parseUserInfo(HTTPResponse httpResponse) throws ParseException {
        return UserInfoResponse.parse((HTTPResponse)httpResponse);
    }

    public MUser getUser() {
        AtomicReference<Object> user = new AtomicReference<Object>(null);
        Optional<String> maybeUserEmail = Optional.ofNullable(this.getUserInfo().get("email"));
        maybeUserEmail.ifPresent(email -> user.set(MUser.getUsers((Properties)Env.getCtx(), (String)email).stream().findFirst().orElse(null)));
        return user.get();
    }

    public ClientID getClientID() {
        this.clientID = Optional.ofNullable(this.clientID).orElse(new ClientID(this.applicationRegistration.getParameterValue("CLIENT_ID")));
        return this.clientID;
    }

    public Secret getClientSecret() {
        this.clientSecret = Optional.ofNullable(this.clientSecret).orElse(new Secret(this.applicationRegistration.getParameterValue("CLIENT_SECRET")));
        return this.clientSecret;
    }

    public URI getAuthorizationEndPoint() {
        return this.authorizationEndPoint;
    }

    public void setAuthorizationEndPoint(String URL2) {
        Optional<String> maybeURL = Optional.ofNullable(URL2);
        maybeURL.ifPresent(url -> {
            this.authorizationEndPoint = this.getValidURL(URL2);
        });
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String URL2) {
        Optional<String> maybeURL = Optional.ofNullable(URL2);
        maybeURL.ifPresent(url -> {
            this.tokenEndpoint = this.getValidURL(URL2);
        });
    }

    public URI getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String URL2) {
        Optional<String> maybeURL = Optional.ofNullable(URL2);
        maybeURL.ifPresent(url -> {
            this.userInfoEndpoint = this.getValidURL(URL2);
        });
    }

    public URI getRedirectURL() {
        this.redirectURL = Optional.ofNullable(this.redirectURL).orElse(this.getValidURL(this.applicationRegistration.getParameterValue("REDIRECT_URL")));
        return this.redirectURL;
    }

    private URI getValidURL(String URL2) {
        URI validURI = null;
        try {
            validURI = new URI(URL2);
        }
        catch (URISyntaxException e) {
            log.severe(e.getMessage());
        }
        return validURI;
    }

    public void setScope(String ... scope) {
        this.scope = new Scope(scope);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void clearValues() {
        this.accessToken = null;
        this.refreshToken = null;
        this.userInfoData.clear();
    }
}

