/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services.provider;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minidev.json.JSONObject;
import org.spin.authentication.services.OpenIDConnect;
import org.spin.authentication.services.OpenIDUtil;

public class GitHubAuthentication
extends OpenIDConnect {
    private static final String defaultScope = "user:email";
    private static final String authorizationEndPoint = "https://github.com/login/oauth/authorize";
    private static final String userInfoEndPoint = "https://api.github.com/user";
    private static final String tokenEndPoint = "https://github.com/login/oauth/access_token";

    public GitHubAuthentication() {
        this.setResponseType(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}));
        this.setAuthorizationEndPoint(authorizationEndPoint);
        this.setUserInfoEndpoint(userInfoEndPoint);
        this.setTokenEndpoint(tokenEndPoint);
        this.setScope(defaultScope);
    }

    @Override
    protected TokenResponse parseTokenResponse(HTTPResponse httpResponse) throws ParseException {
        JSONObject contentJSON = this.getContentAsJSONObject(httpResponse.getContent());
        if (httpResponse.getStatusCode() == 200 && contentJSON.get((Object)"access_token") != null) {
            return OIDCTokenResponse.parse((JSONObject)contentJSON);
        }
        return TokenErrorResponse.parse((JSONObject)contentJSON);
    }

    private JSONObject getContentAsJSONObject(String content) {
        JSONObject contentJSON = new JSONObject();
        Optional<Map> maybeMapContent = Optional.ofNullable(OpenIDUtil.getMapFromString((String)content, (String)"&"));
        maybeMapContent.ifPresent(mapContent -> mapContent.entrySet().forEach(map -> contentJSON.put((Object)this.validData((String)map.getKey()), (Object)this.validData((String)map.getValue()))));
        return contentJSON;
    }

    @Override
    protected UserInfoResponse parseUserInfo(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() == 200) {
            return GitHubAuthentication.parseJson(httpResponse.getContentAsJSONObject());
        }
        return UserInfoErrorResponse.parse((HTTPResponse)httpResponse);
    }

    private String validData(String data) {
        return Optional.ofNullable(data).orElse("").replace("bearer", "Bearer").replace("\n", "");
    }

    private static UserInfoSuccessResponse parseJson(JSONObject userInfoJson) throws ParseException {
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        Optional<JSONObject> maybeUserInfoJson = Optional.ofNullable(userInfoJson);
        maybeUserInfoJson.ifPresent(userInfo -> {
            boolean existSub = userInfo.entrySet().stream().anyMatch(map -> ((String)map.getKey()).equals("sub"));
            if (!existSub) {
                userInfo.put((Object)"sub", (Object)"");
            }
            UserInfo claimsSet = new UserInfo(userInfoJson);
            response.set(new UserInfoSuccessResponse(claimsSet));
        });
        return response.get();
    }
}

