/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.command;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.pos.AdempierePOSException;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CommandReceiver {
    private Properties ctx;
    private Optional<Integer> processId;
    private Optional<Integer> bankAccountId;
    private Optional<Integer> posId;
    private Optional<String> value;
    private Optional<String> name;
    private Optional<Integer> orderId;
    private Optional<Integer> partnerId;
    private Optional<Integer> warehouseId;
    private Optional<String> event;
    private ProcessInfo processInfo;

    public CommandReceiver(Integer processId, String value, String event) {
        this.setValue(value);
        if (processId != null && processId > 0) {
            this.setName(MProcess.get((Properties)Env.getCtx(), (int)processId).getName());
            if (event != null) {
                this.setEvent(Msg.parseTranslation((Properties)Env.getCtx(), (String)event));
            } else {
                this.setEvent(this.getName());
            }
        } else if (value != null && value.length() > 0) {
            this.setProcessId(MProcess.getProcess_ID((String)value, null));
            this.setName(MProcess.get((Properties)Env.getCtx(), (int)this.getProcessId()).getName());
            if (event != null) {
                this.setEvent(Msg.parseTranslation((Properties)Env.getCtx(), (String)event));
            } else {
                this.setEvent(this.getName());
            }
        } else if (value == null && event != null && event.length() > 0) {
            this.setEvent(Msg.parseTranslation((Properties)Env.getCtx(), (String)event));
        }
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public void setCtx(Properties ctx) {
        this.ctx = ctx;
    }

    public Integer getProcessId() {
        return this.processId.orElseThrow(() -> new AdempierePOSException("@AD_Process_ID@ @NotFound@"));
    }

    public void setProcessId(Integer processId) {
        this.processId = Optional.ofNullable(processId);
    }

    public String getValue() {
        return this.value.orElseThrow(() -> new AdempierePOSException("@Value@ @NotFound@"));
    }

    public void setValue(String value) {
        this.value = Optional.ofNullable(value);
    }

    public String getName() {
        return this.name.orElseThrow(() -> new AdempierePOSException("@Name@ @NotFound@"));
    }

    public void setName(String name) {
        this.name = Optional.ofNullable(name);
    }

    public String getEvent() {
        return this.event.orElseThrow(() -> new AdempierePOSException("Event Name @NotFound@"));
    }

    public void setEvent(String event) {
        this.event = Optional.ofNullable(event);
    }

    public Integer getOrderId() {
        return this.orderId.orElseThrow(() -> new AdempierePOSException("@C_Order_ID@ @NotFound@"));
    }

    public void setOrderId(int orderId) {
        this.orderId = Optional.ofNullable(orderId);
    }

    public void setPartnerId(Integer partnerId) {
        this.partnerId = Optional.ofNullable(partnerId);
    }

    public Integer getPartnerId() {
        return this.partnerId.orElseThrow(() -> new AdempierePOSException("@C_BPartner_ID@ @NotFound@"));
    }

    public void setWarehouseId(Integer warehouseId) {
        this.warehouseId = Optional.ofNullable(warehouseId);
    }

    public Integer getWarehouseId() {
        return this.warehouseId.orElseThrow(() -> new AdempierePOSException("@M_Warehouse_ID@ @NotFound@"));
    }

    public void setBankAccountId(Integer bankAccountId) {
        this.bankAccountId = Optional.ofNullable(bankAccountId);
    }

    public Integer getBankAccountId() {
        return this.bankAccountId.orElseThrow(() -> new AdempierePOSException("@C_BankAccount_ID@ @NotFound@"));
    }

    public void setPOSId(Integer posId) {
        this.posId = Optional.ofNullable(posId);
    }

    public Integer getPOSId() {
        return this.posId.orElseThrow(() -> new AdempierePOSException("@C_POS_ID@ @NotFound@"));
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }
}

