/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.CloseStatementPOSAbstract;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.util.Msg;

public class CloseStatementPOS
extends CloseStatementPOSAbstract {
    protected LinkedHashMap<Integer, MBankStatement> baskStatements = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getBankAccountId() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
        }
        if (this.getTransactionDate() == null || this.getTransactionDateTo() == null) {
            throw new AdempiereException("@DateTrx@ @NotFound@");
        }
        if (this.getDifference().signum() != 0 && !this.isOverUnderPayment()) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@C_BankStatement_ID@ @NotApproved@ @NotMatch@");
        }
        if (this.isOverUnderPayment()) {
            if (this.getChargeId() <= 0) {
                throw new AdempiereException("@C_Charge_ID@ @NotFound@");
            }
            this.generateLostOrProfit();
        }
        this.closeBankStatements();
        return "@Ok@";
    }

    private void closeBankStatements() {
        this.getBankStatements().entrySet().stream().forEach(entry -> {
            MBankStatement bankStatement = (MBankStatement)entry.getValue();
            bankStatement.processIt("CO");
            bankStatement.saveEx();
        });
    }

    private void generateLostOrProfit() {
        MBankStatement bankStatement = (MBankStatement)this.getBankStatements().entrySet().iterator().next();
        MBankStatementLine bankStatementLine = new MBankStatementLine(bankStatement);
        bankStatementLine.setDateAcct(this.getTransactionDate());
        bankStatementLine.setStatementLineDate(this.getTransactionDateTo());
        bankStatementLine.setStmtAmt(this.getDifference());
        bankStatementLine.setC_Charge_ID(this.getChargeId());
        bankStatementLine.setChargeAmt(this.getDifference());
        bankStatementLine.saveEx();
    }

    private LinkedHashMap<Integer, MBankStatement> getBankStatements() {
        if (this.baskStatements != null && this.baskStatements.size() > 0) {
            return this.baskStatements;
        }
        this.baskStatements = new LinkedHashMap();
        List payments = this.getInstancesForSelection(this.get_TrxName());
        payments.stream().forEach(payment -> {
            MBankStatementLine bankStatementLine;
            MBankStatement bankStatement;
            Integer bankStatementLineId = this.getSelectionAsInt(payment.get_ID(), "BSL_C_BankStatementLine_ID");
            if (bankStatementLineId != null && bankStatementLineId > 0 && !this.baskStatements.containsKey((bankStatement = (bankStatementLine = new MBankStatementLine(this.getCtx(), bankStatementLineId.intValue(), this.get_TrxName())).getParent()).get_ID())) {
                this.baskStatements.put(bankStatement.get_ID(), bankStatement);
            }
        });
        return this.baskStatements;
    }
}

