/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.pos.process.CreateOrderBasedOnAnotherAbstract;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.util.Msg;

public class CreateOrderBasedOnAnother
extends CreateOrderBasedOnAnotherAbstract {
    private MOrder targetOrder;
    private Timestamp today;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder sourceOrder = new MOrder(this.getCtx(), this.getOrderSourceId(), this.get_TrxName());
        this.targetOrder = MOrder.copyFrom((MOrder)sourceOrder, (Timestamp)this.today, (int)sourceOrder.getC_DocTypeTarget_ID(), (boolean)sourceOrder.isSOTrx(), (boolean)false, (boolean)true, (String)this.get_TrxName());
        if (this.getSOSubType() != null) {
            this.targetOrder.setC_DocTypeTarget_ID(MDocType.getDocTypeBaseOnSubType((int)sourceOrder.getAD_Org_ID(), (String)"SOO", (String)this.getSOSubType()));
        }
        this.targetOrder.setC_BPartner_ID(this.getInvoicePartnerId());
        this.targetOrder.setRef_Order_ID(sourceOrder.get_ID());
        this.targetOrder.setDocAction(this.getDocumentAction());
        this.targetOrder.setDocStatus("DR");
        this.targetOrder.setProcessed(false);
        this.targetOrder.saveEx();
        this.targetOrder.processIt(this.getDocumentAction());
        this.targetOrder.saveEx();
        this.addLog(this.targetOrder.getDocumentNo());
        this.getProcessInfo().setRecord_ID(this.targetOrder.get_ID());
        String message = "@C_Order_ID@ " + this.targetOrder.getDocumentNo();
        if (!this.targetOrder.isProcessed()) {
            return message;
        }
        if (this.isIncludePayments()) {
            this.createPayments(sourceOrder, this.targetOrder);
        }
        if (this.isAllocated()) {
            this.createAllocations(this.targetOrder);
        }
        return message;
    }

    private void createAllocations(MOrder targetOrder) {
        List payments = MPayment.getOfOrder((MOrder)targetOrder);
        MInvoice[] invoices = targetOrder.getInvoices();
        BigDecimal totalPay = BigDecimal.ZERO;
        BigDecimal totalInvoiced = BigDecimal.ZERO;
        for (MPayment payment : payments) {
            totalPay = totalPay.add(payment.getPayAmt());
        }
        for (MInvoice invoice : invoices) {
            totalInvoiced = totalInvoiced.add(invoice.getGrandTotal());
        }
        if (totalInvoiced.signum() != 0 && totalPay.signum() != 0 && totalInvoiced.compareTo(totalPay) == 0) {
            MAllocationHdr allocation = new MAllocationHdr(this.getCtx(), true, this.today, targetOrder.getC_Currency_ID(), targetOrder.getDescription(), this.get_TrxName());
            allocation.setDocStatus("DR");
            allocation.setDocAction("CO");
            allocation.saveEx();
            this.addLog(allocation.getDocumentInfo());
            for (MInvoice invoice : invoices) {
                MAllocationLine allocationLine = new MAllocationLine(allocation);
                allocationLine.setDocInfo(targetOrder.getC_BPartner_ID(), targetOrder.getC_Order_ID(), invoice.getC_Invoice_ID());
                allocationLine.setAmount(invoice.getGrandTotal());
                allocationLine.saveEx();
            }
            for (MPayment payment : payments) {
                MAllocationLine allocationLine = new MAllocationLine(allocation);
                allocationLine.setPaymentInfo(payment.get_ID(), 0);
                allocationLine.setAmount(payment.getPayAmt());
                allocationLine.saveEx();
            }
            allocation.processIt("CO");
            allocation.saveEx();
        }
    }

    private void createPayments(MOrder sourceOrder, MOrder targetOrder) {
        for (MPayment sourcePayment : MPayment.getOfOrder((MOrder)sourceOrder)) {
            MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourcePayment, (PO)payment);
            payment.setDateTrx(this.today);
            payment.setDateAcct(this.today);
            payment.setC_Order_ID(targetOrder.getC_Order_ID());
            payment.setC_BPartner_ID(targetOrder.getC_BPartner_ID());
            payment.setC_Invoice_ID(-1);
            payment.addDescription(Msg.parseTranslation((Properties)sourceOrder.getCtx(), (String)" @From@ ") + sourcePayment.getDocumentNo());
            payment.setIsReceipt(true);
            payment.setC_DocType_ID(MDocType.getDocType((String)"ARR", (int)sourceOrder.getAD_Org_ID()));
            payment.setIsPrepayment(true);
            payment.saveEx();
            payment.processIt(this.getDocumentAction());
            payment.saveEx();
            this.addLog(payment.getDocumentInfo());
        }
    }
}

