/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.GenerateWithdrawalAbstract;
import org.compiere.model.MBankStatement;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class GenerateWithdrawal
extends GenerateWithdrawalAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        Object description = this.getDescription();
        if (Util.isEmpty((String)description)) {
            description = Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generated@ @from@ @C_POS_ID@") + DisplayType.getDateFormat((int)15).format(this.getTransactionDate());
        }
        MPaymentBatch paymentBatchFrom = new MPaymentBatch(this.getCtx(), 0, this.get_TrxName());
        paymentBatchFrom.setName((String)description);
        paymentBatchFrom.setProcessingDate(this.getTransactionDate());
        paymentBatchFrom.saveEx();
        MPaymentBatch paymentBatchTo = new MPaymentBatch(this.getCtx(), 0, this.get_TrxName());
        paymentBatchTo.setName((String)description);
        paymentBatchTo.setProcessingDate(this.getTransactionDate());
        paymentBatchTo.saveEx();
        List refLists = this.getInstancesForSelection(this.get_TrxName());
        refLists.stream().forEach(refList -> {
            BigDecimal amount = this.getSelectionAsBigDecimal(refList.get_ID(), "TT_Amount");
            String referenceNo = this.getSelectionAsString(refList.get_ID(), "TT_ReferenceNo");
            if (amount.signum() > 0) {
                this.createPayment(this.getBankAccountId(), this.getPOSTerminalId(), this.getBusinessPartnerId(), this.getDocumentNo(), referenceNo, paymentBatchFrom.getName(), this.getDocumentTypeId(), this.getChargeId(), refList.getValue(), this.getCurrencyId(), amount, this.getTransactionDate(), this.getAccountDate(), false, paymentBatchFrom.get_ID());
                this.createPayment(this.getTransferCashtrxtoId(), this.getPOSTerminalId(), this.getBusinessPartnerId(), this.getDocumentNo(), referenceNo, paymentBatchTo.getName(), this.getCounterDocumentTypeId(), this.getChargeId(), refList.getValue(), this.getCurrencyId(), amount, this.getTransactionDate(), this.getAccountDate(), true, paymentBatchTo.get_ID());
            }
        });
        return "@Ok@";
    }

    private void createPayment(Integer bankAccountId, Integer pOSTerminalId, Integer businessPartnerId, String documentNo, String referenceNo, String description, Integer documentTypeId, Integer chargeId, String tenderType, Integer currencyId, BigDecimal amount, Timestamp transactionDate, Timestamp accountDate, Boolean isReceipt, Integer paymentBatchId) {
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setC_POS_ID(pOSTerminalId.intValue());
        MPOS terminal = MPOS.get((Properties)this.getCtx(), (int)pOSTerminalId);
        payment.setDateTrx(transactionDate);
        if (documentNo != null && documentNo.length() > 0) {
            payment.setDocumentNo(documentNo);
        }
        if (referenceNo != null && referenceNo.length() > 0) {
            payment.setVoiceAuthCode(referenceNo);
        }
        payment.setC_BankAccount_ID(bankAccountId.intValue());
        payment.setDateAcct(accountDate);
        payment.setC_BPartner_ID(businessPartnerId.intValue());
        payment.addDescription(description);
        payment.setTenderType(tenderType);
        payment.setIsReceipt(isReceipt.booleanValue());
        payment.setC_Charge_ID(chargeId.intValue());
        payment.setC_DocType_ID(documentTypeId.intValue());
        payment.setC_Currency_ID(currencyId.intValue());
        if (terminal.get_ValueAsInt("C_ConversionType_ID") > 0) {
            payment.setC_ConversionType_ID(terminal.get_ValueAsInt("C_ConversionType_ID"));
        }
        payment.setAmount(currencyId.intValue(), amount);
        payment.setC_PaymentBatch_ID(paymentBatchId.intValue());
        payment.saveEx();
        if (!payment.processIt("CO")) {
            throw new AdempiereException("@Error@ " + payment.getErrorMessage());
        }
        payment.saveEx();
        MBankStatement.addPayment((MPayment)payment);
        this.addLog(payment.getDocumentInfo());
    }
}

