/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.process.ReverseTheSalesTransactionAbstract;
import org.compiere.model.MBankStatement;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Msg;
import org.eevolution.services.dsl.ProcessBuilder;

public class ReverseTheSalesTransaction
extends ReverseTheSalesTransactionAbstract {
    private Timestamp today;
    private List<MInOut> customerReturns = new ArrayList<MInOut>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        MInvoice[] invoices;
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder sourceOrder = new MOrder(this.getCtx(), this.getOrderId(), this.get_TrxName());
        MInOut[] shipments = sourceOrder.getShipments();
        if (shipments.length > 0 && (sourceOrder.getC_BPartner_ID() != this.getInvoicePartnerId() || this.isCancelled())) {
            this.cancelShipments(shipments);
        }
        if ((invoices = sourceOrder.getInvoices()).length > 0 && (sourceOrder.getC_BPartner_ID() != this.getInvoicePartnerId() || this.isCancelled())) {
            this.cancelInvoices();
        }
        for (MPayment payment : ReverseTheSalesTransaction.cancelPayments(sourceOrder, this.today)) {
            this.addLog(payment.getDocumentInfo());
        }
        sourceOrder.processIt("CL");
        sourceOrder.saveEx();
        return "@Ok@";
    }

    private void cancelShipments(MInOut[] sourceShipments) {
        for (MInOut sourceShipment : sourceShipments) {
            MRMA rma = new MRMA(this.getCtx(), 0, this.get_TrxName());
            rma.setM_InOut_ID(sourceShipment.getM_InOut_ID());
            rma.setAD_Org_ID(sourceShipment.getAD_Org_ID());
            rma.setM_RMAType_ID(this.getRMATypeId());
            rma.setC_BPartner_ID(sourceShipment.getC_BPartner_ID());
            rma.setName(sourceShipment.getDocumentInfo());
            rma.setIsSOTrx(true);
            rma.setSalesRep_ID(sourceShipment.getSalesRep_ID());
            rma.setC_DocType_ID(MDocType.getDocTypeBaseOnSubType((int)sourceShipment.getAD_Org_ID(), (String)"SOO", (String)"RM"));
            rma.setDocStatus("DR");
            rma.setDocAction("CO");
            rma.saveEx();
            MInOut customerReturn = new MInOut(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceShipment, (PO)customerReturn);
            customerReturn.setDocumentNo(null);
            customerReturn.setM_RMA_ID(rma.getM_RMA_ID());
            customerReturn.setIsSOTrx(true);
            customerReturn.setC_BPartner_ID(sourceShipment.getC_BPartner_ID());
            customerReturn.setC_Order_ID(-1);
            for (MDocType mDocType : MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"MMR")) {
                if (!mDocType.isSOTrx()) continue;
                customerReturn.setC_DocType_ID();
            }
            customerReturn.setMovementType("C+");
            customerReturn.setDocStatus("DR");
            customerReturn.setDocAction("CO");
            customerReturn.setProcessed(false);
            customerReturn.saveEx();
            for (MDocType mDocType : sourceShipment.getLines()) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), 0, this.get_TrxName());
                rmaLine.setM_RMA_ID(rma.getM_RMA_ID());
                rmaLine.setAD_Org_ID(mDocType.getAD_Org_ID());
                rmaLine.setM_InOutLine_ID(mDocType.getM_InOutLine_ID());
                rmaLine.setQty(mDocType.getMovementQty());
                rmaLine.saveEx();
                MInOutLine customerReturnLine = new MInOutLine(this.getCtx(), 0, this.get_TrxName());
                customerReturnLine.setM_InOut_ID(customerReturn.getM_InOut_ID());
                customerReturnLine.setM_RMALine_ID(rmaLine.getM_RMALine_ID());
                customerReturnLine.setM_Product_ID(rmaLine.getM_Product_ID());
                customerReturnLine.setM_Locator_ID(mDocType.getM_Locator_ID());
                customerReturnLine.setMovementQty(rmaLine.getQty());
                customerReturnLine.saveEx();
            }
            rma.processIt("CO");
            rma.saveEx();
            this.addLog(rma.getDocumentInfo());
            if (customerReturn.getC_DocType().isShipConfirm() && this.isShipReceiptConfirmation()) {
                customerReturn.processIt("IP");
                customerReturn.saveEx();
                for (MDocType mDocType : customerReturn.getConfirmations(true)) {
                    for (MInOutLineConfirm confirmLine : mDocType.getLines(true)) {
                        confirmLine.setConfirmedQty(confirmLine.getTargetQty());
                        confirmLine.saveEx();
                    }
                    mDocType.processIt("CO");
                    mDocType.saveEx();
                    this.addLog(mDocType.getDocumentInfo());
                }
            }
            customerReturn.processIt("CO");
            customerReturn.saveEx();
            this.addLog(customerReturn.getDocumentInfo());
            this.customerReturns.add(customerReturn);
        }
    }

    private void cancelInvoices() {
        for (MInOut customerReturn : this.customerReturns) {
            ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process("M_InOut_CreateInvoice").withTitle("Generate Invoice from Receipt").withRecordId(Integer.valueOf(MInOut.Table_ID), Integer.valueOf(customerReturn.getM_InOut_ID())).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                String errorMessage = Msg.parseTranslation((Properties)this.getCtx(), (String)(processInfo.getTitle() + " @ProcessRunError@ " + processInfo.getSummary() + " " + processInfo.getLogInfo()));
                throw new AdempierePOSException(errorMessage);
            }
            this.addLog(processInfo.getLogInfo());
            for (MInvoice creditNote : this.getCreditNotes(customerReturn.getM_RMA_ID())) {
                if (creditNote == null || creditNote.getC_Invoice_ID() <= 0) continue;
                creditNote.setDateInvoiced(this.today);
                creditNote.setDateAcct(this.today);
                creditNote.processIt("CO");
                creditNote.saveEx();
                this.addLog(creditNote.getDocumentInfo());
            }
        }
    }

    public static List<MPayment> cancelPayments(MOrder sourceOrder, Timestamp today) {
        ArrayList<MPayment> payments = new ArrayList<MPayment>();
        List sourcePayments = MPayment.getOfOrder((MOrder)sourceOrder);
        for (MPayment sourcePayment : sourcePayments) {
            MPayment payment = new MPayment(sourceOrder.getCtx(), 0, sourceOrder.get_TrxName());
            PO.copyValues((PO)sourcePayment, (PO)payment);
            payment.setDateTrx(today);
            payment.setC_Order_ID(sourceOrder.getC_Order_ID());
            payment.setDateAcct(today);
            payment.addDescription(" @From@ " + sourcePayment.getDocumentNo());
            payment.setIsReceipt(false);
            payment.setC_DocType_ID(MDocType.getDocType((String)"APP"));
            payment.setDocAction("CO");
            payment.setDocStatus("DR");
            payment.setIsPrepayment(true);
            payment.saveEx();
            payment.processIt("CO");
            payment.saveEx();
            payments.add(payment);
            MBankStatement.addPayment((MPayment)payment);
        }
        return payments;
    }

    public int getRMATypeId() {
        return new Query(this.getCtx(), "M_RMAType", null, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("Name").setClient_ID().firstId();
    }

    public List<MInvoice> getCreditNotes(int Id) {
        StringBuilder where = new StringBuilder();
        where.append("M_RMA_ID").append("=?");
        return new Query(this.getCtx(), "C_Invoice", where.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{Id}).list();
    }
}

