/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.services;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import org.adempiere.core.domains.models.I_AD_User;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.command.CommandManager;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProductPricing;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.ValueNamePair;
import org.eevolution.services.dsl.ProcessBuilder;

public class CPOS {
    private MPOS entityPOS;
    private MOrder currentOrder;
    private MSequence documentSequence;
    private MBPartner partner;
    private int priceListVersionId;
    private int priceListId;
    private Properties ctx;
    private Timestamp today;
    private ArrayList<Integer> orderList;
    private int recordPosition;
    private boolean isToPrint;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private BigDecimal quantity = BigDecimal.ZERO;
    private BigDecimal quantityAdded = BigDecimal.ZERO;
    private BigDecimal priceLimit = BigDecimal.ZERO;
    private BigDecimal price = BigDecimal.ZERO;
    private BigDecimal priceList = BigDecimal.ZERO;
    private BigDecimal discountPercentage = BigDecimal.ZERO;
    private boolean isAddQty = false;
    private int orderLineId = 0;
    private DecimalFormat decimalFormat;
    private SimpleDateFormat dateFormat;
    private int windowNo;

    public CPOS() {
        this.ctx = Env.getCtx();
        this.decimalFormat = DisplayType.getNumberFormat((int)12);
        this.dateFormat = DisplayType.getDateFormat((int)15);
        this.today = Env.getContextAsDate((Properties)this.ctx, (String)"#Date");
    }

    public void setPOS(int salesRepId) {
        List<MPOS> poss = this.getPOSByOrganization(Env.getAD_Org_ID((Properties)this.getCtx()));
        if (poss.size() == 0) {
            throw new AdempierePOSException("@NoPOSForUser@");
        }
        if (poss.size() == 1) {
            this.entityPOS = poss.get(0);
        }
    }

    public void setM_POS(MPOS pos) {
        this.entityPOS = pos;
    }

    public DecimalFormat getNumberFormat() {
        return this.decimalFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public boolean isCompleted() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isProcessed() && "CO".equals(this.currentOrder.getDocStatus());
    }

    public int getAD_Sequence_ID() {
        if (this.entityPOS.getC_DocType_ID() > 0) {
            return this.entityPOS.getC_DocType().getDocNoSequence_ID();
        }
        throw new AdempierePOSException("@C_POS_ID@ @C_DocType_ID @NotFound@");
    }

    public int getAD_Org_ID() {
        return this.entityPOS.getAD_Org_ID();
    }

    public boolean isClosed() {
        if (!this.hasOrder()) {
            return false;
        }
        return "CL".equals(this.currentOrder.getDocStatus());
    }

    public boolean isVoided() {
        if (!this.hasOrder()) {
            return false;
        }
        return "VO".equals(this.currentOrder.getDocStatus());
    }

    public boolean isDrafted() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "DR".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInProgress() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IP".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInvalid() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IN".equals(this.currentOrder.getDocStatus());
    }

    public boolean hasLines() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.getLines().length > 0;
    }

    public boolean isPOSOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WR".equals(this.getDocSubTypeSO());
    }

    public boolean isCreditOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WI".equals(this.getDocSubTypeSO());
    }

    public boolean isStandardOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "SO".equals(this.getDocSubTypeSO());
    }

    public boolean isPrepayOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "PR".equals(this.getDocSubTypeSO());
    }

    public boolean isWarehouseOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WP".equals(this.getDocSubTypeSO());
    }

    public boolean isReturnMaterial() {
        if (!this.hasOrder()) {
            return false;
        }
        return "RM".equals(this.getDocSubTypeSO());
    }

    public boolean isInvoiced() {
        if (!this.hasOrder()) {
            return false;
        }
        MInvoice[] invoices = this.getOrder().getInvoices();
        boolean orderInvoiced = false;
        if (invoices != null && invoices.length > 0) {
            orderInvoiced = invoices[0].getDocStatus().equalsIgnoreCase("CO");
        }
        return this.currentOrder.isInvoiced() || orderInvoiced;
    }

    public boolean isDelivered() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isDelivered();
    }

    private String getDocSubTypeSO() {
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (docType != null && docType.getDocSubTypeSO() != null) {
            return docType.getDocSubTypeSO();
        }
        return "";
    }

    public int getC_DocType_ID() {
        if (!this.hasOrder()) {
            return 0;
        }
        if (this.isCompleted() || this.isVoided()) {
            return this.currentOrder.getC_DocType_ID();
        }
        return this.currentOrder.getC_DocTypeTarget_ID();
    }

    public boolean isToPrint() {
        return this.isToPrint;
    }

    public void setIsToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    public MOrder getOrder() {
        return this.currentOrder;
    }

    public boolean hasOrder() {
        return this.currentOrder != null && this.currentOrder.getC_Order_ID() != 0;
    }

    public boolean hasBPartner() {
        return this.partner != null;
    }

    public boolean compareBPName(String name) {
        return this.partner.getName().equals(name);
    }

    public int getC_BPartner_ID() {
        if (this.hasBPartner()) {
            return this.partner.getC_BPartner_ID();
        }
        return 0;
    }

    public int getC_BankAccount_ID() {
        return this.entityPOS.getC_BankAccount_ID();
    }

    public String getBPName() {
        if (this.hasBPartner()) {
            return this.partner.getName();
        }
        return null;
    }

    public int getC_Currency_ID() {
        if (this.hasBPartner() && this.currentOrder != null) {
            return this.currentOrder.getC_Currency_ID();
        }
        return 0;
    }

    public int getAD_User_ID() {
        return Env.getAD_User_ID((Properties)Env.getCtx());
    }

    public int getAutoLogoutDelay() {
        if (this.entityPOS != null) {
            return this.entityPOS.getAutoLogoutDelay();
        }
        return 0;
    }

    public int getPINEntryTimeout() {
        if (this.entityPOS != null) {
            return this.entityPOS.getPINEntryTimeout();
        }
        return 0;
    }

    public String getSalesRepName() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            String salesRepName = this.currentOrder.getC_BPartner().getSalesRep().getName();
            return salesRepName;
        }
        MUser salesRep = MUser.get((Properties)this.ctx);
        if (salesRep == null) {
            return null;
        }
        return salesRep.getName();
    }

    public int getSalesRep_ID() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            return this.currentOrder.getC_BPartner().getSalesRep_ID();
        }
        return this.entityPOS.getSalesRep_ID();
    }

    public MPOS getM_POS() {
        return this.entityPOS;
    }

    public String getPOSName() {
        return this.entityPOS.getName();
    }

    public int getC_POS_ID() {
        return this.entityPOS.getC_POS_ID();
    }

    public boolean isEnableProductLookup() {
        return this.entityPOS.isEnableProductLookup();
    }

    public boolean isRequiredPIN() {
        return this.entityPOS.isPOSRequiredPIN();
    }

    public void newOrder(int partnerId) {
        this.log.info("PosPanel.newOrder");
        this.currentOrder = null;
        int docTypeId = this.entityPOS.getC_DocType_ID();
        this.createOrder(partnerId, docTypeId);
        this.reloadOrder();
    }

    public void setC_DocType_ID(int docTypeTargetId) {
        if (!this.isDrafted()) {
            return;
        }
        this.currentOrder.setC_DocTypeTarget_ID(docTypeTargetId);
        String value = DB.getDocumentNo((int)this.getC_DocType_ID(), null, (boolean)false, (PO)this.currentOrder);
        if (value != null) {
            this.currentOrder.setDocumentNo(value);
        }
        this.currentOrder.saveEx();
    }

    private void createOrder(int partnerId, int docTypeTargetId) {
        int orderId = this.getFreeC_Order_ID();
        if (orderId > 0) {
            this.currentOrder = new MOrder(Env.getCtx(), orderId, null);
            this.currentOrder.setDateOrdered(this.getToday());
            this.currentOrder.setDateAcct(this.getToday());
            this.currentOrder.setDatePromised(this.getToday());
        } else {
            this.currentOrder = new MOrder(Env.getCtx(), 0, null);
        }
        this.currentOrder.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        this.currentOrder.setIsSOTrx(true);
        if (this.entityPOS.getM_PriceList_ID() > 0) {
            this.currentOrder.setM_PriceList_ID(this.entityPOS.getM_PriceList_ID());
        }
        if (this.entityPOS.getDeliveryRule() != null) {
            this.currentOrder.setDeliveryRule(this.getDeliveryRule());
        }
        if (this.entityPOS.getInvoiceRule() != null) {
            this.currentOrder.setInvoiceRule(this.getInvoiceRule());
        }
        this.currentOrder.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.currentOrder.setM_Warehouse_ID(this.entityPOS.getM_Warehouse_ID());
        if (docTypeTargetId != 0) {
            this.currentOrder.setC_DocTypeTarget_ID(docTypeTargetId);
        } else {
            this.currentOrder.setC_DocTypeTarget_ID("WI");
        }
        this.configureBPartner(partnerId);
        if (orderId < 0) {
            this.orderList.add(this.currentOrder.getC_Order_ID());
        }
        this.reloadIndex(this.currentOrder.getC_Order_ID());
    }

    private int getFreeC_Order_ID() {
        return DB.getSQLValue(null, (String)"SELECT o.C_Order_ID FROM C_Order o WHERE o.DocStatus = 'DR' AND o.C_POS_ID = ? AND o.SalesRep_ID = ? AND NOT EXISTS(SELECT 1 \t\t\t\t\tFROM C_OrderLine ol \t\t\t\t\tWHERE ol.C_Order_ID = o.C_Order_ID) ORDER BY o.Updated", (int)this.getC_POS_ID(), (int)this.getSalesRep_ID());
    }

    public boolean isBPartnerStandard() {
        int partnerId;
        int n = partnerId = this.currentOrder != null ? this.currentOrder.getC_BPartner_ID() : 0;
        return this.entityPOS.getC_BPartnerCashTrx_ID() == partnerId;
    }

    public void configureBPartner(int partnerId) {
        MOrderLine[] lines;
        if (this.isCompleted() || this.isVoided()) {
            return;
        }
        this.log.fine("CPOS.setC_BPartner_ID=" + partnerId);
        boolean isSamePOSPartner = false;
        if (partnerId == 0) {
            isSamePOSPartner = true;
            partnerId = this.entityPOS.getC_BPartnerCashTrx_ID();
        }
        this.partner = MBPartner.get((Properties)this.ctx, (int)partnerId);
        if (this.partner == null || this.partner.get_ID() == 0) {
            throw new AdempierePOSException("POS.NoBPartnerForOrder");
        }
        this.log.info("CPOS.SetC_BPartner_ID -" + this.partner);
        this.currentOrder.setBPartner(this.partner);
        MBPartnerLocation[] partnerLocations = this.partner.getLocations(true);
        if (partnerLocations.length > 0) {
            for (MBPartnerLocation partnerLocation : partnerLocations) {
                if (partnerLocation.isBillTo()) {
                    this.currentOrder.setBill_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                }
                if (!partnerLocation.isShipTo()) continue;
                this.currentOrder.setShip_Location_ID(partnerLocation.getC_BPartner_Location_ID());
            }
        }
        if (isSamePOSPartner && this.currentOrder.getPaymentRule() == null) {
            this.currentOrder.setPaymentRule("B");
        }
        if (this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            this.currentOrder.setSalesRep_ID(this.currentOrder.getC_BPartner().getSalesRep_ID());
        } else {
            this.currentOrder.setSalesRep_ID(this.entityPOS.getSalesRep_ID());
        }
        this.currentOrder.saveEx();
        MPriceListVersion priceListVersion = this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
        MProductPrice[] productPrices = priceListVersion.getProductPrice("AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = " + this.currentOrder.getC_Order_ID() + " AND ol.M_Product_ID = M_ProductPrice.M_Product_ID)");
        for (MOrderLine line : lines = this.currentOrder.getLines()) {
            if (this.existInPriceList(line.getM_Product_ID(), productPrices)) {
                line.setC_BPartner_ID(this.partner.getC_BPartner_ID());
                line.setC_BPartner_Location_ID(this.currentOrder.getC_BPartner_Location_ID());
                line.setPrice();
                line.setTax();
                line.saveEx();
                continue;
            }
            line.deleteEx(true);
        }
    }

    private boolean existInPriceList(int productId, MProductPrice[] productPrices) {
        for (MProductPrice productPrice : productPrices) {
            if (productId != productPrice.getM_Product_ID()) continue;
            return true;
        }
        return false;
    }

    public List<MPOS> getPOSByOrganization(int orgId) {
        return MPOS.getByOrganization((Properties)this.ctx, (int)orgId, null);
    }

    public Timestamp getToday() {
        return this.today;
    }

    public void setOrder(int orderId) {
        this.currentOrder = new MOrder(this.ctx, orderId, null);
        if (orderId != 0) {
            this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
        }
        this.reloadOrder();
    }

    public BigDecimal[] updateLine(int orderLineId, BigDecimal qtyOrdered, BigDecimal priceLimit, BigDecimal priceEntered, BigDecimal priceList, BigDecimal discountPercentage) {
        if (!this.isDrafted()) {
            return null;
        }
        MOrderLine[] orderLines = this.currentOrder.getLines("AND C_OrderLine_ID = " + orderLineId, "Line");
        BigDecimal lineNetAmt = Env.ZERO;
        BigDecimal taxRate = Env.ZERO;
        BigDecimal grandTotal = Env.ZERO;
        for (MOrderLine orderLine : orderLines) {
            if (qtyOrdered.compareTo(orderLine.getQtyOrdered()) == 0 && priceEntered.compareTo(orderLine.getPriceEntered()) == 0 && discountPercentage.compareTo(orderLine.getDiscount()) == 0) {
                return null;
            }
            if (discountPercentage.compareTo(orderLine.getDiscount()) != 0) {
                BigDecimal discountAmount = orderLine.getPriceList().multiply(discountPercentage.divide(Env.ONEHUNDRED));
                priceEntered = orderLine.getPriceList().subtract(discountAmount);
            }
            orderLine.setPrice(priceEntered);
            orderLine.setQty(qtyOrdered);
            orderLine.setTax();
            orderLine.saveEx();
            lineNetAmt = orderLine.getLineNetAmt();
            taxRate = MTax.get((Properties)this.ctx, (int)orderLine.getC_Tax_ID()).getRate();
            taxRate = taxRate == null ? Env.ZERO : taxRate.divide(Env.ONEHUNDRED);
            grandTotal = lineNetAmt.add(lineNetAmt.multiply(taxRate));
        }
        return new BigDecimal[]{lineNetAmt, taxRate, grandTotal};
    }

    public MOrderLine addOrUpdateLine(MProduct product, BigDecimal qtyOrdered, MProductPricing productPricing) {
        MOrderLine[] lines;
        if (!this.isDrafted()) {
            return null;
        }
        for (MOrderLine line : lines = this.currentOrder.getLines(true, "Line")) {
            if (line.getM_Product_ID() != product.getM_Product_ID()) continue;
            this.setOrderLineId(line.getC_OrderLine_ID());
            BigDecimal currentPrice = line.getPriceEntered();
            BigDecimal currentQty = line.getQtyEntered();
            BigDecimal totalQty = currentQty.add(qtyOrdered);
            line.setQty(this.isAddQty() ? totalQty : qtyOrdered);
            line.setPrice(currentPrice);
            line.saveEx();
            return line;
        }
        MOrderLine line = new MOrderLine(this.currentOrder);
        line.setProduct(product);
        line.setQty(qtyOrdered);
        line.setPrice();
        if (productPricing.getPriceStd().signum() > 0) {
            line.setPriceLimit(productPricing.getPriceLimit());
            line.setPrice(productPricing.getPriceStd());
            line.setPriceList(productPricing.getPriceList());
            this.setPriceLimit(productPricing.getPriceLimit());
            this.setPriceList(productPricing.getPriceList());
            BigDecimal percentageDiscount = line.getDiscount();
            this.setDiscountPercentage(percentageDiscount);
        }
        this.setOrderLineId(line.getC_OrderLine_ID());
        line.saveEx();
        return line;
    }

    public String addOrUpdate(int productId, BigDecimal qtyOrdered) {
        String errorMessage = null;
        try {
            MProduct product = MProduct.get((Properties)this.ctx, (int)productId);
            if (product == null) {
                return "@No@ @InfoProduct@";
            }
            MProductPricing productPricing = new MProductPricing(productId, this.getC_BPartner_ID(), qtyOrdered, true, null);
            productPricing.setM_PriceList_ID(this.getM_PriceList_ID());
            productPricing.calculatePrice();
            if (!this.hasOrder()) {
                return "@POS.MustCreateOrder@";
            }
            this.addOrUpdateLine(product, qtyOrdered, productPricing);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private boolean voidOrder() {
        if (!(this.currentOrder.getDocStatus().equals("DR") || this.currentOrder.getDocStatus().equals("IP") || this.currentOrder.getDocStatus().equals("CO"))) {
            return false;
        }
        this.currentOrder.setDocAction("VO");
        if (this.currentOrder.processIt("VO")) {
            this.currentOrder.setDocAction("--");
            this.currentOrder.setDocStatus("VO");
            this.currentOrder.saveEx();
            return true;
        }
        return false;
    }

    public String cancelOrder() {
        String errorMsg = null;
        try {
            int currentIndex = this.orderList.indexOf(this.currentOrder.getC_Order_ID());
            if (!this.hasOrder()) {
                throw new AdempierePOSException("@POS.MustCreateOrder@");
            }
            if (!this.isCompleted()) {
                this.currentOrder.deleteEx(true);
            } else if (this.isCompleted()) {
                this.voidOrder();
            } else {
                throw new AdempierePOSException("@POS.OrderIsNotProcessed@");
            }
            if (currentIndex >= 0) {
                this.orderList.remove(currentIndex);
            }
            this.currentOrder = null;
            if (this.hasRecord()) {
                if (this.isFirstRecord()) {
                    this.firstRecord();
                } else if (this.isLastRecord()) {
                    this.lastRecord();
                } else {
                    this.previousRecord();
                }
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }

    public void deleteLine(int orderLineId) {
        if (orderLineId != -1 && this.currentOrder != null) {
            for (MOrderLine line : this.currentOrder.getLines(true, "M_Product_ID")) {
                if (line.getC_OrderLine_ID() != orderLineId) continue;
                line.deleteEx(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listOrder() {
        block6: {
            String sql = new String("SELECT o.C_Order_ID FROM C_Order o WHERE o.IsSOTrx='Y' AND o.Processed = 'N' AND o.AD_Client_ID = ? AND o.C_POS_ID = ? AND o.SalesRep_ID = ? ORDER BY o.Updated");
            CPreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            this.orderList = new ArrayList();
            try {
                preparedStatement = DB.prepareStatement((String)sql, null);
                preparedStatement.setInt(1, Env.getAD_Client_ID((Properties)Env.getCtx()));
                preparedStatement.setInt(2, this.getC_POS_ID());
                preparedStatement.setInt(3, this.getSalesRep_ID());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.orderList.add(resultSet.getInt(1));
                }
                DB.close((ResultSet)resultSet);
            }
            catch (Exception e) {
                this.log.severe("SubOrder.listOrder: " + e + " -> " + sql);
                break block6;
            }
            finally {
                DB.close(resultSet);
                DB.close((Statement)preparedStatement);
            }
            DB.close((Statement)preparedStatement);
        }
        this.recordPosition = this.hasRecord() ? this.orderList.size() - 1 : -1;
    }

    public boolean hasRecord() {
        return !this.orderList.isEmpty();
    }

    public boolean isFirstRecord() {
        return this.recordPosition == 0;
    }

    public boolean isLastRecord() {
        return this.recordPosition == this.orderList.size() - 1;
    }

    public void previousRecord() {
        if (this.recordPosition > 0) {
            this.setOrder(this.orderList.get(--this.recordPosition));
        }
    }

    public void nextRecord() {
        if (this.recordPosition < this.orderList.size() - 1) {
            this.setOrder(this.orderList.get(++this.recordPosition));
        }
    }

    public void reloadIndex(int orderId) {
        int position = this.orderList.indexOf(orderId);
        if (position >= 0) {
            this.recordPosition = position;
        }
    }

    public void lastRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            --this.recordPosition;
        }
    }

    public void firstRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            this.recordPosition = 0;
        }
    }

    public boolean processOrder(String trxName, boolean isPrepayment, boolean isPaid) {
        boolean orderCompleted = this.isCompleted();
        if (orderCompleted) {
            this.setIsToPrint(false);
        } else {
            if (trxName == null) {
                trxName = this.currentOrder.get_TrxName();
            } else {
                this.currentOrder.set_TrxName(trxName);
            }
            if (this.currentOrder.getDocStatus().equalsIgnoreCase("IN")) {
                this.currentOrder.setDocStatus("IP");
            }
            this.currentOrder.setDocAction("CO");
            if (this.currentOrder.processIt("CO")) {
                this.currentOrder.saveEx();
                orderCompleted = true;
                this.setIsToPrint(true);
            } else {
                this.log.info("Process Order FAILED " + this.currentOrder.getProcessMsg());
                this.currentOrder.saveEx();
                return orderCompleted;
            }
        }
        if (isPaid && !this.isStandardOrder()) {
            if (!this.isDelivered()) {
                this.generateShipment(trxName);
            }
            if (!this.isInvoiced() && ("I".equals(this.currentOrder.getInvoiceRule()) || "D".equals(this.currentOrder.getInvoiceRule()) && this.isDelivered())) {
                this.generateInvoice(trxName);
            }
            orderCompleted = true;
        }
        return orderCompleted;
    }

    private void generateShipment(String trxName) {
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(199)).withTitle(Msg.parseTranslation((Properties)this.getCtx(), (String)"@InOutGenerateGen@")).withParameter("M_Warehouse_ID", (Object)this.getM_Warehouse_ID()).withParameter("Selection", (Object)true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public void completeReturn() {
        Trx.run((TrxRunnable)new TrxRunnable(){

            public void run(String trxName) {
                String error = CPOS.this.completeReturn(trxName);
                if (error != null) {
                    throw new AdempiereException(error);
                }
                if (CPOS.this.isToPrint()) {
                    CPOS.this.printTicket();
                }
            }
        });
    }

    private String completeReturn(String trxName) {
        if (this.isDrafted() || this.isInProgress() || this.isInvalid()) {
            if (!this.processOrder(trxName, false, false)) {
                return Msg.parseTranslation((Properties)this.getCtx(), (String)(" @ProcessRunError@. @order.no@: " + this.getDocumentNo() + ". @Process@: " + CommandManager.COMPLETE_DOCUMENT));
            }
            String docSubTypeSO = this.getDocSubTypeSO();
            if ((docSubTypeSO.equals("SO") || docSubTypeSO.equals("WI") || docSubTypeSO.equals("WP")) && this.isCompleted()) {
                return "@POS.IsNotReturn@";
            }
        }
        MOrder returnOrder = new MOrder(this.getCtx(), this.getC_Order_ID(), trxName);
        returnOrder.setInvoiceRule("I");
        returnOrder.setDeliveryRule("F");
        returnOrder.saveEx();
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(returnOrder.get_ID());
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(199)).withParameter("M_Warehouse_ID", (Object)this.getM_Warehouse_ID()).withParameter("Selection", (Object)true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            return processInfo.getLogInfo();
        }
        for (MInOut customerReturn : returnOrder.getShipments()) {
            customerReturn.processIt("CO");
            customerReturn.saveEx();
            for (MInOutConfirm confirm : customerReturn.getConfirmations(true)) {
                for (MInOutLineConfirm confirmLine : confirm.getLines(true)) {
                    confirmLine.setConfirmedQty(confirmLine.getTargetQty());
                    confirmLine.saveEx();
                }
                confirm.processIt("CO");
                confirm.saveEx();
            }
        }
        MOrder sourceOrder = (MOrder)returnOrder.getRef_Order();
        if (sourceOrder != null && returnOrder.getC_Order_ID() > 0) {
            if (sourceOrder.getInvoices().length > 0) {
                processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(134)).withTitle(processInfo.getTitle()).withParameter("Selection", (Object)true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withParameter("DocAction", (Object)"CO").withoutTransactionClose().execute(trxName);
                if (processInfo.isError()) {
                    return processInfo.getLogInfo();
                }
            } else {
                Timestamp today = new Timestamp(System.currentTimeMillis());
                MPayment payment = new MPayment(returnOrder.getCtx(), 0, returnOrder.get_TrxName());
                payment.setDateTrx(today);
                payment.setC_Order_ID(returnOrder.getC_Order_ID());
                payment.setC_BankAccount_ID(this.getC_BankAccount_ID());
                payment.setDateAcct(today);
                payment.addDescription(Msg.parseTranslation((Properties)returnOrder.getCtx(), (String)(" @C_Order_ID@ " + returnOrder.getDocumentNo())));
                payment.setIsReceipt(false);
                payment.setC_DocType_ID(MDocType.getDocType((String)"APP"));
                payment.setAmount(returnOrder.getC_Currency_ID(), returnOrder.getGrandTotal());
                payment.setDocAction("CO");
                payment.setDocStatus("DR");
                payment.setIsPrepayment(true);
                payment.saveEx();
                payment.processIt("CO");
                payment.saveEx();
                returnOrder.setC_POS_ID(this.getC_POS_ID());
                returnOrder.saveEx();
                processInfo.addLog(0, null, null, payment.getDocumentInfo());
            }
        }
        this.setIsToPrint(true);
        return null;
    }

    private void generateInvoice(String trxName) {
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(134)).withTitle(Msg.parseTranslation((Properties)this.getCtx(), (String)"@InvGenerateGen@")).withParameter("Selection", (Object)true).withParameter("DocAction", (Object)"CO").withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public String getProcessMsg() {
        return this.currentOrder.getProcessMsg();
    }

    public void setC_PaymentTerm_ID(int paymentTermId) {
        if (paymentTermId != 0 && this.hasOrder() && !this.isCompleted() && !this.isVoided()) {
            this.currentOrder.setC_PaymentTerm_ID(paymentTermId);
        }
    }

    public int getC_PaymentTerm_ID() {
        if (this.hasOrder()) {
            return this.currentOrder.getC_PaymentTerm_ID();
        }
        return 0;
    }

    public BigDecimal getTaxAmt() {
        BigDecimal taxAmt = Env.ZERO;
        for (MOrderTax tax : this.currentOrder.getTaxes(true)) {
            taxAmt = taxAmt.add(tax.getTaxAmt());
        }
        return taxAmt;
    }

    public BigDecimal getTotalLines() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getTaxAmt());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getGrandTotal() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal();
        }
        return BigDecimal.ZERO;
    }

    public String getDocumentNo() {
        return this.currentOrder.getDocumentNo();
    }

    public String getDeliveryRule() {
        return this.entityPOS.getDeliveryRule();
    }

    public String getInvoiceRule() {
        return this.entityPOS.getInvoiceRule();
    }

    public BigDecimal getOpenAmt() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getAmountReceived());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAmountReceived() {
        BigDecimal totalPayAmt = Env.ZERO;
        for (MPayment payment : MPayment.getOfOrder((MOrder)this.getOrder())) {
            totalPayAmt = totalPayAmt.add(payment.getPayAmt());
        }
        return totalPayAmt;
    }

    public boolean isPaid() {
        return this.getOpenAmt().signum() == 0;
    }

    public BigDecimal getPaidAmt() {
        BigDecimal receivedInvoices = BigDecimal.ZERO;
        BigDecimal receivedPrePayments = BigDecimal.ZERO;
        BigDecimal receivedCash = BigDecimal.ZERO;
        BigDecimal receivedTotal = BigDecimal.ZERO;
        String payment = "C_Payment";
        String allocation = "C_AllocationHdr";
        String allocationLine = "C_AllocationLine";
        String cashLine = "C_CashLine";
        String orderId = "C_Order_ID";
        String invoiceId = "C_Invoice_ID";
        String allocationId = "C_AllocationHdr_ID";
        String payAmt = "PayAmt";
        String documentStatus = "DocStatus";
        String amount = "Amount";
        if (this.currentOrder != null) {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("C_Order_ID").append("=?").append(" AND ").append("DocStatus").append(" IN ('CO','CL') ");
            receivedPrePayments = new Query(this.getCtx(), "C_Payment", whereClause.toString(), null).setClient_ID().setParameters(new Object[]{this.currentOrder.getC_Order_ID()}).sum("PayAmt");
            if (receivedPrePayments == null) {
                receivedPrePayments = Env.ZERO;
            }
            if (this.currentOrder.getC_Invoice_ID() > 1) {
                whereClause = new StringBuilder();
                whereClause.append("EXISTS (SELECT 1 FROM ").append("C_AllocationHdr").append(" WHERE ").append("C_AllocationHdr").append(".").append("C_AllocationHdr_ID").append("=").append("C_AllocationLine").append(".").append("C_AllocationHdr_ID").append(" AND ").append("C_AllocationHdr").append(".").append("DocStatus").append(" IN ('CO','CL') AND ").append("C_AllocationLine").append(".").append("C_Invoice_ID").append("=?)");
                receivedInvoices = new Query(this.getCtx(), "C_AllocationLine", whereClause.toString(), null).setClient_ID().setParameters(new Object[]{this.currentOrder.getC_Invoice_ID()}).sum("Amount");
                if (receivedInvoices == null) {
                    receivedInvoices = Env.ZERO;
                }
                whereClause = new StringBuilder();
                whereClause.append("C_Invoice_ID").append("=?");
                receivedCash = new Query(this.getCtx(), "C_CashLine", whereClause.toString(), null).setClient_ID().setParameters(new Object[]{this.currentOrder.getC_Invoice_ID()}).sum("Amount");
                if (receivedCash == null) {
                    receivedCash = Env.ZERO;
                }
            }
        }
        receivedTotal = receivedInvoices.add(receivedPrePayments).add(receivedCash);
        return receivedTotal;
    }

    public void reloadOrder() {
        if (this.currentOrder == null) {
            if (this.recordPosition != -1 && this.recordPosition < this.orderList.size()) {
                this.setOrder(this.orderList.get(this.recordPosition));
            }
            return;
        }
        this.currentOrder.load(this.currentOrder.get_TrxName());
        this.currentOrder.getLines(true, "Line");
        this.partner = MBPartner.get((Properties)this.getCtx(), (int)this.currentOrder.getC_BPartner_ID());
    }

    public int getM_PriceList_Version_ID() {
        return this.priceListVersionId;
    }

    public int getM_PriceList_ID() {
        return this.priceListId;
    }

    public MPriceListVersion loadPriceListVersion(int priceListId) {
        this.priceListVersionId = 0;
        this.priceListId = priceListId;
        MPriceList priceList = MPriceList.get((Properties)this.ctx, (int)priceListId, null);
        MPriceListVersion priceListVersion = priceList.getPriceListVersion(this.getToday());
        if (priceListVersion != null && priceListVersion.getM_PriceList_Version_ID() != 0) {
            this.priceListVersionId = priceListVersion.getM_PriceList_Version_ID();
        }
        return priceListVersion;
    }

    public int getM_Warehouse_ID() {
        return this.entityPOS.getM_Warehouse_ID();
    }

    public void validLocator() {
        MLocator[] locators;
        MWarehouse warehouse = MWarehouse.get((Properties)this.ctx, (int)this.getM_Warehouse_ID());
        for (MLocator mLocator : locators = warehouse.getLocators(true)) {
            if (!mLocator.isDefault()) continue;
            return;
        }
        throw new AdempierePOSException("@M_Locator_ID@ @default@ @not.found@ @M_Warehouse_ID@: " + warehouse.getName());
    }

    public String getWarehouseName() {
        if (this.getM_Warehouse_ID() > 0) {
            MWarehouse.get((Properties)this.ctx, (int)this.getM_Warehouse_ID()).getName();
        }
        return "";
    }

    public String getDocumentTypeName() {
        MDocType m_DocType;
        if (this.hasOrder() && (m_DocType = MDocType.get((Properties)this.getCtx(), (int)this.currentOrder.getC_DocTypeTarget_ID())) != null) {
            return m_DocType.getName();
        }
        return "";
    }

    public Timestamp getDateOrdered() {
        if (this.hasOrder()) {
            return this.currentOrder.getDateOrdered();
        }
        return null;
    }

    public String getCurSymbol() {
        MCurrency currency;
        int currencyId = this.getC_Currency_ID();
        if (currencyId > 0 && (currency = MCurrency.get((Properties)this.getCtx(), (int)currencyId)) != null) {
            return currency.getCurSymbol();
        }
        return "";
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            MPaymentProcessor[] paymentProcessors = MPaymentProcessor.find((Properties)Env.getCtx(), null, null, (int)this.currentOrder.getAD_Client_ID(), (int)this.currentOrder.getAD_Org_ID(), (int)this.currentOrder.getC_Currency_ID(), (BigDecimal)amt, (String)this.currentOrder.get_TrxName());
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < paymentProcessors.length; ++i) {
                if (paymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (paymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (paymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (paymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (paymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!paymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + paymentProcessors.length);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ValueNamePair[] getCreditNotes() {
        try {
            String whereClause = "C_BPartner_ID = ? AND IsPaid ='N' AND EXISTS(SELECT 1 \t\t\t\tFROM C_DocType dt \t\t\t\tWHERE dt.C_DocType_ID = C_Invoice.C_DocType_ID \t\t\t\tAND dt.DocBaseType ='ARC')";
            List invoiceList = new Query(Env.getCtx(), "C_Invoice", whereClause, null).setParameters(new Object[]{this.currentOrder.getC_BPartner_ID()}).list();
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (MInvoice invoice : invoiceList) {
                Integer id = invoice.getC_Invoice_ID();
                ValueNamePair valueNamePair = new ValueNamePair(id.toString(), invoice.getDocumentNo() + " " + invoice.getOpenAmt().toString());
                map.put(invoice.getDocumentNo(), valueNamePair);
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public int getOSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getOSK_KeyLayout_ID();
        }
        return 0;
    }

    public int getC_POSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getC_POSKeyLayout_ID();
        }
        return 0;
    }

    public boolean isModifyPrice() {
        return this.entityPOS.isModifyPrice();
    }

    public int getC_Order_ID() {
        int m_C_Order_ID = 0;
        if (this.hasOrder()) {
            m_C_Order_ID = this.currentOrder.getC_Order_ID();
        }
        return m_C_Order_ID;
    }

    public void saveNextSeq(String trxName) {
        int next = this.documentSequence.getCurrentNext() + this.documentSequence.getIncrementNo();
        this.documentSequence.setCurrentNext(next);
        this.documentSequence.saveEx(trxName);
    }

    public String getSequenceDoc(String trxName) {
        this.documentSequence = new MSequence(Env.getCtx(), this.getAD_Sequence_ID(), trxName);
        return this.documentSequence.getPrefix() + this.documentSequence.getCurrentNext();
    }

    public void setPOReference(String documentNo) {
        String trxName = this.currentOrder.get_TrxName();
        Trx trx = Trx.get((String)trxName, (boolean)true);
        this.currentOrder.setPOReference(documentNo);
        this.currentOrder.saveEx(trx.getTrxName());
        trx.close();
    }

    public BigDecimal getQty() {
        return this.quantity;
    }

    public void setQty(BigDecimal qty) {
        this.quantity = qty;
    }

    public BigDecimal getQtyAdded() {
        BigDecimal quantityAddedReturn = this.quantityAdded;
        this.quantityAdded = Env.ZERO;
        this.setAddQty(false);
        return quantityAddedReturn;
    }

    public void setQtyAdded(BigDecimal qtyAdded) {
        this.quantityAdded = qtyAdded;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(BigDecimal discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public void setPriceLimit(BigDecimal priceLimit) {
        this.priceLimit = priceLimit;
    }

    public BigDecimal getPriceLimit() {
        return this.priceLimit;
    }

    public BigDecimal getPriceList() {
        return this.priceList;
    }

    public void setPriceList(BigDecimal priceList) {
        this.priceList = priceList;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setPrice(MProductPricing productPricing) {
        this.setPriceLimit(productPricing.getPriceLimit());
        this.setPrice(productPricing.getPriceStd());
        this.setPriceList(productPricing.getPriceList());
    }

    public String getElectronicScales() {
        if (this.entityPOS != null) {
            return this.entityPOS.getElectronicScales();
        }
        return null;
    }

    public String getMeasureRequestCode() {
        if (this.entityPOS != null) {
            return this.entityPOS.getMeasureRequestCode();
        }
        return null;
    }

    public boolean isPresentElectronicScales() {
        if (this.getElectronicScales() != null) {
            return this.getElectronicScales().length() > 0;
        }
        return false;
    }

    public boolean IsShowLineControl() {
        return true;
    }

    public boolean isVirtualKeyboard() {
        return this.getOSKeyLayout_ID() > 0;
    }

    public int getProductImageId(int productId, int posKeyLayoutId) {
        int imageId = 0;
        if (productId == 0) {
            return imageId;
        }
        int m_C_POSKey_ID = DB.getSQLValue(null, (String)"SELECT pk.C_POSKey_ID FROM C_POSKey pk WHERE pk.C_POSKeyLayout_ID = ? AND pk.M_Product_ID = ? AND pk.IsActive = 'Y'", (int)posKeyLayoutId, (int)productId);
        if (m_C_POSKey_ID > 0) {
            MPOSKey key = new MPOSKey(this.ctx, m_C_POSKey_ID, null);
            imageId = key.getAD_Image_ID();
        } else {
            m_C_POSKey_ID = DB.getSQLValue(null, (String)"SELECT pk2.C_POSKey_ID FROM C_POSKey pk1 INNER JOIN C_POSKey pk2 ON pk1.subkeylayout_id=pk2.c_poskeylayout_id AND pk1.subkeylayout_id IS NOT NULL WHERE pk2.M_Product_ID = ? AND pk1.IsActive = 'Y' AND pk2.IsActive = 'Y'", (int)productId);
            if (m_C_POSKey_ID > 0) {
                MPOSKey key = new MPOSKey(this.ctx, m_C_POSKey_ID, null);
                imageId = key.getAD_Image_ID();
            }
        }
        return imageId;
    }

    public int getM_Product_ID(int orderLineId) {
        return DB.getSQLValue(null, (String)"SELECT ol.M_Product_ID FROM C_OrderLine ol WHERE ol.C_OrderLine_ID = ?", (int)orderLineId);
    }

    public boolean isValidUserPin(char[] userPin) {
        int i;
        if (userPin == null || userPin.length == 0) {
            return false;
        }
        MUser user = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
        Optional<I_AD_User> optionalSuperVisor = Optional.of(user.getSupervisor());
        I_AD_User superVisor = optionalSuperVisor.orElseThrow(() -> new AdempierePOSException("@Supervisor@ @NotFound@"));
        Optional<String> superVisorName = Optional.ofNullable(superVisor.getName());
        if (superVisor.getUserPIN() == null || superVisor.getUserPIN().isEmpty()) {
            throw new AdempierePOSException("@Supervisor@ \"" + superVisorName.orElseGet(() -> "") + "\": @UserPIN@ @NotFound@");
        }
        char[] correctPassword = superVisor.getUserPIN().toCharArray();
        boolean isCorrect = true;
        if (userPin.length != correctPassword.length) {
            isCorrect = false;
        } else {
            for (i = 0; i < userPin.length; ++i) {
                if (userPin[i] == correctPassword[i]) continue;
                isCorrect = false;
            }
        }
        for (i = 0; i < correctPassword.length; ++i) {
            correctPassword[i] = '\u0000';
        }
        return isCorrect;
    }

    public String getProductValue(int productId) {
        return DB.getSQLValueString(null, (String)"SELECT Value FROM M_Product WHERE M_Product_ID = ? ", (int)productId);
    }

    public String getProductName(int productId) {
        return DB.getSQLValueString(null, (String)"SELECT name FROM M_Product WHERE M_Product_ID = ? ", (int)productId);
    }

    public static List<Vector<Object>> getQueryProduct(String productCode, int warehouseId, int priceListId, int partnerId) {
        ArrayList<Vector<Object>> rows = new ArrayList<Vector<Object>>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT ON ( ProductPricing.M_Product_ID , p.Value, p.Name ) ProductPricing.M_Product_ID , p.Value, p.Name,").append("   BomQtyAvailable(ProductPricing.M_Product_ID, ? , 0 ) AS QtyAvailable , PriceStd , PriceList").append(" FROM M_Product p INNER JOIN (").append("\tSELECT pl.M_PriceList_ID , plv.ValidFrom , 0 AS BreakValue , null AS C_BPartner_ID,").append("   p.M_Product_ID,").append("\tbomPriceStd(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceStd,").append("\tbomPriceList(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceList,").append("\tbomPriceLimit(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceLimit").append("\tFROM M_Product p").append("\tINNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID)").append("\tINNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID)").append("\tINNER JOIN M_PriceList pl ON (plv.M_PriceList_ID=pl.M_PriceList_ID)").append("\tWHERE pl.M_PriceList_ID=? AND plv.IsActive='Y' AND pp.IsActive='Y' ").append("\tUNION\t").append("\tSELECT pl.M_PriceList_ID , plv.ValidFrom , pp.BreakValue , pp.C_BPartner_ID,").append("   p.M_Product_ID,").append("   pp.PriceStd, pp.PriceList, pp.PriceLimit").append("\tFROM M_Product p").append("\tINNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID)").append("\tINNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID)").append("\tINNER JOIN M_PriceList pl ON (plv.M_PriceList_ID=pl.M_PriceList_ID)").append("\tWHERE pl.M_PriceList_ID=? AND plv.IsActive='Y' AND pp.IsActive='Y'AND pp.BreakValue IN (0,1)").append("  ORDER BY ValidFrom DESC, BreakValue DESC , C_BPartner_ID ASC").append(") ProductPricing  ON (p.M_Product_ID=ProductPricing.M_Product_ID)").append(" WHERE ProductPricing.M_PriceList_ID=? AND ProductPricing.ValidFrom <= getDate() ");
        if (partnerId > 0) {
            sql.append("AND (ProductPricing.C_BPartner_ID IS NULL OR ProductPricing.C_BPartner_ID =?) ");
        } else {
            sql.append("AND ProductPricing.C_BPartner_ID IS NULL ");
        }
        sql.append("AND p.AD_Client_ID=? AND p.IsSold=? AND p.Discontinued=? ").append("AND ").append("(").append("UPPER(p.Name)  LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.Value) LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.UPC)   LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.SKU)   LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(")");
        CPreparedStatement statement = null;
        try {
            statement = DB.prepareStatement((String)sql.toString(), null);
            int count = 1;
            statement.setInt(count, warehouseId);
            statement.setInt(++count, priceListId);
            statement.setInt(++count, priceListId);
            statement.setInt(++count, priceListId);
            ++count;
            if (partnerId > 0) {
                statement.setInt(count, partnerId);
                ++count;
            }
            statement.setInt(count, Env.getAD_Client_ID((Properties)Env.getCtx()));
            statement.setString(++count, "Y");
            statement.setString(++count, "N");
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Vector<Object> columns = new Vector<Object>();
                Integer productId = resultSet.getInt(1);
                String productValue = resultSet.getString(2).trim();
                String productName = resultSet.getString(3).trim();
                String qtyAvailable = resultSet.getBigDecimal(4) != null ? resultSet.getBigDecimal(4).toString().trim() : "0";
                String priceStd = resultSet.getBigDecimal(5) != null ? resultSet.getBigDecimal(5).setScale(2, RoundingMode.UP).toString().trim() : "0";
                String priceList = resultSet.getBigDecimal(6) != null ? resultSet.getBigDecimal(6).setScale(2, RoundingMode.UP).toString().trim() : "0 ";
                columns.add(productId);
                columns.add(productValue);
                columns.add(productName);
                columns.add(qtyAvailable);
                columns.add(priceStd);
                columns.add(priceList);
                rows.add(columns);
            }
            DB.close((ResultSet)resultSet, (Statement)statement);
            statement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rows;
    }

    public void printTicket() {
        if (!this.hasOrder()) {
            return;
        }
        POSTicketHandler ticketHandler = POSTicketHandler.getTicketHandler(this);
        if (ticketHandler == null) {
            return;
        }
        ticketHandler.printTicket();
    }

    public void setAddQty(boolean isAddQty) {
        this.isAddQty = isAddQty;
    }

    public boolean isAddQty() {
        return this.isAddQty;
    }

    public int getOrderLineId() {
        return this.orderLineId;
    }

    public void setOrderLineId(int orderLineId) {
        this.orderLineId = orderLineId;
    }

    public String getTotaLinesForView() {
        return this.getNumberFormat().format(this.getTotalLines());
    }

    public String getGrandTotalForView() {
        return this.getNumberFormat().format(this.getGrandTotal());
    }

    public String getTaxAmtForView() {
        return this.getNumberFormat().format(this.getGrandTotal().subtract(this.getTotalLines()));
    }

    public String getDateOrderedForView() {
        return this.getDateFormat().format(this.getDateOrdered());
    }

    public String getTicketHandlerClassName() {
        return this.entityPOS.getTicketClassName();
    }

    public String get_TrxName() {
        if (!this.hasOrder()) {
            return null;
        }
        return this.currentOrder.get_TrxName();
    }
}

