/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.services;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.pos.services.CollectDetail;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class Collect {
    private String trxName;
    private MOrder order;
    private MPOS entityPOS;
    private int partnerId;
    private int bankAccountId;
    private Timestamp dateTrx;
    private List<CollectDetail> collectDetails;
    private boolean isCreditOrder = false;
    private int paymentTermId = 0;
    private StringBuffer errorMsg = new StringBuffer();

    public Collect(Properties ctx, MOrder order, int posId) {
        this(ctx, order, MPOS.get((Properties)ctx, (int)posId));
    }

    public Collect(Properties ctx, MOrder order, MPOS entityPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = entityPOS;
        if (order != null) {
            this.order = order;
            this.partnerId = order.getC_BPartner_ID();
            this.bankAccountId = entityPOS.getC_BankAccount_ID();
            this.dateTrx = order.getDateOrdered();
            this.trxName = order.get_TrxName();
        }
    }

    public void load(Properties ctx, MOrder order, MPOS entityPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = entityPOS;
        if (order != null) {
            this.order = order;
            this.partnerId = order.getC_BPartner_ID();
            this.bankAccountId = entityPOS.getC_BankAccount_ID();
            this.dateTrx = order.getDateOrdered();
            this.trxName = order.get_TrxName();
        }
    }

    public void addCollect(CollectDetail detail) {
        this.collectDetails.add(detail);
    }

    public void removeCollect(CollectDetail detail) {
        this.collectDetails.remove(detail);
    }

    public void removeAllCollectDetail() {
        int lenght = this.collectDetails.size();
        for (int i = lenght - 1; i >= 0; --i) {
            this.collectDetails.remove(i);
        }
    }

    public BigDecimal getCollectDetailAmt() {
        BigDecimal payAmt = Env.ZERO;
        for (CollectDetail detail : this.collectDetails) {
            payAmt = payAmt.add(detail.getPayAmt());
        }
        return payAmt;
    }

    protected BigDecimal getBalance(BigDecimal openAmt) {
        BigDecimal totalPayAmt = this.getCollectDetailAmt();
        if (this.order != null) {
            return openAmt.subtract(totalPayAmt);
        }
        return Env.ZERO;
    }

    public void addCash(BigDecimal m_PayAmt) {
        int position = this.findCash();
        CollectDetail collectDetail = null;
        if (position != -1) {
            collectDetail = this.collectDetails.get(position);
            collectDetail.setPayAmt(m_PayAmt);
            this.collectDetails.set(position, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCash(m_PayAmt);
        collectDetail.setDateTrx(this.getDateTrx());
        this.collectDetails.add(collectDetail);
    }

    public void addCheck(BigDecimal payAmt, String checkNo, int bankId, Timestamp dateTrx) {
        int position = this.findCheck(checkNo);
        CollectDetail collectDetail = null;
        if (position != -1) {
            collectDetail = this.collectDetails.get(position);
            collectDetail.setPayAmt(payAmt);
            this.collectDetails.set(position, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCheck(payAmt, checkNo, bankId, dateTrx);
        this.collectDetails.add(collectDetail);
    }

    public int findCheck(String checkNo) {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K") || collectDetail.getReferenceNo() == null || !collectDetail.getReferenceNo().equals(checkNo)) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistCash() {
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            return true;
        }
        return false;
    }

    public boolean isExistOnlyOneCash() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCreditCard() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("C")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCreditCard() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("C")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCheck() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCheck() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("K")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int findCash() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("X")) continue;
            return i;
        }
        return -1;
    }

    public boolean payCash(BigDecimal amount, BigDecimal overUnderAmt) {
        MPayment payment = this.createPayment("X");
        if (payment.isCashTrx() && !MSysConfig.getBooleanValue((String)"CASH_AS_PAYMENT", (boolean)true, (int)payment.getAD_Client_ID())) {
            payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        } else {
            payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        }
        payment.setAmount(this.order.getC_Currency_ID(), amount);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        payment.setOverUnderAmt(overUnderAmt);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment((MPayment)payment);
            return true;
        }
        return false;
    }

    public boolean payCheck(BigDecimal amount, String accountNo, String routingNo, String checkNo) {
        MPayment payment = this.createPayment("K");
        payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        payment.setAmount(this.order.getC_Currency_ID(), amount);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setAccountNo(accountNo);
        payment.setRoutingNo(routingNo);
        payment.setCheckNo(checkNo);
        payment.setDescription(checkNo);
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment((MPayment)payment);
            return true;
        }
        return false;
    }

    public boolean payDirectDebit(BigDecimal amt, String routingNo, String accountCountry, String cVV) {
        MPayment payment = this.createPayment("D");
        payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        payment.setAmount(this.order.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setRoutingNo(routingNo);
        payment.setA_Country(accountCountry);
        payment.setCreditCardVV(cVV);
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment((MPayment)payment);
            return true;
        }
        return false;
    }

    public boolean payCreditCard(BigDecimal amount, String accountName, int month, int year, String cardNo, String cvc, String cardtype) {
        MPayment payment = this.createPayment("C");
        payment.setAmount(this.order.getC_Currency_ID(), amount);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.setCreditCard("S", cardtype, cardNo, cvc, month, year);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment((MPayment)payment);
            return true;
        }
        return false;
    }

    public boolean payCreditMemo(MInvoice creditNote, BigDecimal amount) {
        int invoiceId = this.order.getC_Invoice_ID();
        if (invoiceId == 0) {
            return false;
        }
        MPayment payment = this.createPayment("T");
        if (payment.getC_Invoice_ID() > 0) {
            payment.setC_Invoice_ID(0);
        }
        if (payment.getC_Order_ID() > 0) {
            payment.setC_Order_ID(0);
        }
        if (payment.getC_Charge_ID() > 0) {
            payment.setC_Charge_ID(0);
        }
        payment.setAmount(this.order.getC_Currency_ID(), Env.ZERO);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        MPaymentAllocate paymentAllocate = new MPaymentAllocate(Env.getCtx(), 0, this.trxName);
        paymentAllocate.setC_Payment_ID(payment.getC_Payment_ID());
        paymentAllocate.setC_Invoice_ID(invoiceId);
        paymentAllocate.setInvoiceAmt(amount);
        paymentAllocate.setAmount(amount);
        paymentAllocate.saveEx();
        paymentAllocate = new MPaymentAllocate(Env.getCtx(), 0, this.trxName);
        paymentAllocate.setC_Payment_ID(payment.getC_Payment_ID());
        paymentAllocate.setC_Invoice_ID(creditNote.getC_Invoice_ID());
        paymentAllocate.setAmount(amount.negate());
        paymentAllocate.setInvoiceAmt(amount.negate());
        paymentAllocate.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment((MPayment)payment);
            return true;
        }
        return false;
    }

    private MPayment createPayment(String tenderType) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.trxName);
        payment.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        payment.setC_POS_ID(this.entityPOS.getC_POS_ID());
        payment.setTenderType(tenderType);
        payment.setIsReceipt(true);
        payment.setC_Order_ID(this.order.getC_Order_ID());
        payment.setIsPrepayment(true);
        payment.setC_BPartner_ID(this.getC_BPartner_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        int invoiceId = this.order.getC_Invoice_ID();
        if (invoiceId > 0) {
            payment.setC_Invoice_ID(invoiceId);
            MInvoice invoice = new MInvoice(Env.getCtx(), payment.getC_Invoice_ID(), this.trxName);
            payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Invoice No ") + invoice.getDocumentNo());
        } else {
            payment.setDescription(Msg.getMsg((Properties)Env.getCtx(), (String)"Order No ") + this.order.getDocumentNo());
        }
        this.order.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.order.saveEx(this.trxName);
        return payment;
    }

    private void addErrorMsg(String error) {
        if (error == null || error.length() == 0) {
            return;
        }
        if (this.errorMsg.length() > 0) {
            this.errorMsg.append(Env.NL);
        } else {
            this.errorMsg.append("@ValidationError@").append(Env.NL);
        }
        this.errorMsg.append(error);
    }

    public String getErrorMsg() {
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            return this.errorMsg.toString();
        }
        return null;
    }

    private void cleanErrorMsg() {
        this.errorMsg = new StringBuffer();
    }

    protected String validateTenderTypes(BigDecimal openAmt) {
        BigDecimal returnAmt;
        this.cleanErrorMsg();
        if (openAmt.doubleValue() <= 0.0) {
            this.addErrorMsg("@POS.validatePayment.NoOpenAmt@");
        }
        if (this.isAllowsPartialPayment()) {
            return null;
        }
        if (!this.isCreditOrder() && openAmt.subtract(this.getCollectDetailAmt()).doubleValue() > 0.0) {
            this.addErrorMsg("@POS.OrderPayNotCompleted@");
        }
        BigDecimal cashPayment = Env.ZERO;
        BigDecimal otherPayments = Env.ZERO;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (collectDetail.getPayAmt() == null || !(collectDetail.getPayAmt().doubleValue() > 0.0)) {
                this.addErrorMsg("@POS.validatePayment.ZeroAmount@");
                continue;
            }
            if (collectDetail.getTenderType().equals("X")) {
                cashPayment = cashPayment.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("T")) {
                otherPayments = otherPayments.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("D")) {
                otherPayments = otherPayments.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("K")) {
                otherPayments = otherPayments.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("C")) {
                otherPayments = otherPayments.add(collectDetail.getPayAmt());
                String mmyy = collectDetail.getCreditCardExpMM() + collectDetail.getCreditCardExpYY();
                String processError = MPaymentValidate.validateCreditCardExp((String)mmyy);
                if (processError != null && !processError.isEmpty()) {
                    this.addErrorMsg("@" + processError + "@");
                }
                if ((processError = MPaymentValidate.validateCreditCardNumber((String)collectDetail.getCreditCardNumber(), (String)collectDetail.getCreditCardType())) == null || processError.isEmpty()) continue;
                this.addErrorMsg("@" + processError + "@");
                continue;
            }
            if (collectDetail.getTenderType().equals("M")) {
                if (collectDetail.getC_Invoice_ID() == 0) {
                    this.addErrorMsg("@POS.CreditMemoNotSelected@");
                }
                BigDecimal amtCreditMemo = collectDetail.getOpenAmtCreditMemo();
                if (collectDetail.getPayAmt().compareTo(amtCreditMemo) > 0) {
                    this.addErrorMsg("@POS.OpenAmountCreditMemo@ < @POS.PayAmt@ ");
                    collectDetail.setPayAmt(amtCreditMemo);
                }
                otherPayments = otherPayments.add(collectDetail.getPayAmt());
                continue;
            }
            this.addErrorMsg("@POS.validatePayment.UnsupportedPaymentType@");
        }
        if (otherPayments.subtract(openAmt).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.NonCashPaymentIncorrect@");
        }
        if (otherPayments.subtract(openAmt).signum() == 0 && cashPayment.signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.CashPaymentNotNeeded@");
        }
        if ((returnAmt = cashPayment.add(otherPayments.subtract(openAmt))).subtract(cashPayment).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.ChangeIncorrect@");
        }
        return this.getErrorMsg();
    }

    public void processTenderTypes(String trxName, BigDecimal openAmt) {
        boolean result;
        this.cleanErrorMsg();
        this.trxName = trxName;
        BigDecimal totalPaid = Env.ZERO;
        BigDecimal cashPayment = Env.ZERO;
        BigDecimal otherPayment = Env.ZERO;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (collectDetail.getTenderType().equals("X") || collectDetail.getTenderType().equals("T")) {
                cashPayment = cashPayment.add(collectDetail.getPayAmt());
            } else if (collectDetail.getTenderType().equals("D")) {
                otherPayment = otherPayment.add(collectDetail.getPayAmt());
                result = this.payDirectDebit(collectDetail.getPayAmt(), collectDetail.getRoutingNo(), collectDetail.getA_Country(), collectDetail.getCreditCardVV());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentDirectDebit@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("K")) {
                otherPayment = otherPayment.add(collectDetail.getPayAmt());
                result = this.payCheck(collectDetail.getPayAmt(), null, collectDetail.getRoutingNo(), collectDetail.getReferenceNo());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCheck@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("C")) {
                otherPayment = otherPayment.add(collectDetail.getPayAmt());
                String mmyy = collectDetail.getCreditCardExpMM() + collectDetail.getCreditCardExpYY();
                int month = MPaymentValidate.getCreditCardExpMM((String)mmyy);
                int year = MPaymentValidate.getCreditCardExpYY((String)mmyy);
                result = this.payCreditCard(collectDetail.getPayAmt(), collectDetail.getA_Name(), month, year, collectDetail.getCreditCardNumber(), collectDetail.getCreditCardVV(), collectDetail.getCreditCardType());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditCard@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("M")) {
                if (this.isAllowsPartialPayment()) {
                    this.addErrorMsg("@POS.PrePayment.NoCreditMemoAllowed@");
                    return;
                }
                otherPayment = otherPayment.add(collectDetail.getPayAmt());
                result = this.payCreditMemo(collectDetail.getM_InvCreditMemo(), collectDetail.getPayAmt());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditMEmo@");
                    return;
                }
            }
            totalPaid = totalPaid.add(collectDetail.getPayAmt());
        }
        BigDecimal amountRefunded = openAmt.subtract(otherPayment.add(cashPayment));
        if (amountRefunded.signum() == -1 && cashPayment.doubleValue() > 0.0) {
            if (amountRefunded.abs().doubleValue() > cashPayment.doubleValue()) {
                this.addErrorMsg("@POS.validatePayment.PaymentBustBeExact@");
            } else {
                result = this.payCash(cashPayment.add(amountRefunded), amountRefunded.negate());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCash@");
                    return;
                }
            }
        } else if (cashPayment.signum() > 0 && !(result = this.payCash(cashPayment, amountRefunded.negate()))) {
            this.addErrorMsg("@POS.ErrorPaymentCash@");
            return;
        }
        this.order.saveEx(trxName);
    }

    public BigDecimal getPrePayAmt() {
        String sql = "SELECT Sum(PayAmt) FROM C_Order o\tLEFT JOIN C_Payment p on p.C_order_ID = o.C_order_ID\tWHERE o.C_Order_ID = ?";
        BigDecimal received = DB.getSQLValueBD(null, (String)sql, (int)this.order.getC_Order_ID());
        if (received == null) {
            received = Env.ZERO;
        }
        return received;
    }

    public ValueNamePair[] getCreditCards(BigDecimal amount, int clientId, int orgId, int currencyId, String trxName) {
        try {
            MPaymentProcessor[] paymentProcessors = MPaymentProcessor.find((Properties)Env.getCtx(), null, null, (int)clientId, (int)orgId, (int)currencyId, (BigDecimal)amount, (String)trxName);
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < paymentProcessors.length; ++i) {
                if (paymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (paymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (paymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (paymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (paymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!paymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String creditCardType) {
        return new ValueNamePair(creditCardType, this.getCreditCardName(creditCardType));
    }

    public String getCreditCardName(String creditCardType) {
        if (creditCardType == null) {
            return "--";
        }
        if ("M".equals(creditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(creditCardType)) {
            return "Visa";
        }
        if ("A".equals(creditCardType)) {
            return "Amex";
        }
        if ("C".equals(creditCardType)) {
            return "ATM";
        }
        if ("D".equals(creditCardType)) {
            return "Diners";
        }
        if ("N".equals(creditCardType)) {
            return "Discover";
        }
        if ("P".equals(creditCardType)) {
            return "PurchaseCard";
        }
        return "?" + creditCardType + "?";
    }

    public int getC_BPartner_ID() {
        return this.partnerId;
    }

    public int getC_BankAccount_ID() {
        return this.bankAccountId;
    }

    public Timestamp getDateTrx() {
        return this.dateTrx;
    }

    public void setC_BPartner_ID(int partnerId) {
        this.partnerId = partnerId;
    }

    public void setC_BankAccount_ID(int bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public void setDateTrx(Timestamp dateTrx) {
        this.dateTrx = dateTrx;
    }

    public void setC_PaymentTerm_ID(int paymentTermId) {
        this.paymentTermId = paymentTermId;
    }

    public int getC_PaymentTerm_ID() {
        return this.paymentTermId;
    }

    public boolean isCreditOrder() {
        return this.isCreditOrder;
    }

    public void setIsCreditOrder(boolean isCreditOrder) {
        this.isCreditOrder = isCreditOrder;
    }

    public boolean isAllowsPartialPayment() {
        return this.order != null && "WR".equals(this.order.getC_DocTypeTarget().getDocSubTypeSO()) && "CO".equals(this.order.getDocStatus());
    }

    public int getDetailQty() {
        return this.collectDetails.size();
    }

    public List<CollectDetail> getCollectDetails() {
        return this.collectDetails;
    }
}

