/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.services;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;

public class CollectDetail {
    private String m_TenderType;
    private BigDecimal m_PayAmt;
    private BigDecimal m_InitPayAmt;
    private String m_ReferenceNo;
    private int m_C_Bank_ID;
    private Timestamp m_DateTrx;
    private String m_CreditCardExpMM;
    private String m_CreditCardExpYY;
    private String m_CreditCardNumber;
    private String m_CreditCardType;
    private String m_CreditCardVV;
    private String m_A_Name;
    private String m_A_City;
    private String m_A_State;
    private String m_A_Street;
    private String m_A_Zip;
    private String m_A_Country;
    private String m_A_EMail;
    private String m_A_Ident_DL;
    private String m_A_Ident_SSN;
    private String m_RoutingNo;
    private MInvoice m_CreditMemo;
    private int m_C_Invoice_ID;

    public CollectDetail(String m_TenderType, BigDecimal m_PayAmt, String m_ReferenceNo, int m_C_Bank_ID, Timestamp m_DateTrx, String m_CreditCardExpMM, String m_CreditCardExpYY, String m_CreditCardNumber, String m_CreditCardType, String m_CreditCardVV, String m_A_Name, String m_A_City, String m_A_State, String m_A_Street, String m_A_Zip, String m_A_Country, String m_A_EMail, String m_A_Ident_DL, String m_A_Ident_SSN, String m_RoutingNo) {
        this.m_TenderType = m_TenderType;
        this.m_PayAmt = m_PayAmt;
        this.m_ReferenceNo = m_ReferenceNo;
        this.m_C_Bank_ID = m_C_Bank_ID;
        this.m_DateTrx = m_DateTrx;
        this.m_CreditCardExpMM = m_CreditCardExpMM;
        this.m_CreditCardExpYY = m_CreditCardExpYY;
        this.m_CreditCardNumber = m_CreditCardNumber;
        this.m_CreditCardType = m_CreditCardType;
        this.m_CreditCardVV = m_CreditCardVV;
        this.m_A_Name = m_A_Name;
        this.m_A_City = m_A_City;
        this.m_A_State = m_A_State;
        this.m_A_Street = m_A_Street;
        this.m_A_Zip = m_A_Zip;
        this.m_A_Country = m_A_Country;
        this.m_A_EMail = m_A_EMail;
        this.m_A_Ident_DL = m_A_Ident_DL;
        this.m_A_Ident_SSN = m_A_Ident_SSN;
        this.m_RoutingNo = m_RoutingNo;
    }

    public static CollectDetail createCreditCard(BigDecimal m_PayAmt, String m_CreditCardExpMM, String m_CreditCardExpYY, String m_CreditCardNumber, String m_CreditCardType, String m_CreditCardVV, String m_A_Name, String m_A_City, String m_A_State, String m_A_Street, String m_A_Zip, String m_A_Country, String m_A_EMail, String m_A_Ident_DL, String m_A_Ident_SSN, String m_RoutingNo) {
        return new CollectDetail("C", m_PayAmt, null, 0, null, m_CreditCardExpMM, m_CreditCardExpYY, m_CreditCardNumber, m_CreditCardType, m_CreditCardVV, m_A_Name, m_A_City, m_A_State, m_A_Street, m_A_Zip, m_A_Country, m_A_EMail, m_A_Ident_DL, m_A_Ident_SSN, m_RoutingNo);
    }

    public static CollectDetail createCheck(BigDecimal m_PayAmt, String m_CheckNo, int m_C_Bank_ID, Timestamp m_DateTrx) {
        return new CollectDetail("K", m_PayAmt, m_CheckNo, m_C_Bank_ID, m_DateTrx);
    }

    public static CollectDetail createCash(BigDecimal m_PayAmt) {
        return new CollectDetail("X", m_PayAmt);
    }

    protected CollectDetail(String m_TenderType, BigDecimal m_PayAmt) {
        this.m_TenderType = m_TenderType;
        this.m_PayAmt = m_PayAmt;
        this.setInitPayAmt(m_PayAmt);
        this.m_CreditCardType = "M";
    }

    private CollectDetail(String m_TenderType, BigDecimal m_PayAmt, String m_CheckNo, int m_C_Bank_ID, Timestamp m_DateTrx) {
        this.m_TenderType = m_TenderType;
        this.m_PayAmt = m_PayAmt;
        this.m_ReferenceNo = m_CheckNo;
        this.m_C_Bank_ID = m_C_Bank_ID;
        this.m_DateTrx = m_DateTrx;
    }

    protected ValueNamePair[] getCCMonths() {
        ArrayList<ValueNamePair> m_Months = new ArrayList<ValueNamePair>();
        Locale locale = Language.getLoginLanguage().getLocale();
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i <= 11; ++i) {
            cal.set(1, i, 1);
            String displayName = cal.getDisplayName(2, 1, locale);
            String value = String.format("%02d", i + 1);
            m_Months.add(new ValueNamePair(value, displayName + "-" + value));
        }
        ValueNamePair[] values = new ValueNamePair[m_Months.size()];
        m_Months.toArray(values);
        return values;
    }

    protected ValueNamePair[] getCCYears() {
        ArrayList<ValueNamePair> m_Years = new ArrayList<ValueNamePair>();
        Locale locale = Language.getLoginLanguage().getLocale();
        Calendar cal = Calendar.getInstance(locale);
        for (int i = 0; i < 10; ++i) {
            String year = String.valueOf(cal.get(1));
            String shortYear = year.substring(2);
            m_Years.add(new ValueNamePair(shortYear, year));
            cal.add(1, 1);
        }
        ValueNamePair[] values = new ValueNamePair[m_Years.size()];
        m_Years.toArray(values);
        return values;
    }

    public String getTenderType() {
        return this.m_TenderType;
    }

    public BigDecimal getPayAmt() {
        if (this.m_PayAmt == null) {
            return Env.ZERO;
        }
        return this.m_PayAmt;
    }

    public String getReferenceNo() {
        return this.m_ReferenceNo;
    }

    public int getC_Bank_ID() {
        return this.m_C_Bank_ID;
    }

    public Timestamp getDateTrx() {
        return this.m_DateTrx;
    }

    public String getCreditCardExpMM() {
        return this.m_CreditCardExpMM;
    }

    public String getCreditCardExpYY() {
        return this.m_CreditCardExpYY;
    }

    public String getCreditCardNumber() {
        return this.m_CreditCardNumber;
    }

    public String getCreditCardType() {
        return this.m_CreditCardType;
    }

    public String getCreditCardVV() {
        return this.m_CreditCardVV;
    }

    public String getA_Name() {
        return this.m_A_Name;
    }

    public String getA_City() {
        return this.m_A_City;
    }

    public String getA_State() {
        return this.m_A_State;
    }

    public String getA_Street() {
        return this.m_A_Street;
    }

    public String getA_Zip() {
        return this.m_A_Zip;
    }

    public String getA_Country() {
        return this.m_A_Country;
    }

    public String getA_EMail() {
        return this.m_A_EMail;
    }

    public String getA_Ident_DL() {
        return this.m_A_Ident_DL;
    }

    public String getA_Ident_SSN() {
        return this.m_A_Ident_SSN;
    }

    public String getRoutingNo() {
        return this.m_RoutingNo;
    }

    public void setTenderType(String m_TenderType) {
        this.m_TenderType = m_TenderType;
    }

    public void setPayAmt(BigDecimal m_PayAmt) {
        this.m_PayAmt = m_PayAmt;
    }

    public void setReferenceNo(String m_ReferenceNo) {
        this.m_ReferenceNo = m_ReferenceNo;
    }

    public void setC_Bank_ID(int m_C_Bank_ID) {
        this.m_C_Bank_ID = m_C_Bank_ID;
    }

    public void setDateTrx(Timestamp m_DateTrx) {
        this.m_DateTrx = m_DateTrx;
    }

    public void setCreditCardExpMM(String m_CreditCardExpMM) {
        this.m_CreditCardExpMM = m_CreditCardExpMM;
    }

    public void setCreditCardExpYY(String m_CreditCardExpYY) {
        this.m_CreditCardExpYY = m_CreditCardExpYY;
    }

    public void setCreditCardNumber(String m_CreditCardNumber) {
        this.m_CreditCardNumber = m_CreditCardNumber;
    }

    public void setCreditCardType(String m_CreditCardType) {
        this.m_CreditCardType = m_CreditCardType;
    }

    public void setCreditCardVV(String m_CreditCardVV) {
        this.m_CreditCardVV = m_CreditCardVV;
    }

    public void setA_Name(String m_A_Name) {
        this.m_A_Name = m_A_Name;
    }

    public void setA_City(String m_A_City) {
        this.m_A_City = m_A_City;
    }

    public void setA_State(String m_A_State) {
        this.m_A_State = m_A_State;
    }

    public void setA_Street(String m_A_Street) {
        this.m_A_Street = m_A_Street;
    }

    public void setA_Zip(String m_A_Zip) {
        this.m_A_Zip = m_A_Zip;
    }

    public void setA_Country(String m_A_Country) {
        this.m_A_Country = m_A_Country;
    }

    public void setA_EMail(String m_A_EMail) {
        this.m_A_EMail = m_A_EMail;
    }

    public void setA_Ident_DL(String m_A_Ident_DL) {
        this.m_A_Ident_DL = m_A_Ident_DL;
    }

    public void setA_Ident_SSN(String m_A_Ident_SSN) {
        this.m_A_Ident_SSN = m_A_Ident_SSN;
    }

    public void setRoutingNo(String m_RoutingNo) {
        this.m_RoutingNo = m_RoutingNo;
    }

    public int getC_Invoice_ID() {
        return this.m_C_Invoice_ID;
    }

    public void setC_Invoice_ID(int m_C_Invoice_ID) {
        this.m_C_Invoice_ID = m_C_Invoice_ID;
    }

    public BigDecimal getOpenAmtCreditMemo() {
        BigDecimal m_PayAmt = Env.ZERO;
        if (this.m_C_Invoice_ID == 0) {
            return m_PayAmt;
        }
        this.m_CreditMemo = MInvoice.get((Properties)Env.getCtx(), (int)this.m_C_Invoice_ID);
        MDocType dt = MDocType.get((Properties)this.m_CreditMemo.getCtx(), (int)this.m_CreditMemo.getC_DocType_ID());
        m_PayAmt = this.m_CreditMemo.getOpenAmt();
        if ("API".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType())) {
            m_PayAmt = m_PayAmt.negate();
        }
        if (m_PayAmt.compareTo(this.getPayAmt()) > 0) {
            m_PayAmt = this.getPayAmt();
        }
        return m_PayAmt;
    }

    public BigDecimal getInitPayAmt() {
        return this.m_InitPayAmt;
    }

    public void setInitPayAmt(BigDecimal m_InitPayAmt) {
        this.m_InitPayAmt = m_InitPayAmt;
    }

    protected MLookup getCreditMemoLockup(int p_C_BPartner_ID) {
        MLookup lookup = null;
        int AD_Column_ID = 12349;
        String whereClause = "IsPaid='N' and Processed='Y' and C_BPartner_ID= " + p_C_BPartner_ID + " and exists ( select 1 from C_DocType C_DocType where C_DocType.DocBaseType ='ARC' \tand C_Invoice.C_DocTypeTarget_ID = C_DocType.C_DocType_ID)";
        try {
            lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_Invoice_ID", (int)0, (boolean)false, (String)whereClause);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lookup;
    }

    public MInvoice getM_InvCreditMemo() {
        return this.m_CreditMemo;
    }

    public void setCreditMemo(MInvoice m_CreditMemo) {
        this.m_CreditMemo = m_CreditMemo;
    }

    public String toString() {
        return "CollectType [m_TenderType=" + this.m_TenderType + ", m_PayAmt=" + this.m_PayAmt + ", m_ReferenceNo=" + this.m_ReferenceNo + ", m_C_Bank_ID=" + this.m_C_Bank_ID + ", m_DateTrx=" + this.m_DateTrx + ", m_CreditCardExpMM=" + this.m_CreditCardExpMM + ", m_CreditCardExpYY=" + this.m_CreditCardExpYY + ", m_CreditCardNumber=" + this.m_CreditCardNumber + ", m_CreditCardType=" + this.m_CreditCardType + ", m_CreditCardVV=" + this.m_CreditCardVV + ", m_A_Name=" + this.m_A_Name + ", m_A_City=" + this.m_A_City + ", m_A_State=" + this.m_A_State + ", m_A_Street=" + this.m_A_Street + ", m_A_Zip=" + this.m_A_Zip + ", m_A_Country=" + this.m_A_Country + ", m_A_EMail=" + this.m_A_EMail + ", m_A_Ident_DL=" + this.m_A_Ident_DL + ", m_A_Ident_SSN=" + this.m_A_Ident_SSN + ", m_RoutingNo=" + this.m_RoutingNo + "]";
    }
}

