/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.services;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MImage;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.util.Env;

public class ProductInfo {
    public String value;
    public String name;
    public String description;
    public String uomSymbol;
    public String productCategoryName;
    public String productTaxCategory;
    public BigDecimal priceStd;
    public BigDecimal priceList;
    public BigDecimal priceLimit;
    public byte[] imageData;

    public ProductInfo(int productId, BigDecimal quantity, int imageId, int priceListId, int partnerId) {
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)productId);
        MProductPricing productPricing = new MProductPricing(productId, partnerId, quantity, true, null);
        productPricing.setM_PriceList_ID(priceListId);
        productPricing.calculatePrice();
        this.value = product.getValue();
        this.name = product.getName();
        this.description = product.getDescription();
        this.uomSymbol = product.getC_UOM().getUOMSymbol();
        this.productCategoryName = product.getM_Product_Category().getName();
        this.productTaxCategory = product.getC_TaxCategory().getName();
        this.priceStd = productPricing.getPriceStd();
        this.priceList = productPricing.getPriceList();
        this.priceLimit = productPricing.getPriceLimit();
        MImage image = this.getImage(imageId);
        this.imageData = image != null ? image.getData() : null;
    }

    public MImage getImage(int imageId) {
        if (imageId != 0) {
            MImage image = MImage.get((Properties)Env.getCtx(), (int)imageId);
            return image;
        }
        return null;
    }
}

