/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.services.driver;

import java.math.BigDecimal;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.services.driver.POSScalesDriverInterface;

public class POSScalesDriver
implements POSScalesDriverInterface {
    private String electronicScales;
    private String measureRequestCode;
    private boolean loadLibrary;

    private native boolean openPort(String var1);

    private native String getMeasureMessage();

    public native void closePort();

    @Override
    public void setup() {
        this.loadLibrary = false;
        if (this.getElectronicScales() == null) {
            throw new AdempierePOSException("@NotFound@ @Port@ @ElectronicScales@");
        }
        if (this.getMeasureRequestCode() == null) {
            throw new AdempierePOSException("@NotFound@ @MeasureRequestCode@");
        }
    }

    public POSScalesDriver(String electronicScales, String measureRequestCode) {
        this.setElectronicScales(electronicScales);
        this.setMeasureRequestCode(measureRequestCode);
        this.setup();
    }

    @Override
    public String getElectronicScales() {
        return this.electronicScales;
    }

    @Override
    public void setElectronicScales(String electronicScales) {
        this.electronicScales = electronicScales;
    }

    @Override
    public String getMeasureRequestCode() {
        return this.measureRequestCode;
    }

    @Override
    public void setMeasureRequestCode(String measureRequestCode) {
        this.measureRequestCode = measureRequestCode;
    }

    @Override
    public boolean loadLibrary() {
        if (this.loadLibrary) {
            return this.loadLibrary;
        }
        try {
            System.loadLibrary("scale");
            this.loadLibrary = true;
            return this.loadLibrary;
        }
        catch (UnsatisfiedLinkError exception) {
            return false;
        }
    }

    @Override
    public BigDecimal getMeasure() {
        if (this.loadLibrary()) {
            String[] tokens;
            if (!this.openPort(this.getElectronicScales())) {
                throw new AdempierePOSException("@NotFound@ @Port@ @ElectronicScales@");
            }
            String measure = this.getMeasureMessage().trim();
            if (measure != null && !measure.equals("NEG") && (tokens = measure.split(" ")) != null && tokens.length > 0) {
                try {
                    BigDecimal measureQuantity = new BigDecimal(tokens[0].trim());
                    if (measureQuantity != null && measureQuantity.signum() > 0) {
                        this.closePort();
                        return measureQuantity;
                    }
                    return BigDecimal.ONE;
                }
                catch (Exception e) {
                    throw new AdempierePOSException("@Error@ @From@ @ElectronicScales@ : " + measure);
                }
            }
        }
        return BigDecimal.ONE;
    }
}

