/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.util;

import java.lang.reflect.Constructor;
import org.adempiere.pos.services.CPOS;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public abstract class POSTicketHandler {
    private CPOS pos;
    protected static CLogger log = CLogger.getCLogger(POSTicketHandler.class);
    private static CCache<String, POSTicketHandler> s_cache = new CCache("POSTicketHandler", 40, 5);

    public POSTicketHandler(CPOS pos) {
        this.pos = pos;
    }

    public CPOS getPOS() {
        return this.pos;
    }

    public void setPOS(CPOS pos) {
        this.pos = pos;
    }

    public static POSTicketHandler getTicketHandler(CPOS pos) {
        if (pos == null) {
            log.severe("Not have POS");
            return null;
        }
        String className = pos.getTicketHandlerClassName();
        if (className == null || className.trim().length() == 0) {
            log.fine("Get from GenericTicketHandlerClass");
        }
        POSTicketHandler ticketHandler = null;
        ticketHandler = (POSTicketHandler)s_cache.get((Object)className);
        if (ticketHandler != null) {
            ticketHandler.setPOS(pos);
            return ticketHandler;
        }
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null && superClazz != POSTicketHandler.class; superClazz = superClazz.getSuperclass()) {
            }
            Constructor<?> constructor = null;
            constructor = clazz.getDeclaredConstructor(CPOS.class);
            ticketHandler = (POSTicketHandler)constructor.newInstance(pos);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        if (ticketHandler != null) {
            s_cache.put((Object)className, (Object)ticketHandler);
        }
        return ticketHandler;
    }

    public abstract void printTicket();

    public abstract void openDrawer();

    public abstract void showMessage(String var1);
}

