/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.controller;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_ProjectPhase;
import org.adempiere.core.domains.models.I_C_ProjectTask;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.util.Env;

public class CalloutProject
extends CalloutEngine {
    public String planned(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal PlannedAmt;
        BigDecimal PlannedPrice;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int StdPrecision = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"StdPrecision");
        BigDecimal PlannedQty = (BigDecimal)mTab.getValue("PlannedQty");
        if (PlannedQty == null) {
            PlannedQty = Env.ONE;
        }
        if ((PlannedPrice = (BigDecimal)mTab.getValue("PlannedPrice")) == null) {
            PlannedPrice = Env.ZERO;
        }
        if ((PlannedAmt = PlannedQty.multiply(PlannedPrice)).scale() > StdPrecision) {
            PlannedAmt = PlannedAmt.setScale(StdPrecision, RoundingMode.HALF_UP);
        }
        this.log.fine("PlannedQty=" + PlannedQty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt + " (Precision=" + StdPrecision + ")");
        mTab.setValue("PlannedAmt", (Object)PlannedAmt);
        return "";
    }

    public String projectPhase(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectPhase> projectPhaseOptional = Optional.of((I_C_ProjectPhase)GridTabWrapper.create((Object)gridTab, I_C_ProjectPhase.class));
        projectPhaseOptional.ifPresent(projectPhase -> {
            MProjectTypePhase projectTypePhase = (MProjectTypePhase)projectPhase.getC_Phase();
            if (projectPhase.getC_Phase_ID() > 0) {
                if (projectPhase.getName() == null || projectPhase.getName().isEmpty()) {
                    projectPhase.setName(projectTypePhase.getName());
                }
                if (projectPhase.getDescription() == null || projectPhase.getDescription().isEmpty()) {
                    projectPhase.setDescription(projectTypePhase.getDescription());
                }
                if (projectPhase.getHelp() == null || projectPhase.getHelp().isEmpty()) {
                    projectPhase.setHelp(projectTypePhase.getHelp());
                }
                if (projectPhase.getPriorityRule() == null || projectPhase.getPriorityRule().isEmpty()) {
                    projectPhase.setPriorityRule(projectTypePhase.getPriorityRule());
                }
                projectPhase.setIsMilestone(projectTypePhase.isMilestone());
                if (projectPhase.getDurationUnit() == null || projectPhase.getDurationUnit().isEmpty()) {
                    projectPhase.setDurationUnit(projectTypePhase.getDurationUnit());
                }
                if (projectPhase.getDurationEstimated().signum() == 0) {
                    projectPhase.setDurationEstimated(projectTypePhase.getDurationEstimated());
                }
                if (projectPhase.getM_Product_ID() <= 0) {
                    projectPhase.setM_Product_ID(projectTypePhase.getM_Product_ID());
                }
                if (projectPhase.getPP_Product_BOM_ID() <= 0) {
                    projectPhase.setPP_Product_BOM_ID(projectTypePhase.getPP_Product_BOM_ID());
                }
                if (projectPhase.getAD_Workflow_ID() <= 0) {
                    projectPhase.setAD_Workflow_ID(projectTypePhase.getAD_Workflow_ID());
                }
                if (projectPhase.getQty().signum() == 0) {
                    projectPhase.setQty(projectTypePhase.getStandardQty());
                }
                projectPhase.setIsIndefinite(projectTypePhase.isIndefinite());
                projectPhase.setIsRecurrent(projectTypePhase.isRecurrent());
                projectPhase.setFrequencyType(projectTypePhase.getFrequencyType());
                projectPhase.setFrequency(projectTypePhase.getFrequency());
                projectPhase.setRunsMax(projectTypePhase.getRunsMax());
            }
        });
        return "";
    }

    public String projectTask(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectTask> projectTaskOptional = Optional.of((I_C_ProjectTask)GridTabWrapper.create((Object)gridTab, I_C_ProjectTask.class));
        projectTaskOptional.ifPresent(projectTask -> {
            MProjectTypeTask projectTypeTask = (MProjectTypeTask)projectTask.getC_Task();
            if (projectTask.getC_Task_ID() > 0) {
                if (projectTask.getName() == null || projectTask.getName().isEmpty()) {
                    projectTask.setName(projectTypeTask.getName());
                }
                if (projectTask.getDescription() == null || projectTask.getDescription().isEmpty()) {
                    projectTask.setDescription(projectTypeTask.getDescription());
                }
                if (projectTask.getHelp() == null || projectTask.getHelp().isEmpty()) {
                    projectTask.setHelp(projectTypeTask.getHelp());
                }
                if (projectTask.getPriorityRule() == null || projectTask.getPriorityRule().isEmpty()) {
                    projectTask.setPriorityRule(projectTypeTask.getPriorityRule());
                }
                projectTask.setIsMilestone(projectTypeTask.isMilestone());
                if (projectTask.getDurationUnit() == null || projectTask.getDurationUnit().isEmpty()) {
                    projectTask.setDurationUnit(projectTypeTask.getDurationUnit());
                }
                if (projectTask.getDurationEstimated().signum() == 0) {
                    projectTask.setDurationEstimated(projectTypeTask.getDurationEstimated());
                }
                if (projectTask.getM_Product_ID() <= 0) {
                    projectTask.setM_Product_ID(projectTypeTask.getM_Product_ID());
                }
                if (projectTask.getPP_Product_BOM_ID() <= 0) {
                    projectTask.setPP_Product_BOM_ID(projectTypeTask.getPP_Product_BOM_ID());
                }
                if (projectTask.getAD_Workflow_ID() <= 0) {
                    projectTask.setAD_Workflow_ID(projectTypeTask.getAD_Workflow_ID());
                }
                projectTask.setIsIndefinite(projectTypeTask.isIndefinite());
                projectTask.setIsRecurrent(projectTypeTask.isRecurrent());
                projectTask.setFrequencyType(projectTypeTask.getFrequencyType());
                projectTask.setFrequency(projectTypeTask.getFrequency());
                projectTask.setRunsMax(projectTypeTask.getRunsMax());
            }
        });
        return "";
    }

    public String completeTask(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectTask> projectTaskOptional = Optional.of((I_C_ProjectTask)GridTabWrapper.create((Object)gridTab, I_C_ProjectTask.class));
        projectTaskOptional.ifPresent(projectTask -> {
            if (projectTask.getPercentageCompleted().compareTo(new BigDecimal(100)) == 0 && !projectTask.isComplete()) {
                projectTask.setIsComplete(true);
            }
            if (projectTask.isComplete() && projectTask.getPercentageCompleted().compareTo(new BigDecimal(100)) <= 0) {
                projectTask.setPercentageCompleted(new BigDecimal(100));
            }
        });
        return null;
    }
}

