/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_ProjectPhase;
import org.adempiere.core.domains.models.I_C_ProjectTask;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProductPO;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.project.process.ProjectGenPOAbstract;
import org.compiere.util.Env;

public class ProjectGenPO
extends ProjectGenPOAbstract {
    private ArrayList<MOrder> orders = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.log.info("doIt - C_Project_ID=" + this.getProjectId() + " - C_ProjectLine_ID=" + this.getProjectLineId() + " - Consolidate=" + this.isConsolidateDocument());
        if (this.getProjectId() != 0) {
            MProjectLine projectLine2 = new MProjectLine(this.getCtx(), this.getProjectLineId(), this.get_TrxName());
            MProject project = new MProject(this.getCtx(), projectLine2.getC_Project_ID(), this.get_TrxName());
            this.createPO(project, projectLine2);
        } else {
            MProject project = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
            project.getLines().stream().forEach(projectLine -> this.createPO(project, (MProjectLine)projectLine));
        }
        return "";
    }

    private void createPO(MProject project, MProjectLine projectLine) {
        if (projectLine.getM_Product_ID() == 0) {
            this.addLog(projectLine.getLine(), null, null, "Line has no Product");
            return;
        }
        if (projectLine.getC_OrderPO_ID() != 0) {
            this.addLog(projectLine.getLine(), null, null, "Line was ordered previously");
            return;
        }
        List productPurchaseList = MProductPO.getByPartner((Properties)this.getCtx(), (Integer)this.getVendorId(), (Integer)projectLine.getM_Product_ID(), (String)this.get_TrxName());
        if (this.getVendorId() <= 0 && (productPurchaseList == null || productPurchaseList.size() == 0)) {
            this.addLog(projectLine.getLine(), null, null, "Product has no PO record");
            return;
        }
        MProductPO productPurchase = productPurchaseList.stream().findFirst().orElseGet(() -> new MProductPO(this.getCtx(), projectLine.getM_Product_ID(), this.getVendorId(), project.getC_Currency_ID(), this.get_TrxName()));
        MOrder pruchaseOrder = this.orders.stream().filter(order -> order.getC_BPartner_ID() == productPurchase.getC_BPartner_ID()).findFirst().orElseGet(() -> this.createOrder(project, projectLine, productPurchase.getC_BPartner_ID()));
        this.createOrderLine(pruchaseOrder, projectLine, productPurchase);
    }

    private MOrder createOrder(MProject project, MProjectLine projectLine, Integer partnerId) {
        Optional<I_C_ProjectPhase> optionalProjectPhase = Optional.ofNullable(projectLine.getC_ProjectPhase());
        Optional<I_C_ProjectTask> optionalProjectTask = Optional.ofNullable(projectLine.getC_ProjectTask());
        MBPartner vendor = new MBPartner(this.getCtx(), partnerId.intValue(), this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setClientOrg(projectLine.getAD_Client_ID(), projectLine.getAD_Org_ID());
        order.setIsSOTrx(false);
        order.setDescription(project.getName());
        optionalProjectPhase.ifPresent(projectPhase -> this.setDimension((PO)order, project.getC_Project_ID(), projectPhase.getC_ProjectPhase_ID(), -1, projectPhase.getResponsible_ID(), projectPhase.getC_Activity_ID(), projectPhase.getC_Campaign_ID(), projectPhase.getAD_OrgTrx_ID(), projectPhase.getUser1_ID(), projectPhase.getUser2_ID(), projectPhase.getUser3_ID(), projectPhase.getUser4_ID()));
        optionalProjectTask.ifPresent(projectTask -> this.setDimension((PO)order, project.getC_Project_ID(), projectTask.getC_ProjectPhase_ID(), projectTask.getC_ProjectTask_ID(), projectTask.getResponsible_ID(), projectTask.getC_Activity_ID(), projectTask.getC_Campaign_ID(), projectTask.getAD_OrgTrx_ID(), projectTask.getUser1_ID(), projectTask.getUser2_ID(), projectTask.getUser3_ID(), projectTask.getUser4_ID()));
        order.setPriorityRule(projectLine.getPriorityRule());
        order.setDateOrdered(projectLine.getDateOrdered());
        order.setDatePromised(projectLine.getDatePromised());
        order.setBPartner(vendor);
        if (order.getM_PriceList_ID() <= 0) {
            MPriceList priceList = this.getPriceList(project.getC_Currency_ID());
            order.setM_PriceList_ID(priceList.getM_PriceList_ID());
        }
        order.setAD_User_ID(project.getAD_User_ID());
        order.setM_Warehouse_ID(project.getM_Warehouse_ID());
        order.setC_DocTypeTarget_ID();
        int orgId = projectLine.getAD_Org_ID();
        if (orgId == 0) {
            this.log.warning("createPOfromProjectLine - AD_Org_ID=0");
            orgId = Env.getAD_Org_ID((Properties)this.getCtx());
            if (orgId != 0) {
                projectLine.setAD_Org_ID(orgId);
            }
        }
        order.saveEx();
        if (this.isConsolidateDocument()) {
            this.orders.add(order);
        }
        return order;
    }

    private void setDimension(PO instance, Integer projectId, Integer projectPhaseId, Integer projectTaskId, Integer responsibleId, Integer activityId, Integer campaignId, Integer orgTrxId, Integer user1Id, Integer user2Id, Integer user3Id, Integer user4Id) {
        if (instance.get_ColumnIndex("C_Project_ID") > 0 && projectId > 0) {
            instance.set_ValueOfColumn("C_Project_ID", (Object)projectId);
        }
        if (instance.get_ColumnIndex("C_ProjectPhase_ID") > 0 && projectPhaseId > 0) {
            instance.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
        }
        if (instance.get_ColumnIndex("C_ProjectTask_ID") > 0 && projectTaskId > 0) {
            instance.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
        }
        if (instance.get_ColumnIndex("SalesRep_ID") > 0 && responsibleId > 0) {
            instance.set_ValueOfColumn("SalesRep_ID", (Object)responsibleId);
        }
        if (instance.get_ColumnIndex("C_Activity_ID") > 0 && activityId > 0) {
            instance.set_ValueOfColumn("C_Activity_ID", (Object)activityId);
        }
        if (instance.get_ColumnIndex("C_Campaign_ID") > 0 && campaignId > 0) {
            instance.set_ValueOfColumn("C_Campaign_ID", (Object)campaignId);
        }
        if (instance.get_ColumnIndex("AD_OrgTrx_ID") > 0 && orgTrxId > 0) {
            instance.set_ValueOfColumn("AD_OrgTrx_ID", (Object)orgTrxId);
        }
        if (instance.get_ColumnIndex("User1_ID") > 0 && user1Id > 0) {
            instance.set_ValueOfColumn("User1_ID", (Object)user1Id);
        }
        if (instance.get_ColumnIndex("User2_ID") > 0 && user2Id > 0) {
            instance.set_ValueOfColumn("User2_ID", (Object)user2Id);
        }
        if (instance.get_ColumnIndex("User3_ID") > 0 && user3Id > 0) {
            instance.set_ValueOfColumn("User3_ID", (Object)user3Id);
        }
        if (instance.get_ColumnIndex("User4_ID") > 0 && user4Id > 0) {
            instance.set_ValueOfColumn("User4_ID", (Object)user4Id);
        }
    }

    private MOrderLine createOrderLine(MOrder order, MProjectLine projectLine, MProductPO productPurchase) {
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
        orderLine.setQty(projectLine.getPlannedQty());
        orderLine.setDescription(projectLine.getDescription());
        orderLine.setPrice();
        if (orderLine.getPriceActual().signum() == 0) {
            BigDecimal purchasePrice = productPurchase.getPricePO();
            int currencyId = productPurchase.getC_Currency_ID();
            if (purchasePrice == null || purchasePrice.signum() == 0) {
                purchasePrice = productPurchase.getPriceLastPO();
            }
            if (purchasePrice == null || purchasePrice.signum() == 0) {
                purchasePrice = productPurchase.getPriceList();
            }
            if (purchasePrice != null && purchasePrice.signum() != 0) {
                if (order.getC_Currency_ID() != currencyId) {
                    purchasePrice = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)purchasePrice, (int)currencyId, (int)order.getC_Currency_ID(), (Timestamp)order.getDateAcct(), (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID());
                }
                orderLine.setPrice(purchasePrice);
            }
        }
        orderLine.setTax();
        this.setDimension((PO)orderLine, projectLine.getC_Project_ID(), projectLine.getC_ProjectPhase_ID(), projectLine.getC_ProjectTask_ID(), order.getSalesRep_ID(), order.getC_Activity_ID(), order.getC_Campaign_ID(), order.getAD_OrgTrx_ID(), order.getUser1_ID(), order.getUser2_ID(), order.getUser3_ID(), order.getUser4_ID());
        orderLine.saveEx();
        projectLine.setC_OrderPO_ID(order.getC_Order_ID());
        projectLine.saveEx();
        this.addLog(projectLine.getLine(), null, projectLine.getPlannedQty(), order.getDocumentNo());
        return orderLine;
    }

    private MPriceList getPriceList(Integer currencyId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_Currency_ID").append("=? AND ").append("IsSOPriceList").append("=?");
        MPriceList priceList = (MPriceList)new Query(this.getCtx(), "M_PriceList", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{currencyId, "N"}).setOrderBy("IsDefault").first();
        return priceList;
    }
}

