/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MStorage;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.project.process.ProjectIssueAbstract;
import org.compiere.util.Env;

public class ProjectIssue
extends ProjectIssueAbstract {
    private List<MProjectIssue> projectIssues = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        MProject project = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        if (!"W".equals(project.getProjectCategory()) && !"A".equals(project.getProjectCategory())) {
            throw new IllegalArgumentException("Project not Work Order or Asset =" + project.getProjectCategory());
        }
        this.log.info(project.toString());
        if (this.getInOutId() != 0) {
            return this.issueReceipt(project);
        }
        if (this.getTimeExpenseId() != 0) {
            return this.issueExpense(project);
        }
        if (this.getLocatorId() == 0) {
            throw new IllegalArgumentException("Locator missing");
        }
        if (this.getProjectLineId() != 0) {
            return this.issueProjectLine(project);
        }
        return this.issueInventory(project);
    }

    private String issueReceipt(MProject project) {
        MInOut inOut = new MInOut(this.getCtx(), this.getInOutId(), null);
        if (inOut.isSOTrx() || !inOut.isProcessed() || !"CO".equals(inOut.getDocStatus()) && !"CL".equals(inOut.getDocStatus())) {
            throw new IllegalArgumentException("Receipt not valid - " + inOut);
        }
        this.log.info(inOut.toString());
        if (inOut.getC_Project_ID() == 0) {
            inOut.setC_Project_ID(project.getC_Project_ID());
            inOut.saveEx();
        } else if (inOut.getC_Project_ID() != project.getC_Project_ID()) {
            throw new IllegalArgumentException("Receipt for other Project (" + inOut.getC_Project_ID() + ")");
        }
        MInOutLine[] inOutLines = inOut.getLines(false);
        AtomicInteger counter = new AtomicInteger(0);
        Arrays.stream(inOut.getLines(false)).filter(inOutLine -> inOutLine.getM_Product_ID() != 0 && (inOutLine.getMovementQty() != null || inOutLine.getMovementQty().signum() != 0) && !this.projectIssueHasReceipt(project, inOutLine.getM_InOutLine_ID())).forEach(inOutLine -> {
            MProjectIssue projectIssue = new MProjectIssue(project);
            projectIssue.setMandatory(inOutLine.getM_Locator_ID(), inOutLine.getM_Product_ID(), inOutLine.getMovementQty());
            if (this.getMovementDate() != null) {
                projectIssue.setMovementDate(this.getMovementDate());
            }
            if (this.getDescription() != null && this.getDescription().length() > 0) {
                projectIssue.setDescription(this.getDescription());
            } else if (inOutLine.getDescription() != null) {
                projectIssue.setDescription(inOutLine.getDescription());
            } else if (inOut.getDescription() != null) {
                projectIssue.setDescription(inOut.getDescription());
            }
            projectIssue.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
            projectIssue.process();
            MProjectLine firstProjectLine = project.getLines().stream().filter(projectLine -> projectLine.getC_OrderPO_ID() == inOut.getC_Order_ID() && projectLine.getM_Product_ID() == inOutLine.getM_Product_ID() && projectLine.getC_ProjectIssue_ID() == 0).findFirst().get();
            if (firstProjectLine == null) {
                firstProjectLine = new MProjectLine(project);
            }
            firstProjectLine.setMProjectIssue(projectIssue);
            firstProjectLine.saveEx();
            this.addLog(projectIssue.getLine(), projectIssue.getMovementDate(), projectIssue.getMovementQty(), null);
            counter.getAndUpdate(no -> no + 1);
        });
        return "@Created@ " + counter.get();
    }

    private String issueExpense(MProject project) {
        MTimeExpense expense = new MTimeExpense(this.getCtx(), this.getTimeExpenseId(), this.get_TrxName());
        if (!expense.isProcessed()) {
            throw new IllegalArgumentException("Time+Expense not processed - " + expense);
        }
        MTimeExpenseLine[] expenseLines = expense.getLines(false);
        AtomicInteger counter = new AtomicInteger(0);
        Arrays.stream(expenseLines).filter(expenseLine -> expenseLine.getM_Product_ID() != 0 && (expenseLine.getQty() != null || expenseLine.getQty().signum() != 0) && expenseLine.getC_Project_ID() == project.getC_Project_ID() && !this.projectIssueHasExpense(project, expenseLine.getS_TimeExpenseLine_ID())).forEach(expenseLine -> {
            int locatorId = 0;
            locatorId = MStorage.getM_Locator_ID((int)expense.getM_Warehouse_ID(), (int)expenseLine.getM_Product_ID(), (int)0, (BigDecimal)expenseLine.getQty(), null);
            if (locatorId == 0) {
                locatorId = expense.getM_Locator_ID();
            }
            MProjectIssue projectIssue = new MProjectIssue(project);
            projectIssue.setMandatory(locatorId, expenseLine.getM_Product_ID(), expenseLine.getQty());
            if (this.getMovementDate() != null) {
                projectIssue.setMovementDate(this.getMovementDate());
            }
            if (this.getDescription() != null && this.getDescription().length() > 0) {
                projectIssue.setDescription(this.getDescription());
            } else if (expenseLine.getDescription() != null) {
                projectIssue.setDescription(expenseLine.getDescription());
            }
            projectIssue.setS_TimeExpenseLine_ID(expenseLine.getS_TimeExpenseLine_ID());
            projectIssue.process();
            MProjectLine projectLine = new MProjectLine(project);
            projectLine.setMProjectIssue(projectIssue);
            projectLine.saveEx();
            this.addLog(projectIssue.getLine(), projectIssue.getMovementDate(), projectIssue.getMovementQty(), null);
            counter.getAndUpdate(no -> no + 1);
        });
        return "@Created@ " + counter.get();
    }

    private String issueProjectLine(MProject project) {
        MProjectLine projectLine = new MProjectLine(this.getCtx(), this.getProjectLineId(), this.get_TrxName());
        if (projectLine.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("Projet Line has no Product");
        }
        if (projectLine.getC_ProjectIssue_ID() != 0) {
            throw new IllegalArgumentException("Projet Line already been issued");
        }
        if (this.getLocatorId() == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (projectLine.getPlannedQty() == null || projectLine.getPlannedQty().signum() == 0) {
            projectLine.setPlannedQty(Env.ONE);
        }
        MProjectIssue projectIssue = new MProjectIssue(project);
        projectIssue.setMandatory(this.getLocatorId(), projectLine.getM_Product_ID(), projectLine.getPlannedQty());
        if (this.getMovementDate() != null) {
            projectIssue.setMovementDate(this.getMovementDate());
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            projectIssue.setDescription(this.getDescription());
        } else if (projectLine.getDescription() != null) {
            projectIssue.setDescription(projectLine.getDescription());
        }
        projectIssue.process();
        projectLine.setMProjectIssue(projectIssue);
        projectLine.saveEx();
        this.addLog(projectIssue.getLine(), projectIssue.getMovementDate(), projectIssue.getMovementQty(), null);
        return "@Created@ 1";
    }

    private String issueInventory(MProject project) {
        if (this.getLocatorId() == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (this.getProductId() == 0) {
            throw new IllegalArgumentException("No Product");
        }
        MProjectIssue projectIssue = new MProjectIssue(project);
        projectIssue.setMandatory(this.getLocatorId(), this.getProductId(), this.getMovementQty());
        if (this.getMovementDate() != null) {
            projectIssue.setMovementDate(this.getMovementDate());
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            projectIssue.setDescription(this.getDescription());
        }
        projectIssue.process();
        MProjectLine projectLine = new MProjectLine(project);
        projectLine.setMProjectIssue(projectIssue);
        projectLine.saveEx();
        this.addLog(projectIssue.getLine(), projectIssue.getMovementDate(), projectIssue.getMovementQty(), null);
        return "@Created@ 1";
    }

    private boolean projectIssueHasExpense(MProject project, int timeExpenseLineId) {
        if (this.projectIssues == null) {
            this.projectIssues = project.getIssues();
        }
        if (this.projectIssues.isEmpty()) {
            return false;
        }
        Boolean exists = this.projectIssues.stream().allMatch(projectIssue -> projectIssue.getS_TimeExpenseLine_ID() == timeExpenseLineId);
        return exists != false;
    }

    private boolean projectIssueHasReceipt(MProject project, int inOutLineId) {
        Boolean exists;
        if (this.projectIssues == null) {
            this.projectIssues = project.getIssues();
        }
        return (exists = Boolean.valueOf(this.projectIssues.stream().allMatch(projectIssue -> projectIssue.getM_InOutLine_ID() == inOutLineId))) != false;
    }
}

