/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.util.Properties;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.project.process.ProjectLinePricingAbstract;
import org.compiere.util.Msg;

public class ProjectLinePricing
extends ProjectLinePricingAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("@C_ProjectLine_ID@ @IsMandatory@");
        }
    }

    protected String doIt() throws Exception {
        MProjectLine projectLine = new MProjectLine(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.log.info("doIt - " + projectLine);
        if (projectLine.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("@M_Product_ID@ @NotFound@");
        }
        MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
        if (project.getM_PriceList_ID() == 0) {
            throw new IllegalArgumentException("@M_PriceList_ID@ @NotFound@");
        }
        boolean isSOTrx = true;
        MProductPricing pp = new MProductPricing(projectLine.getM_Product_ID(), project.getC_BPartner_ID(), projectLine.getPlannedQty(), isSOTrx, null);
        pp.setM_PriceList_ID(project.getM_PriceList_ID());
        pp.setPriceDate(project.getDateContract());
        projectLine.setPlannedPrice(pp.getPriceStd());
        projectLine.setPlannedMarginAmt(pp.getPriceStd().subtract(pp.getPriceLimit()));
        projectLine.saveEx();
        String retValue = Msg.getElement((Properties)this.getCtx(), (String)"PriceList") + pp.getPriceList() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"PriceStd") + pp.getPriceStd() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"PriceLimit") + pp.getPriceLimit();
        return retValue;
    }
}

