/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.project.model.validator;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class ProjectModelValidator
implements ModelValidator {
    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return "";
    }

    public String modelChange(PO entity, int type) {
        Integer projectId;
        if (2 == type && (projectId = Integer.valueOf(entity.get_ValueAsInt("C_Project_ID"))) > 0) {
            MProject project = new MProject(entity.getCtx(), projectId.intValue(), entity.get_TrxName());
            if (entity.get_ColumnIndex("C_Campaign_ID") > 0 && entity.get_ValueAsInt("C_Campaign_ID") <= 0 && project.getC_Campaign_ID() > 0) {
                entity.set_ValueOfColumn("C_Campaign_ID", (Object)project.getC_Campaign_ID());
            }
            if (entity.get_ColumnIndex("C_Activity_ID") > 0 && entity.get_ValueAsInt("C_Activity_ID") <= 0 && project.getC_Activity_ID() > 0) {
                entity.set_ValueOfColumn("C_Activity_ID", (Object)project.getC_Activity_ID());
            }
            if (entity.get_ColumnIndex("User1_ID") > 0 && entity.get_ValueAsInt("User1_ID") <= 0 && project.getUser1_ID() > 0) {
                entity.set_ValueOfColumn("User1_ID", (Object)project.getUser1_ID());
            }
            if (entity.get_ColumnIndex("User2_ID") > 0 && entity.get_ValueAsInt("User2_ID") <= 0 && project.getUser2_ID() > 0) {
                entity.set_ValueOfColumn("User2_ID", (Object)project.getUser2_ID());
            }
            if (entity.get_ColumnIndex("User3_ID") > 0 && entity.get_ValueAsInt("User3_ID") <= 0 && project.getUser3_ID() > 0) {
                entity.set_ValueOfColumn("User3_ID", (Object)project.getUser3_ID());
            }
            if (entity.get_ColumnIndex("User4_ID") > 0 && entity.get_ValueAsInt("User4_ID") <= 0 && project.getUser4_ID() > 0) {
                entity.set_ValueOfColumn("User4_ID", (Object)project.getUser4_ID());
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (MPayment.Table_ID == entity.get_Table_ID() && entity.get_ValueAsInt("C_Project_ID") > 0) {
            MPayment payment = (MPayment)entity;
            MProject project = (MProject)payment.getC_Project();
            BigDecimal paymentAmount = payment.getPayAmt();
            if (payment.getC_Currency_ID() != project.getC_Currency_ID()) {
                paymentAmount = MConversionRate.convert((Properties)entity.getCtx(), (BigDecimal)paymentAmount, (int)project.getC_Currency_ID(), (int)payment.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)this.getAD_Client_ID(), (int)payment.getAD_Org_ID());
            }
            if (9 == timing && payment.getReversal_ID() <= 0) {
                if (payment.isReceipt()) {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().add(paymentAmount));
                } else {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().subtract(paymentAmount));
                }
                project.saveEx();
            }
            if (payment.getReversal_ID() > 0 && (13 == timing || 14 == timing)) {
                if (payment.isReceipt()) {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().subtract(paymentAmount));
                } else {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().add(paymentAmount));
                }
                project.saveEx();
            }
        }
        return null;
    }
}

