/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_PaymentMethod;
import org.compiere.model.MStore;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MCPaymentMethod
extends X_C_PaymentMethod {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MCPaymentMethod> paymentMethodCacheIds = new CCache("C_PaymentMethod", 30);
    private static CCache<String, MCPaymentMethod> paymentMethodGroupCodes = new CCache("C_PaymentMethod", 30);

    public MCPaymentMethod(Properties ctx, int terminalId, String trxName) {
        super(ctx, terminalId, trxName);
    }

    public MCPaymentMethod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MCPaymentMethod getById(Properties ctx, int terminalId, String trxName) {
        if (terminalId <= 0) {
            return null;
        }
        MCPaymentMethod paymentMethod = (MCPaymentMethod)((Object)paymentMethodCacheIds.get((Object)terminalId));
        if (paymentMethod != null && paymentMethod.get_ID() > 0) {
            return paymentMethod;
        }
        paymentMethod = (MCPaymentMethod)new Query(ctx, "C_PaymentMethod", "C_PaymentMethod_ID=?", trxName).setParameters(new Object[]{terminalId}).first();
        if (paymentMethod != null && paymentMethod.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + paymentMethod.getValue();
            paymentMethodGroupCodes.put((Object)key, (Object)paymentMethod);
            paymentMethodCacheIds.put((Object)paymentMethod.get_ID(), (Object)paymentMethod);
        }
        return paymentMethod;
    }

    public static MCPaymentMethod getByValue(Properties ctx, String value, String trxName) {
        String key;
        MCPaymentMethod paymentMethod;
        if (value == null) {
            return null;
        }
        if (paymentMethodGroupCodes.size() == 0) {
            MCPaymentMethod.getAll(ctx, true, trxName);
        }
        if ((paymentMethod = (MCPaymentMethod)((Object)paymentMethodGroupCodes.get((Object)(key = value)))) != null && paymentMethod.get_ID() > 0) {
            return paymentMethod;
        }
        paymentMethod = (MCPaymentMethod)new Query(ctx, "C_PaymentMethod", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (paymentMethod != null && paymentMethod.get_ID() > 0) {
            paymentMethodGroupCodes.put((Object)key, (Object)paymentMethod);
            paymentMethodCacheIds.put((Object)paymentMethod.get_ID(), (Object)paymentMethod);
        }
        return paymentMethod;
    }

    public static List<MCPaymentMethod> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || paymentMethodCacheIds.size() > 0) {
            List productGroupList = new Query(Env.getCtx(), "C_PaymentMethod", null, trxName).setClient_ID().setOrderBy("Name").list();
            productGroupList.stream().forEach(paymentMethod -> {
                String key = paymentMethod.getValue();
                paymentMethodCacheIds.put((Object)paymentMethod.getC_PaymentMethod_ID(), (Object)paymentMethod);
                paymentMethodGroupCodes.put((Object)key, (Object)paymentMethod);
            });
            return productGroupList;
        }
        List<MCPaymentMethod> productGroupList = paymentMethodCacheIds.entrySet().stream().map(applicationType -> (MCPaymentMethod)((Object)((Object)applicationType.getValue()))).collect(Collectors.toList());
        return productGroupList;
    }

    public static List<MCPaymentMethod> getOfStore(Properties ctx, int storeId, String trxName) {
        return new Query(Env.getCtx(), "C_PaymentMethod", "EXISTS(SELECT 1 FROM C_PaymentMethodAllocation a WHERE a.C_PaymentMethod_ID = C_PaymentMethod.C_PaymentMethod_ID AND a.W_Store_ID = ?)", trxName).setParameters(new Object[]{storeId}).setClient_ID().list();
    }

    public List<MStore> getStoresList() {
        return new Query(Env.getCtx(), "M_Product", "EXISTS(SELECT 1 FROM C_PaymentMethodAllocation a WHERE a.W_Store_ID = W_Store.W_Store_ID AND a.W_ProductCategory_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getC_PaymentMethod_ID()}).setClient_ID().list();
    }

    public String toString() {
        return "MWPaymentMethod [getName()=" + this.getName() + ", getValue()=" + this.getValue() + ", getC_PaymentMethod_ID()=" + this.getC_PaymentMethod_ID() + "]";
    }
}

