/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.model.validator;

import java.util.Properties;
import org.adempiere.core.domains.models.X_W_Basket;
import org.adempiere.core.domains.models.X_W_BasketLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.store.model.MWCategory;
import org.spin.store.util.ElasticSearchHelper;
import org.spin.store.util.VueStoreFrontUtil;
import org.spin.store.util.support.elasticsearch.Attribute;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.Product;
import org.spin.store.util.support.elasticsearch.TaxCategory;

public class VueStoreFront
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(VueStoreFront.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Product", (ModelValidator)this);
        engine.addModelChange("W_Category", (ModelValidator)this);
        engine.addModelChange("C_TaxCategory", (ModelValidator)this);
        engine.addModelChange("C_Tax", (ModelValidator)this);
        engine.addModelChange("M_Attribute", (ModelValidator)this);
        engine.addModelChange("M_AttributeValue", (ModelValidator)this);
        engine.addModelChange("AD_Attachment", (ModelValidator)this);
        engine.addModelChange("AD_User", (ModelValidator)this);
        engine.addModelChange("W_Basket", (ModelValidator)this);
        engine.addModelChange("W_BasketLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1) {
            MUser user;
            if (po.get_TableName().equals("W_BasketLine")) {
                X_W_BasketLine basketLine = (X_W_BasketLine)po;
                VueStoreFrontUtil.setBasketLineDefaultValues(basketLine);
            } else if (po instanceof MUser && (user = (MUser)po).isWebstoreUser()) {
                MStore defaultStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID((Properties)Env.getCtx()));
                if (defaultStore == null) {
                    throw new AdempiereException("@W_Store_ID@ @NotFound@");
                }
                MBPartner customer = VueStoreFrontUtil.getTemplate(user.getCtx(), defaultStore.get_ValueAsInt("C_TemplateBPartner_ID"), user.get_TrxName());
                customer.setValue(user.getEMail());
                customer.setTaxID(user.getEMail());
                customer.setName(user.getName());
                customer.saveEx();
                user.setC_BPartner_ID(customer.getC_BPartner_ID());
            }
        } else if (type == 2) {
            X_W_BasketLine basketLine;
            if (po.get_TableName().equals("W_BasketLine") && ((basketLine = (X_W_BasketLine)po).is_ValueChanged("Qty") || basketLine.is_ValueChanged("Price"))) {
                VueStoreFrontUtil.setBasketLineDefaultValues(basketLine);
            }
        } else if (type != 3) {
            if (type == 4) {
                MUser user;
                if (po instanceof MProduct) {
                    MProduct product = (MProduct)po;
                    if (product.is_ValueChanged("IsWebStoreFeatured") && !product.isWebStoreFeatured()) {
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(product)).close();
                    } else {
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(product)).close();
                    }
                } else if (po instanceof MWCategory) {
                    MWCategory group = (MWCategory)po;
                    ElasticSearchHelper.getInstance().connect().index(Category.newInstance().withCategoy(group)).close();
                } else if (po instanceof MTaxCategory) {
                    MTaxCategory taxCategory = (MTaxCategory)po;
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MTax) {
                    MTax tax = (MTax)po;
                    MTaxCategory taxCategory = (MTaxCategory)tax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MAttribute) {
                    MAttribute attribute = (MAttribute)po;
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttributeValue) {
                    MAttributeValue attributeValue = (MAttributeValue)po;
                    MAttribute attribute = (MAttribute)attributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttachment) {
                    MAttachment attachment = (MAttachment)po;
                    if (attachment.getAD_Table_ID() == MProduct.Table_ID) {
                        MProduct product = MProduct.get((Properties)attachment.getCtx(), (int)attachment.getRecord_ID());
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(product)).close();
                    }
                } else if (po instanceof MUser && (user = (MUser)po).isWebstoreUser()) {
                    MStore defaultStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID((Properties)Env.getCtx()));
                    if (defaultStore == null) {
                        throw new AdempiereException("@W_Store_ID@ @NotFound@");
                    }
                    int defaultRoleId = defaultStore.get_ValueAsInt("CustomerRole_ID");
                    if (defaultRoleId <= 0) {
                        throw new AdempiereException("@CustomerRole_ID@ @NotFound@");
                    }
                    new MUserRoles(user.getCtx(), user.getAD_User_ID(), defaultRoleId, user.get_TrxName()).saveEx();
                    MBPartner customer = VueStoreFrontUtil.getTemplate(user.getCtx(), defaultStore.get_ValueAsInt("C_TemplateBPartner_ID"), user.get_TrxName());
                    customer.setValue(user.getEMail());
                    customer.setTaxID(user.getEMail());
                    customer.setName(user.getName());
                    customer.saveEx();
                }
            } else if (type == 5) {
                MAttachment attachment;
                if (po instanceof MProduct) {
                    MProduct product = (MProduct)po;
                    ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(product)).close();
                } else if (po instanceof MWCategory) {
                    MWCategory group = (MWCategory)po;
                    ElasticSearchHelper.getInstance().connect().index(Category.newInstance().withCategoy(group)).close();
                } else if (po instanceof MTaxCategory) {
                    MTaxCategory taxCategory = (MTaxCategory)po;
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MTax) {
                    MTax tax = (MTax)po;
                    MTaxCategory taxCategory = (MTaxCategory)tax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MAttribute) {
                    MAttribute attribute = (MAttribute)po;
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttributeValue) {
                    MAttributeValue attributeValue = (MAttributeValue)po;
                    MAttribute attribute = (MAttribute)attributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttachment && (attachment = (MAttachment)po).getAD_Table_ID() == MProduct.Table_ID) {
                    MProduct product = MProduct.get((Properties)attachment.getCtx(), (int)attachment.getRecord_ID());
                    ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(product)).close();
                }
            } else if (type == 6) {
                if (po instanceof MProduct) {
                    MProduct product = (MProduct)po;
                    ElasticSearchHelper.getInstance().connect().delete(Product.newInstance().withProduct(product)).close();
                } else if (po instanceof MWCategory) {
                    MWCategory group = (MWCategory)po;
                    ElasticSearchHelper.getInstance().connect().delete(Category.newInstance().withCategoy(group)).close();
                } else if (po instanceof MTaxCategory) {
                    MTaxCategory taxCategory = (MTaxCategory)po;
                    ElasticSearchHelper.getInstance().connect().delete(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MTax) {
                    MTax tax = (MTax)po;
                    MTaxCategory taxCategory = (MTaxCategory)tax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().delete(TaxCategory.newInstance().withTaxCategory(taxCategory)).close();
                } else if (po instanceof MAttribute) {
                    MAttribute attribute = (MAttribute)po;
                    ElasticSearchHelper.getInstance().connect().delete(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttributeValue) {
                    MAttributeValue attributeValue = (MAttributeValue)po;
                    MAttribute attribute = (MAttribute)attributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().delete(Attribute.newInstance().withAttribute(attribute)).close();
                } else if (po instanceof MAttachment) {
                    MAttachment attachment = (MAttachment)po;
                    if (attachment.getAD_Table_ID() == MProduct.Table_ID) {
                        MProduct product = MProduct.get((Properties)attachment.getCtx(), (int)attachment.getRecord_ID());
                        ElasticSearchHelper.getInstance().connect().delete(Product.newInstance().withProduct(product)).close();
                    }
                } else if (po.get_TableName().equals("W_Basket")) {
                    X_W_Basket basket = (X_W_Basket)po;
                    VueStoreFrontUtil.deletePackageFromBasket(basket.getCtx(), basket.getW_Basket_ID(), basket.get_TrxName());
                } else if (po.get_TableName().equals("W_BasketLine")) {
                    X_W_BasketLine basketLine = (X_W_BasketLine)po;
                    VueStoreFrontUtil.deletePackageLineFromBasketLine(basketLine.getCtx(), basketLine.getW_BasketLine_ID(), basketLine.get_TrxName());
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

