/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.store.support.IExternalCache;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class ElasticSearchHelper {
    private static Map<Integer, ElasticSearchHelper> instances;
    private MStore webStore;
    private boolean isValid = false;
    private IExternalCache externalCache;

    public static ElasticSearchHelper getInstance(MStore webStore) {
        int storeId = 0;
        if (webStore != null) {
            storeId = webStore.getW_Store_ID();
        }
        if (instances == null) {
            instances = new HashMap<Integer, ElasticSearchHelper>();
            instances.put(storeId, new ElasticSearchHelper(webStore));
        }
        return instances.get(storeId);
    }

    public static ElasticSearchHelper getInstance() {
        List<MStore> stores = Arrays.asList(MStore.getOfClient((MClient)MClient.get((Properties)Env.getCtx())));
        AtomicReference store = new AtomicReference();
        if (stores != null && stores.size() > 0) {
            stores.forEach(storeToInstance -> {
                if (store.get() == null) {
                    store.set(storeToInstance);
                }
            });
        }
        return ElasticSearchHelper.getInstance((MStore)store.get());
    }

    private ElasticSearchHelper(MStore webStore) {
        this.webStore = webStore;
    }

    private boolean isValid() {
        boolean bl = this.isValid = this.webStore != null;
        if (!this.isValid) {
            return false;
        }
        try {
            this.isValid = this.externalCache != null;
            int elasticSearchConnectionId = this.webStore.get_ValueAsInt("CacheServerProvider_ID");
            if (this.isValid && this.externalCache.getCacheId() == elasticSearchConnectionId) {
                return true;
            }
            if (elasticSearchConnectionId == 0) {
                throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
            }
            IAppSupport supportedApi = AppSupportHandler.getInstance().getAppSupport(MADAppRegistration.getById((Properties)Env.getCtx(), (int)elasticSearchConnectionId, null));
            if (supportedApi == null) {
                throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
            }
            if (!IExternalCache.class.isAssignableFrom(supportedApi.getClass())) {
                throw new AdempiereException("@CacheServerProvider_ID@ @Invalid@");
            }
            this.externalCache = (IExternalCache)supportedApi;
            this.externalCache.withWebStore(this.webStore);
            this.isValid = true;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this.isValid;
    }

    public final MStore getWebStore() {
        return this.webStore;
    }

    public final ElasticSearchHelper withWebStore(MStore webStore) {
        this.webStore = webStore;
        return this;
    }

    public final ElasticSearchHelper withWebStoreId(int webStoreId) {
        if (webStoreId <= 0) {
            return this;
        }
        this.webStore = MStore.get((Properties)Env.getCtx(), (int)webStoreId);
        return this;
    }

    public final ElasticSearchHelper withWebContext(String webContext) {
        if (Util.isEmpty((String)webContext)) {
            return this;
        }
        this.webStore = MStore.get((Properties)Env.getCtx(), (String)webContext);
        return this;
    }

    public ElasticSearchHelper index(IPersistenceWrapper entity) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.index(entity.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper update(IPersistenceWrapper entity) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.update(entity.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper delete(IPersistenceWrapper entity) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.delete(entity.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this;
    }

    public boolean exist(IPersistenceWrapper entity) {
        if (!this.isValid()) {
            return false;
        }
        try {
            return this.externalCache.exist(entity.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    public ElasticSearchHelper connect() {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.connect();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper close() {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.close();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        return this;
    }
}

