/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.compiere.util.CLogger;
import org.spin.store.model.MWCategory;
import org.spin.store.util.support.elasticsearch.ElasticSearch;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;

public class Category
implements IPersistenceWrapper {
    Map<String, Object> map = new HashMap<String, Object>();
    private MWCategory category;
    private List<Integer> parents;
    private static CLogger log = CLogger.getCLogger(Category.class);

    public static Category newInstance() {
        return new Category();
    }

    public Category withCategoy(MWCategory category) {
        this.category = category;
        return this;
    }

    private Category() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        if (Optional.ofNullable(this.category).isPresent()) {
            this.map.put("id", this.category.get_ID());
            this.map.put("name", this.category.getName());
            this.map.put("url_key", this.getURLKey(this.category, true));
            this.map.put("slug", this.getURLKey(this.category, true));
            this.map.put("path", this.getPath());
            this.map.put("url_path", this.getURLPath());
            this.map.put("position", this.getLevel());
            Map<String, Object> child = this.getChild(this.category);
            int childrenCount = 0;
            if (child.containsKey("children_data")) {
                List children = (List)child.get("children_data");
                this.map.put("children_data", child.get("children_data"));
                childrenCount = children.size();
            }
            this.map.put("children_count", childrenCount);
            if (this.category.getW_Category_Parent_ID() != 0) {
                this.map.put("parent_id", this.category.getW_Category_Parent_ID());
            }
            this.map.put("level", this.getLevel());
            this.map.put("product_count", this.category.getProductCount());
            this.map.put("is_active", this.category.isActive() && this.category.isWebStoreFeatured());
            this.map.put("created_at", ElasticSearch.convertedDate(this.category.getCreated().getTime()));
            this.map.put("updated_at", ElasticSearch.convertedDate(this.category.getUpdated().getTime()));
        }
        return this.map;
    }

    private void loadParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<Integer>();
            this.parents.add(this.category.getW_Category_ID());
            this.loadParents(this.category);
            Collections.reverse(this.parents);
        }
    }

    private void loadParents(MWCategory child) {
        MWCategory parent;
        if (child.getW_Category_Parent_ID() != 0 && (parent = (MWCategory)child.getW_Category_Parent()) != null) {
            if (!this.parents.contains(parent.getW_Category_ID())) {
                this.parents.add(parent.getW_Category_ID());
                this.loadParents(parent);
            } else {
                log.warning("Possible recursive call: " + child.getValue() + " - " + child.getName());
            }
        }
    }

    public String getURLKey(boolean withId) {
        return this.getURLKey(this.category, withId);
    }

    private String getURLKey(MWCategory category, boolean withId) {
        Object value = this.getValidValue(category.getName());
        if (withId) {
            value = (String)value + "-" + String.valueOf(category.getW_Category_ID());
        }
        return value;
    }

    private String getValidValue(String value) {
        return value.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    public int getLevel() {
        this.loadParents();
        int level = this.parents.size() + 2;
        if (this.category.getW_Category_Parent_ID() == 0) {
            level = 2;
        }
        return level;
    }

    public String getURLPath() {
        this.loadParents();
        StringBuffer urlPath = new StringBuffer();
        this.parents.forEach(categoryId -> {
            MWCategory categoryForUrl = MWCategory.getById(this.category.getCtx(), categoryId, this.category.get_TrxName());
            if (urlPath.length() > 0) {
                urlPath.append("/");
            }
            urlPath.append(this.getURLKey(categoryForUrl, categoryId.intValue() == this.category.getW_Category_ID()));
        });
        return urlPath.toString();
    }

    public String getPath() {
        this.loadParents();
        StringBuffer path = new StringBuffer();
        this.parents.forEach(categoryId -> {
            MWCategory categoryForPath = MWCategory.getById(this.category.getCtx(), categoryId, this.category.get_TrxName());
            if (path.length() > 0) {
                path.append("/");
            }
            path.append(categoryForPath.getW_Category_ID());
        });
        return path.toString();
    }

    private Map<String, Object> getChild(MWCategory category) {
        HashMap<String, Object> mapOfChild = new HashMap<String, Object>();
        ArrayList currentChildList = new ArrayList();
        category.getChildList().forEach(child -> {
            Map<String, Object> childMap = Category.newInstance().withCategoy((MWCategory)((Object)child)).getMap();
            currentChildList.add(childMap);
        });
        mapOfChild.put("children_data", currentChildList);
        return mapOfChild;
    }

    @Override
    public String getKeyValue() {
        if (this.category == null) {
            return "";
        }
        return String.valueOf(this.category.get_ID());
    }

    @Override
    public String getCatalogName() {
        return "category";
    }

    @Override
    public boolean isValid() {
        return this.category != null;
    }

    @Override
    public IPersistenceWrapper withWebStoreId(int webStoreId) {
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        HashMap<String, String> createdAt = new HashMap<String, String>();
        createdAt.put("type", "date");
        createdAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap<String, String> updatedAt = new HashMap<String, String>();
        updatedAt.put("type", "date");
        updatedAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap properties = new HashMap();
        properties.put("created_at", createdAt);
        properties.put("updated_at", updatedAt);
        HashMap<String, String> slug = new HashMap<String, String>();
        slug.put("type", "keyword");
        properties.put("slug", slug);
        HashMap<String, String> urlPath = new HashMap<String, String>();
        urlPath.put("type", "keyword");
        properties.put("url_path", urlPath);
        HashMap<String, String> urlKey = new HashMap<String, String>();
        urlKey.put("type", "keyword");
        properties.put("url_key", urlKey);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("properties", properties);
        return mapping;
    }
}

