/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_W_Category;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MWCategory
extends X_W_Category {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MWCategory> productGroupCacheIds = new CCache("W_Category", 30);
    private static CCache<String, MWCategory> productGroupCodes = new CCache("W_Category", 30);

    public MWCategory(Properties ctx, int terminalId, String trxName) {
        super(ctx, terminalId, trxName);
    }

    public MWCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MWCategory getById(Properties ctx, int terminalId, String trxName) {
        if (terminalId <= 0) {
            return null;
        }
        MWCategory productGroup = (MWCategory)((Object)productGroupCacheIds.get((Object)terminalId));
        if (productGroup != null && productGroup.get_ID() > 0) {
            return productGroup;
        }
        productGroup = (MWCategory)new Query(ctx, "W_Category", "W_Category_ID=?", trxName).setParameters(new Object[]{terminalId}).first();
        if (productGroup != null && productGroup.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + productGroup.getValue();
            productGroupCodes.put((Object)key, (Object)productGroup);
            productGroupCacheIds.put((Object)productGroup.get_ID(), (Object)productGroup);
        }
        return productGroup;
    }

    public static MWCategory getByValue(Properties ctx, String value, String trxName) {
        String key;
        MWCategory productGroup;
        if (value == null) {
            return null;
        }
        if (productGroupCodes.size() == 0) {
            MWCategory.getAll(ctx, true, trxName);
        }
        if ((productGroup = (MWCategory)((Object)productGroupCodes.get((Object)(key = value)))) != null && productGroup.get_ID() > 0) {
            return productGroup;
        }
        productGroup = (MWCategory)new Query(ctx, "W_Category", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (productGroup != null && productGroup.get_ID() > 0) {
            productGroupCodes.put((Object)key, (Object)productGroup);
            productGroupCacheIds.put((Object)productGroup.get_ID(), (Object)productGroup);
        }
        return productGroup;
    }

    public static List<MWCategory> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || productGroupCacheIds.size() > 0) {
            List productGroupList = new Query(Env.getCtx(), "W_Category", null, trxName).setClient_ID().setOrderBy("Name").list();
            productGroupList.stream().forEach(airport -> {
                String key = airport.getValue();
                productGroupCacheIds.put((Object)airport.getW_Category_ID(), (Object)airport);
                productGroupCodes.put((Object)key, (Object)airport);
            });
            return productGroupList;
        }
        List<MWCategory> productGroupList = productGroupCacheIds.entrySet().stream().map(applicationType -> (MWCategory)((Object)((Object)applicationType.getValue()))).collect(Collectors.toList());
        return productGroupList;
    }

    public static List<MWCategory> getOfProduct(Properties ctx, int productId, String trxName) {
        return new Query(Env.getCtx(), "W_Category", "EXISTS(SELECT 1 FROM W_CategoryAllocation a WHERE a.W_Category_ID = W_Category.W_Category_ID AND a.M_Product_ID = ?)", trxName).setParameters(new Object[]{productId}).setClient_ID().list();
    }

    public List<MWCategory> getChildList() {
        return new Query(Env.getCtx(), "W_Category", "W_Category_Parent_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getW_Category_ID()}).setClient_ID().list();
    }

    public List<MProduct> getProductsList() {
        return new Query(Env.getCtx(), "M_Product", "EXISTS(SELECT 1 FROM W_CategoryAllocation a WHERE a.M_Product_ID = M_Product.M_Product_ID AND a.W_Category_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getW_Category_ID()}).setClient_ID().list();
    }

    public int getProductCount() {
        return new Query(Env.getCtx(), "M_Product", "EXISTS(SELECT 1 FROM W_CategoryAllocation a WHERE a.M_Product_ID = M_Product.M_Product_ID AND a.W_Category_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getW_Category_ID()}).setClient_ID().count();
    }

    public String toString() {
        return "MWProductGroup [getName()=" + this.getName() + ", getUUID()=" + this.getUUID() + ", getValue()=" + this.getValue() + ", getW_Category_ID()=" + this.getW_Category_ID() + "]";
    }
}

