/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.process;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.MProduct;
import org.compiere.model.MTaxCategory;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.spin.store.model.MWCategory;
import org.spin.store.process.ExportCatalogAbstract;
import org.spin.store.util.ElasticSearchHelper;
import org.spin.store.util.support.elasticsearch.Attribute;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.Product;
import org.spin.store.util.support.elasticsearch.TaxCategory;

public class ExportCatalog
extends ExportCatalogAbstract {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    protected String doIt() throws Exception {
        try {
            ElasticSearchHelper.getInstance().withWebStoreId(this.getStoreId()).connect();
            if (this.isExportProduct()) {
                AtomicInteger productCounter = new AtomicInteger();
                KeyNamePair[] productArray = DB.getKeyNamePairs((String)"SELECT M_Product_ID, Name FROM M_Product WHERE AD_Client_ID = ? AND IsActive = 'Y' AND IsWebStoreFeatured = 'Y'", (boolean)false, (Object[])new Object[]{this.getAD_Client_ID()});
                Arrays.asList(productArray).forEach(productPair -> {
                    try {
                        MProduct product = MProduct.get((Properties)this.getCtx(), (int)productPair.getKey());
                        ElasticSearchHelper.getInstance().index(Product.newInstance().withProduct(product));
                        this.addLog(productPair.getName() + ": @Ok@");
                        productCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + productPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_Product_ID@: " + productCounter.get());
            }
            if (this.isExportProductCategory()) {
                AtomicInteger categoryCounter = new AtomicInteger();
                KeyNamePair[] categoryArray = DB.getKeyNamePairs((String)"SELECT W_Category_ID, Name FROM W_Category WHERE AD_Client_ID = ? AND IsActive = 'Y'", (boolean)false, (Object[])new Object[]{this.getAD_Client_ID()});
                Arrays.asList(categoryArray).forEach(categoryPair -> {
                    try {
                        MWCategory category = MWCategory.getById(this.getCtx(), categoryPair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(Category.newInstance().withCategoy(category));
                        this.addLog(categoryPair.getName() + ": @Ok@");
                        categoryCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + categoryPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@W_Category_ID@: " + categoryCounter);
            }
            if (this.isExportProductAttribute()) {
                AtomicInteger attributeCounter = new AtomicInteger();
                KeyNamePair[] attributeArray = DB.getKeyNamePairs((String)"SELECT M_Attribute_ID, Name FROM M_Attribute WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM M_AttributeValue av WHERE av.M_Attribute_ID = M_Attribute.M_Attribute_ID)", (boolean)false, (Object[])new Object[]{this.getAD_Client_ID()});
                Arrays.asList(attributeArray).forEach(attributePair -> {
                    try {
                        MAttribute attribute = new MAttribute(this.getCtx(), attributePair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(Attribute.newInstance().withAttribute(attribute));
                        this.addLog(attributePair.getName() + ": @Ok@");
                        attributeCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + attributePair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_AttributeSet_ID@: " + attributeCounter);
            }
            if (this.isExportTax()) {
                AtomicInteger taxCategoryCounter = new AtomicInteger();
                KeyNamePair[] taxCategoryArray = DB.getKeyNamePairs((String)"SELECT C_TaxCategory_ID, Name FROM C_TaxCategory WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM C_Tax t WHERE t.C_TaxCategory_ID = C_TaxCategory.C_TaxCategory_ID AND (t.IsSalesTax = 'Y' OR t.SOPOType IN('S', 'B')))", (boolean)false, (Object[])new Object[]{this.getAD_Client_ID()});
                Arrays.asList(taxCategoryArray).forEach(taxCategoryPair -> {
                    try {
                        MTaxCategory taxCategory = new MTaxCategory(this.getCtx(), taxCategoryPair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(TaxCategory.newInstance().withTaxCategory(taxCategory));
                        this.addLog(taxCategoryPair.getName() + ": @Ok@");
                        taxCategoryCounter.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.log.warning("Error: " + e.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + taxCategoryPair.getName() + ": " + e.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@C_TaxCategory_ID@: " + taxCategoryCounter);
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
        finally {
            ElasticSearchHelper.getInstance().close();
        }
        return "@Created@: " + this.created.get() + " - @Errors@: " + this.errors.get();
    }
}

