/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClientInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MStore;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.spin.model.MADAttachmentReference;
import org.spin.store.model.MWCategory;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.ElasticSearch;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;

public class Product
implements IPersistenceWrapper {
    Map<String, Object> map = new HashMap<String, Object>();
    private MProduct product;
    private MStore webStore;

    public static Product newInstance() {
        return new Product();
    }

    public Product withProduct(MProduct product) {
        this.product = product;
        return this;
    }

    private Product() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        if (Optional.ofNullable(this.product).isPresent()) {
            this.map.put("id", this.product.getM_Product_ID());
            this.map.put("name", this.product.getName());
            this.map.put("image", this.getImageName(this.product));
            this.map.put("sku", this.product.getSKU());
            this.map.put("url_key", this.getValidValue(this.product.getName()));
            this.map.put("type_id", this.getProductTypeFromProduct(this.product));
            this.map.put("price", this.getPrice(this.product));
            this.map.put("short_description", this.product.getDescription());
            this.map.put("description", this.product.getHelp());
            this.map.put("status", this.product.isActive() ? "1" : "2");
            this.map.put("visibility", "4");
            ArrayList categories = new ArrayList();
            ArrayList categoriesIds = new ArrayList();
            List<MWCategory> productGroups = MWCategory.getOfProduct(this.product.getCtx(), this.product.getM_Product_ID(), this.product.get_TrxName());
            StringBuffer urlPath = new StringBuffer();
            if (productGroups != null && productGroups.size() > 0) {
                productGroups.forEach(group -> {
                    Category wrapperOfGroup = Category.newInstance().withCategoy((MWCategory)((Object)group));
                    categories.add(wrapperOfGroup.getMap());
                    categoriesIds.add(wrapperOfGroup.getKeyValue());
                    if (urlPath.length() == 0) {
                        urlPath.append(wrapperOfGroup.getURLPath());
                    }
                });
            }
            urlPath.append("/").append(this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID())).append(".html");
            this.map.put("slug", this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID()));
            this.map.put("url_path", urlPath.toString());
            this.map.put("category_ids", categoriesIds);
            this.map.put("category", categories);
            ArrayList mediaList = new ArrayList();
            MClientInfo clientInfo = MClientInfo.get((Properties)this.product.getCtx());
            if (clientInfo.getFileHandler_ID() != 0) {
                AtomicInteger counter = new AtomicInteger(1);
                Optional.ofNullable(this.product.getAttachment()).ifPresent(attachment -> MADAttachmentReference.getListByAttachmentId((Properties)this.product.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)attachment.getAD_Attachment_ID(), (String)this.product.get_TrxName()).forEach(attachmentReference -> {
                    HashMap<String, Object> mediaMap = new HashMap<String, Object>();
                    mediaMap.put("image", "/" + attachmentReference.getValidFileName());
                    mediaMap.put("pos", counter.getAndIncrement());
                    mediaList.add(mediaMap);
                }));
            }
            this.map.put("media_gallery", mediaList);
            if (this.product.getM_AttributeSet_ID() != 0) {
                ArrayList configurableList = new ArrayList();
                AtomicInteger counter = new AtomicInteger(1);
                MAttributeSet attributeSet = MAttributeSet.get((Properties)this.product.getCtx(), (int)this.product.getM_AttributeSet_ID());
                Arrays.asList(attributeSet.getMAttributes(true)).forEach(attribute -> {
                    HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                    attributeMap.put("id", attribute.getM_Attribute_ID());
                    attributeMap.put("attribute_id", attribute.getM_Attribute_ID());
                    attributeMap.put("label", attribute.getName());
                    attributeMap.put("pos", counter.getAndIncrement());
                    if (attribute.getAttributeValueType().equals("L")) {
                        ArrayList attributeValuesList = new ArrayList();
                        Arrays.asList(attribute.getMAttributeValues()).forEach(attributeValue -> {
                            HashMap<String, Object> attributeValueMap = new HashMap<String, Object>();
                            attributeValueMap.put("value_index", attributeValue.getM_AttributeValue_ID());
                            attributeValueMap.put("label", attributeValue.getName());
                            attributeValuesList.add(attributeValueMap);
                        });
                        attributeMap.put("values", attributeValuesList);
                    }
                    attributeMap.put("product_id", this.product.getM_Product_ID());
                    attributeMap.put("attribute_code", attribute.getName().replaceAll(" ", ""));
                    configurableList.add(attributeMap);
                });
            }
            HashMap<String, Comparable<Boolean>> stockMap = new HashMap<String, Comparable<Boolean>>();
            stockMap.put("is_in_stock", Boolean.valueOf(this.product.isStocked()));
            stockMap.put("qty", Double.valueOf(this.getStock(this.product)));
            this.map.put("stock", stockMap);
            if (this.product.isBOM() && this.product.isVerified()) {
                this.map.put("configurable_children", this.getBillOfMaterial(this.product));
            }
            this.map.put("is_active", this.product.isActive());
            this.map.put("created_at", ElasticSearch.convertedDate(this.product.getCreated().getTime()));
            this.map.put("updated_at", ElasticSearch.convertedDate(this.product.getUpdated().getTime()));
        }
        return this.map;
    }

    private String getImageName(MProduct product) {
        MClientInfo clientInfo = MClientInfo.get((Properties)product.getCtx());
        AtomicReference imageName = new AtomicReference();
        if (clientInfo.getFileHandler_ID() != 0) {
            Optional.ofNullable(product.getAttachment()).ifPresent(attachment -> {
                Optional maybeReference = MADAttachmentReference.getListByAttachmentId((Properties)product.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)attachment.getAD_Attachment_ID(), (String)product.get_TrxName()).stream().findFirst();
                if (maybeReference.isPresent()) {
                    imageName.set("/" + ((MADAttachmentReference)maybeReference.get()).getValidFileName());
                }
            });
        }
        return (String)imageName.get();
    }

    private List<Map<String, Object>> getBillOfMaterial(MProduct product) {
        ArrayList<Map<String, Object>> bomList = new ArrayList<Map<String, Object>>();
        MPPProductBOM billOfMaterial = MPPProductBOM.getDefault((MProduct)product, (String)product.get_TrxName());
        if (Optional.ofNullable(billOfMaterial).isPresent()) {
            HashMap childMap = new HashMap();
            Arrays.asList(billOfMaterial.getLines()).forEach(child -> {
                MProduct childProduct = MProduct.get((Properties)product.getCtx(), (int)child.getM_Product_ID());
                childMap.put("id", childProduct.getM_Product_ID());
                childMap.put("sku", childProduct.getSKU());
                childMap.put("name", childProduct.getName());
                childMap.put("url_key", this.getValidValue(childProduct.getName()));
                childMap.put("url_path", childProduct.getDescriptionURL());
                childMap.put("status", this.getProductTypeFromProduct(childProduct));
                childMap.put("image", this.getImageName(childProduct));
                childMap.put("price", this.getPrice(childProduct));
                childMap.put("type_id", this.getProductTypeFromProduct(childProduct));
                bomList.add(childMap);
            });
        }
        return bomList;
    }

    private double getPrice(MProduct product) {
        MPriceList priceList = MPriceList.get((Properties)product.getCtx(), (int)this.webStore.getM_PriceList_ID(), (String)product.get_TrxName());
        Timestamp validFrom = TimeUtil.getDay((long)System.currentTimeMillis());
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), 0, Env.ZERO, true, product.get_TrxName());
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        return productPricing.getPriceStd().setScale(productPricing.getPrecision()).doubleValue();
    }

    private String getValidValue(String value) {
        return value.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    private double getStock(MProduct product) {
        Optional<MStorage> maybeStorage = Arrays.asList(MStorage.getOfProduct((Properties)Env.getCtx(), (int)product.getM_Product_ID(), (String)product.get_TrxName())).stream().filter(storage -> storage.getQtyOnHand().signum() > 0).filter(storage -> storage.getM_Warehouse_ID() == this.webStore.getM_Warehouse_ID()).findFirst();
        if (maybeStorage.isPresent()) {
            BigDecimal quantityOnHand = Env.ZERO;
            BigDecimal quantityReserved = Env.ZERO;
            if (maybeStorage.get().getQtyOnHand() != null) {
                quantityOnHand = maybeStorage.get().getQtyOnHand();
            }
            if (maybeStorage.get().getQtyReserved() != null) {
                quantityReserved = maybeStorage.get().getQtyReserved();
            }
            if (quantityReserved.signum() < 0) {
                return 0.0;
            }
            return quantityOnHand.doubleValue();
        }
        return 0.0;
    }

    @Override
    public String getKeyValue() {
        if (this.product == null) {
            return "";
        }
        return String.valueOf(this.product.getM_Product_ID());
    }

    private String getProductTypeFromProduct(MProduct product) {
        if (Util.isEmpty((String)product.getProductType())) {
            return "simple";
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.getM_AttributeSet_ID() > 0) {
            return "configurable";
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.isBOM()) {
            return "grouped";
        }
        if (product.getProductType().equals("S")) {
            return "configurable";
        }
        if (product.getProductType().equals("I") && !product.isStocked() && product.isBOM()) {
            return "grouped";
        }
        if (product.getProductType().equals("S") && product.getM_Product_Category().getA_Asset_Group_ID() > 0) {
            return "downloadable";
        }
        if ((product.getProductType().equals("I") || product.getProductType().equals("S")) && product.getR_MailText_ID() > 0) {
            return "gift";
        }
        return "simple";
    }

    @Override
    public String getCatalogName() {
        return "product";
    }

    @Override
    public boolean isValid() {
        return this.product != null && this.webStore != null;
    }

    @Override
    public IPersistenceWrapper withWebStoreId(int webStoreId) {
        if (webStoreId > 0) {
            this.webStore = MStore.get((Properties)this.product.getCtx(), (int)webStoreId);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        HashMap<String, String> createdAt = new HashMap<String, String>();
        createdAt.put("type", "date");
        createdAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap<String, String> updatedAt = new HashMap<String, String>();
        updatedAt.put("type", "date");
        updatedAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap properties = new HashMap();
        properties.put("created_at", createdAt);
        properties.put("updated_at", updatedAt);
        HashMap<String, String> slug = new HashMap<String, String>();
        slug.put("type", "keyword");
        properties.put("slug", slug);
        HashMap<String, String> urlPath = new HashMap<String, String>();
        urlPath.put("type", "keyword");
        properties.put("url_path", urlPath);
        HashMap<String, String> urlKey = new HashMap<String, String>();
        urlKey.put("type", "keyword");
        properties.put("url_key", urlKey);
        HashMap<String, String> sku = new HashMap<String, String>();
        sku.put("type", "keyword");
        properties.put("sku", sku);
        HashMap<String, String> price = new HashMap<String, String>();
        price.put("type", "float");
        properties.put("price", price);
        HashMap<String, String> finalPrice = new HashMap<String, String>();
        finalPrice.put("type", "float");
        properties.put("final_price", finalPrice);
        HashMap<String, String> sizeOptions = new HashMap<String, String>();
        sizeOptions.put("type", "integer");
        properties.put("size_options", sizeOptions);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("properties", properties);
        return mapping;
    }
}

