/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.support;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;
import org.spin.queue.notification.support.INotification;
import org.spin.queue.notification.telegram.support.SenderBot;
import org.spin.queue.notification.telegram.support.SenderSession;
import org.spin.queue.notification.telegram.util.BaseMessage;
import org.spin.queue.notification.telegram.util.MessageFactory;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.queue.util.QueueLoader;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.generics.LongPollingBot;

public class Telegram
implements INotification {
    private int registrationId = 0;
    private String botName = null;
    private String botToken = null;
    private String chatId = null;
    private final String BOT_NAME = "bot_name";
    private final String BOT_TOKEN = "bot_token";
    private final String CHAT_ID = "chat_id";
    private CLogger log = CLogger.getCLogger(Telegram.class);

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.botName = registration.getParameterValue("bot_name");
        this.botToken = registration.getParameterValue("bot_token");
        this.chatId = registration.getParameterValue("chat_id");
        this.log.fine("set Registration: " + registrationId);
    }

    public String testConnection() {
        this.log.fine("Test connection");
        try {
            if (Util.isEmpty((String)this.chatId)) {
                throw new AdempiereException("chat id not found");
            }
            MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
            SenderBot sender = new SenderBot(this.botName, this.botToken);
            new TelegramBotsApi(SenderSession.class).registerBot((LongPollingBot)sender);
            assert (registration != null);
            StringBuilder testMessage = new StringBuilder("*").append(registration.getName()).append("*");
            testMessage.append(Env.NL).append("*@Value@*: ").append(MClient.get((Properties)Env.getCtx()).getValue()).append(Env.NL).append("*@Name@*: ").append(MClient.get((Properties)Env.getCtx()).getName()).append(Env.NL).append("*@Version@*: ").append(Adempiere.getVersion());
            sender.sendMessage(BaseMessage.createBaseMessage(Msg.parseTranslation((Properties)Env.getCtx(), (String)testMessage.toString()), this.chatId));
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        return "Ok";
    }

    public void sendNotification(MADNotificationQueue notification) {
        StringBuffer errorMessage = new StringBuffer();
        SenderBot sender = new SenderBot(this.botName, this.botToken);
        try {
            new TelegramBotsApi(SenderSession.class).registerBot((LongPollingBot)sender);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        notification.getRecipients().forEach(recipient -> {
            try {
                if (Util.isEmpty((String)notification.getText())) {
                    throw new AdempiereException("@Text@ @IsMandatory@");
                }
                sender.sendMessage(MessageFactory.getInstance().getHandler(recipient.getMessageType()).createAndGetMessage(notification, (MADNotificationRecipient)recipient));
                recipient.setProcessed(true);
                recipient.saveEx();
                this.log.fine("Telegram sent");
            }
            catch (Exception exception) {
                this.log.severe(exception.getLocalizedMessage());
                recipient.setErrorMsg(exception.getLocalizedMessage());
                recipient.saveEx();
                if (errorMessage.length() > 0) {
                    errorMessage.append(Env.NL);
                }
                errorMessage.append("Error: Sending to: ").append(recipient.getAccountName()).append(": ").append(exception.getLocalizedMessage());
            }
        });
        if (errorMessage.length() > 0) {
            throw new AdempiereException(errorMessage.toString());
        }
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)1000000);
        Trx.run(transactionName -> {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(Env.getCtx()).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType("STG").withUserId(100).withText("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec fringilla faucibus enim quis aliquam. Integer tincidunt et dui vitae egestas. Suspendisse felis est, commodo at ex eu, pellentesque varius leo. Pellentesque tempor quis felis et rutrum. Curabitur imperdiet euismod leo, in pretium ante convallis eu. Nam non odio vulputate, luctus est sed, semper dolor. Vivamus auctor, odio vitae sodales vestibulum, lacus metus auctor ex, nec accumsan est nibh a erat. Ut suscipit velit a imperdiet vestibulum.\n\nMaecenas vel felis ac nulla eleifend volutpat in ac magna. Duis dui est, facilisis at posuere eu, faucibus at nisl. Duis efficitur porttitor lorem. Curabitur tincidunt lorem massa, in sollicitudin ante fringilla sit amet. Nunc nec neque pharetra, tempor mi ac, pharetra risus. Donec tristique laoreet dolor tincidunt venenatis. Sed et leo eget diam molestie venenatis in a eros. Cras nibh arcu, laoreet et suscipit sed, ornare eu mauris. Nulla egestas lacus efficitur, faucibus odio sed, elementum velit. Proin fringilla bibendum lacinia. Vivamus maximus vulputate hendrerit. Fusce mauris ex, finibus eget augue at, volutpat viverra ipsum. Nullam justo nibh, maximus vel nisl tempus, sollicitudin tempor magna.\n\nSed odio dui, tristique sit amet pretium vitae, vehicula vitae enim. In et interdum quam. Etiam id metus a quam interdum tempor. Sed luctus, tellus et mollis porttitor, dolor lectus dignissim eros, in commodo mauris ligula quis eros. Suspendisse scelerisque ipsum at turpis suscipit interdum at ac velit. Aenean suscipit ipsum ut velit cursus sodales. Nulla viverra mi quis commodo aliquam. Ut auctor condimentum urna sed mollis. Fusce neque neque, interdum eget purus ut, efficitur vestibulum lectus. Praesent sagittis nunc ut tincidunt posuere. In faucibus, elit vel vehicula porta, felis ligula finibus arcu, in suscipit odio risus pellentesque lorem. Etiam viverra lacus a eros placerat, eget tempus mi eleifend. Donec ac arcu vel lacus tristique imperdiet. Quisque venenatis arcu egestas ex viverra accumsan. Aenean vitae massa sed elit hendrerit faucibus.\n\nIn hac habitasse platea dictumst. Sed tellus ante, pretium ut viverra feugiat, consectetur et velit. Nulla quis nibh est. Quisque pharetra sem eget ultrices efficitur. Phasellus maximus posuere metus, facilisis dictum justo bibendum ut. Sed aliquet scelerisque risus vel luctus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse eget diam vestibulum risus venenatis pellentesque. Suspendisse tincidunt orci et nisl malesuada, ut porta neque dictum. Quisque at mollis arcu. Nulla sodales diam id lacus efficitur aliquet. In dui leo, pharetra vulputate purus quis, tincidunt ultricies enim. Nulla facilisi. Donec sagittis pharetra ante. Aenean et condimentum ligula, sed volutpat lorem.\n\nNulla laoreet faucibus odio, in rutrum diam semper ut. Praesent at purus id massa hendrerit ultricies. Nam sodales sapien id diam finibus viverra. Duis efficitur hendrerit vulputate. Cras urna enim, vestibulum sit amet ex nec, lobortis viverra massa. Morbi accumsan vel magna in dictum. Cras sed mollis libero. Etiam egestas, orci sed dapibus tempus, ligula ex vulputate lacus, sit amet volutpat urna nulla ac massa. Phasellus ac sollicitudin purus. Ut sit amet ligula eget justo imperdiet rhoncus non nec lectus. Mauris euismod ornare felis et dictum. Maecenas vestibulum dictum dui, ut elementum tellus convallis ac. In congue nunc vel felis elementum, at ultrices velit pharetra.\n").addRecipient("-537126434", "CFM").withEntity(MClient.Table_ID, 1000000).withDescription("Hello by Notes").addToQueue();
        });
        Trx.run(transactionName -> {
            ProcessInfo result = ProcessBuilder.create((Properties)Env.getCtx()).process(Integer.valueOf(FlushSystemQueue.getProcessId())).withParameter("BatchsToProcess", (Object)1).withParameter("RecordsByBatch", (Object)100).withParameter("IsDeleteAfterProcess", (Object)false).execute();
            System.err.println(result.getSummary());
        });
    }
}

