/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.util;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.pipo.IDFinder;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.queue.model.MADQueue;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;
import org.spin.queue.notification.telegram.util.BaseMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;

public class ConfirmationMessage
extends BaseMessage {
    public static final String MESSAGE_TYPE = "CFM";
    public static final String YES = "y";
    public static final String NO = "n";
    public static final String CLIENT_CODE = "CLIENT_CODE";

    private String getInLineOption(String clientCode, int notificationId, String action) {
        return "c=" + clientCode + "|t=CFM|n=" + notificationId + "|a=" + action;
    }

    @Override
    public SendMessage createAndGetMessage(MADNotificationQueue notification, MADNotificationRecipient recipient) {
        String tableName;
        String uuid;
        SendMessage message = ConfirmationMessage.createBaseMessage();
        StringBuilder messageInfo = new StringBuilder();
        if (!Util.isEmpty((String)notification.getDescription())) {
            messageInfo.append("*").append(notification.getDescription().trim()).append("*").append("\n");
        }
        if (!Util.isEmpty((String)notification.getText())) {
            messageInfo.append(notification.getText());
        }
        message.setText(messageInfo.toString());
        message.setChatId(recipient.getAccountName());
        MADQueue queue = new MADQueue(notification.getCtx(), notification.getAD_Queue_ID(), notification.get_TrxName());
        if (queue.getAD_Table_ID() > 0 && queue.getRecord_ID() > 0 && !Util.isEmpty((String)(uuid = IDFinder.getUUIDFromId((String)(tableName = MTable.getTableName((Properties)queue.getCtx(), (int)queue.getAD_Table_ID())), (int)queue.getRecord_ID(), (int)notification.getAD_Client_ID(), (String)notification.get_TrxName())))) {
            InlineKeyboardButton addColumn = new InlineKeyboardButton();
            InlineKeyboardMarkup markupInline = new InlineKeyboardMarkup();
            ArrayList rowsInline = new ArrayList();
            ArrayList<InlineKeyboardButton> columnsInline = new ArrayList<InlineKeyboardButton>();
            String host = MSysConfig.getValue((String)CLIENT_CODE, (String)"none", (int)queue.getAD_Client_ID());
            addColumn.setCallbackData(this.getInLineOption(host, notification.getAD_NotificationQueue_ID(), NO));
            addColumn.setText(Msg.getMsg((Properties)queue.getCtx(), (String)"no"));
            columnsInline.add(addColumn);
            addColumn = new InlineKeyboardButton();
            addColumn.setCallbackData(this.getInLineOption(host, notification.getAD_NotificationQueue_ID(), YES));
            addColumn.setText(Msg.getMsg((Properties)queue.getCtx(), (String)"yes"));
            columnsInline.add(addColumn);
            rowsInline.add(columnsInline);
            markupInline.setKeyboard(rowsInline);
            message.setReplyMarkup((ReplyKeyboard)markupInline);
        }
        return message;
    }
}

